/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CQuickImageSaveEntry;
import org.monazilla.v2c.V2CQuickImageSaveMenu;
import org.monazilla.v2c.V2CSPTree;
import org.monazilla.v2c.V2CSubMenuFolder;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextField;
import org.monazilla.v2c.V2CTreeFolder;

public class V2CQuickImageSaveSP
extends JPanel
implements ActionListener {
    QuickImageSaveModel qisTreeModel;
    V2CSPTree vSPTree;
    JTextField jtfMnemonic;
    JButton jbRecursiveAdd;
    JTextField jtfLabel;
    JTextField jtfFolder;
    JButton jbAddFolder;
    JButton jbAdd;
    JButton jbBrowse;
    boolean bChanged;

    public V2CQuickImageSaveSP() {
        super(new GridBagLayout());
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        V2CSPTree v2CSPTree;
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 4, 10, 4);
        this.qisTreeModel = new QuickImageSaveModel();
        this.vSPTree = v2CSPTree = new V2CSPTree(this.qisTreeModel);
        v2CSPTree.addMouseListener(new TreePopupListener());
        JScrollPane jScrollPane = new JScrollPane(v2CSPTree);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        V2CTextField v2CTextField = new V2CTextField(2);
        this.jtfMnemonic = v2CTextField;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)v2CTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("\uff08[ 0-9A-Z]\u306e1\u6587\u5b57\uff09"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbRecursiveAdd = jButton4 = new JButton("\u4e0b\u4f4d\u30d5\u30a9\u30eb\u30c0\u767b\u9332\u2026");
        jButton4.setFocusable(false);
        jButton4.addActionListener(this);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jButton4, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("\u30e9\u30d9\u30eb\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        V2CTextField v2CTextField2 = new V2CTextField();
        this.jtfLabel = v2CTextField2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)v2CTextField2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx += 2;
        this.jbAddFolder = jButton3 = new JButton("\u4e0b\u4f4d\uff92\uff86\uff6d\uff70");
        jButton3.setFocusable(false);
        jButton3.addActionListener(this);
        this.add((Component)jButton3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbAdd = jButton2 = new JButton("\u8ffd\u52a0");
        jButton2.setFocusable(false);
        jButton2.addActionListener(this);
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("\u30d5\u30a9\u30eb\u30c0\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        V2CTextField v2CTextField3 = new V2CTextField();
        this.jtfFolder = v2CTextField3;
        v2CTextField3.setEditable(false);
        v2CTextField3.setFocusable(false);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        this.add((Component)v2CTextField3, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx += 3;
        this.jbBrowse = jButton = new JButton("\u2026");
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        gridBagConstraints.fill = 2;
        this.add((Component)jButton, gridBagConstraints);
    }

    boolean isChanged() {
        return this.bChanged || this.vSPTree.isChanged();
    }

    void beforeConfig() {
        this.vSPTree.setToolTipText("tooltip");
        ToolTipManager.sharedInstance().registerComponent(this.vSPTree);
    }

    void afterConfig() {
        ToolTipManager.sharedInstance().unregisterComponent(this.vSPTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean showDialog() {
        this.beforeConfig();
        String[] stringArray = new String[]{"OK", "Cancel"};
        try {
            V2CSwingUtil.showDialogWithClose((JFrame)V2CMain.v2cMain, (JComponent)this, (JTextComponent)this.jtfLabel, "\u30d5\u30a9\u30eb\u30c0\u306b\u76f4\u63a5\u4fdd\u5b58\u306e\u8a2d\u5b9a", stringArray, null);
            Object var3_2 = null;
            this.afterConfig();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.afterConfig();
            throw throwable;
        }
        return stringArray[0] != null && this.isChanged();
    }

    void addSeparator() {
        TreePath treePath = this.vSPTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == this.qisTreeModel.getRoot()) {
            return;
        }
        this.qisTreeModel.addSeparator((DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent());
    }

    void editSelectedEntry() {
        TreePath treePath = this.vSPTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == this.qisTreeModel.getRoot()) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        char c = '\u0000';
        if (object instanceof V2CTreeFolder) {
            V2CTreeFolder v2CTreeFolder = (V2CTreeFolder)object;
            this.jtfLabel.setText(v2CTreeFolder.getName());
            c = v2CTreeFolder.getMnemonic();
        } else if (object instanceof V2CQuickImageSaveEntry) {
            V2CQuickImageSaveEntry v2CQuickImageSaveEntry = (V2CQuickImageSaveEntry)object;
            this.jtfLabel.setText(v2CQuickImageSaveEntry.getName());
            this.jtfFolder.setText(v2CQuickImageSaveEntry.getFolder().getAbsolutePath());
            c = v2CQuickImageSaveEntry.getMnemonic();
        }
        this.jtfMnemonic.setText(c > '\u0000' ? new String(new char[]{c}) : "");
    }

    char getMnemonic() {
        String string = this.jtfMnemonic.getText();
        if (string.length() == 0) {
            return '\u0000';
        }
        return V2CSwingUtil.restrictMnemonic(string.charAt(0));
    }

    void overwriteSelectedEntry() {
        File file;
        TreePath treePath = this.vSPTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == this.qisTreeModel.getRoot()) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        String string = this.jtfLabel.getText();
        if (string.length() == 0) {
            return;
        }
        char c = this.getMnemonic();
        boolean bl = false;
        if (object instanceof V2CTreeFolder) {
            defaultMutableTreeNode.setUserObject(new V2CTreeFolder(string, c));
            bl = true;
        } else if (object instanceof V2CQuickImageSaveEntry && (file = this.getSelectedFolder()) != null) {
            defaultMutableTreeNode.setUserObject(new V2CQuickImageSaveEntry(string, file, c));
            bl = true;
        }
        if (bl) {
            this.bChanged = true;
            this.qisTreeModel.nodeChanged(defaultMutableTreeNode);
            V2CSPTree.checkDuplicatedMnemonic(defaultMutableTreeNode);
        }
    }

    void deleteSelectedEntry() {
        TreePath treePath = this.vSPTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        this.qisTreeModel.delete((DefaultMutableTreeNode)treePath.getLastPathComponent());
    }

    File getSelectedFolder() {
        String string = this.jtfFolder.getText();
        if (string.length() == 0) {
            return null;
        }
        return new File(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbRecursiveAdd) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.qisTreeModel.getRoot();
            }
            if (!defaultMutableTreeNode.getAllowsChildren()) {
                V2CSwingUtil.showErrorMessage("\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
            JFileChooser jFileChooser = V2CSwingUtil.createFileChooser();
            jFileChooser.setFileSelectionMode(1);
            File file = this.getSelectedFolder();
            if (file != null && file.isDirectory()) {
                jFileChooser.setSelectedFile(file);
            }
            if ((n = jFileChooser.showOpenDialog(this)) != 0) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.isDirectory()) {
                return;
            }
            V2CQuickImageSaveSP.addSubFolders(file, defaultMutableTreeNode);
            this.qisTreeModel.nodeStructureChanged(defaultMutableTreeNode);
        } else if (object == this.jbAdd) {
            this.qisTreeModel.add(this.jtfLabel.getText(), this.getSelectedFolder(), (DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent(), this.getMnemonic());
        } else if (object == this.jbAddFolder) {
            this.qisTreeModel.createFolder(this.jtfLabel.getText(), (DefaultMutableTreeNode)this.vSPTree.getLastSelectedPathComponent(), this.getMnemonic());
        } else if (object == this.jbBrowse) {
            int n;
            JFileChooser jFileChooser = V2CSwingUtil.createFileChooser();
            jFileChooser.setFileSelectionMode(1);
            File file = this.getSelectedFolder();
            if (file != null && file.isDirectory()) {
                jFileChooser.setSelectedFile(file);
            }
            if ((n = jFileChooser.showOpenDialog(this)) != 0) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.isDirectory()) {
                return;
            }
            this.jtfFolder.setText(file.getAbsolutePath());
            this.jtfLabel.setText(file.getName());
        }
    }

    static void addSubFolders(File file, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        int n;
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        int n2 = fileArray.length;
        Object[] objectArray = new FileHolder[n2];
        for (n = 0; n < n2; ++n) {
            object = fileArray[n];
            objectArray[n] = new FileHolder((File)object, V2CMiscUtil.replaceChar(((File)object).getName(), '\t', ' '));
        }
        Arrays.sort(objectArray);
        for (n = 0; n < n2; ++n) {
            object = objectArray[n];
            File file2 = ((FileHolder)object).fFile;
            String string = ((FileHolder)object).sName;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new V2CQuickImageSaveEntry(string, file2), false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new V2CTreeFolder(string), true);
            V2CQuickImageSaveSP.addSubFolders(file2, defaultMutableTreeNode3);
            if (defaultMutableTreeNode3.getChildCount() <= 0) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
        }
    }

    static DefaultMutableTreeNode createTreeNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new V2CTreeFolder("\u76f4\u63a5\u4fdd\u5b58\u30d5\u30a9\u30eb\u30c0"), true);
        ArrayList arrayList = V2CQuickImageSaveMenu.restoreFolders();
        V2CQuickImageSaveSP.createTreeNodes(defaultMutableTreeNode, arrayList);
        return defaultMutableTreeNode;
    }

    static void createTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object e = arrayList.get(i);
            if (e instanceof V2CSubMenuFolder) {
                object = (V2CSubMenuFolder)e;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new V2CTreeFolder(((V2CSubMenuFolder)object).sName, ((V2CSubMenuFolder)object).cMnemonic), true);
                V2CQuickImageSaveSP.createTreeNodes(defaultMutableTreeNode2, ((V2CSubMenuFolder)object).alSubEntries);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            if (!(e instanceof V2CQuickImageSaveEntry)) continue;
            object = (V2CQuickImageSaveEntry)e;
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(e, false));
        }
    }

    ArrayList getResult() {
        if (this.vSPTree.isEditing()) {
            this.vSPTree.stopEditing();
        }
        ArrayList arrayList = new ArrayList();
        this.createEntryList(arrayList, (DefaultMutableTreeNode)this.qisTreeModel.getRoot());
        return arrayList;
    }

    void createEntryList(ArrayList arrayList, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (defaultMutableTreeNode2.getAllowsChildren()) {
                V2CTreeFolder v2CTreeFolder = (V2CTreeFolder)object;
                V2CSubMenuFolder v2CSubMenuFolder = new V2CSubMenuFolder(v2CTreeFolder.getName(), v2CTreeFolder.getMnemonic());
                this.createEntryList(v2CSubMenuFolder.alSubEntries, defaultMutableTreeNode2);
                arrayList.add(v2CSubMenuFolder);
                continue;
            }
            arrayList.add(object);
        }
    }

    class TreePopupListener
    extends V2CPopupListener {
        public TreePopupListener() {
            super("", V2CQuickImageSaveSP.this);
        }

        void showPopup(MouseEvent mouseEvent) {
            Object object;
            V2CSPTree v2CSPTree = V2CQuickImageSaveSP.this.vSPTree;
            TreePath treePath = v2CSPTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            String string = null;
            if (!(treePath.getPathCount() <= 1 || (object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof V2CQuickImageSaveEntry && ((V2CQuickImageSaveEntry)object).isSeparator())) {
                string = "SepEditOverwriteAndDeleteEntry";
            }
            String string2 = this.sPopupName = string != null ? string : "DeleteEntry";
            if (!v2CSPTree.isPathSelected(treePath)) {
                v2CSPTree.setSelectionPath(treePath);
            }
            super.showPopup(mouseEvent);
        }
    }

    private class QuickImageSaveModel
    extends DefaultTreeModel {
        QuickImageSaveModel() {
            super(V2CQuickImageSaveSP.createTreeNodes(), true);
        }

        void delete(DefaultMutableTreeNode defaultMutableTreeNode) {
            if (defaultMutableTreeNode == this.getRoot()) {
                defaultMutableTreeNode.removeAllChildren();
                this.nodeStructureChanged(defaultMutableTreeNode);
            } else {
                this.removeNodeFromParent(defaultMutableTreeNode);
            }
            V2CQuickImageSaveSP.this.bChanged = true;
        }

        void add(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            Serializable serializable;
            Object object;
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getRoot();
            }
            if ((object = defaultMutableTreeNode2.getUserObject()) instanceof V2CTreeFolder) {
                this.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            } else {
                serializable = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                this.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)((Object)serializable), serializable.getIndex(defaultMutableTreeNode2));
            }
            V2CQuickImageSaveSP.this.bChanged = true;
            serializable = new TreePath(defaultMutableTreeNode.getPath());
            V2CQuickImageSaveSP.this.vSPTree.setSelectionPath((TreePath)serializable);
            V2CQuickImageSaveSP.this.vSPTree.scrollPathToVisible((TreePath)serializable);
            V2CSPTree.checkDuplicatedMnemonic(defaultMutableTreeNode);
        }

        void createFolder(String string, DefaultMutableTreeNode defaultMutableTreeNode, char c) {
            this.add(new DefaultMutableTreeNode(new V2CTreeFolder(string, c), true), defaultMutableTreeNode);
        }

        void add(String string, File file, DefaultMutableTreeNode defaultMutableTreeNode, char c) {
            if (file == null) {
                return;
            }
            if (file.toString().indexOf(9) >= 0) {
                V2CMain.setErrorMessage("\u30bf\u30d6\u30b3\u30fc\u30c9\u3092\u542b\u3080\u30d1\u30b9\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            this.add(new DefaultMutableTreeNode(new V2CQuickImageSaveEntry(string, file, c), false), defaultMutableTreeNode);
        }

        void addSeparator(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.add(new DefaultMutableTreeNode(V2CQuickImageSaveEntry.createSeparator(), false), defaultMutableTreeNode);
        }
    }

    private static class FileHolder
    implements Comparable {
        final File fFile;
        final String sName;

        FileHolder(File file, String string) {
            this.fFile = file;
            this.sName = string;
        }

        public int compareTo(Object object) {
            return this.sName.compareToIgnoreCase(((FileHolder)object).sName);
        }
    }
}

