/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CFavoriteFolder;
import org.monazilla.v2c.V2CFavoritePanel;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CRSSItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CURLItem;

public class V2CFavoriteMenu
extends JPopupMenu
implements ActionListener,
MouseMotionListener,
MouseWheelListener {
    Timer tScrollTimer;
    boolean bOnTop;
    Window wPopupWindow;

    public V2CFavoriteMenu(V2CFavoritePanel v2CFavoritePanel) {
        this.setLightWeightPopupEnabled(false);
        this.createMenu(v2CFavoritePanel);
        this.addMouseWheelListener(this);
    }

    void createMenu(V2CFavoritePanel v2CFavoritePanel) {
        TreeModel treeModel = v2CFavoritePanel.getModel();
        this.createMenu(this, (DefaultMutableTreeNode)treeModel.getRoot());
    }

    private void createMenu(JPopupMenu jPopupMenu, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object4 = defaultMutableTreeNode2.getUserObject();
            if (object4 instanceof V2CFavoriteFolder) {
                object3 = new JMenu(((V2CFavoriteFolder)object4).getName());
                ((Component)object3).addMouseMotionListener(this);
                jPopupMenu.add((JMenuItem)object3);
                object2 = ((JMenu)object3).getPopupMenu();
                ((JPopupMenu)object2).setLightWeightPopupEnabled(false);
                ((Component)object2).addMouseWheelListener(this);
                this.createMenu((JPopupMenu)object2, defaultMutableTreeNode2);
                continue;
            }
            object3 = null;
            object2 = null;
            if (object4 instanceof V2CThreadItem) {
                object = (V2CThreadItem)object4;
                if (((V2CThreadItem)object).isActive()) {
                    object3 = ((V2CThreadItem)object).getTitle();
                    object2 = ((V2CThreadItem)object).getIconForFP();
                }
            } else if (object4 instanceof V2CBoardItem) {
                object3 = ((V2CBoardItem)object4).getName();
                object2 = V2CBoardItem.getIcon();
            } else if (object4 instanceof V2CRSSItem) {
                object3 = ((V2CRSSItem)object4).getName();
                object2 = V2CRSSItem.getIcon();
            } else if (object4 instanceof V2CURLItem) {
                object = (V2CURLItem)object4;
                object3 = ((V2CURLItem)object).getLabel();
                object2 = ((V2CURLItem)object).getIcon();
            }
            if (object3 == null) continue;
            object = new FavoriteMenuItem((String)object3, (Icon)object2, object4);
            ((AbstractButton)object).addActionListener(this);
            ((Component)object).addMouseMotionListener(this);
            jPopupMenu.add((JMenuItem)object);
        }
        if (jPopupMenu.getComponentCount() == 0) {
            JMenuItem jMenuItem = new JMenuItem("\uff08\u306a\u3057\uff09");
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = actionEvent.getModifiers();
        if (object instanceof FavoriteMenuItem) {
            boolean bl = (n & 1) != 0;
            String string = V2CMouseClickManager.getMouseAction("G", bl ? (char)'B' : 'A');
            boolean bl2 = string != null && string.equals("ON");
            Object object2 = ((FavoriteMenuItem)object).oItem;
            if (object2 instanceof V2CThreadItem) {
                ((V2CThreadItem)object2).open(true, bl2);
            } else if (object2 instanceof V2CBoardItem) {
                ((V2CBoardItem)object2).open(true, bl2);
            } else if (object2 instanceof V2CRSSItem) {
                ((V2CRSSItem)object2).open(true, bl2, false);
            } else if (object2 instanceof V2CURLItem) {
                ((V2CURLItem)object2).open(bl2, false);
            }
        } else if (object instanceof Timer) {
            Timer timer = (Timer)object;
            if (timer != this.tScrollTimer) {
                this.tScrollTimer = null;
                return;
            }
            Window window = this.wPopupWindow;
            if (window == null) {
                this.tScrollTimer = null;
                return;
            }
            Point point = V2CSwingUtil.getMouseLocationOnScreen(null);
            Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
            Rectangle rectangle2 = window.getBounds();
            int n2 = point.x;
            int n3 = point.y;
            if (n2 <= rectangle2.x || n2 >= rectangle2.x + rectangle2.width || (this.bOnTop ? n3 >= rectangle.y + 5 : n3 <= rectangle.y + rectangle.height - 5)) {
                this.tScrollTimer = null;
                return;
            }
            if (this.bOnTop) {
                if (rectangle2.y >= rectangle.y) {
                    this.tScrollTimer = null;
                    return;
                }
                rectangle2.y = Math.min(rectangle.y, rectangle2.y + 20);
            } else {
                if (rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
                    this.tScrollTimer = null;
                    return;
                }
                rectangle2.y = Math.max(rectangle.y + rectangle.height - rectangle2.height, rectangle2.y - 20);
            }
            window.setBounds(rectangle2);
            timer.start();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Timer timer;
        boolean bl;
        if (V2CApp.javaVersionLessThan(1, 5) && !V2CApp.isMacintosh() || this.tScrollTimer != null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return;
        }
        this.wPopupWindow = window;
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(mouseEvent.getPoint());
        Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseEvent);
        int n = point.y;
        if (n < rectangle.y + 5) {
            bl = true;
        } else if (n > rectangle.y + rectangle.height - 5) {
            bl = false;
        } else {
            return;
        }
        this.bOnTop = bl;
        Rectangle rectangle2 = window.getBounds();
        if (bl ? rectangle2.y >= rectangle.y : rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return;
        }
        this.tScrollTimer = timer = new Timer(50, this);
        timer.setRepeats(false);
        timer.start();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        Window window = SwingUtilities.getWindowAncestor(mouseWheelEvent.getComponent());
        if (window == null || window instanceof JFrame) {
            return;
        }
        int n = mouseWheelEvent.getUnitsToScroll();
        if (V2CApp.isMacintosh()) {
            if (n > 0) {
                n = Math.max(n / 3, 1);
            } else if (n < 0) {
                n = Math.min(n / 3, -1);
            }
        }
        Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseWheelEvent);
        Rectangle rectangle = window.getBounds();
        int n2 = point.y;
        if (n > 0) {
            int n3 = rectangle.y + rectangle.height - 10;
            if (n3 <= n2) {
                return;
            }
            rectangle.y += Math.max(-10 * n, n2 - n3);
        } else {
            int n4 = rectangle.y + 10;
            if (n4 >= n2) {
                return;
            }
            rectangle.y += Math.min(-10 * n, n2 - n4);
        }
        window.setBounds(rectangle);
    }

    static class FavoriteMenuItem
    extends JMenuItem {
        Object oItem;

        FavoriteMenuItem(String string, Icon icon, Object object) {
            super(string, icon);
            this.oItem = object;
        }
    }
}

