/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSingleThreadViewPane;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CGestureListener
extends MouseInputAdapter
implements MouseWheelListener {
    final V2CGestureMap vGestureMap;
    final String sPopupName;

    static void registerGestureListener(JComponent jComponent, String string, String string2) {
        V2CGestureListener v2CGestureListener = new V2CGestureListener(string, string2);
        jComponent.addMouseListener(v2CGestureListener);
        jComponent.addMouseMotionListener(v2CGestureListener);
        jComponent.addMouseWheelListener(v2CGestureListener);
    }

    private V2CGestureListener(String string, String string2) {
        this.vGestureMap = V2CGestureMap.getGestureMap(string);
        this.sPopupName = string2;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.vGestureMap.mouseDragged(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component;
        if (!V2CPopupListener.isDefined(mouseEvent)) {
            return;
        }
        if (this.vGestureMap.mousePressed(mouseEvent, true)) {
            this.showPopup(mouseEvent);
        } else if (V2CSwingUtil.isSimpleClick(mouseEvent) && (component = mouseEvent.getComponent()) instanceof V2CSingleThreadViewPane) {
            ((V2CSingleThreadViewPane)component).jpKeyPanel.requestFocusInWindow();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!V2CPopupListener.isDefined(mouseEvent)) {
            return;
        }
        if (this.vGestureMap.mouseReleased(mouseEvent)) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.vGestureMap.mouseWheelMoved(mouseWheelEvent)) {
            return;
        }
        Component component = mouseWheelEvent.getComponent();
        if (!component.isShowing()) {
            return;
        }
        Container container = component.getParent();
        if (container == null || !(container instanceof JViewport)) {
            return;
        }
        mouseWheelEvent.consume();
        Point point = SwingUtilities.convertPoint(component, mouseWheelEvent.getPoint(), container);
        container.dispatchEvent(new MouseWheelEvent((Component)container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (int)point.getX(), (int)point.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
    }

    private void showPopup(MouseEvent mouseEvent) {
        String string = this.sPopupName;
        if (string == null) {
            return;
        }
        JPopupMenu jPopupMenu = V2CMain.getPopupMenu(string);
        if (jPopupMenu == null || jPopupMenu.getComponentCount() == 0) {
            return;
        }
        mouseEvent.consume();
        Point point = mouseEvent.getPoint();
        V2CPopupListener.showPopup(jPopupMenu, mouseEvent, mouseEvent.getComponent(), (int)point.getX(), (int)point.getY());
    }
}

