/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.UIResource;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CActionMap;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CClassStateSaver;
import org.monazilla.v2c.V2CInputMapConstants;
import org.monazilla.v2c.V2CInputMapSP;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSaveFile;

public class V2CInputMap
extends InputMap
implements V2CInputMapConstants {
    private static final String sSaveFile = "inputmap.txt";
    private static final HashMap hmInputMaps = new HashMap();
    static V2CInputMap[] vimlInputMaps;
    static InputMap imGlobalOther;
    static ClassStateSaver classStateSaver;
    String sName;
    String sLabel;
    private boolean bGlobal;
    static boolean bNumKeyPopupChecked;
    static boolean bNumKeyPopupPossible;
    private static final String sDummyAction = "v2cDummyAction";
    private static final Action dummyAction;
    private static KeyStroke[] kslDummyKeyStrokes;

    static {
        imGlobalOther = new InputMap();
        classStateSaver = new ClassStateSaver(60);
        dummyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
            }
        };
        vimlInputMaps = new V2CInputMap[slInputMapName.length];
    }

    static V2CInputMap getInputMap(String s) {
        return (V2CInputMap)hmInputMaps.get(s);
    }

    static void restoreInputMap() {
        HashMap hashmap;
        block13: {
            BufferedReader bufferedreader = V2CLocalFileHandler.getUserSaveFileReader(sSaveFile);
            if (bufferedreader == null) {
                System.out.println("cannot read inputmap.txt !");
                return;
            }
            hashmap = hmInputMaps;
            try {
                try {
                    String s1;
                    V2CInputMap v2cinputmap = null;
                    boolean flag = true;
                    while ((s1 = bufferedreader.readLine()) != null) {
                        String[] as;
                        int k;
                        int j = s1.length();
                        if (flag) {
                            flag = false;
                            if (j > 0 && s1.charAt(0) == '\ufeff') {
                                if (j == 1) continue;
                                s1 = s1.substring(1);
                                --j;
                            }
                        }
                        if (j <= 0 || s1.charAt(0) == '#' || (k = (as = V2CMiscUtil.split(s1)).length) != 2) continue;
                        if (as[0].equals("Map")) {
                            v2cinputmap = new V2CInputMap(as[1]);
                            hashmap.put(as[1], v2cinputmap);
                            continue;
                        }
                        if (v2cinputmap == null) continue;
                        String s2 = as[0];
                        s2 = V2CApp.isMacintosh() ? V2CMiscUtil.replaceFirst(s2, "ctrl", "meta") : V2CMiscUtil.replaceFirst(s2, "meta", "ctrl");
                        KeyStroke keystroke = KeyStroke.getKeyStroke(s2);
                        if (keystroke == null) continue;
                        v2cinputmap.put(keystroke, as[1]);
                    }
                }
                catch (IOException ioexception) {
                    System.out.println(ioexception.getMessage());
                    V2CLocalFileHandler.closeReader(bufferedreader);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                V2CLocalFileHandler.closeReader(bufferedreader);
                throw throwable;
            }
            V2CLocalFileHandler.closeReader(bufferedreader);
        }
        int i = 0;
        while (i < vimlInputMaps.length) {
            String s = slInputMapName[i];
            V2CInputMap v2cinputmap1 = (V2CInputMap)hashmap.get(s);
            if (v2cinputmap1 == null) {
                v2cinputmap1 = new V2CInputMap(s);
                hashmap.put(s, v2cinputmap1);
                if (s.equals("BoardTreeMiniSearch")) {
                    v2cinputmap1.put(KeyStroke.getKeyStroke("ENTER"), "FindNext");
                    v2cinputmap1.put(KeyStroke.getKeyStroke("shift ENTER"), "FindPrevious");
                }
            }
            V2CInputMap.vimlInputMaps[i] = v2cinputmap1;
            v2cinputmap1.sLabel = V2CJStr.slInputMapLabels[i];
            ++i;
        }
        V2CInputMap.setAccelerator();
        V2CInputMap.setKeyBind((JComponent)V2CMain.v2cMain.getContentPane(), 1, null, imGlobalOther);
    }

    static V2CInputMap getGlobalMap() {
        return V2CInputMap.getInputMap("Global");
    }

    static void checkGlobal() {
        imGlobalOther.clear();
        V2CInputMap v2cinputmap = V2CInputMap.getGlobalMap();
        if (v2cinputmap == null) {
            return;
        }
        KeyStroke[] akeystroke = v2cinputmap.keys();
        if (akeystroke == null) {
            return;
        }
        HashSet hashset = V2CMain.v2cMain.createActionSet();
        int i = 0;
        while (i < akeystroke.length) {
            KeyStroke keystroke = akeystroke[i];
            String s = (String)v2cinputmap.get(keystroke);
            V2CAbstractAction v2cabstractaction = V2CAction.getAction(s);
            if (v2cabstractaction != null && !hashset.contains(v2cabstractaction)) {
                imGlobalOther.put(keystroke, s);
            }
            ++i;
        }
    }

    static void checkActions() {
        boolean flag = false;
        V2CInputMap[] av2cinputmap = vimlInputMaps;
        int i = 0;
        while (i < av2cinputmap.length) {
            V2CInputMap v2cinputmap = av2cinputmap[i];
            KeyStroke[] akeystroke = v2cinputmap.keys();
            if (akeystroke != null) {
                int j = 0;
                while (j < akeystroke.length) {
                    KeyStroke keystroke = akeystroke[j];
                    if (V2CActionMap.getAction(v2cinputmap.get(keystroke)) == null) {
                        flag = true;
                        v2cinputmap.remove(keystroke);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (flag) {
            classStateSaver.requestSave();
        }
    }

    static void saveInputMap() {
        V2CSaveFile v2csavefile;
        block18: {
            v2csavefile = new V2CSaveFile(sSaveFile);
            BufferedWriter bufferedwriter = v2csavefile.getWriter();
            if (bufferedwriter == null) {
                return;
            }
            try {
                try {
                    int i = 0;
                    while (i < slInputMapName.length) {
                        bufferedwriter.write("Map,");
                        bufferedwriter.write(slInputMapName[i]);
                        bufferedwriter.newLine();
                        V2CInputMap v2cinputmap = vimlInputMaps[i];
                        if (v2cinputmap == null) {
                            bufferedwriter.newLine();
                        } else {
                            KeyStroke[] akeystroke = v2cinputmap.keys();
                            if (akeystroke == null) {
                                bufferedwriter.newLine();
                            } else {
                                int j = 0;
                                while (j < akeystroke.length) {
                                    String s1;
                                    String s;
                                    KeyStroke keystroke = akeystroke[j];
                                    if (keystroke != null && (s = (String)v2cinputmap.get(keystroke)) != null && s.length() != 0 && (s1 = V2CInputMap.getKeyText(keystroke.getKeyCode())) != null && s1.length() != 0) {
                                        int k = keystroke.getModifiers();
                                        if ((k & 0x40) != 0) {
                                            bufferedwriter.write("shift ");
                                        }
                                        if ((k & 0x80) != 0) {
                                            bufferedwriter.write("ctrl ");
                                        }
                                        if ((k & 0x200) != 0) {
                                            bufferedwriter.write("alt ");
                                        }
                                        if ((k & 0x100) != 0) {
                                            bufferedwriter.write("meta ");
                                        }
                                        if (s1.indexOf(32) >= 0) {
                                            s1 = s1.replaceAll(" ", "_");
                                        }
                                        bufferedwriter.write(s1.toUpperCase());
                                        bufferedwriter.write(44);
                                        bufferedwriter.write(s);
                                        bufferedwriter.newLine();
                                    }
                                    ++j;
                                }
                                bufferedwriter.newLine();
                            }
                        }
                        ++i;
                    }
                    v2csavefile.setOK();
                }
                catch (IOException iOException) {
                    V2CLocalFileHandler.closeWriter(bufferedwriter);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                V2CLocalFileHandler.closeWriter(bufferedwriter);
                throw throwable;
            }
            V2CLocalFileHandler.closeWriter(bufferedwriter);
        }
        v2csavefile.replaceTmpFile();
    }

    static String getKeyText(int i) {
        String s = KeyEvent.getKeyText(i);
        if (s == null || s.length() == 0) {
            return null;
        }
        if (V2CApp.isMacintosh()) {
            if (s.startsWith("\u6570\u5b57\u30ad\u30fc")) {
                s = "NumPad" + s.substring(4);
            } else if (s.length() > 0 && s.charAt(0) == '\u2328') {
                s = "NumPad" + s.substring(1);
            } else {
                String[][] as = V2CJStr.sllMacKeyText;
                for (int j = 0; j < as.length; ++j) {
                    if (!s.equals(as[j][0])) continue;
                    s = as[j][1];
                    break;
                }
            }
        }
        if (s.length() == 1) {
            switch (s.charAt(0)) {
                case '=': {
                    s = "Equals";
                    break;
                }
                case '[': 
                case '{': {
                    s = "Open Bracket";
                    break;
                }
                case ']': 
                case '}': {
                    s = "Close Bracket";
                    break;
                }
                case ';': {
                    s = "Semicolon";
                    break;
                }
                case ',': {
                    s = "Comma";
                    break;
                }
                case '.': {
                    s = "Period";
                    break;
                }
                case '\\': {
                    s = "Back Slash";
                    break;
                }
                case '/': {
                    s = "Slash";
                    break;
                }
                case '_': {
                    s = "Underscore";
                }
            }
        } else if (s.startsWith("NumPad")) {
            if (s.length() == 8) {
                switch (s.charAt(7)) {
                    case '/': {
                        s = "Divide";
                        break;
                    }
                    case '*': {
                        s = "Multiply";
                        break;
                    }
                    case '-': {
                        s = "Subtract";
                        break;
                    }
                    case '+': {
                        s = "Add";
                        break;
                    }
                    case '.': {
                        s = "Decimal";
                        break;
                    }
                    default: {
                        s = "NumPad" + s.substring(7);
                        break;
                    }
                }
            }
        } else if (s.equals("Backspace")) {
            s = "Back Space";
        }
        return s;
    }

    static void setAccelerator() {
        V2CInputMap v2cinputmap = V2CInputMap.getGlobalMap();
        if (v2cinputmap == null) {
            return;
        }
        KeyStroke[] akeystroke = v2cinputmap.keys();
        if (akeystroke == null) {
            return;
        }
        int i = 0;
        while (i < akeystroke.length) {
            KeyStroke keystroke = akeystroke[i];
            String s = (String)v2cinputmap.get(keystroke);
            V2CAbstractAction v2cabstractaction = V2CAction.getAction(s);
            if (v2cabstractaction != null) {
                v2cabstractaction.putValue("AcceleratorKey", keystroke);
            }
            ++i;
        }
    }

    static void setActionMap(JComponent jcomponent) {
        ActionMap actionmap = jcomponent.getActionMap();
        while (actionmap != null) {
            ActionMap actionmap1 = actionmap.getParent();
            if (actionmap1 == null || actionmap1 instanceof UIResource) {
                V2CActionMap v2cactionmap = new V2CActionMap();
                actionmap.setParent(v2cactionmap);
                if (actionmap1 == null) break;
                v2cactionmap.setParent(actionmap1);
                break;
            }
            actionmap = actionmap1;
        }
    }

    static void setKeyBind(JComponent jcomponent, int i, String s) {
        V2CInputMap.setKeyBind(jcomponent, i, s, null);
    }

    static void setKeyBind(JComponent jcomponent, int i, String s, InputMap inputmap) {
        InputMap inputmap1 = jcomponent.getInputMap(i);
        if (inputmap == null) {
            inputmap = V2CInputMap.getInputMap(s);
        }
        if (inputmap == null) {
            return;
        }
        if (inputmap1 instanceof ComponentInputMap) {
            KeyStroke[] akeystroke = inputmap.keys();
            if (akeystroke != null) {
                int j = 0;
                while (j < akeystroke.length) {
                    inputmap1.put(akeystroke[j], inputmap.get(akeystroke[j]));
                    ++j;
                }
            }
        } else {
            InputMap inputmap2 = inputmap1.getParent();
            inputmap1.setParent(inputmap);
            if (inputmap2 != null && inputmap2 != inputmap) {
                inputmap.setParent(inputmap2);
            }
        }
        V2CInputMap.setActionMap(jcomponent);
    }

    static void textSelected(V2CAbstractThreadPanel v2cabstractthreadpanel, boolean flag) {
        InputMap inputmap = v2cabstractthreadpanel.getInputMap(0);
        InputMap inputmap1 = inputmap.getParent();
        if (!(inputmap1 instanceof V2CInputMap)) {
            return;
        }
        V2CInputMap v2cinputmap = vimlInputMaps[4];
        V2CInputMap v2cinputmap1 = vimlInputMaps[5];
        if (inputmap1 != (flag ? v2cinputmap : v2cinputmap1)) {
            return;
        }
        if (flag) {
            inputmap.setParent(v2cinputmap1);
            v2cinputmap1.setParent(inputmap1);
        } else {
            InputMap inputmap2 = inputmap1.getParent();
            if (inputmap2 != v2cinputmap) {
                return;
            }
            inputmap.setParent(inputmap2);
        }
    }

    static void setSingleKeyBind(JComponent jcomponent, int i, int j, int k, String s, Action action) {
        KeyStroke keystroke = KeyStroke.getKeyStroke(j, k);
        if (keystroke != null) {
            jcomponent.getInputMap(i).put(keystroke, s);
            jcomponent.getActionMap().put(s, action);
        }
    }

    static void setFindKey(JComponent jcomponent) {
        InputMap inputmap = jcomponent.getInputMap(1);
        V2CInputMap v2cinputmap = V2CInputMap.getGlobalMap();
        KeyStroke[] akeystroke = v2cinputmap.keys();
        if (akeystroke == null) {
            return;
        }
        boolean flag = false;
        int i = akeystroke.length - 1;
        while (i >= 0) {
            KeyStroke keystroke = akeystroke[i];
            Object obj = v2cinputmap.get(keystroke);
            if (V2CMiscUtil.isEqual(obj, "FindPrevious")) {
                inputmap.put(keystroke, "FindPrevious");
                flag = true;
            } else if (V2CMiscUtil.isEqual(obj, "FindNext")) {
                inputmap.put(keystroke, "FindNext");
                flag = true;
            }
            --i;
        }
        if (flag) {
            V2CInputMap.setActionMap(jcomponent);
        }
    }

    static void showSettingPanel() {
        V2CInputMapSP v2cinputmapsp = new V2CInputMapSP(vimlInputMaps);
        if (v2cinputmapsp.showDialog()) {
            V2CInputMap.applyChanges(v2cinputmapsp, false);
        }
    }

    static void applyChanges(V2CInputMapSP v2cinputmapsp, boolean saveScroll) {
        if (saveScroll) {
            v2cinputmapsp.saveScroll();
        }
        bNumKeyPopupChecked = false;
        V2CInputMap.checkGlobal();
        classStateSaver.requestSave();
    }

    public static JPanel getConfPanel() {
        V2CInputMapSP v2cinputmapsp = new V2CInputMapSP(vimlInputMaps);
        v2cinputmapsp.initScroll();
        return v2cinputmapsp;
    }

    static boolean isKeyBindDefined(String s, String s1) {
        V2CInputMap v2cinputmap = V2CInputMap.getInputMap(s);
        if (v2cinputmap == null || v2cinputmap.size() == 0) {
            return false;
        }
        KeyStroke[] akeystroke = v2cinputmap.keys();
        if (akeystroke == null) {
            return false;
        }
        int i = 0;
        while (i < akeystroke.length) {
            Object obj = v2cinputmap.get(akeystroke[i]);
            if (obj instanceof String && obj.equals(s1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static int[] getDefinedKeys(String s, String s1) {
        V2CInputMap v2cinputmap = V2CInputMap.getInputMap(s);
        if (v2cinputmap == null || v2cinputmap.size() == 0) {
            return null;
        }
        KeyStroke[] akeystroke = v2cinputmap.keys();
        if (akeystroke == null) {
            return null;
        }
        ArrayList<Integer> arraylist = new ArrayList<Integer>();
        int i = 0;
        while (i < akeystroke.length) {
            Integer integer;
            KeyStroke keystroke = akeystroke[i];
            if (s1.equals(v2cinputmap.get(keystroke)) && !arraylist.contains(integer = new Integer(keystroke.getKeyCode()))) {
                arraylist.add(integer);
            }
            ++i;
        }
        int j = arraylist.size();
        if (j == 0) {
            return null;
        }
        int[] ai = new int[j];
        int k = 0;
        while (k < j) {
            ai[k] = (Integer)arraylist.get(k);
            ++k;
        }
        return ai;
    }

    static boolean isNumKeyPopupPossible() {
        if (bNumKeyPopupChecked) {
            return bNumKeyPopupPossible;
        }
        bNumKeyPopupChecked = true;
        int[] ai = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105};
        KeyStroke[] akeystroke = new KeyStroke[ai.length];
        int i = 0;
        while (i < akeystroke.length) {
            akeystroke[i] = KeyStroke.getKeyStroke(ai[i], 0);
            ++i;
        }
        V2CInputMap[] av2cinputmap = new V2CInputMap[]{V2CInputMap.getGlobalMap(), V2CInputMap.getInputMap("ThreadView")};
        boolean flag = true;
        int j = 0;
        block1: while (j < av2cinputmap.length) {
            V2CInputMap v2cinputmap = av2cinputmap[j];
            for (int k = 0; k < akeystroke.length; ++k) {
                if (v2cinputmap.get(akeystroke[k]) == null) continue;
                flag = false;
                break block1;
            }
            ++j;
        }
        bNumKeyPopupPossible = flag;
        return flag;
    }

    static void interceptNormalKeyForTextComponent(JComponent jcomponent) {
        KeyStroke[] akeystroke = kslDummyKeyStrokes;
        if (akeystroke == null) {
            ArrayList<KeyStroke> arraylist = new ArrayList<KeyStroke>();
            int i = 48;
            while (i < 90) {
                if (i <= 57 || i >= 65) {
                    arraylist.add(KeyStroke.getKeyStroke(i, 0));
                    arraylist.add(KeyStroke.getKeyStroke(i, 64));
                }
                ++i;
            }
            int[] ai = new int[]{192, 92, 93, 44, 61, 45, 91, 46, 222, 59, 47};
            int j = 0;
            while (j < ai.length) {
                int l = ai[j];
                arraylist.add(KeyStroke.getKeyStroke(l, 0));
                arraylist.add(KeyStroke.getKeyStroke(l, 64));
                ++j;
            }
            kslDummyKeyStrokes = akeystroke = arraylist.toArray(new KeyStroke[arraylist.size()]);
        }
        InputMap inputmap = new InputMap();
        String s = sDummyAction;
        int k = akeystroke.length - 1;
        while (k >= 0) {
            inputmap.put(akeystroke[k], s);
            --k;
        }
        InputMap inputmap1 = jcomponent.getInputMap(1);
        while (inputmap1 != null) {
            InputMap inputmap2 = inputmap1.getParent();
            if (inputmap2 == null || inputmap2 instanceof UIResource) {
                inputmap1.setParent(inputmap);
                if (inputmap2 == null) break;
                inputmap.setParent(inputmap2);
                break;
            }
            inputmap1 = inputmap2;
        }
        jcomponent.getActionMap().put(sDummyAction, dummyAction);
    }

    public V2CInputMap(String s) {
        this.sName = s;
        this.bGlobal = s.equals("Global");
    }

    String getName() {
        return this.sName;
    }

    boolean isGlobal() {
        return this.bGlobal;
    }

    public String toString() {
        return this.sLabel;
    }

    static class ClassStateSaver
    extends V2CClassStateSaver {
        @Override
        public void doSaveState() {
            V2CInputMap.saveInputMap();
        }

        ClassStateSaver(int i) {
            super(i);
        }
    }
}

