/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CBBSThreadRes;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CBoardList;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscThreadUtil;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNameAndMail;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CScriptRes;
import org.monazilla.v2c.V2CScriptResSeparator;
import org.monazilla.v2c.V2CThreadHashMap;
import org.monazilla.v2c.V2CThreadItem;

public class V2CLocalThreadUtil {
    static V2CBoardItem getLocalBoard(String string) {
        String string2 = V2CLocalThreadUtil.getLocalBoardURLFromDir(string);
        return string2 != null ? V2CBoardItem.getBoardItem(string2) : null;
    }

    static String getLocalBoardURLFromDir(String string) {
        return string != null && string.matches("\\p{Alnum}+") ? "http://localboard/" + string + '/' : null;
    }

    static String repWDgenR(String string, String string2) {
        string = V2CMiscUtil.replaceAll(string, "<", "&lt;");
        string = V2CMiscUtil.replaceAll(string, ">", "&gt;");
        string = V2CMiscUtil.replaceAll(string, "\"", "&quot;");
        string = V2CMiscUtil.replaceAll(string, "\n", " <br> ");
        return V2CMiscUtil.generateReference(V2CJPConverter.replaceWaveDash(string, string2), string2, true, true);
    }

    private static StringBuffer createDatLine(V2CNameAndMail v2CNameAndMail, String string, V2CBoardItem v2CBoardItem, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = V2CBBS.checkTrip(V2CLocalThreadUtil.repWDgenR(v2CNameAndMail.getPostName(), string2), v2CBoardItem);
        if ((string4 == null || string4.length() == 0) && (string3 = v2CBoardItem.getSettingNoName()) != null) {
            string4 = string3;
        }
        stringBuffer.append(string4);
        stringBuffer.append("<>");
        stringBuffer.append(V2CLocalThreadUtil.repWDgenR(v2CNameAndMail.getPostMail(), string2));
        stringBuffer.append("<>");
        stringBuffer.append(new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss", Locale.JAPANESE).format(new Date()));
        stringBuffer.append("<>");
        stringBuffer.append(' ');
        stringBuffer.append(V2CLocalThreadUtil.repWDgenR(string, string2));
        stringBuffer.append(' ');
        stringBuffer.append("<>");
        return stringBuffer;
    }

    static V2CThreadItem createLocalThread(String string, V2CNameAndMail v2CNameAndMail, String string2, V2CBoardItem v2CBoardItem) {
        V2CThreadHashMap v2CThreadHashMap = v2CBoardItem.getBoardHashMap();
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        String string3 = l2 + ".dat";
        while (v2CThreadHashMap.contains(string3)) {
            string3 = ++l2 + ".dat";
        }
        String string4 = "MS932";
        V2CThreadItem v2CThreadItem = new V2CThreadItem(string, 0, string3, v2CThreadHashMap.size(), v2CBoardItem);
        StringBuffer stringBuffer = V2CLocalThreadUtil.createDatLine(v2CNameAndMail, string2, v2CBoardItem, string4);
        stringBuffer.append(V2CLocalThreadUtil.repWDgenR(string, string4));
        stringBuffer.append('\n');
        if (!V2CLocalFileHandler.saveToFile(v2CThreadItem.getLocalFile(), stringBuffer.toString(), string4)) {
            return null;
        }
        V2CLocalThreadUtil.updateThreadInfo(v2CThreadItem, 1);
        v2CBoardItem.createLocalSubjectFile();
        v2CThreadItem.registerLocalThreadStatus();
        v2CThreadItem.threadStatusChanged();
        v2CBoardItem.setLastCheckTime((l2 - 1L) * 1000L);
        return v2CThreadItem;
    }

    private static V2CThreadItem createLocalThread(String string, String string2, V2CBoardItem v2CBoardItem) {
        if (!v2CBoardItem.isLocalBoard() || string2 == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        V2CThreadHashMap v2CThreadHashMap = v2CBoardItem.getBoardHashMap();
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        String string3 = l2 + ".dat";
        while (v2CThreadHashMap.contains(string3)) {
            string3 = ++l2 + ".dat";
        }
        String string4 = "MS932";
        V2CThreadItem v2CThreadItem = new V2CThreadItem(string, 0, string3, v2CThreadHashMap.size(), v2CBoardItem);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(V2CLocalThreadUtil.repWDgenR(string, string4));
        stringBuffer.append('\n');
        if (!V2CLocalFileHandler.saveToFile(v2CThreadItem.getLocalFile(), stringBuffer.toString(), string4)) {
            return null;
        }
        V2CLocalThreadUtil.updateThreadInfo(v2CThreadItem, 1);
        v2CBoardItem.createLocalSubjectFile();
        v2CThreadItem.registerLocalThreadStatus();
        v2CThreadItem.threadStatusChanged();
        v2CBoardItem.setLastCheckTime((l2 - 1L) * 1000L);
        V2CBoardList v2CBoardList = V2CBoardList.getBoardList(v2CBoardItem);
        if (v2CBoardList != null) {
            v2CBoardList.checkList(false);
        }
        return v2CThreadItem;
    }

    static boolean postLocalMessage(V2CNameAndMail v2CNameAndMail, String string, V2CThreadItem v2CThreadItem) {
        V2CBoardItem v2CBoardItem = v2CThreadItem.getBoardItem();
        String string2 = "MS932";
        StringBuffer stringBuffer = V2CLocalThreadUtil.createDatLine(v2CNameAndMail, string, v2CBoardItem, string2);
        stringBuffer.append('\n');
        if (!V2CLocalFileHandler.appendToFile(v2CThreadItem.getLocalFile(), stringBuffer.toString(), string2)) {
            return false;
        }
        V2CLocalThreadUtil.updateThreadInfo(v2CThreadItem, v2CThreadItem.getNRes() + 1);
        v2CThreadItem.registerLocalThreadStatus();
        v2CThreadItem.threadStatusChanged();
        v2CBoardItem.createLocalSubjectFile();
        return true;
    }

    private static boolean addDatLine(String string, V2CThreadItem v2CThreadItem, boolean bl) {
        if (string == null) {
            return false;
        }
        string = string + '\n';
        if (!V2CLocalFileHandler.appendToFile(v2CThreadItem.getLocalFile(), string, "MS932")) {
            return false;
        }
        V2CLocalThreadUtil.updateThreadInfo(v2CThreadItem, v2CThreadItem.getNRes() + 1);
        if (bl) {
            V2CLocalThreadUtil.updateThreadStatus(v2CThreadItem);
        }
        return true;
    }

    private static void updateThreadInfo(V2CThreadItem v2CThreadItem, int n) {
        v2CThreadItem.setNResGet(n, true);
        v2CThreadItem.setLogSize((int)v2CThreadItem.getLocalFile().length());
    }

    private static void updateThreadStatus(V2CThreadItem v2CThreadItem) {
        v2CThreadItem.registerLocalThreadStatus();
        v2CThreadItem.threadStatusChanged();
        v2CThreadItem.getBoardItem().createLocalSubjectFile();
    }

    static V2CThreadItem createLocalThread(String string, V2CThreadItem v2CThreadItem, V2CResItem v2CResItem, V2CBoardItem v2CBoardItem, String string2) {
        return V2CLocalThreadUtil.appendResToLocalThread(string, v2CThreadItem, v2CResItem, null, v2CBoardItem, string2, true, true);
    }

    static boolean appendResToLocalThread(V2CThreadItem v2CThreadItem, V2CResItem v2CResItem, V2CThreadItem v2CThreadItem2, String string, boolean bl) {
        return V2CLocalThreadUtil.appendResToLocalThread(null, v2CThreadItem, v2CResItem, v2CThreadItem2, null, string, bl, true) != null;
    }

    static boolean appendResToLocalThread0(V2CThreadItem v2CThreadItem, V2CResItem v2CResItem, V2CThreadItem v2CThreadItem2, String string, boolean bl) {
        return V2CLocalThreadUtil.appendResToLocalThread(null, v2CThreadItem, v2CResItem, v2CThreadItem2, null, string, bl, false) != null;
    }

    private static V2CThreadItem appendResToLocalThread(String string, V2CThreadItem v2CThreadItem, V2CResItem v2CResItem, V2CThreadItem v2CThreadItem2, V2CBoardItem v2CBoardItem, String string2, boolean bl, boolean bl2) {
        Matcher matcher;
        String string3 = V2CBBSThreadRes.getDatLine(v2CThreadItem, v2CResItem.getResIndex(), true);
        if (string3 == null) {
            return null;
        }
        int n = string3.lastIndexOf("<>");
        if (n > 0 && string3.charAt(n - 1) == ' ') {
            --n;
        }
        String string4 = v2CThreadItem.getThreadKey();
        String string5 = v2CThreadItem.getBoardItem().getURLString();
        if (string5.startsWith("http://")) {
            if ((string5 = string5.substring(7)).charAt(string5.length() - 1) == '/') {
                string5 = string5.substring(0, string5.length() - 1);
            }
        } else {
            string5 = null;
        }
        String string6 = string3.substring(0, n);
        int n2 = string6.lastIndexOf("<>");
        String string7 = "";
        if (n2 > 0) {
            if (string6.charAt(n2 += 2) == ' ') {
                ++n;
            }
            string7 = string6.substring(n2);
            string6 = string6.substring(0, n2);
        }
        if (!(matcher = Pattern.compile("<!--V2CANOT\\s[^>]+-->\\s*$").matcher(string7)).find()) {
            StringBuffer stringBuffer = new StringBuffer(string6);
            if (bl) {
                boolean bl3 = false;
                int n3 = string2.length();
                for (int i = 0; i < n3; ++i) {
                    char c = string2.charAt(i);
                    if (bl3) {
                        bl3 = false;
                        String string8 = null;
                        if (c == '%') {
                            string8 = "%";
                        } else if (c == 'P') {
                            string8 = string7;
                        } else if (c == 'T') {
                            string8 = v2CThreadItem.getTitle();
                            if (string8 == null) {
                                string8 = v2CThreadItem.getFormalURLString();
                            }
                        } else if (c == 'U') {
                            string8 = v2CThreadItem.getBBS().getName(v2CThreadItem.getBoardItem());
                        } else if (c == 'B') {
                            string8 = v2CThreadItem.getBoardItem().getName();
                        } else if (c == 'H') {
                            V2CMiscThreadUtil.appendResURL(v2CThreadItem, v2CResItem, stringBuffer);
                        } else if (c == 'n') {
                            string8 = " <br> ";
                        }
                        if (string8 == null) continue;
                        stringBuffer.append(string8);
                        continue;
                    }
                    if (c == '%') {
                        bl3 = true;
                        continue;
                    }
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(string7);
            }
            if (string5 != null) {
                stringBuffer.append("<!--V2CANOT src=\"");
                stringBuffer.append(string5);
                stringBuffer.append(':');
                stringBuffer.append(string4);
                stringBuffer.append(':');
                stringBuffer.append(v2CResItem.getResIndex() + 1);
                stringBuffer.append("\"-->");
            }
            stringBuffer.append(string3.substring(n));
            string3 = stringBuffer.toString();
        }
        if (v2CThreadItem2 != null) {
            return V2CLocalThreadUtil.addDatLine(string3, v2CThreadItem2, bl2) ? v2CThreadItem2 : null;
        }
        return V2CLocalThreadUtil.createLocalThread(string, string3, v2CBoardItem);
    }

    static V2CThreadItem createLocalThread(V2CBoardItem v2CBoardItem, String string, ArrayList arrayList) {
        V2CThreadItem v2CThreadItem = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string2 = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof V2CScriptResSeparator) {
                string2 = ((V2CScriptResSeparator)e).getText();
                if (string2 == null) continue;
                string2 = V2CMiscUtil.replaceChar(string2, '\t', ' ');
                string2 = V2CMiscUtil.replaceChar(string2, '\n', ' ');
                continue;
            }
            if (e instanceof V2CScriptRes) {
                V2CScriptRes v2CScriptRes = (V2CScriptRes)e;
                V2CThreadItem v2CThreadItem2 = v2CScriptRes.getThread().getThreadItem();
                V2CResItem v2CResItem = v2CScriptRes.getResItem();
                if (v2CThreadItem == null) {
                    v2CThreadItem = V2CLocalThreadUtil.createLocalThread(string, v2CThreadItem2, v2CResItem, v2CBoardItem, "%P");
                    if (v2CThreadItem == null) {
                        return null;
                    }
                } else {
                    bl = true;
                    V2CLocalThreadUtil.appendResToLocalThread0(v2CThreadItem2, v2CResItem, v2CThreadItem, "%P", false);
                }
                if (string2 != null) {
                    stringBuffer.append(v2CThreadItem.getNRes() - 1);
                    stringBuffer.append(':');
                    stringBuffer.append(string2);
                    stringBuffer.append('\t');
                }
            }
            string2 = null;
        }
        if (bl) {
            V2CLocalThreadUtil.updateThreadStatus(v2CThreadItem);
        }
        if (v2CThreadItem != null && stringBuffer.length() > 0) {
            v2CThreadItem.getProperty().put("ThreadView.ResSeparators", stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        return v2CThreadItem;
    }
}

