/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import org.monazilla.v2c.V2CKeyword;
import org.monazilla.v2c.V2CKeywordItem;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNGItem;
import org.monazilla.v2c.V2CNGWord;
import org.monazilla.v2c.V2CNGWordMatrix;
import org.monazilla.v2c.V2CPackedPropValue;

public class V2CNGWordItem
extends V2CKeywordItem
implements V2CNGItem {
    int nMaxRecDepth;
    boolean bMatch;
    boolean bNot;
    boolean bTransparent;
    String sLabel;
    String sReason;

    public V2CNGWordItem(V2CKeyword v2CKeyword, String string) {
        this(v2CKeyword, string, null, false, false);
    }

    public V2CNGWordItem(V2CKeyword v2CKeyword, String string, boolean bl, boolean bl2) {
        this(v2CKeyword, string, null, bl, bl2);
    }

    public V2CNGWordItem(V2CKeyword v2CKeyword, String string, String string2, boolean bl, boolean bl2) {
        super(v2CKeyword, string, bl, bl2);
        if (string2 != null && string2.length() > 0 && (string2 = V2CMiscUtil.replaceChar(string2, '\t', ' ')).length() > 0) {
            this.sLabel = string2;
        }
        this.nMaxRecDepth = -1;
    }

    public V2CNGWordItem(V2CKeyword v2CKeyword, V2CPackedPropValue v2CPackedPropValue) {
        super(v2CKeyword, v2CPackedPropValue);
        if (v2CPackedPropValue != null) {
            int n;
            this.nMaxRecDepth = n = v2CPackedPropValue.getIntInRangeIfExists('D', -1, 0, 100);
            if (n > 0) {
                V2CNGWordMatrix.setRecursiveUsed();
            }
            this.bMatch = v2CPackedPropValue.getBoolean('M');
            this.bNot = v2CPackedPropValue.getBoolean('!');
            this.bTransparent = v2CPackedPropValue.getBoolean('T');
            this.sLabel = v2CPackedPropValue.getString('L');
        }
    }

    V2CPackedPropValue getSaveValue() {
        V2CPackedPropValue v2CPackedPropValue = super.getSaveValue();
        if (v2CPackedPropValue != null) {
            if (this.nMaxRecDepth >= 0) {
                v2CPackedPropValue.setInt('D', this.nMaxRecDepth);
            }
            v2CPackedPropValue.setBoolean('M', this.bMatch);
            v2CPackedPropValue.setBoolean('!', this.bNot);
            v2CPackedPropValue.setBoolean('T', this.bTransparent);
            v2CPackedPropValue.setString('L', this.sLabel);
        }
        return v2CPackedPropValue;
    }

    public int getMaxRecDepth() {
        return this.nMaxRecDepth;
    }

    void setMaxRecDepth(int n) {
        if (this.nMaxRecDepth == n) {
            return;
        }
        this.nMaxRecDepth = n;
        this.vParent.requestSave();
        if (n > 0) {
            V2CNGWordMatrix.setRecursiveUsed();
        }
    }

    void setMatch(boolean bl) {
        if (this.bMatch == bl) {
            return;
        }
        this.bMatch = bl;
        this.vParent.requestSave();
    }

    void setNot(boolean bl) {
        if (this.bNot == bl) {
            return;
        }
        this.bNot = bl;
        this.vParent.requestSave();
    }

    void setTransparent() {
        this.bTransparent = true;
    }

    void setTransparent(boolean bl) {
        if (this.bTransparent == bl) {
            return;
        }
        this.bTransparent = bl;
        this.vParent.requestSave();
    }

    void setLabel(String string) {
        this.sReason = null;
        if (string != null) {
            if (string.indexOf(9) >= 0) {
                string = V2CMiscUtil.replaceTab2SP(string);
            }
            if (string.equals(this.sLabel)) {
                return;
            }
        } else if (this.sLabel == null) {
            return;
        }
        this.sLabel = string;
        this.vParent.requestSave();
    }

    boolean isMatch() {
        return this.bMatch;
    }

    boolean isNot() {
        return this.bNot;
    }

    String getLabel() {
        return this.sLabel;
    }

    public boolean isTransparent() {
        return this.bTransparent;
    }

    public String getReasonString() {
        if (this.sReason == null) {
            if (this.vParent instanceof V2CNGWord) {
                this.sReason = ((V2CNGWord)this.vParent).getReasonString();
                if (this.sLabel != null) {
                    this.sReason = this.sReason + '[' + this.sLabel + ']';
                }
            } else {
                this.sReason = this.sLabel != null ? this.sLabel : "";
            }
        }
        return this.sReason;
    }
}

