/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2C2chBBS;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CCookie;
import org.monazilla.v2c.V2CIntString;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNinjaSP;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CNinjaUtil {
    private static final String sNinjaConfKey = "2ch.NinjaConf:";
    static final String sErrorTrain = "<b>\uff25\uff32\uff32\uff2f\uff32\uff1a\u4fee\u884c\u304c\u8db3\u308a\u307e\u305b\u3093";
    static final String sNinpoChoSakusei = "<b>\u3088\u3046\u3053\u305d\uff1a\u8cb4\u65b9\u306e\u5fcd\u6cd5\u5e16\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002";
    static final String sYararetadeGozaru = "<b>\u3084\u3089\u308c\u305f\u3067\u3054\u3056\u308b\uff1a";
    static final int MAX_NINJALEVEL = 40;
    private static boolean bNinjaConfRestored;
    private static boolean bUseNinjaLevel;
    private static boolean bNinjaHost;
    private static final NinjaState v2chNinjaState;
    private static final NinjaState vBPNinjaState;

    static void restoreNinjaConf() {
        if (bNinjaConfRestored) {
            return;
        }
        bNinjaConfRestored = true;
        V2CPackedPropValue v2CPackedPropValue = V2CBBS.get2chBBS().getProperty().getPackedValue(sNinjaConfKey);
        if (v2CPackedPropValue != null) {
            bUseNinjaLevel = !v2CPackedPropValue.getBoolean('U');
            V2CNinjaUtil.v2chNinjaState.nNinjaLevel = v2CPackedPropValue.getIntInRangeIfExists('L', 0, 40);
            V2CNinjaUtil.vBPNinjaState.nNinjaLevel = v2CPackedPropValue.getIntInRangeIfExists('M', 0, 40);
            bNinjaHost = v2CPackedPropValue.getBoolean('H');
        } else {
            bUseNinjaLevel = true;
            V2CNinjaUtil.v2chNinjaState.nNinjaLevel = V2CCookie.hasHAP(false) ? 40 : 0;
            V2CNinjaUtil.vBPNinjaState.nNinjaLevel = V2CCookie.hasHAP(true) ? 40 : 0;
        }
    }

    static void saveNinjaConf() {
        int n = V2CNinjaUtil.v2chNinjaState.nNinjaLevel;
        int n2 = V2CNinjaUtil.vBPNinjaState.nNinjaLevel;
        V2CProperty v2CProperty = V2CBBS.get2chBBS().getProperty();
        if (n > 0 || n2 > 0 || bNinjaHost || !bUseNinjaLevel) {
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            if (n > 0) {
                v2CPackedPropValue.setInt('L', n);
            }
            if (n2 > 0) {
                v2CPackedPropValue.setInt('M', n2);
            }
            v2CPackedPropValue.setBoolean('H', bNinjaHost);
            v2CPackedPropValue.setBoolean('U', !bUseNinjaLevel);
            v2CProperty.putPackedValue(sNinjaConfKey, v2CPackedPropValue);
        } else {
            v2CProperty.remove(sNinjaConfKey);
        }
        V2CThreadPanel.updateWritePanels();
    }

    static void config() {
        V2CNinjaSP v2CNinjaSP = new V2CNinjaSP(false);
        if (!v2CNinjaSP.showDialog()) {
            return;
        }
        v2CNinjaSP.postConfig();
    }

    static void postConfig(boolean bl, int n, int n2, boolean bl2) {
        if (bl == bUseNinjaLevel && n == V2CNinjaUtil.v2chNinjaState.nNinjaLevel && n2 == V2CNinjaUtil.vBPNinjaState.nNinjaLevel && bl2 == bNinjaHost) {
            return;
        }
        bUseNinjaLevel = bl;
        V2CNinjaUtil.v2chNinjaState.nNinjaLevel = n;
        V2CNinjaUtil.vBPNinjaState.nNinjaLevel = n2;
        bNinjaHost = bl2;
        V2CNinjaUtil.saveNinjaConf();
    }

    static void discardNinpoCho(boolean bl) {
        if (!V2CSwingUtil.showOKCancelWarningDialog((bl ? "BBSPINK" : "2ch") + "\u306e\u5fcd\u6cd5\u5e16\u3092\u7834\u68c4\u3057\u307e\u3059\u3002")) {
            return;
        }
        V2CCookie.discardHAP(bl);
        V2CNinjaUtil.getNinjaState((boolean)bl).nNinjaLevel = 0;
        V2CNinjaUtil.saveNinjaConf();
    }

    static boolean getUseNinjaLevel() {
        V2CNinjaUtil.restoreNinjaConf();
        return bUseNinjaLevel;
    }

    private static NinjaState getNinjaState(V2CBoardItem v2CBoardItem) {
        return V2C2chBBS.isBBSPink(v2CBoardItem) ? vBPNinjaState : v2chNinjaState;
    }

    private static NinjaState getNinjaState(boolean bl) {
        return bl ? vBPNinjaState : v2chNinjaState;
    }

    static int getNinjaLevel(V2CBoardItem v2CBoardItem, String string, boolean bl, boolean bl2) {
        return V2CNinjaUtil.isNinjaApplicable(v2CBoardItem, string, bl, bl2) ? V2CNinjaUtil.getNinjaLevel(v2CBoardItem) : -1;
    }

    static int getNinjaLevel(V2CBoardItem v2CBoardItem) {
        if (v2CBoardItem == null || !v2CBoardItem.is2ch()) {
            return -1;
        }
        return V2CNinjaUtil.getNinjaLevel(V2C2chBBS.isBBSPink(v2CBoardItem));
    }

    static int getNinjaLevel(boolean bl) {
        V2CNinjaUtil.restoreNinjaConf();
        return V2CNinjaUtil.getNinjaState((boolean)bl).nNinjaLevel;
    }

    private static void setNinjaLevel(int n, V2CBoardItem v2CBoardItem, boolean bl) {
        if (bl || v2CBoardItem == null || !v2CBoardItem.is2ch()) {
            return;
        }
        V2CNinjaUtil.restoreNinjaConf();
        if (n < 0 || n > 40) {
            return;
        }
        V2CNinjaUtil.getNinjaState((V2CBoardItem)v2CBoardItem).nNinjaLevel = n;
        V2CNinjaUtil.saveNinjaConf();
    }

    static boolean isNinjaHost() {
        V2CNinjaUtil.restoreNinjaConf();
        return bNinjaHost;
    }

    static void checkMyPost(String string, String string2, V2CBoardItem v2CBoardItem, boolean bl) {
        if (bl || v2CBoardItem == null || !v2CBoardItem.is2ch() || string == null || string2 == null || string2.indexOf("!ninja") < 0) {
            return;
        }
        int n = string.indexOf("<>");
        if (n <= 0) {
            return;
        }
        Matcher matcher = Pattern.compile("</b>\u5fcd\u6cd5\u5e16\u3010Lv=(\\d{1,2}),\\p{Alpha}{4,10}\u3011", 2).matcher(string.substring(0, n));
        if (!matcher.find()) {
            return;
        }
        int n2 = V2CMiscUtil.parseInt(matcher.group(1), -1);
        if (n2 < 0 || n2 > 40) {
            return;
        }
        V2CNinjaUtil.setNinjaLevel(n2, v2CBoardItem, bl);
    }

    static void checkErrorMessage(String string, V2CBoardItem v2CBoardItem, boolean bl) {
        int n;
        Matcher matcher;
        if (string.indexOf(sNinpoChoSakusei) >= 0) {
            V2CNinjaUtil.setNinjaLevel(0, v2CBoardItem, bl);
            return;
        }
        int n2 = -1;
        Matcher matcher2 = Pattern.compile("<body[^>]*>(?:\\s*<(?:!|\\p{Alpha}{2,})[^>]*>)*\\s*<b>([^\\n]+?)</b>", 2).matcher(string);
        if (matcher2.find() && (matcher = Pattern.compile("\u3053\u306e\u677f\u306esamba\u306f samba=(\\d+) sec").matcher(matcher2.group(1))).find() && (n = V2CMiscUtil.parseInt(matcher.group(1))) > 0) {
            v2CBoardItem.getBBS().setSamba24Time(n, v2CBoardItem);
        }
        if ((matcher = Pattern.compile("<body[^>]*>(?:\\s*<(?:!|\\p{Alpha}{2,})[^>]*>)*\\s*<b>([^<]+)<", 2).matcher(string)).find()) {
            int n3;
            String string2 = matcher.group(1);
            Matcher matcher3 = Pattern.compile("\\(Lv=(\\d{1,2})\\)").matcher(string2);
            Matcher matcher4 = Pattern.compile("\\(-Lv(\\d{1,2})\\)").matcher(string2);
            if (matcher3.find()) {
                n2 = V2CMiscUtil.parseInt(matcher3.group(1), -1);
            } else if (matcher4.find() && (n3 = V2CMiscUtil.parseInt(matcher4.group(1), -1)) > 0) {
                n2 = V2CNinjaUtil.getNinjaLevel(v2CBoardItem) - n3;
            }
        }
        if (n2 < 0 || n2 > 40) {
            return;
        }
        V2CNinjaUtil.setNinjaLevel(n2, v2CBoardItem, bl);
    }

    static V2CIntString checkBeforePost(V2CBoardItem v2CBoardItem, String string, int n, boolean bl, boolean bl2) {
        if (!V2CNinjaUtil.isNinjaApplicable(v2CBoardItem, string, bl, bl2)) {
            return null;
        }
        return V2CNinjaUtil.getNinjaState(v2CBoardItem).checkBeforePost(n, v2CBoardItem);
    }

    static void checkAfterPost(V2CBoardItem v2CBoardItem, int n) {
        V2CNinjaUtil.getNinjaState(v2CBoardItem).checkAfterPost(n);
    }

    private static boolean isNinjaApplied(V2CBoardItem v2CBoardItem, String string, boolean bl, boolean bl2) {
        return V2CNinjaUtil.isNinjaApplicable(false, v2CBoardItem, string, bl, bl2);
    }

    private static boolean isNinjaApplicable(V2CBoardItem v2CBoardItem, String string, boolean bl, boolean bl2) {
        return V2CNinjaUtil.isNinjaApplicable(true, v2CBoardItem, string, bl, bl2);
    }

    private static boolean isNinjaApplicable(boolean bl, V2CBoardItem v2CBoardItem, String string, boolean bl2, boolean bl3) {
        if (bl3 || v2CBoardItem == null || !v2CBoardItem.is2ch()) {
            return false;
        }
        V2CNinjaUtil.restoreNinjaConf();
        if (bl && !bUseNinjaLevel) {
            return false;
        }
        if (string != null && string.indexOf("!ninja") >= 0) {
            return true;
        }
        if (v2CBoardItem.isNinjaChecked()) {
            return true;
        }
        boolean bl4 = V2C2chBBS.isBBSPink(v2CBoardItem);
        String string2 = v2CBoardItem.getBoardDir();
        URL uRL = v2CBoardItem.getURL();
        if (string2 == null || uRL == null) {
            return false;
        }
        String string3 = uRL.getHost();
        if (bl4 ? bl2 : bl2 && !string2.matches("saku2ch")) {
            return true;
        }
        return bNinjaHost;
    }

    static int getMinPostInterval(V2CBoardItem v2CBoardItem, String string, boolean bl, boolean bl2) {
        if (!V2CNinjaUtil.isNinjaApplicable(v2CBoardItem, string, bl, bl2)) {
            return 0;
        }
        int n = V2CNinjaUtil.getNinjaLevel(v2CBoardItem);
        if (n < 0) {
            return 0;
        }
        if (n <= 1) {
            return 120;
        }
        if (n <= 2) {
            return 120;
        }
        if (n <= 3) {
            return 60;
        }
        if (n <= 5) {
            return 45;
        }
        if (n <= 7) {
            return 30;
        }
        if (n <= 19) {
            return 15;
        }
        if (n <= 29) {
            return 5;
        }
        if (n <= 34) {
            return 2;
        }
        return 1;
    }

    static float getMaxPostCharFactor(V2CBoardItem v2CBoardItem, String string, boolean bl, boolean bl2, boolean bl3) {
        if (!V2CNinjaUtil.isNinjaApplicable(v2CBoardItem, string, bl2, bl3)) {
            return 0.0f;
        }
        if (bl) {
            return 0.0f;
        }
        int n = V2CNinjaUtil.getNinjaLevel(v2CBoardItem);
        if (n < 0) {
            return 0.0f;
        }
        if (n <= 2) {
            return 0.3f;
        }
        if (n <= 5) {
            return 0.5f;
        }
        if (n <= 9) {
            return 0.7f;
        }
        return 1.0f;
    }

    static {
        v2chNinjaState = new NinjaState();
        vBPNinjaState = new NinjaState();
    }

    private static class NinjaState {
        long tLastWrite;
        int nNinjaLevel;
        long tStartTotal;
        int nTotalBytes;
        int nBytes0;
        int nBytes1;
        int nBytes2;

        private NinjaState() {
        }

        synchronized V2CIntString checkBeforePost(int n, V2CBoardItem v2CBoardItem) {
            if (V2CMiscUtil.isEqual(v2CBoardItem.getSettingProperty("BBS_NINJA"), "nashi")) {
                return null;
            }
            long l = System.currentTimeMillis();
            String string = null;
            if (this.tStartTotal > 0L && l >= this.tStartTotal && l <= this.tStartTotal + 300000L) {
                int n2 = this.nTotalBytes + n;
                if (n2 > 20480) {
                    string = "\u5fcd\u6cd5\u5e16\uff08\u672c\u6587\u7dcf\u91cf\u898f\u5236\uff09";
                }
                if (n2 > 6144 && n > 384 && n == this.nBytes0 && n == this.nBytes1) {
                    string = "\u5fcd\u6cd5\u5e16\uff08\u672c\u6587\u540c\u4e00\u30b5\u30a4\u30ba\u898f\u5236\uff09";
                }
            }
            return string != null ? new V2CIntString(300, (int)((l - this.tStartTotal) / 1000L), string) : null;
        }

        synchronized void checkAfterPost(int n) {
            long l;
            this.tLastWrite = l = System.currentTimeMillis();
            if (this.tStartTotal <= 0L || l < this.tStartTotal || l > this.tStartTotal + 300000L) {
                this.tStartTotal = l;
                this.nBytes0 = this.nTotalBytes = n;
                this.nBytes1 = 0;
                this.nBytes2 = 0;
            } else {
                this.nTotalBytes += n;
                if (this.nTotalBytes > 20480) {
                    this.tStartTotal = l;
                }
                this.nBytes2 = this.nBytes1;
                this.nBytes1 = this.nBytes0;
                this.nBytes0 = n;
                if (this.nTotalBytes <= 6144 || n <= 384 || n != this.nBytes1 || n == this.nBytes2) {
                    // empty if block
                }
            }
        }
    }
}

