/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.monazilla.v2c.V2CAbstractImagePanel;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CGestureActionEvent;
import org.monazilla.v2c.V2CImageCacheList;
import org.monazilla.v2c.V2CImageViewer;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CQuickImageSaveEntry;
import org.monazilla.v2c.V2CQuickImageSaveSP;
import org.monazilla.v2c.V2CSlideShowPanel;
import org.monazilla.v2c.V2CSubMenuFolder;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThumbnailStrip;

public class V2CQuickImageSaveMenu
extends JMenu
implements ActionListener,
MouseMotionListener,
PopupMenuListener {
    private static Reference refQuickImageSaveMenu;
    private static final String sFoldersKey = "Link.QuickImageSaveFolders";
    static ArrayList alRootEntries;
    static long ltConfigTime;
    String sCmd;
    Timer tScrollTimer;
    boolean bOnTop;
    Window wPopupWindow;
    long ltCreationTime = -1L;

    static void showQuickImageSavePopupMenu(Object object, ActionEvent actionEvent) {
        int n;
        int n2;
        Container container;
        Object object2;
        Serializable serializable;
        if (!(object instanceof JComponent)) {
            return;
        }
        boolean bl = actionEvent instanceof V2CGestureActionEvent;
        String string = actionEvent.getActionCommand();
        JComponent jComponent = (JComponent)object;
        if (!bl && jComponent instanceof V2CAbstractThreadPanel && !V2CMiscUtil.isEqual(string, "ST")) {
            if (string != null && string.length() == 2 && string.charAt(0) == 'M') {
                string = string.charAt(1) != '-' ? string.substring(1) : null;
            } else {
                serializable = (V2CAbstractThreadPanel)jComponent;
                if (!((V2CAbstractThreadPanel)serializable).isNormalMode()) {
                    return;
                }
                object2 = ((V2CAbstractThreadPanel)serializable).getTopPopup();
                if (object2 != null) {
                    if (!(object2 instanceof V2CAbstractThreadPanel)) {
                        return;
                    }
                    jComponent = (JComponent)object2;
                }
                string = "ST";
            }
        }
        serializable = null;
        if (jComponent instanceof V2CPanel) {
            object2 = (V2CPanel)((Object)jComponent);
            if (!(object2 instanceof V2CAbstractImagePanel || object2 instanceof V2CAbstractThreadPanel || object2 instanceof V2CImageCacheList)) {
                return;
            }
            if (bl) {
                serializable = ((V2CGestureActionEvent)actionEvent).getStartPoint();
                if (object2 instanceof V2CImageCacheList) {
                    ((V2CImageCacheList)object2).checkGestureOrigin((Point)serializable);
                }
                string = object2 instanceof V2CAbstractThreadPanel && ((V2CAbstractThreadPanel)object2).isSelTextGesture() ? "S" : "T";
                serializable = V2CSwingUtil.getMouseLocation(jComponent);
            } else if (string != null && string.equals("ST")) {
                serializable = V2CSwingUtil.getMouseLocation(jComponent);
                string = "S";
            } else if (string == null || !string.equals("C")) {
                string = "T";
            }
        } else {
            if (!(jComponent instanceof V2CImageViewer)) {
                return;
            }
            serializable = V2CSwingUtil.getMouseLocation(jComponent);
        }
        object2 = null;
        Reference reference = refQuickImageSaveMenu;
        if (reference != null) {
            object2 = (V2CQuickImageSaveMenu)refQuickImageSaveMenu.get();
        }
        if (object2 == null) {
            object2 = new V2CQuickImageSaveMenu(string);
            refQuickImageSaveMenu = new WeakReference<Object>(object2);
        } else {
            ((V2CQuickImageSaveMenu)object2).sCmd = string;
        }
        if (serializable == null && (container = jComponent.getParent()) instanceof JViewport) {
            serializable = ((JViewport)container).getViewPosition();
        }
        if (serializable != null) {
            n2 = ((Point)serializable).x;
            n = ((Point)serializable).y;
        } else {
            n2 = 0;
            n = 0;
        }
        JPopupMenu jPopupMenu = ((JMenu)object2).getPopupMenu();
        V2CPopupListener.showPopup(jPopupMenu, null, jComponent, n2, n);
    }

    static void setFolders() {
        V2CQuickImageSaveSP v2CQuickImageSaveSP = new V2CQuickImageSaveSP();
        if (!v2CQuickImageSaveSP.showDialog()) {
            return;
        }
        V2CQuickImageSaveMenu.postConfigFolders(v2CQuickImageSaveSP);
    }

    static void postConfigFolders(V2CQuickImageSaveSP v2CQuickImageSaveSP) {
        ArrayList arrayList;
        alRootEntries = arrayList = v2CQuickImageSaveSP.getResult();
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (arrayList.size() == 0) {
            v2CProperty.remove(sFoldersKey);
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        V2CQuickImageSaveMenu.saveEntries(0, arrayList, arrayList2);
        int n = arrayList2.size();
        v2CProperty.putPackedValueArray(sFoldersKey, arrayList2.toArray(new V2CPackedPropValue[n]));
        ltConfigTime = System.currentTimeMillis();
    }

    static void saveEntries(int n, ArrayList arrayList, ArrayList arrayList2) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Object object;
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            arrayList2.add(v2CPackedPropValue);
            Object e = arrayList.get(i);
            if (e instanceof V2CSubMenuFolder) {
                object = (V2CSubMenuFolder)e;
                v2CPackedPropValue.setString('L', ((V2CSubMenuFolder)object).sName);
                v2CPackedPropValue.setBoolean('f', true);
                v2CPackedPropValue.setChar('M', ((V2CSubMenuFolder)object).cMnemonic);
                V2CQuickImageSaveMenu.saveEntries(n + 1, ((V2CSubMenuFolder)object).alSubEntries, arrayList2);
            } else if (e instanceof V2CQuickImageSaveEntry) {
                object = (V2CQuickImageSaveEntry)e;
                if (((V2CQuickImageSaveEntry)object).isSeparator()) {
                    v2CPackedPropValue.setBoolean('s', true);
                } else {
                    v2CPackedPropValue.setString('L', ((V2CQuickImageSaveEntry)object).getName());
                    v2CPackedPropValue.setString('F', V2CLocalFileHandler.getV2CRelativePath(((V2CQuickImageSaveEntry)object).getFolder()));
                    v2CPackedPropValue.setChar('M', ((V2CQuickImageSaveEntry)object).getMnemonic());
                }
            } else {
                arrayList2.remove(arrayList2.size() - 1);
                continue;
            }
            if (n <= 0) continue;
            v2CPackedPropValue.setInt('D', n);
        }
    }

    static ArrayList restoreFolders() {
        ArrayList arrayList = alRootEntries;
        if (arrayList != null) {
            return arrayList;
        }
        alRootEntries = arrayList = new ArrayList();
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(sFoldersKey);
        if (v2CPackedPropValueArray != null) {
            int n = 0;
            for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
                V2CPackedPropValue v2CPackedPropValue = v2CPackedPropValueArray[i];
                boolean bl = v2CPackedPropValue.getBoolean('s');
                String string = v2CPackedPropValue.getString('L');
                if (!bl && string == null) continue;
                char c = V2CSwingUtil.restrictMnemonic(v2CPackedPropValue.getChar('M'));
                int n2 = v2CPackedPropValue.getInt('D');
                if (n2 > n) continue;
                if (n2 < n) {
                    for (int j = n - 1; j >= n2; --j) {
                        arrayList = (ArrayList)arrayList2.remove(j);
                    }
                    n = arrayList2.size();
                }
                if (bl) {
                    arrayList.add(V2CQuickImageSaveEntry.createSeparator());
                    continue;
                }
                if (v2CPackedPropValue.getBoolean('f')) {
                    V2CSubMenuFolder v2CSubMenuFolder = new V2CSubMenuFolder(string, c);
                    arrayList.add(v2CSubMenuFolder);
                    arrayList2.add(arrayList);
                    n = arrayList2.size();
                    arrayList = v2CSubMenuFolder.alSubEntries;
                    continue;
                }
                arrayList.add(V2CQuickImageSaveEntry.createEntry(string, v2CPackedPropValue.getString('F'), c));
            }
        }
        return alRootEntries;
    }

    public V2CQuickImageSaveMenu(String string) {
        super("\u30d5\u30a9\u30eb\u30c0\u306b\u76f4\u63a5\u4fdd\u5b58");
        this.sCmd = string;
    }

    public void updateUI() {
        super.updateUI();
        this.ltCreationTime = 0L;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        PopupMenuListener[] popupMenuListenerArray = jPopupMenu.getPopupMenuListeners();
        if (popupMenuListenerArray != null) {
            for (int i = 0; i < popupMenuListenerArray.length; ++i) {
                if (popupMenuListenerArray[i] != this) continue;
                return;
            }
        }
        jPopupMenu.addPopupMenuListener(this);
    }

    void createMenu() {
        ArrayList arrayList = V2CQuickImageSaveMenu.restoreFolders();
        if (this.ltCreationTime >= ltConfigTime) {
            return;
        }
        this.ltCreationTime = ltConfigTime;
        this.removeAll();
        this.createMenu(this, arrayList);
    }

    private void createMenu(JMenu jMenu, ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object e = arrayList.get(i);
            if (e instanceof V2CSubMenuFolder) {
                object2 = (V2CSubMenuFolder)e;
                object = ((V2CSubMenuFolder)object2).sName;
                char c = ((V2CSubMenuFolder)object2).cMnemonic;
                if (c > '\u0000') {
                    object = (String)object + " [" + c + "]";
                }
                JMenu jMenu2 = new JMenu((String)object);
                if (c > '\u0000') {
                    jMenu2.setMnemonic(c);
                }
                this.createMenu(jMenu2, ((V2CSubMenuFolder)object2).alSubEntries);
                jMenu2.addMouseMotionListener(this);
                jMenu.add(jMenu2);
                continue;
            }
            if (!(e instanceof V2CQuickImageSaveEntry)) continue;
            object2 = (V2CQuickImageSaveEntry)e;
            if (((V2CQuickImageSaveEntry)object2).isSeparator()) {
                jMenu.addSeparator();
                continue;
            }
            if (!((V2CQuickImageSaveEntry)object2).isOK()) continue;
            object = new QuickSaveMenuItem((V2CQuickImageSaveEntry)object2);
            ((AbstractButton)object).addActionListener(this);
            ((Component)object).addMouseMotionListener(this);
            jMenu.add((JMenuItem)object);
        }
        if (jMenu.getItemCount() == 0) {
            JMenuItem jMenuItem = new JMenuItem("\uff08\u306a\u3057\uff09");
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof QuickSaveMenuItem) {
            File file = ((QuickSaveMenuItem)object).fFolder;
            V2CLink.saveLastImageSaveDir(file, false);
            V2CPanel v2CPanel = V2CAction.getSourcePanel(actionEvent);
            if (v2CPanel instanceof V2CImageCacheList) {
                ((V2CImageCacheList)v2CPanel).saveSelectedImages(file, false, null);
            } else if (v2CPanel instanceof V2CAbstractImagePanel) {
                ((V2CAbstractImagePanel)v2CPanel).saveImage(file, false);
            } else if (v2CPanel instanceof V2CAbstractThreadPanel) {
                ((V2CAbstractThreadPanel)v2CPanel).saveImage(this.sCmd, file, false);
            } else {
                Component component = V2CAction.getInvoker(actionEvent);
                if (component instanceof V2CImageViewer) {
                    ((V2CImageViewer)component).saveImage(this.sCmd, file, false);
                } else if (component instanceof V2CSlideShowPanel) {
                    ((V2CSlideShowPanel)component).saveImage(file, false);
                } else if (component instanceof V2CThumbnailStrip) {
                    ((V2CThumbnailStrip)component).saveImage(file, false);
                }
            }
        } else if (object instanceof Timer) {
            Timer timer = (Timer)object;
            if (timer != this.tScrollTimer) {
                this.tScrollTimer = null;
                return;
            }
            Window window = this.wPopupWindow;
            if (window == null) {
                this.tScrollTimer = null;
                return;
            }
            Point point = V2CSwingUtil.getMouseLocationOnScreen(null);
            Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
            Rectangle rectangle2 = window.getBounds();
            int n = point.x;
            int n2 = point.y;
            if (n <= rectangle2.x || n >= rectangle2.x + rectangle2.width || (this.bOnTop ? n2 >= rectangle.y + 5 : n2 <= rectangle.y + rectangle.height - 5)) {
                this.tScrollTimer = null;
                return;
            }
            if (this.bOnTop) {
                if (rectangle2.y >= rectangle.y) {
                    this.tScrollTimer = null;
                    return;
                }
                rectangle2.y = Math.min(rectangle.y, rectangle2.y + 20);
            } else {
                if (rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
                    this.tScrollTimer = null;
                    return;
                }
                rectangle2.y = Math.max(rectangle.y + rectangle.height - rectangle2.height, rectangle2.y - 20);
            }
            window.setBounds(rectangle2);
            timer.start();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Timer timer;
        boolean bl;
        if (V2CApp.javaVersionLessThan(1, 5) && !V2CApp.isMacintosh() || this.tScrollTimer != null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return;
        }
        this.wPopupWindow = window;
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(mouseEvent.getPoint());
        Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseEvent);
        int n = point.y;
        if (n < rectangle.y + 5) {
            bl = true;
        } else if (n > rectangle.y + rectangle.height - 5) {
            bl = false;
        } else {
            return;
        }
        this.bOnTop = bl;
        Rectangle rectangle2 = window.getBounds();
        if (bl ? rectangle2.y >= rectangle.y : rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return;
        }
        this.tScrollTimer = timer = new Timer(50, this);
        timer.setRepeats(false);
        timer.start();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.createMenu();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    static class QuickSaveMenuItem
    extends JMenuItem {
        File fFolder;

        QuickSaveMenuItem(V2CQuickImageSaveEntry v2CQuickImageSaveEntry) {
            super(v2CQuickImageSaveEntry.toString());
            this.fFolder = v2CQuickImageSaveEntry.getFolder();
            char c = v2CQuickImageSaveEntry.getMnemonic();
            if (c > '\u0000') {
                this.setMnemonic(c);
            }
        }
    }
}

