/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CResLabel;
import org.monazilla.v2c.V2CThreadRes;

public class V2CResLabelMenu
extends JMenu {
    static Reference refResLabelMenu;
    static boolean bChanged;
    static V2CResItem vResItem;
    static Reference refThreadRes;
    ButtonGroup buttonGroup;

    static V2CResLabelMenu getInstance(String string) {
        V2CResLabelMenu v2CResLabelMenu = V2CResLabelMenu.getInstance();
        if (v2CResLabelMenu == null) {
            v2CResLabelMenu = new V2CResLabelMenu(string);
            refResLabelMenu = new SoftReference<V2CResLabelMenu>(v2CResLabelMenu);
        }
        return v2CResLabelMenu;
    }

    private static V2CResLabelMenu getInstance() {
        Reference reference = refResLabelMenu;
        if (reference != null) {
            return (V2CResLabelMenu)reference.get();
        }
        return null;
    }

    static void resLabelChanged() {
        bChanged = true;
    }

    static void setCurrentRes(V2CResItem v2CResItem, V2CThreadRes v2CThreadRes) {
        vResItem = v2CResItem;
        refThreadRes = new WeakReference<V2CThreadRes>(v2CThreadRes);
        V2CResLabelMenu v2CResLabelMenu = V2CResLabelMenu.getInstance();
        if (v2CResLabelMenu != null) {
            v2CResLabelMenu.setSelectedLabel(v2CResItem);
        }
    }

    public V2CResLabelMenu(String string) {
        super(string);
        bChanged = true;
        this.buttonGroup = new ButtonGroup();
    }

    void checkChange() {
        V2CAbstractAction v2CAbstractAction;
        if (!bChanged) {
            return;
        }
        bChanged = false;
        this.removeAll();
        this.add(new LabelMenuItem("\uff08\u306a\u3057\uff09"));
        V2CResLabel[] v2CResLabelArray = V2CResLabel.getLabels();
        if (v2CResLabelArray != null) {
            for (int i = 0; i < v2CResLabelArray.length; ++i) {
                this.add(new LabelMenuItem(v2CResLabelArray[i]));
            }
        }
        if ((v2CAbstractAction = V2CAction.getAction("MiscAction")) != null) {
            this.addSeparator();
            JMenuItem jMenuItem = new JMenuItem(v2CAbstractAction);
            jMenuItem.setText("\u30e9\u30d9\u30eb\u306e\u8a2d\u5b9a\u2026");
            jMenuItem.setActionCommand("Config$ResLabel");
            this.add(jMenuItem);
        }
    }

    void setSelectedLabel(V2CResItem v2CResItem) {
        this.checkChange();
        if (this.getItemCount() == 0) {
            return;
        }
        V2CResLabel v2CResLabel = v2CResItem != null ? v2CResItem.getResLabel() : null;
        LabelMenuItem labelMenuItem = null;
        if (v2CResLabel != null && v2CResLabel.isParent() && v2CResLabel.isActive()) {
            for (int i = this.getItemCount() - 1; i > 0; --i) {
                JMenuItem jMenuItem = this.getItem(i);
                if (!(jMenuItem instanceof LabelMenuItem)) continue;
                LabelMenuItem labelMenuItem2 = (LabelMenuItem)jMenuItem;
                if (v2CResLabel != labelMenuItem2.vResLabel) continue;
                labelMenuItem = labelMenuItem2;
                break;
            }
        } else {
            labelMenuItem = (LabelMenuItem)this.getItem(0);
        }
        if (labelMenuItem != null) {
            labelMenuItem.setSelected(true);
        }
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        super.add(jMenuItem);
        this.buttonGroup.add(jMenuItem);
        return jMenuItem;
    }

    public void remove(int n) {
        this.buttonGroup.remove(this.getItem(n));
        super.remove(n);
    }

    private static class LabelMenuItem
    extends JRadioButtonMenuItem
    implements ActionListener {
        V2CResLabel vResLabel;

        LabelMenuItem(String string) {
            super(string);
            this.addActionListener(this);
        }

        LabelMenuItem(V2CResLabel v2CResLabel) {
            super(v2CResLabel.getName());
            this.vResLabel = v2CResLabel;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            V2CThreadRes v2CThreadRes;
            if (refThreadRes != null && (v2CThreadRes = (V2CThreadRes)refThreadRes.get()) != null && vResItem != null) {
                v2CThreadRes.setResLabel(vResItem, this.vResLabel);
            }
        }
    }
}

