/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CSSBoxShadow;
import org.monazilla.v2c.V2CSSColor;
import org.monazilla.v2c.V2CSSColorGradation;
import org.monazilla.v2c.V2CSSDistance;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSSFontWeight;
import org.monazilla.v2c.V2CSSTextShadow;
import org.monazilla.v2c.V2CThreadStyle;
import org.monazilla.v2c.V2CVariableImage;

public class V2CStyleSheet {
    static final Integer SSKEY_BGColor;
    static final Integer SSKEY_BGGradation;
    static final Integer SSKEY_BGImage;
    static final Integer SSKEY_BGPosition;
    static final Integer SSKEY_BGAttachment;
    static final Integer SSKEY_BGRepeat;
    static final Integer SSKEY_BGOverflow;
    static final Integer SSKEY_BDColor;
    static final Integer SSKEY_BDImage;
    static final Integer SSKEY_BDOverflow;
    static final Integer SSKEY_BDStyle;
    static final Integer SSKEY_BDRadius;
    static final Integer SSKEY_BDWidth;
    static final Integer SSKEY_FTFamliy;
    static final Integer SSKEY_FTSize;
    static final Integer SSKEY_FTWeight;
    static final Integer SSKEY_TXAlign;
    static final Integer SSKEY_TXDecoration;
    static final Integer SSKEY_TXShadow;
    static final Integer SSKEY_Margin;
    static final Integer SSKEY_Padding;
    static final Integer SSKEY_Width;
    static final Integer SSKEY_MinWidth;
    static final Integer SSKEY_MaxWidth;
    static final Integer SSKEY_Height;
    static final Integer SSKEY_MinHeight;
    static final Integer SSKEY_Color;
    static final Integer SSKEY_LNHeight;
    static final Integer SSKEY_Opacity;
    static final Integer SSKEY_BoxShadow;
    static final Integer SSKEY_TBMarginOffset;
    static final Integer SSKEY_BBMarginOffset;
    static final Integer SSKEY_BDImgSrc;
    static final Integer SSKEY_BDImgSlc;
    static final Integer SSKEY_BDImgRpt;
    static final Integer SSKEY_BDImgOS;
    static final Integer SSKEY_FRColor;
    static final Integer SSKEY_THBG;
    static float fCM2PX;
    static float fMM2PX;
    static float fIN2PX;
    static float fPT2PX;
    static float fPC2PX;
    static final int BORDER_NONE = 0;
    static final int BORDER_HIDDEN = 1;
    static final int BORDER_DOTTED = 2;
    static final int BORDER_DASHED = 3;
    static final int BORDER_SOLID = 4;
    static final int BORDER_DOUBLE = 5;
    static final int BORDER_GROOVE = 6;
    static final int BORDER_RIDGE = 7;
    static final int BORDER_INSET = 8;
    static final int BORDER_OUTSET = 9;
    static final int BDIMGRPT_STRETCH = 0;
    static final int BDIMGRPT_REPEAT = 1;
    static final int BDIMGRPT_ROUND = 2;
    static final int BDIMGRPT_SPACE = 3;
    static final int TEXTALIGN_LEFT = 0;
    static final int TEXTALIGN_CENTER = 1;
    static final int TEXTALIGN_RIGHT = 2;
    static final int TEXTDECORATION_NONE = 0;
    static final int TEXTDECORATION_UNDERLINE = 1;
    static final int TEXTDECORATION_OVERLINE = 2;
    static final int TEXTDECORATION_LINETHROUGH = 4;
    static final int BG_NOREPEAT = 0;
    static final int BG_REPEATX = 1;
    static final int BG_REPEATY = 2;
    static final int BG_REPEAT = 3;
    static final int BGATTACHMENT_SCROLL = 0;
    static final int BGATTACHMENT_FIXED_SCROLL = 1;
    static final int BGATTACHMENT_SCROLL_FIXED = 2;
    static final int BGATTACHMENT_FIXED = 3;
    static final int BGATTACHMENT_HFIXED = 1;
    static final int BGATTACHMENT_VFIXED = 2;
    static final int MARGIN_AUTO = -2147483647;
    private static final boolean bDbg = false;
    Entry[] elStyles;
    final HashMap hmClasses = new HashMap();
    StringBuffer sbBuffer = new StringBuffer();
    boolean bInStyle;
    float fEM2PX;
    float fEX2PX;
    boolean bFixedAttachment;
    private static final Matcher mWord;
    static final Pattern pSize;
    private static Pattern pImage;
    private static final String sThreadBG = "threadbg";
    private static final Pattern pPosition;

    public V2CStyleSheet(V2CSSFont v2CSSFont, boolean bl) {
        this.setCurrentFont(v2CSSFont);
    }

    void setCurrentFont(V2CSSFont[] v2CSSFontArray) {
        if (v2CSSFontArray != null && v2CSSFontArray.length > 0) {
            this.setCurrentFont(v2CSSFontArray[0]);
        }
    }

    void setCurrentFont(V2CSSFont v2CSSFont) {
        float f;
        if (v2CSSFont == null) {
            return;
        }
        this.fEM2PX = f = v2CSSFont.getSize();
        this.fEX2PX = 0.6f * f;
    }

    boolean parse(V2CThreadStyle v2CThreadStyle) {
        StringBuffer stringBuffer = this.sbBuffer;
        int n = 0;
        while ((n = stringBuffer.indexOf("/*", n)) >= 0) {
            int n2 = stringBuffer.indexOf("*/", n + 2);
            if (n2 > 0) {
                stringBuffer.delete(n, n2 + 2);
                continue;
            }
            stringBuffer.delete(n, stringBuffer.length());
            break;
        }
        String string = stringBuffer.toString();
        Pattern pattern = Pattern.compile("\\s*([.#]?[A-Za-z][-\\w:.]*(?:\\s*,\\s*[.#]?[A-Za-z][-\\w:.]*)*)\\s*\\{");
        Matcher matcher = pattern.matcher(string);
        Pattern pattern2 = Pattern.compile("\\s*([-\\w]+)\\s*:\\s*([^;]*?)\\s*(?:;|$)");
        Matcher matcher2 = pattern2.matcher("");
        Pattern pattern3 = Pattern.compile("\\s*,\\s*");
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        HashMap hashMap = this.hmClasses;
        int n3 = 0;
        int n4 = 0;
        while (matcher.find(n3)) {
            Object object;
            Object object2;
            int n5;
            n3 = matcher.end();
            String string2 = matcher.group(1);
            String[] stringArray = string2.indexOf(44) >= 0 ? pattern3.split(string2) : new String[]{string2};
            int n6 = stringArray.length;
            Integer[] integerArray = new Integer[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                object2 = stringArray[n5];
                object = hashMap.get(object2);
                if (object == null) {
                    object = new Integer(n4++);
                    hashMap.put(object2, object);
                }
                integerArray[n5] = (Integer)object;
            }
            n5 = string.indexOf(125, n3);
            if (n5 < 0) {
                return false;
            }
            object2 = new HashMap();
            matcher2.reset(string.substring(n3, n5));
            object = new Object[2];
            int n7 = 0;
            while (matcher2.find(n7)) {
                String string3 = matcher2.group(1);
                object[1] = null;
                this.parseValue(string3, matcher2.group(2), (Object[])object, v2CThreadStyle, (HashMap)object2);
                Object v = object[1];
                if (v != null) {
                    ((HashMap)object2).put(object[0], v);
                }
                n7 = matcher2.end();
            }
            arrayList.add(new Entry(integerArray, (HashMap)object2));
            n3 = n5 + 1;
        }
        int n8 = arrayList.size();
        if (n8 > 0) {
            this.elStyles = arrayList.toArray(new Entry[n8]);
        }
        return true;
    }

    private String[] splitByComma(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c == ',') {
                if (n3 >= 0 && n4 >= n3) {
                    arrayList.add(string.substring(n3, n4 + 1));
                }
                n3 = -1;
                n4 = -1;
                continue;
            }
            if (c == ' ') continue;
            if (n3 < 0) {
                n3 = n;
            }
            n4 = n;
        }
        if (n3 >= 0) {
            arrayList.add(string.substring(n3, n2));
        }
        n = arrayList.size();
        return arrayList.toArray(new String[n]);
    }

    void parseValue(String string, String string2, Object[] objectArray, V2CThreadStyle v2CThreadStyle, HashMap hashMap) {
        int n = string.length();
        if (n < 4) {
            return;
        }
        char c = string.charAt(0);
        if (c == 'b') {
            char c2 = string.charAt(1);
            if (c2 == 'a') {
                char c3;
                char c4 = c3 = n > 11 ? string.charAt(11) : (char)'\u0000';
                if (c3 == 'c' && string.equals("background-color")) {
                    objectArray[0] = SSKEY_BGColor;
                    objectArray[1] = V2CSSColor.parseColor(string2);
                } else if (c3 == 'g' && string.equals("background-gradation")) {
                    objectArray[0] = SSKEY_BGGradation;
                    objectArray[1] = V2CSSColorGradation.parse(string2);
                } else if (c3 == 'i' && string.equals("background-image")) {
                    objectArray[0] = SSKEY_BGImage;
                    objectArray[1] = this.parseBGImage(string2, v2CThreadStyle, hashMap);
                } else if (c3 == 'p' && string.equals("background-position")) {
                    objectArray[0] = SSKEY_BGPosition;
                    objectArray[1] = this.parseBGPosition(string2);
                } else if (c3 == 'a' && string.equals("background-attachment")) {
                    objectArray[0] = SSKEY_BGAttachment;
                    String[] stringArray = string2.indexOf(44) < 0 ? new String[]{string2} : this.splitByComma(string2);
                    int[] nArray = new int[stringArray.length];
                    Matcher matcher = mWord;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3;
                        matcher.reset(stringArray[i]);
                        int n2 = 0;
                        if (matcher.find() && (string3 = matcher.group(1)).equals("fixed")) {
                            n2 = 3;
                        }
                        if (matcher.find()) {
                            string3 = matcher.group(1);
                            if (string3.equals("fixed")) {
                                n2 |= 2;
                            } else if (string3.equals("scroll")) {
                                n2 &= 0xFFFFFFFD;
                            }
                        }
                        nArray[i] = n2;
                    }
                    objectArray[1] = nArray;
                } else if (c3 == 'r' && string.equals("background-repeat")) {
                    objectArray[0] = SSKEY_BGRepeat;
                    String[] stringArray = string2.indexOf(44) >= 0 ? this.splitByComma(string2) : new String[]{string2};
                    int n3 = stringArray.length;
                    int[] nArray = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        String string4 = stringArray[i];
                        nArray[i] = string4.equals("repeat-x") ? 1 : (string4.equals("repeat-y") ? 2 : (string4.equals("no-repeat") ? 0 : 3));
                    }
                    objectArray[1] = nArray;
                } else if (c3 == 'o' && string.equals("background-overflow")) {
                    objectArray[0] = SSKEY_BGOverflow;
                    if (string2.indexOf(44) < 0) {
                        boolean[] blArray;
                        if (string2.equals("visible")) {
                            boolean[] blArray2 = new boolean[1];
                            blArray = blArray2;
                            blArray2[0] = true;
                        } else {
                            blArray = null;
                        }
                        objectArray[1] = blArray;
                    } else {
                        String[] stringArray = this.splitByComma(string2);
                        boolean[] blArray = new boolean[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            blArray[i] = stringArray[i].equals("visible");
                        }
                        objectArray[1] = blArray;
                    }
                }
            } else if (c2 == 'o') {
                char c5;
                char c6 = c5 = n > 7 ? string.charAt(7) : (char)'\u0000';
                if (c5 == 'c' && string.equals("border-color")) {
                    objectArray[0] = SSKEY_BDColor;
                    V2CSSColor[] v2CSSColorArray = V2CSSColor.parseColorArray(string2, 4);
                    if (v2CSSColorArray != null) {
                        int n4 = 4;
                        for (int i = 0; i < 4; ++i) {
                            if (v2CSSColorArray[i] != null) continue;
                            n4 = i;
                            break;
                        }
                        if (n4 > 0) {
                            this.distributeToFourSide(v2CSSColorArray, n4);
                        } else {
                            v2CSSColorArray = null;
                        }
                    }
                    objectArray[1] = v2CSSColorArray;
                } else if (c5 == 'i' && string.startsWith("border-image")) {
                    if (string.length() == 12) {
                        objectArray[0] = SSKEY_BDImage;
                        objectArray[1] = this.parseBorderImage(string2, v2CThreadStyle);
                    } else if (string.length() >= 15) {
                        char c7 = string.charAt(14);
                        if (c7 == 'e' && string.equals("border-image-repeat")) {
                            objectArray[0] = SSKEY_BDImgRpt;
                            int[] nArray = new int[2];
                            Matcher matcher = mWord.reset(string2);
                            int n5 = 0;
                            while (matcher.find()) {
                                String string5 = matcher.group(1);
                                int n6 = -1;
                                if (string5.equals("stretch")) {
                                    n6 = 0;
                                } else if (string5.equals("repeat")) {
                                    n6 = 1;
                                } else if (string5.equals("round")) {
                                    n6 = 2;
                                } else if (string5.equals("space")) {
                                    n6 = 3;
                                } else {
                                    nArray = null;
                                    break;
                                }
                                nArray[n5++] = n6;
                                if (n5 < 2) continue;
                                break;
                            }
                            if (nArray != null) {
                                if (n5 == 0) {
                                    nArray = null;
                                } else if (n5 == 1) {
                                    nArray[1] = nArray[0];
                                }
                            }
                            objectArray[1] = nArray;
                        } else if (c7 == 'o' && string.equals("border-image-source")) {
                            objectArray[0] = SSKEY_BDImgSrc;
                            objectArray[1] = this.parseImageSource(string2, v2CThreadStyle);
                        } else if (c7 == 'l' && string.equals("border-image-slice")) {
                            objectArray[0] = SSKEY_BDImgSlc;
                            objectArray[1] = this.parseBDImgSlc(string2, v2CThreadStyle);
                        } else if (c7 == 'u' && string.equals("border-image-outset")) {
                            objectArray[0] = SSKEY_BDImgOS;
                            objectArray[1] = this.parseTLBRSizes(string2);
                        }
                    }
                } else if (c5 == 'o' && string.equals("border-overflow")) {
                    objectArray[0] = SSKEY_BDOverflow;
                    boolean[] blArray = new boolean[]{false, true};
                    Matcher matcher = mWord.reset(string2);
                    int n7 = 0;
                    int n8 = 0;
                    while (matcher.find()) {
                        n7 = matcher.end();
                        String string6 = matcher.group(1);
                        blArray[n8] = string6.equals("visible");
                        if (++n8 < 2) continue;
                        break;
                    }
                    objectArray[1] = blArray;
                } else if (c5 == 's' && string.equals("border-style")) {
                    objectArray[0] = SSKEY_BDStyle;
                    int[] nArray = new int[4];
                    Matcher matcher = mWord.reset(string2);
                    int n9 = 0;
                    int n10 = 0;
                    while (matcher.find()) {
                        n9 = matcher.end();
                        String string7 = matcher.group(1);
                        int n11 = -1;
                        if (string7.equals("none")) {
                            n11 = 0;
                        } else if (string7.equals("hidden")) {
                            n11 = 1;
                        } else if (string7.equals("dotted")) {
                            n11 = 2;
                        } else if (string7.equals("dashed")) {
                            n11 = 3;
                        } else if (string7.equals("solid")) {
                            n11 = 4;
                        } else if (string7.equals("double")) {
                            n11 = 5;
                        } else if (string7.equals("groove")) {
                            n11 = 6;
                        } else if (string7.equals("ridge")) {
                            n11 = 7;
                        } else if (string7.equals("inset")) {
                            n11 = 8;
                        } else if (string7.equals("outset")) {
                            n11 = 9;
                        }
                        if (n11 >= 0) {
                            nArray[n10++] = n11;
                        }
                        if (n10 < 4) continue;
                        break;
                    }
                    this.distributeToFourSide(nArray, n10, 0);
                    objectArray[1] = nArray;
                } else if (c5 == 'r' && string.equals("border-radius")) {
                    objectArray[0] = SSKEY_BDRadius;
                    objectArray[1] = this.parseTLBRSizes(string2);
                } else if (c5 == 'w' && string.equals("border-width")) {
                    objectArray[0] = SSKEY_BDWidth;
                    objectArray[1] = this.parseTLBRSizes(string2);
                } else if (c5 == 'a' && string.equals("bottombar-margin-offset")) {
                    objectArray[0] = SSKEY_BBMarginOffset;
                    objectArray[1] = V2CSSDistance.parse(string2);
                } else if (c5 == 'd' && string.equals("box-shadow")) {
                    objectArray[0] = SSKEY_BoxShadow;
                    objectArray[1] = V2CSSBoxShadow.parse(string2);
                }
            }
        } else if (c == 'f') {
            char c8;
            char c9 = c8 = n > 5 ? string.charAt(5) : (char)'\u0000';
            if (c8 == 'f' && string.equals("font-family")) {
                objectArray[0] = SSKEY_FTFamliy;
                objectArray[1] = this.parseFontFamily(string2);
            } else if (c8 == 's' && string.equals("font-size")) {
                objectArray[0] = SSKEY_FTSize;
                objectArray[1] = this.parseFontSize(string2);
            } else if (c8 == 'w' && string.equals("font-weight")) {
                objectArray[0] = SSKEY_FTWeight;
                V2CSSFontWeight v2CSSFontWeight = null;
                if (string2.startsWith("normal")) {
                    v2CSSFontWeight = new V2CSSFontWeight(TextAttribute.WEIGHT_REGULAR);
                } else if (string2.startsWith("bold")) {
                    v2CSSFontWeight = new V2CSSFontWeight(TextAttribute.WEIGHT_BOLD);
                }
                if (v2CSSFontWeight != null && V2CStyleSheet.isImportant(string2) > 0) {
                    v2CSSFontWeight.setImportant();
                }
                objectArray[1] = v2CSSFontWeight;
            } else if (c8 == '-' && string.equals("frame-color")) {
                objectArray[0] = SSKEY_FRColor;
                objectArray[1] = V2CSSColor.parseColor(string2);
            }
        } else if (c == 't') {
            char c10;
            char c11 = c10 = n > 5 ? string.charAt(5) : (char)'\u0000';
            if (c10 == 'a' && string.equals("text-align")) {
                objectArray[0] = SSKEY_TXAlign;
                if (string2.equals("left")) {
                    objectArray[1] = new Integer(0);
                } else if (string2.equals("center")) {
                    objectArray[1] = new Integer(1);
                } else if (string2.equals("right")) {
                    objectArray[1] = new Integer(2);
                }
            } else if (c10 == 'd' && string.equals("text-decoration")) {
                objectArray[0] = SSKEY_TXDecoration;
                if (string2.equals("underline")) {
                    objectArray[1] = new Integer(1);
                } else if (string2.equals("none")) {
                    objectArray[1] = new Integer(0);
                } else if (string2.equals("overline")) {
                    objectArray[1] = new Integer(2);
                } else if (string2.equals("line-through")) {
                    objectArray[1] = new Integer(4);
                }
            } else if (c10 == 's' && string.equals("text-shadow")) {
                objectArray[0] = SSKEY_TXShadow;
                objectArray[1] = V2CSSTextShadow.parse(string2);
            } else if (c10 == 'r' && string.equals("topbar-margin-offset")) {
                objectArray[0] = SSKEY_TBMarginOffset;
                objectArray[1] = V2CSSDistance.parse(string2);
            }
        } else if (c == 'm') {
            if (string.equals("margin")) {
                objectArray[0] = SSKEY_Margin;
                objectArray[1] = this.parseTLBRSizes(string2, true);
            } else if (string.equals("min-height")) {
                objectArray[0] = SSKEY_MinHeight;
                objectArray[1] = string2.equals("fill") ? Boolean.TRUE : this.parseSize(string2);
            } else if (string.equals("min-width")) {
                objectArray[0] = SSKEY_MinWidth;
                objectArray[1] = this.parseSize(string2);
            } else if (string.equals("max-width")) {
                objectArray[0] = SSKEY_MaxWidth;
                objectArray[1] = this.parseSize(string2);
            }
        } else if (c == 'o' && string.equals("opacity")) {
            objectArray[0] = SSKEY_Opacity;
            objectArray[1] = this.parseFloat(string2, 0.0f, 1.0f);
        } else if (c == 'p' && string.equals("padding")) {
            objectArray[0] = SSKEY_Padding;
            objectArray[1] = this.parseTLBRSizes(string2);
        } else if (c == 'w' && string.equals("width")) {
            objectArray[0] = SSKEY_Width;
            objectArray[1] = this.parseWidth(string2);
        } else if (c == 'c' && string.equals("color")) {
            objectArray[0] = SSKEY_Color;
            objectArray[1] = V2CSSColor.parseColor(string2);
        } else if (c == 'l' && string.equals("line-height")) {
            objectArray[0] = SSKEY_LNHeight;
            objectArray[1] = string2.equals("normal") ? new Float(0.0f) : this.parseFloat(string2, 1.0f, 3.0f);
        }
    }

    static int isImportant(String string) {
        int n;
        if (string == null || !string.endsWith("important")) {
            return -1;
        }
        char c = '\u0000';
        for (n = string.length() - 10; n >= 0 && ((c = string.charAt(n)) == ' ' || c == '\t'); --n) {
        }
        if (n < 0) {
            return -1;
        }
        return n >= 0 && c == '!' ? n : -1;
    }

    private Float parseFloat(String string, float f, float f2) {
        float f3 = 0.0f;
        try {
            f3 = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (f3 < f) {
            f3 = f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        return new Float(f3);
    }

    private String[] parseFontFamily(String string) {
        int n;
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        int n3 = 0;
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            if (c == '\"' || c == '\'') {
                if (c2 != c) continue;
                if (n > n3 && bl) {
                    arrayList.add(string.substring(n3, n));
                }
                c = '\u0000';
                bl = false;
                n3 = n + 1;
                continue;
            }
            if (c2 == '\"' || c2 == '\'') {
                c = c2;
                n3 = n + 1;
                continue;
            }
            if (c2 != ',' && !Character.isWhitespace(c2)) continue;
            if (n > n3) {
                if (bl) {
                    arrayList.add(string.substring(n3, n));
                }
                bl = false;
            }
            n3 = n + 1;
            if (c2 != ',') continue;
            bl = true;
        }
        if (c == '\u0000' && n3 < n2) {
            arrayList.add(string.substring(n3, n2));
        }
        return (n = arrayList.size()) > 0 ? arrayList.toArray(new String[n]) : null;
    }

    private V2CSSDistance parseFontSize(String string) {
        return V2CSSDistance.parse(string, 36);
    }

    private V2CSSDistance[] parseWidth(String string) {
        return this.parseSizeArray(string, 1, 32);
    }

    private V2CSSDistance[] parseSize(String string) {
        return this.parseSizeArray(string, 1, 0);
    }

    private V2CSSDistance[] parseTLBRSizes(String string) {
        return this.parseTLBRSizes(string, false);
    }

    private V2CSSDistance[] parseTLBRSizes(String string, boolean bl) {
        return this.parseTLBRSizes(string, bl ? 16 : 0);
    }

    private V2CSSDistance[] parseTLBRSizes(String string, int n) {
        V2CSSDistance[] v2CSSDistanceArray = this.parseSizeArray(string, 4, n);
        int n2 = 4;
        for (int i = 0; i < 4; ++i) {
            if (v2CSSDistanceArray[i] != null) continue;
            n2 = i;
            break;
        }
        this.distributeToFourSide(v2CSSDistanceArray, n2);
        return v2CSSDistanceArray;
    }

    private V2CSSDistance[] parseSizeArray(String string, int n, int n2) {
        Matcher matcher = pSize.matcher(string);
        V2CSSDistance[] v2CSSDistanceArray = new V2CSSDistance[n];
        int n3 = 0;
        int n4 = 0;
        while (matcher.find(n3)) {
            if (matcher.start() != n3) {
                return v2CSSDistanceArray;
            }
            n3 = matcher.end();
            V2CSSDistance v2CSSDistance = V2CSSDistance.parse(matcher.group(1), n2);
            if (v2CSSDistance == null) {
                return v2CSSDistanceArray;
            }
            v2CSSDistanceArray[n4++] = v2CSSDistance;
            if (n4 < n) continue;
            break;
        }
        return v2CSSDistanceArray;
    }

    private BufferedImage parseImageSource(String string, V2CThreadStyle v2CThreadStyle) {
        if (string.equals("none")) {
            return new BufferedImage(0, 0, 2);
        }
        Matcher matcher = pImage.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        char c = string2.charAt(0);
        if (c == '\"' || c == '\'') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return v2CThreadStyle.readImage(string2);
    }

    private V2CVariableImage[] parseBGImage(String string, V2CThreadStyle v2CThreadStyle, HashMap hashMap) {
        V2CVariableImage[] v2CVariableImageArray;
        int n;
        int n2;
        int n3;
        if (string.equals("none")) {
            return new V2CVariableImage[0];
        }
        if (string.startsWith(sThreadBG)) {
            hashMap.put(SSKEY_THBG, Boolean.TRUE);
            n3 = string.length();
            for (n2 = sThreadBG.length(); n2 < n3; ++n2) {
                n = string.charAt(n2);
                if (n == 32 || n == 44) continue;
                string = string.substring(n2);
                break;
            }
        } else if (string.endsWith(sThreadBG)) {
            hashMap.put(SSKEY_THBG, Boolean.TRUE);
            n3 = string.length();
            if (n3 == sThreadBG.length()) {
                string = "";
            } else {
                n2 = 0;
                for (n = n3 - sThreadBG.length() - 1; n >= 0; --n) {
                    char c = string.charAt(n);
                    if (c == ',') {
                        n2 = 1;
                        continue;
                    }
                    if (c == ' ') continue;
                    if (n2 != 0) {
                        string = string.substring(0, n + 1);
                    } else {
                        hashMap.remove(SSKEY_THBG);
                    }
                    break;
                }
            }
        }
        Matcher matcher = pImage.matcher(string);
        n2 = string.length();
        ArrayList<V2CVariableImage> arrayList = null;
        V2CVariableImage v2CVariableImage = null;
        int n4 = 0;
        block2: while (matcher.find(n4) && matcher.start() == n4) {
            V2CVariableImage v2CVariableImage2;
            String string2 = matcher.group(1);
            int n5 = string2.length();
            if (n5 > 2) {
                if (string2.charAt(0) == '\"') {
                    if (string2.charAt(n5 - 1) == '\"') {
                        string2 = string2.substring(1, n5 - 1);
                    }
                } else if (string2.charAt(0) == '\'' && string2.charAt(n5 - 1) == '\'') {
                    string2 = string2.substring(1, n5 - 1);
                }
            }
            if ((v2CVariableImage2 = V2CVariableImage.readImage(v2CThreadStyle, string2)) != null) {
                if (v2CVariableImage == null) {
                    v2CVariableImage = v2CVariableImage2;
                } else {
                    if (arrayList == null) {
                        arrayList = new ArrayList<V2CVariableImage>();
                        arrayList.add(v2CVariableImage);
                    }
                    arrayList.add(v2CVariableImage2);
                }
            }
            boolean bl = false;
            for (n4 = matcher.end(); n4 < n2; ++n4) {
                char c = string.charAt(n4);
                if (c == ' ') continue;
                if (c == ',') {
                    if (bl) break block2;
                    bl = true;
                    continue;
                }
                if (!bl) break block2;
                continue block2;
            }
        }
        if (arrayList != null) {
            return arrayList.toArray(new V2CVariableImage[arrayList.size()]);
        }
        if (v2CVariableImage != null) {
            V2CVariableImage[] v2CVariableImageArray2 = new V2CVariableImage[1];
            v2CVariableImageArray = v2CVariableImageArray2;
            v2CVariableImageArray2[0] = v2CVariableImage;
        } else {
            v2CVariableImageArray = null;
        }
        return v2CVariableImageArray;
    }

    private BufferedImage[] parseBorderImage(String string, V2CThreadStyle v2CThreadStyle) {
        Matcher matcher = pImage.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        BufferedImage[] bufferedImageArray = new BufferedImage[17];
        int n = string2.indexOf("[A]");
        if (n >= 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 3);
            String[] stringArray = new String[]{"T", "TL", "L", "BL", "B", "BR", "R", "TR", "TE", "TLE", "LE", "BLE", "BE", "BRE", "RE", "TRE", "C"};
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedImageArray[i] = v2CThreadStyle.readImage(string3 + stringArray[i] + string4);
            }
        } else {
            n = string2.indexOf("[C]");
            if (n >= 0) {
                String string5 = string2.substring(0, n);
                String string6 = string2.substring(n + 3);
                String[] stringArray = new String[]{"TL", "BL", "BR", "TR"};
                for (int i = 0; i < stringArray.length; ++i) {
                    bufferedImageArray[2 * i + 1] = v2CThreadStyle.readImage(string5 + stringArray[i] + string6);
                }
            } else {
                n = string2.indexOf("[V]");
                if (n >= 0) {
                    String string7 = string2.substring(0, n);
                    String string8 = string2.substring(n + 3);
                    bufferedImageArray[2] = v2CThreadStyle.readImage(string7 + 'L' + string8);
                    bufferedImageArray[6] = v2CThreadStyle.readImage(string7 + 'R' + string8);
                } else {
                    bufferedImageArray[5] = bufferedImageArray[7] = v2CThreadStyle.readImage(string2);
                    bufferedImageArray[3] = bufferedImageArray[7];
                    bufferedImageArray[1] = bufferedImageArray[7];
                }
            }
        }
        return bufferedImageArray;
    }

    private V2CSSDistance[] parseBDImgSlc(String string, V2CThreadStyle v2CThreadStyle) {
        Matcher matcher = Pattern.compile("\\s+fill$").matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            string = string.substring(0, matcher.start());
        }
        V2CSSDistance[] v2CSSDistanceArray = this.parseSizeArray(string, 4, 161);
        int n = 4;
        for (int i = 0; i < 4; ++i) {
            if (v2CSSDistanceArray[i] != null) continue;
            n = i;
            break;
        }
        this.distributeToFourSide(v2CSSDistanceArray, n);
        if (bl) {
            V2CSSDistance[] v2CSSDistanceArray2 = new V2CSSDistance[5];
            System.arraycopy(v2CSSDistanceArray, 0, v2CSSDistanceArray2, 0, 4);
            v2CSSDistanceArray = v2CSSDistanceArray2;
        }
        return v2CSSDistanceArray;
    }

    private V2CSSDistance[][] parseBGPosition(String string) {
        if (string.indexOf(44) < 0) {
            V2CSSDistance[][] v2CSSDistanceArray;
            V2CSSDistance[] v2CSSDistanceArray2 = this.parseBGPosition1(string);
            if (v2CSSDistanceArray2 != null) {
                V2CSSDistance[][] v2CSSDistanceArrayArray = new V2CSSDistance[1][];
                v2CSSDistanceArray = v2CSSDistanceArrayArray;
                v2CSSDistanceArrayArray[0] = v2CSSDistanceArray2;
            } else {
                v2CSSDistanceArray = null;
            }
            return v2CSSDistanceArray;
        }
        String[] stringArray = this.splitByComma(string);
        int n = stringArray.length;
        V2CSSDistance[][] v2CSSDistanceArray = new V2CSSDistance[n][];
        for (int i = 0; i < n; ++i) {
            v2CSSDistanceArray[i] = this.parseBGPosition1(stringArray[i]);
        }
        return v2CSSDistanceArray;
    }

    private V2CSSDistance[] parseBGPosition1(String string) {
        Matcher matcher = pPosition.matcher(string);
        V2CSSDistance[] v2CSSDistanceArray = new V2CSSDistance[2];
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (matcher.find(n)) {
            n = matcher.end();
            V2CSSDistance v2CSSDistance = V2CSSDistance.parse(matcher.group(1), 104);
            if (v2CSSDistance == null) {
                return null;
            }
            int n2 = v2CSSDistance.getDirection();
            if (n2 == 1) {
                bl2 = true;
                v2CSSDistanceArray[0] = v2CSSDistance;
            } else if (n2 == 2) {
                bl3 = true;
                v2CSSDistanceArray[1] = v2CSSDistance;
            } else if (!bl2) {
                bl2 = true;
                v2CSSDistanceArray[0] = v2CSSDistance;
            } else if (!bl3) {
                bl3 = true;
                v2CSSDistanceArray[1] = v2CSSDistance;
            }
            if (!bl2 || !bl3) continue;
            break;
        }
        if (!bl2 && !bl3) {
            return null;
        }
        if (!bl2) {
            v2CSSDistanceArray[0] = new V2CSSDistance(50.0f, 10);
        }
        if (!bl3) {
            v2CSSDistanceArray[1] = new V2CSSDistance(50.0f, 10);
        }
        return v2CSSDistanceArray;
    }

    private void distributeToFourSide(int[] nArray, int n, int n2) {
        switch (n) {
            case 0: {
                Arrays.fill(nArray, n2);
                break;
            }
            case 1: {
                nArray[2] = nArray[3] = nArray[0];
                nArray[1] = nArray[3];
                break;
            }
            case 2: {
                nArray[2] = nArray[0];
                nArray[3] = nArray[1];
                break;
            }
            case 3: {
                nArray[3] = nArray[1];
                break;
            }
            case 4: {
                int n3 = nArray[1];
                nArray[1] = nArray[3];
                nArray[3] = n3;
            }
        }
    }

    private void distributeToFourSide(V2CSSDistance[] v2CSSDistanceArray, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                v2CSSDistanceArray[2] = v2CSSDistanceArray[3] = v2CSSDistanceArray[0];
                v2CSSDistanceArray[1] = v2CSSDistanceArray[3];
                break;
            }
            case 2: {
                v2CSSDistanceArray[2] = v2CSSDistanceArray[0];
                v2CSSDistanceArray[3] = v2CSSDistanceArray[1];
                break;
            }
            case 3: {
                v2CSSDistanceArray[3] = v2CSSDistanceArray[1];
                break;
            }
            case 4: {
                V2CSSDistance v2CSSDistance = v2CSSDistanceArray[1];
                v2CSSDistanceArray[1] = v2CSSDistanceArray[3];
                v2CSSDistanceArray[3] = v2CSSDistance;
            }
        }
    }

    private void distributeToFourSide(V2CSSColor[] v2CSSColorArray, int n) {
        switch (n) {
            case 1: {
                v2CSSColorArray[2] = v2CSSColorArray[3] = v2CSSColorArray[0];
                v2CSSColorArray[1] = v2CSSColorArray[3];
                break;
            }
            case 2: {
                v2CSSColorArray[2] = v2CSSColorArray[0];
                v2CSSColorArray[3] = v2CSSColorArray[1];
                break;
            }
            case 3: {
                v2CSSColorArray[3] = v2CSSColorArray[1];
                break;
            }
            case 4: {
                V2CSSColor v2CSSColor = v2CSSColorArray[1];
                v2CSSColorArray[1] = v2CSSColorArray[3];
                v2CSSColorArray[3] = v2CSSColor;
            }
        }
    }

    float getValue(V2CSSDistance v2CSSDistance, int n) {
        float f = this.getValue(v2CSSDistance);
        float f2 = this.getUnitFactor(n);
        return f2 != 0.0f ? f / f2 : f;
    }

    float getValue(V2CSSDistance v2CSSDistance) {
        if (v2CSSDistance == null) {
            return 0.0f;
        }
        float f = v2CSSDistance.getValue();
        int n = v2CSSDistance.getUnit();
        return n == 2 ? f : this.getUnitFactor(n) * f;
    }

    private float getUnitFactor(int n) {
        switch (n) {
            case 0: {
                return this.fEM2PX;
            }
            case 1: {
                return this.fEX2PX;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return fCM2PX;
            }
            case 4: {
                return fMM2PX;
            }
            case 5: {
                return fIN2PX;
            }
            case 6: {
                return fPT2PX;
            }
            case 7: {
                return fPC2PX;
            }
            case 8: {
                return V2CAbstractThreadPanel.nSNSAvatarSize;
            }
            case 9: {
                return V2CAbstractThreadPanel.nSNSAvatarSize;
            }
            case 10: {
                return 1.0f;
            }
            case 13: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    int getWidth(Integer[] integerArray) {
        int[] nArray = this.getIntArrayValue(integerArray, SSKEY_Width);
        return nArray != null && nArray.length == 1 ? nArray[0] : 0;
    }

    int getMinWidth(Integer[] integerArray) {
        int[] nArray = this.getIntArrayValue(integerArray, SSKEY_MinWidth);
        return nArray != null && nArray.length == 1 ? nArray[0] : 0;
    }

    int getMaxWidth(Integer[] integerArray) {
        int[] nArray = this.getIntArrayValue(integerArray, SSKEY_MaxWidth);
        return nArray != null && nArray.length == 1 ? nArray[0] : 0;
    }

    boolean getFillHeight(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_MinHeight);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    int getMinHeight(Integer[] integerArray) {
        int[] nArray = this.getIntArrayValue(integerArray, SSKEY_MinHeight);
        return nArray != null && nArray.length == 1 ? nArray[0] : 0;
    }

    int[] getMarginOffsets(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_TBMarginOffset);
        int n = object instanceof V2CSSDistance ? (int)this.getValue((V2CSSDistance)object) : Integer.MIN_VALUE;
        Object object2 = this.getValue(integerArray, SSKEY_BBMarginOffset);
        int n2 = object2 instanceof V2CSSDistance ? (int)this.getValue((V2CSSDistance)object2) : Integer.MIN_VALUE;
        if (n != Integer.MIN_VALUE || n2 != Integer.MIN_VALUE) {
            return new int[]{n, n2};
        }
        return null;
    }

    int[] getMargin(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_Margin);
    }

    int[] getPadding(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_Padding);
    }

    int[] getBorderStyle(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_BDStyle);
    }

    int[] getBorderRadius(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_BDRadius);
    }

    int[] getBorderWidth(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_BDWidth);
    }

    V2CSSColor[] getBorderColor(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BDColor);
        return object instanceof V2CSSColor[] ? (V2CSSColor[])object : null;
    }

    BufferedImage[] getBorderImage(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BDImage);
        return object instanceof BufferedImage[] ? (BufferedImage[])object : null;
    }

    BufferedImage getBDImgSrc(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BDImgSrc);
        return object instanceof BufferedImage ? (BufferedImage)object : null;
    }

    V2CSSDistance[] getBDImgSlc(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BDImgSlc);
        return object instanceof V2CSSDistance[] ? (V2CSSDistance[])object : null;
    }

    int[] getBDImgOS(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_BDImgOS);
    }

    int[] getBDImgRpt(Integer[] integerArray) {
        return this.getIntArrayValue(integerArray, SSKEY_BDImgRpt);
    }

    boolean[] getBDOverflow(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BDOverflow);
        return object instanceof boolean[] ? (boolean[])object : null;
    }

    V2CSSColor getBGColor(Integer[] integerArray) {
        return this.getColorValue(integerArray, SSKEY_BGColor);
    }

    V2CSSColorGradation getBGGradation(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BGGradation);
        if (object instanceof V2CSSColorGradation) {
            V2CSSColorGradation v2CSSColorGradation = (V2CSSColorGradation)object;
            v2CSSColorGradation.calcFixedDistance(this);
            return v2CSSColorGradation;
        }
        return null;
    }

    V2CVariableImage[] getBGImage(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BGImage);
        if (object instanceof V2CVariableImage[]) {
            return (V2CVariableImage[])object;
        }
        return null;
    }

    boolean getThreadBG(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_THBG);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    V2CSSDistance[][] getBGPosition(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BGPosition);
        return object instanceof V2CSSDistance[][] ? (V2CSSDistance[][])object : (V2CSSDistance[][])null;
    }

    int[] getBGRepeat(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BGRepeat);
        return object instanceof int[] ? (int[])object : null;
    }

    int[] getBGAttachment(Integer[] integerArray) {
        int[] nArray = this.getIntArrayValue(integerArray, SSKEY_BGAttachment);
        if (!this.bFixedAttachment && nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                this.bFixedAttachment = true;
                break;
            }
        }
        return nArray;
    }

    boolean fixedAttachmentExists() {
        return this.bFixedAttachment;
    }

    boolean[] getBGOverflow(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BGOverflow);
        return object instanceof boolean[] ? (boolean[])object : null;
    }

    String[] getFontFamily(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_FTFamliy);
        return object instanceof String[] ? (String[])object : null;
    }

    V2CSSDistance getFontSize(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_FTSize);
        return object instanceof V2CSSDistance ? (V2CSSDistance)object : null;
    }

    V2CSSFontWeight getFontWeight(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_FTWeight);
        return object instanceof V2CSSFontWeight ? (V2CSSFontWeight)object : null;
    }

    V2CSSColor getFrameColor() {
        Integer[] integerArray = this.convertClassToKey(new String[]{".popuproot"});
        if (integerArray == null) {
            return null;
        }
        return this.getColorValue(integerArray, SSKEY_FRColor);
    }

    V2CSSColor getColor(Integer[] integerArray) {
        return this.getColorValue(integerArray, SSKEY_Color);
    }

    Float getOpacity(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_Opacity);
        return object instanceof Float ? (Float)object : null;
    }

    V2CSSBoxShadow getBoxShadow(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_BoxShadow);
        return object instanceof V2CSSBoxShadow ? (V2CSSBoxShadow)object : null;
    }

    Float getLineHeight(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_LNHeight);
        return object instanceof Float ? (Float)object : null;
    }

    int getTextAlign(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_TXAlign);
        return object instanceof Integer ? (Integer)object : -1;
    }

    int getTextDecoration(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_TXDecoration);
        return object instanceof Integer ? (Integer)object : -1;
    }

    V2CSSTextShadow getTextShadow(Integer[] integerArray) {
        Object object = this.getValue(integerArray, SSKEY_TXShadow);
        if (!(object instanceof V2CSSTextShadow)) {
            return null;
        }
        V2CSSTextShadow v2CSSTextShadow = (V2CSSTextShadow)object;
        return v2CSSTextShadow.duplicate(this);
    }

    Integer[] convertClassToKey(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        HashMap hashMap = this.hmClasses;
        boolean bl = false;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)hashMap.get(stringArray[i]);
            if (n2 == null) continue;
            integerArray[i] = n2;
            bl = true;
        }
        return bl ? integerArray : null;
    }

    private int[] getIntArrayValue(Integer[] integerArray, Object object) {
        Object object2 = this.getValue(integerArray, object);
        if (object2 instanceof int[]) {
            return (int[])object2;
        }
        if (object2 instanceof V2CSSDistance[]) {
            V2CSSDistance[] v2CSSDistanceArray = (V2CSSDistance[])object2;
            int n = v2CSSDistanceArray.length;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                V2CSSDistance v2CSSDistance = v2CSSDistanceArray[i];
                int n2 = 0;
                if (v2CSSDistance != null) {
                    int n3 = v2CSSDistance.getUnit();
                    n2 = n3 == 12 ? -2147483647 : (n3 == 10 ? -((int)(v2CSSDistance.getValue() * 10000.0f)) : (int)this.getValue(v2CSSDistance));
                }
                nArray[i] = n2;
            }
            return nArray;
        }
        return null;
    }

    private V2CSSColor getColorValue(Integer[] integerArray, Object object) {
        Object object2 = this.getValue(integerArray, object);
        return object2 instanceof V2CSSColor ? (V2CSSColor)object2 : null;
    }

    private Object getValue(Integer[] integerArray, Object object) {
        Entry[] entryArray = this.elStyles;
        if (entryArray == null) {
            return null;
        }
        Object object2 = null;
        for (int i = 0; i < entryArray.length; ++i) {
            Object object3 = entryArray[i].get(integerArray, object);
            if (object3 == null) continue;
            object2 = object3;
        }
        return object2;
    }

    void append(String string) {
        this.sbBuffer.append(string);
    }

    static {
        float f;
        SSKEY_BGColor = new Integer(1);
        SSKEY_BGGradation = new Integer(2);
        SSKEY_BGImage = new Integer(3);
        SSKEY_BGPosition = new Integer(4);
        SSKEY_BGAttachment = new Integer(5);
        SSKEY_BGRepeat = new Integer(6);
        SSKEY_BGOverflow = new Integer(7);
        SSKEY_BDColor = new Integer(8);
        SSKEY_BDImage = new Integer(9);
        SSKEY_BDOverflow = new Integer(10);
        SSKEY_BDStyle = new Integer(11);
        SSKEY_BDRadius = new Integer(12);
        SSKEY_BDWidth = new Integer(13);
        SSKEY_FTFamliy = new Integer(14);
        SSKEY_FTSize = new Integer(15);
        SSKEY_FTWeight = new Integer(16);
        SSKEY_TXAlign = new Integer(17);
        SSKEY_TXDecoration = new Integer(18);
        SSKEY_TXShadow = new Integer(19);
        SSKEY_Margin = new Integer(20);
        SSKEY_Padding = new Integer(21);
        SSKEY_Width = new Integer(22);
        SSKEY_MinWidth = new Integer(23);
        SSKEY_MaxWidth = new Integer(24);
        SSKEY_Height = new Integer(25);
        SSKEY_MinHeight = new Integer(26);
        SSKEY_Color = new Integer(27);
        SSKEY_LNHeight = new Integer(28);
        SSKEY_Opacity = new Integer(29);
        SSKEY_BoxShadow = new Integer(30);
        SSKEY_TBMarginOffset = new Integer(31);
        SSKEY_BBMarginOffset = new Integer(32);
        SSKEY_BDImgSrc = new Integer(33);
        SSKEY_BDImgSlc = new Integer(34);
        SSKEY_BDImgRpt = new Integer(35);
        SSKEY_BDImgOS = new Integer(36);
        SSKEY_FRColor = new Integer(100);
        SSKEY_THBG = new Integer(1000);
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        if (n <= 0) {
            n = 72;
        }
        fIN2PX = f = (float)n;
        fCM2PX = f / 2.54f;
        fMM2PX = fCM2PX / 10.0f;
        fPT2PX = f / 72.0f;
        fPC2PX = f / 6.0f;
        mWord = Pattern.compile("\\s*(\\w+)").matcher("");
        pSize = Pattern.compile("\\s*(-?[\\w.%]+)(?:\\s|$)");
        pImage = Pattern.compile("url\\(\\s*([^\\)\\s]+|\"[^\"]+\"|'[^']+')\\s*\\)");
        pPosition = Pattern.compile("\\s*(-?[\\w.%]+)");
    }

    static class Entry {
        Integer[] ilSelectors;
        HashMap hmProperties;

        Entry(Integer[] integerArray, HashMap hashMap) {
            this.ilSelectors = integerArray;
            this.hmProperties = hashMap;
        }

        Object get(Integer[] integerArray, Object object) {
            Integer[] integerArray2 = this.ilSelectors;
            for (int i = 0; i < integerArray2.length; ++i) {
                for (int j = 0; j < integerArray.length; ++j) {
                    if (integerArray2[i] != integerArray[j]) continue;
                    return this.hmProperties.get(object);
                }
            }
            return null;
        }
    }
}

