/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputAdapter;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CAnimationController
extends JPanel
implements ActionListener {
    private static V2CAnimationController vAnimationController;
    V2CImageSet vImageSet;
    String sImageCount;
    JWindow jwPopup;
    JPanel jpMove;
    JButton jbStop;
    JButton jbNextFrame;
    JButton jbPlayNormal;
    JButton jbPlayFast;
    JTextField jtfCount;
    JButton jbClose;

    static void showController(V2CImageSet v2CImageSet, JComponent jComponent, Point point) {
        if (v2CImageSet == null || v2CImageSet.getImageCount() <= 1) {
            return;
        }
        if (vAnimationController == null) {
            vAnimationController = new V2CAnimationController();
        }
        vAnimationController.showPanel(v2CImageSet, jComponent, point);
    }

    static void displayIndexChanged(V2CImageSet v2CImageSet, int n) {
        if (vAnimationController != null) {
            vAnimationController.setDisplayIndex(v2CImageSet, n);
        }
    }

    static void imagePopupClosed(V2CImageSet v2CImageSet) {
        if (vAnimationController != null) {
            vAnimationController.checkClose(v2CImageSet);
        }
    }

    public V2CAnimationController() {
        super(new GridBagLayout());
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        Insets insets = new Insets(2, 7, 2, 7);
        this.jpMove = jPanel = new JPanel(null);
        jPanel.setBorder(new BevelBorder(0));
        jPanel.setCursor(Cursor.getPredefinedCursor(12));
        jPanel.setPreferredSize(new Dimension(15, 10));
        DragMover dragMover = new DragMover();
        jPanel.addMouseListener(dragMover);
        jPanel.addMouseMotionListener(dragMover);
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbStop = this.createButton("arstop", "Stop", insets, gridBagConstraints);
        this.jbNextFrame = this.createButton("acnext", "NextFrame", insets, gridBagConstraints);
        this.jbPlayNormal = this.createButton("arstart", "NormalPlay", insets, gridBagConstraints);
        this.jbPlayFast = this.createButton("acfast", "FastPlay", insets, gridBagConstraints);
        this.jtfCount = new JTextField(5);
        this.jtfCount.setFocusable(false);
        this.jtfCount.setEditable(false);
        this.jtfCount.setFont(this.jtfCount.getFont().deriveFont(1, 12.0f));
        this.jtfCount.setHorizontalAlignment(4);
        if (V2CApp.isMacintosh()) {
            this.jtfCount.setMargin(new Insets(1, 1, 1, 1));
            if (V2CMacQuaquaSupport.needsGeometryTweak()) {
                V2CMacQuaquaSupport.resetVisualMargin(this.jtfCount);
            }
        }
        this.add((Component)this.jtfCount, gridBagConstraints);
        ++gridBagConstraints.gridx;
        Insets insets2 = new Insets(2, 2, 2, 2);
        this.jbClose = this.createButton("arclose", null, insets2, gridBagConstraints);
    }

    private JButton createButton(String string, String string2, Insets insets, GridBagConstraints gridBagConstraints) {
        JButton jButton = new JButton(V2CSwingUtil.getSystemIcon(string));
        jButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(jButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(jButton);
        }
        if (string2 != null) {
            jButton.setActionCommand(string2);
        }
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        this.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jButton;
    }

    private void showPanel(V2CImageSet v2CImageSet, JComponent jComponent, Point point) {
        boolean bl;
        V2CImageSet v2CImageSet2 = this.vImageSet;
        boolean bl2 = bl = v2CImageSet != v2CImageSet2;
        if (bl) {
            this.vImageSet = v2CImageSet;
        }
        this.sImageCount = "/" + v2CImageSet.getImageCount();
        if (point == null) {
            point = V2CSwingUtil.getMouseLocationOnScreen(null);
            point.translate(-10, -10);
        }
        JWindow jWindow = this.jwPopup;
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (jWindow != null && jWindow.isVisible() && window != jWindow.getOwner()) {
            this.hidePanel();
            jWindow = null;
        }
        if (jWindow == null || !jWindow.isVisible()) {
            this.jwPopup = jWindow = new JWindow(window);
            jWindow.getContentPane().add((Component)this, "Center");
            jWindow.setLocation(point);
            jWindow.pack();
            jWindow.setVisible(true);
        } else {
            if (bl) {
                jWindow.setLocation(point);
            }
            jWindow.toFront();
        }
    }

    void hidePanel() {
        this.jwPopup.setVisible(false);
        this.jwPopup.getContentPane().remove(this);
    }

    void setDisplayIndex(V2CImageSet v2CImageSet, int n) {
        if (v2CImageSet == this.vImageSet) {
            this.jtfCount.setText(n + 1 + this.sImageCount);
        }
    }

    void checkClose(V2CImageSet v2CImageSet) {
        if (v2CImageSet == this.vImageSet) {
            this.hidePanel();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbClose) {
            this.hidePanel();
        } else if (object instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (this.vImageSet != null && string != null) {
                this.vImageSet.controlGIFAnimation(string);
            }
        }
    }

    private class DragMover
    extends MouseInputAdapter {
        int nX;
        int nY;
        boolean bCursorSet;

        private DragMover() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.nX = -mouseEvent.getX();
            this.nY = -mouseEvent.getY();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.bCursorSet) {
                this.bCursorSet = false;
                V2CAnimationController.this.jpMove.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseEvent);
            point.translate(this.nX, this.nY);
            V2CAnimationController.this.jwPopup.setLocation(point);
            if (!this.bCursorSet) {
                this.bCursorSet = true;
                V2CAnimationController.this.jpMove.setCursor(Cursor.getPredefinedCursor(13));
            }
        }
    }
}

