/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CImageBBSProps {
    private final int BBS_OTHER = 0;
    private final int BBS_G2 = 1;
    private final int BBS_BLOGKAKIKO = 2;
    private final int BBS_IMG0CH = 3;
    private final int BBS_CYNTHIA = 4;
    private final int BBS_ULACC = 5;
    final V2CBoardItem vBoardItem;
    final int nBBS;

    public V2CImageBBSProps(V2CBoardItem v2CBoardItem) {
        V2CProperty v2CProperty;
        String string;
        this.vBoardItem = v2CBoardItem;
        String string2 = this.vBoardItem.getURLString();
        if (string2 == null) {
            this.nBBS = 0;
            return;
        }
        this.nBBS = string2.matches("https?://[\\w-]+\\.ula\\.cc/.+") ? 5 : (string2.startsWith("http://up.80.kg/") && string2.endsWith("banana100m/") ? 1 : (string2.charAt(7) == 'b' && (string2.regionMatches(10, ".30.kg/", 0, 7) || string2.regionMatches(10, ".kakiko.com/", 0, 12)) ? 2 : ((string = (v2CProperty = this.vBoardItem.getSettingProperty()).get("BBS_MODE")) != null && (string.length() == 0 || string.equals("news") || string.equals("picture")) ? 3 : 0)));
    }

    boolean isG2() {
        return this.nBBS == 1;
    }

    boolean isBlogKakiko() {
        return this.nBBS == 2;
    }

    String createThumbnailURLString(String string) {
        if (string == null) {
            return null;
        }
        switch (this.nBBS) {
            case 1: {
                return this.createG2URLString(string, true);
            }
            case 2: {
                return this.createBlogKakikoURLString(string, true);
            }
        }
        return null;
    }

    String createOriginalURLString(String string) {
        if (string == null) {
            return null;
        }
        switch (this.nBBS) {
            case 1: {
                return this.createG2URLString(string, false);
            }
            case 2: {
                return this.createBlogKakikoURLString(string, false);
            }
        }
        return null;
    }

    private String createG2URLString(String string, boolean bl) {
        if (string.length() < 20) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("http://up.80.kg/_img/");
        if (bl) {
            stringBuffer.append("_thumbnail/");
        }
        stringBuffer.append(string.substring(0, 4));
        stringBuffer.append('/');
        stringBuffer.append(string.substring(0, 8));
        stringBuffer.append('/');
        stringBuffer.append(string.substring(8, 10));
        stringBuffer.append('/');
        stringBuffer.append(string);
        if (bl) {
            int n = stringBuffer.length();
            if (stringBuffer.charAt(n - 4) == '.') {
                stringBuffer.insert(n - 4, 's');
            } else if (stringBuffer.charAt(n - 5) == '.') {
                stringBuffer.insert(n - 5, 's');
            }
        }
        return stringBuffer.toString();
    }

    private String createBlogKakikoURLString(String string, boolean bl) {
        if (string.length() < 20) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("http://");
        stringBuffer.append(this.vBoardItem.getURL().getHost());
        stringBuffer.append("/_img/");
        if (bl) {
            stringBuffer.append("_thumbnail/");
        }
        stringBuffer.append(string.substring(0, 4));
        stringBuffer.append('/');
        stringBuffer.append(string.substring(0, 8));
        stringBuffer.append('/');
        stringBuffer.append(string.substring(8, 10));
        stringBuffer.append('/');
        stringBuffer.append(string);
        if (bl) {
            int n = stringBuffer.length();
            if (stringBuffer.charAt(n - 4) == '.') {
                stringBuffer.insert(n - 4, 's');
            } else if (stringBuffer.charAt(n - 5) == '.') {
                stringBuffer.insert(n - 5, 's');
            }
        }
        return stringBuffer.toString();
    }

    boolean checkFileSize(int n) {
        switch (this.nBBS) {
            case 1: 
            case 2: {
                return n <= 0xA00000;
            }
            case 3: {
                V2CProperty v2CProperty = this.vBoardItem.getSettingProperty();
                int n2 = v2CProperty.getInt("BBS_IMG_MAX_SIZE", -1);
                if (n2 < 0) {
                    n2 = v2CProperty.getInt("IMG_MAX_SIZE");
                }
                return n2 > 0 && n <= n2;
            }
        }
        return true;
    }

    boolean postByMultiPart(boolean bl) {
        return this.canUploadFile(bl);
    }

    boolean canUploadFile(boolean bl) {
        switch (this.nBBS) {
            case 1: {
                return true;
            }
            case 3: {
                String string = this.vBoardItem.getSettingProperty().get("BBS_MODE");
                return string != null && (bl ? string.equals("news") : string.equals("picture"));
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    boolean canSetDelPass() {
        return this.nBBS == 1 || this.nBBS == 4;
    }

    private String[] getSupportedFormats() {
        switch (this.nBBS) {
            case 1: {
                return new String[]{"gif", "jpeg", "png"};
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    String guessMimeType(File file) {
        String[][] stringArrayArray;
        String[] stringArray;
        String string;
        block28: {
            IOException iOException2222;
            ImageReader imageReader;
            ImageInputStream imageInputStream;
            block26: {
                block25: {
                    int n = (int)file.length();
                    if (n == 0) {
                        V2CSwingUtil.showErrorMessage("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\n\u5185\u5bb9\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        return null;
                    }
                    if (!this.checkFileSize(n)) {
                        V2CSwingUtil.showErrorMessage("\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u904e\u304e\u307e\u3059\u3002");
                        return null;
                    }
                    string = null;
                    imageInputStream = null;
                    imageReader = null;
                    imageInputStream = ImageIO.createImageInputStream(file);
                    if (imageInputStream == null || !(stringArray = ImageIO.getImageReaders(imageInputStream)).hasNext()) break block25;
                    imageReader = stringArray.next();
                    imageReader.setInput(imageInputStream);
                    string = imageReader.getFormatName();
                }
                stringArrayArray = null;
                if (imageInputStream == null) break block26;
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (imageReader != null) {
                imageReader.dispose();
            }
            break block28;
            {
                catch (IOException iOException3) {
                    System.out.println(iOException3.getMessage());
                    stringArrayArray = null;
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (IOException iOException2222) {
                            // empty catch block
                        }
                    }
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (imageInputStream != null) {
                    try {
                        imageInputStream.close();
                    }
                    catch (IOException iOException4) {
                        // empty catch block
                    }
                }
                if (imageReader != null) {
                    imageReader.dispose();
                }
                throw throwable;
            }
        }
        stringArray = this.getSupportedFormats();
        if (string != null) {
            string = string.toLowerCase();
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return null;
                }
            }
            string = "image/" + string;
        } else if (stringArray == null) {
            String string2 = V2CLocalFileHandler.getFileExtension(file);
            if (string2 != null) {
                stringArrayArray = new String[][]{{"zip", "application/zip"}, {"pdf", "application/pdf"}, {"rar", "application/rar"}, {"txt", "text/plain"}};
                for (int i = 0; i < stringArrayArray.length; ++i) {
                    String[] stringArray2 = stringArrayArray[i];
                    if (!string2.equals(stringArray2[0])) continue;
                    string = stringArray2[1];
                    break;
                }
            }
            if (string == null) {
                string = "application/octet-stream";
            }
        }
        if (string == null) {
            V2CSwingUtil.showErrorMessage("\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc");
        }
        return string;
    }
}

