/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CKeyword;
import org.monazilla.v2c.V2CKeywordConstants;
import org.monazilla.v2c.V2CKeywordItem;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CThreadItem;

public abstract class V2CKeywordSet
implements V2CKeywordConstants {
    private static final String sDefExpirationKey = "Keyword.DefExpiration";
    static final int EXPIRATION_THREAD = 0;
    static final int EXPIRATION_THRDKWD = 1;
    static final int EXPIRATION_NAME = 2;
    static final int EXPIRATION_EMAIL = 3;
    static final int EXPIRATION_MESSAGE = 4;
    static final int EXPIRATION_NGEX = 5;
    static final int EXPIRATION_MSGKWD = 6;
    static final int EXPIRATION_NAMEKWD = 7;
    static final int EXPIRATION_TWUSER = 8;
    static final int EXPIRATION_TWCLIENT = 9;
    static final int EXPIRATION_NOEXP = 10;
    private static final int EXPIRATION_SIZE = 10;
    static final int[] nlExpiration = new int[10];
    static final byte[] blSaveKeyChar = new byte[]{84, 72, 78, 69, 77, 88, 75, 80, 85, 67, 0};
    final V2CProperty vProperty;
    V2CKeyword[] lKeyword;
    V2CKeywordItem[] lItems;
    final int iDefExpirationIndex;
    V2CThreadItem vThreadItem;
    V2CKeywordItem[] vLastItems;
    V2CKeywordItem[] vLastItemsForCheck;

    static int getDefaultNGExExpirationInDays() {
        return nlExpiration[5] / 1440;
    }

    static int getDefaultNGExExpiration() {
        return nlExpiration[5];
    }

    static void setDefaultNGExExpiration(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n != V2CKeywordSet.getDefaultNGExExpirationInDays()) {
            V2CKeywordSet.nlExpiration[5] = n * 1440;
            V2CKeywordSet.saveDefExpiration();
        }
    }

    static void saveDefExpiration() {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        int[] nArray = nlExpiration;
        byte[] byArray = blSaveKeyChar;
        boolean bl = false;
        for (int i = 0; i < 10; ++i) {
            int n;
            char c = (char)byArray[i];
            if (c <= '\u0000' || (n = nArray[i]) <= 0) continue;
            v2CPackedPropValue.setInt(c, nArray[i] / 1440);
            bl = true;
        }
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (bl) {
            v2CProperty.putPackedValue(sDefExpirationKey, v2CPackedPropValue);
        } else {
            v2CProperty.remove(sDefExpirationKey);
        }
    }

    abstract int getLevelCount();

    abstract V2CKeywordItem createItem(V2CKeyword var1, String var2, boolean var3, boolean var4);

    public V2CKeywordSet(V2CProperty v2CProperty, int n) {
        this.vProperty = v2CProperty;
        this.iDefExpirationIndex = n;
    }

    int getDefaultExpiration() {
        return nlExpiration[this.iDefExpirationIndex];
    }

    int getDefaultExpirationInDays() {
        return this.getDefaultExpiration() / 1440;
    }

    boolean isDefExpAvailable() {
        return this.iDefExpirationIndex != 10;
    }

    void setDefaultExpiration(int n) {
        if (!this.isDefExpAvailable()) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n != this.getDefaultExpirationInDays()) {
            V2CKeywordSet.nlExpiration[this.iDefExpirationIndex] = n * 1440;
            V2CKeywordSet.saveDefExpiration();
        }
    }

    void resetFirst() {
        this.lKeyword[0].reset();
        this.itemChanged();
    }

    void itemChanged() {
        this.lItems = null;
    }

    void checkAppliedTimeChange() {
        this.checkAppliedTimeChange(V2CMiscUtil.currentTimeMins());
    }

    void checkAppliedTimeChange(int n) {
        V2CKeyword[] v2CKeywordArray = this.lKeyword;
        if (v2CKeywordArray == null) {
            return;
        }
        for (int i = 0; i < this.getLevelCount(); ++i) {
            V2CKeyword v2CKeyword = v2CKeywordArray[i];
            if (v2CKeyword == null) continue;
            v2CKeyword.checkAppliedTimeChanged(n);
        }
    }

    void checkExpiration(int n) {
        V2CKeyword[] v2CKeywordArray = this.lKeyword;
        if (v2CKeywordArray == null) {
            return;
        }
        int n2 = this.getDefaultExpiration();
        for (int i = 0; i < this.getLevelCount(); ++i) {
            V2CKeyword v2CKeyword = v2CKeywordArray[i];
            if (v2CKeyword == null) continue;
            v2CKeyword.checkExpiration(n, n2);
        }
    }

    abstract V2CKeywordItem[] createKeywordItemArray(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V2CKeywordItem[] getItemArray() {
        V2CKeywordItem[] v2CKeywordItemArray = this.lItems;
        if (v2CKeywordItemArray != null) {
            return v2CKeywordItemArray;
        }
        V2CKeyword[] v2CKeywordArray = this.lKeyword;
        if (v2CKeywordArray != null) {
            ArrayList<V2CKeywordItem> arrayList = new ArrayList<V2CKeywordItem>();
            for (int i = this.getLevelCount() - 1; i >= 0; --i) {
                V2CKeyword v2CKeyword = this.lKeyword[i];
                if (v2CKeyword == null) continue;
                V2CKeyword v2CKeyword2 = v2CKeyword;
                synchronized (v2CKeyword2) {
                    int n = v2CKeyword.size();
                    for (int j = 0; j < n; ++j) {
                        arrayList.add(v2CKeyword.get(j));
                    }
                    continue;
                }
            }
            v2CKeywordItemArray = arrayList.toArray(this.createKeywordItemArray(arrayList.size()));
        } else {
            v2CKeywordItemArray = this.createKeywordItemArray(0);
        }
        this.lItems = v2CKeywordItemArray;
        return v2CKeywordItemArray;
    }

    V2CKeywordItem[] getItemArrayA() {
        V2CThreadItem v2CThreadItem;
        V2CKeywordItem[] v2CKeywordItemArray = this.getItemArray();
        if (v2CKeywordItemArray == this.vLastItems) {
            return this.vLastItemsForCheck;
        }
        this.vLastItems = v2CKeywordItemArray;
        int n = v2CKeywordItemArray.length;
        if (n > 0 && (v2CThreadItem = this.vThreadItem) != null) {
            int n2 = 0;
            String string = v2CThreadItem.getFormalURLString();
            String string2 = v2CThreadItem.getTitle();
            for (int i = 0; i < n; ++i) {
                V2CKeywordItem v2CKeywordItem = v2CKeywordItemArray[i];
                if (!v2CKeywordItem.checkApply(string, string2)) continue;
                if (n2 < i) {
                    v2CKeywordItemArray[n2] = v2CKeywordItem;
                }
                ++n2;
            }
            if (n2 < n) {
                V2CKeywordItem[] v2CKeywordItemArray2 = this.createKeywordItemArray(n2);
                System.arraycopy(v2CKeywordItemArray, 0, v2CKeywordItemArray2, 0, n2);
                v2CKeywordItemArray = v2CKeywordItemArray2;
            }
        }
        this.vLastItemsForCheck = v2CKeywordItemArray;
        return v2CKeywordItemArray;
    }

    V2CKeyword get(int n) {
        return this.lKeyword != null ? this.lKeyword[n] : null;
    }

    V2CKeywordItem getItem(int n) {
        if (this.lKeyword != null) {
            for (int i = 0; i < this.getLevelCount(); ++i) {
                V2CKeyword v2CKeyword = this.lKeyword[i];
                if (v2CKeyword == null) continue;
                int n2 = v2CKeyword.size();
                if (n < n2) {
                    return v2CKeyword.get(n);
                }
                n -= n2;
            }
        }
        return null;
    }

    int add(int n, String string) {
        if (this.lKeyword != null) {
            V2CKeyword v2CKeyword = this.lKeyword[n];
            v2CKeyword.add(this.createItem(v2CKeyword, string, false, true));
            int n2 = 0;
            for (int i = 0; i <= n; ++i) {
                n2 += this.lKeyword[i].size();
            }
            return n2 - 1;
        }
        return -1;
    }

    boolean move(int n, boolean bl) {
        if (bl && n <= 0 || !bl && n >= this.size() - 1) {
            return false;
        }
        int n2 = this.getKeywordIndex(n);
        return this.lKeyword[n2].move(n - this.size(n2 - 1), bl);
    }

    int getKeywordIndex(int n) {
        if (this.lKeyword != null) {
            for (int i = 0; i < this.getLevelCount(); ++i) {
                V2CKeyword v2CKeyword = this.lKeyword[i];
                if (v2CKeyword == null) continue;
                int n2 = v2CKeyword.size();
                if (n < n2) {
                    return i;
                }
                n -= n2;
            }
        }
        return -1;
    }

    int changeLevel(int n, int n2) {
        int n3 = this.getKeywordIndex(n);
        if (n3 == n2) {
            return n;
        }
        V2CKeywordItem v2CKeywordItem = this.remove(n);
        if (v2CKeywordItem == null) {
            return -1;
        }
        this.lKeyword[n2].add(v2CKeywordItem);
        return this.size(n2) - 1;
    }

    V2CKeywordItem remove(int n) {
        if (this.lKeyword != null) {
            for (int i = 0; i < this.getLevelCount(); ++i) {
                V2CKeyword v2CKeyword = this.lKeyword[i];
                if (v2CKeyword == null) continue;
                int n2 = v2CKeyword.size();
                if (n < n2) {
                    V2CKeywordItem v2CKeywordItem = v2CKeyword.get(n);
                    v2CKeyword.remove(n);
                    return v2CKeywordItem;
                }
                n -= n2;
            }
        }
        return null;
    }

    int size() {
        return this.size(this.getLevelCount() - 1);
    }

    int size(int n) {
        if (this.lKeyword != null) {
            int n2 = 0;
            for (int i = 0; i <= n; ++i) {
                V2CKeyword v2CKeyword = this.lKeyword[i];
                if (v2CKeyword == null) continue;
                n2 += v2CKeyword.size();
            }
            return n2;
        }
        return 0;
    }

    String getLowestLevelString() {
        return this.vProperty.getLevelString();
    }

    String[] getLevelStrings() {
        return this.vProperty.getLevelArray(false);
    }

    abstract int[] getKeywordColumns();

    abstract String getPopupMenuName();

    static {
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sDefExpirationKey);
        if (v2CPackedPropValue != null) {
            int[] nArray = nlExpiration;
            byte[] byArray = blSaveKeyChar;
            for (int i = 0; i < 10; ++i) {
                char c = (char)byArray[i];
                if (c <= '\u0000') continue;
                nArray[i] = v2CPackedPropValue.getInt(c) * 1440;
            }
        }
    }
}

