/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CProxyItem;
import org.monazilla.v2c.V2CProxyScript;
import org.monazilla.v2c.V2CProxySettingPanel;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CProxySetting {
    private static final boolean bDebug = false;
    static final String sKeyPrefix = "Proxy.";
    static final String sUseSystemSettingKey = "Proxy.UseSystemSetting";
    static final String sProxySetKey = "proxySet";
    static final String sHttpProxyHostKey = "http.proxyHost";
    static final String sHttpProxyPortKey = "http.proxyPort";
    static final String sHttpsProxyHostKey = "https.proxyHost";
    static final String sHttpsProxyPortKey = "https.proxyPort";
    static final String sProxySet;
    static final String sHttpProxyHost;
    static final String sHttpProxyPort;
    static final String sHttpsProxyHost;
    static final String sHttpsProxyPort;
    static final MyAuthenticator myAuth;
    static final boolean bUseProperty;
    static V2CProxySetting vpsReadProxySetting;
    static V2CProxySetting vpsWriteProxySetting;
    static boolean bUseSystemSetting;
    static boolean bNeedSynch;
    private static Vector vProxyItems;
    private static boolean bProxyItemsRestored;
    final String sUseProxyKey;
    final String sHostKey;
    final String sPortKey;
    final String sIDKey;
    final String sPWKey;
    boolean bProxyUsed;
    String sHost;
    InetAddress iAddress;
    int nPort;
    String sID;
    String sPW;
    volatile int nProcs;

    static {
        myAuth = new MyAuthenticator();
        bUseProperty = V2CApp.javaVersionLessThan(1, 5);
        String s = System.getProperty(sProxySetKey);
        sProxySet = s == null ? "" : s;
        s = System.getProperty(sHttpProxyHostKey);
        sHttpProxyHost = s == null ? "" : s;
        s = System.getProperty(sHttpProxyPortKey);
        sHttpProxyPort = s == null ? "" : s;
        s = System.getProperty(sHttpsProxyHostKey);
        sHttpsProxyHost = s == null ? "" : s;
        s = System.getProperty(sHttpsProxyPortKey);
        sHttpsProxyPort = s == null ? "" : s;
    }

    static PasswordAuthentication getProxyPasswordAuth(InetAddress inetaddress, int i) {
        return V2CProxySetting.getUseProxySetting() ? myAuth.getPasswordAuthentication(inetaddress, i) : null;
    }

    static Vector getProxyItems() {
        Vector<V2CProxyItem> vector;
        if (bUseProperty) {
            return null;
        }
        if (bProxyItemsRestored) {
            return vProxyItems;
        }
        bProxyItemsRestored = true;
        Object obj = null;
        String s = V2CLocalFileHandler.restoreFromFile(V2CLocalFileHandler.getUserConfigFile("Proxy.txt"));
        if (s != null && s.length() > 0) {
            vector = new Vector<V2CProxyItem>();
            BufferedReader bufferedreader = new BufferedReader(new StringReader(s));
            vector.add(new V2CProxyItem());
            try {
                String s1;
                Matcher matcher = Pattern.compile("([\\dA-Za-z.-]+)(?::(\\d+))?(?:\\s|$)").matcher("");
                while ((s1 = bufferedreader.readLine()) != null) {
                    int i;
                    if ((s1 = s1.trim()).equalsIgnoreCase("[Write]")) continue;
                    matcher.reset(s1);
                    if (!matcher.lookingAt() || (i = V2CMiscUtil.parseInt(matcher.group(2))) <= 0 || i > 65535) continue;
                    vector.add(new V2CProxyItem(matcher.group(1), i, s1.substring(matcher.end())));
                }
                bufferedreader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (vector.size() <= 1) {
                vector = null;
            }
        } else {
            vector = null;
        }
        vProxyItems = vector;
        return vector;
    }

    static void createSettings() {
        bUseSystemSetting = V2CApp.getUserProperty().getBoolean(sUseSystemSettingKey, V2CApp.isMacintosh());
        vpsReadProxySetting = new V2CProxySetting("Read");
        vpsWriteProxySetting = new V2CProxySetting("Write");
        V2CProxySetting.resetStates();
    }

    static boolean getUseSystemSetting() {
        return bUseSystemSetting;
    }

    static boolean getUseProxySetting() {
        return !bUseSystemSetting && (V2CProxySetting.vpsReadProxySetting.bProxyUsed || V2CProxySetting.vpsWriteProxySetting.bProxyUsed);
    }

    static boolean isO2onUsed() {
        if (!V2CApp.isWinType()) {
            return false;
        }
        V2CProxySetting v2cproxysetting = vpsReadProxySetting;
        if (!v2cproxysetting.bProxyUsed) {
            return false;
        }
        String s = v2cproxysetting.sHost;
        return s != null && (s.equals("127.0.0.1") || s.equals("localhost"));
    }

    static void setUseSystemSetting(boolean flag) {
        if (bUseSystemSetting != flag) {
            bUseSystemSetting = flag;
            V2CMain.getUserProperty().putBoolean(sUseSystemSettingKey, flag);
        }
    }

    static void resetStates() {
        V2CProxySetting.checkNeedSynch();
        myAuth.resetIDPW();
    }

    static void checkNeedSynch() {
        boolean flag;
        V2CProxySetting v2cproxysetting = vpsReadProxySetting;
        V2CProxySetting v2cproxysetting1 = vpsWriteProxySetting;
        boolean flag1 = true;
        if (bUseSystemSetting) {
            flag1 = false;
            flag = false;
        } else {
            if (v2cproxysetting.bProxyUsed && v2cproxysetting1.bProxyUsed && v2cproxysetting.sHost.equals(v2cproxysetting1.sHost) && v2cproxysetting.nPort == v2cproxysetting1.nPort && (!v2cproxysetting.sID.equals(v2cproxysetting1.sID) || !v2cproxysetting.sPW.equals(v2cproxysetting1.sPW))) {
                V2CSwingUtil.showErrorMessage("\u8aad\u307f\u8fbc\u307f\u30fb\u66f8\u304d\u8fbc\u307fProxy\u306e\nID\u307e\u305f\u306f\u30d1\u30b9\u30ef\u30fc\u30c9\u3060\u3051\u3092\n\u9055\u3046\u8a2d\u5b9a\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                v2cproxysetting1.sID = v2cproxysetting.sID;
                v2cproxysetting1.sPW = v2cproxysetting.sPW;
            }
            if (bUseProperty) {
                flag = true;
                if (v2cproxysetting.bProxyUsed) {
                    if (v2cproxysetting1.bProxyUsed && v2cproxysetting.sHost.equals(v2cproxysetting1.sHost) && v2cproxysetting.nPort == v2cproxysetting1.nPort && v2cproxysetting.sID.equals(v2cproxysetting1.sID) && v2cproxysetting.sPW.equals(v2cproxysetting1.sPW)) {
                        flag1 = false;
                        flag = false;
                        v2cproxysetting.setProperty();
                    }
                } else if (!v2cproxysetting1.bProxyUsed) {
                    flag = false;
                }
            } else {
                flag = false;
            }
        }
        bNeedSynch = flag;
        if (flag1) {
            V2CProxySetting.reset();
        }
    }

    static void showSettingPanel() {
        boolean flag = bUseSystemSetting;
        V2CProxySettingPanel v2cproxysettingpanel = V2CProxySetting.getConfPanel();
        if (!v2cproxysettingpanel.showPanel()) {
            return;
        }
        V2CProxySetting.applyChanges();
    }

    static V2CProxySettingPanel getConfPanel() {
        V2CProxySettingPanel v2cproxysettingpanel = new V2CProxySettingPanel(vpsReadProxySetting, vpsWriteProxySetting);
        return v2cproxysettingpanel;
    }

    static void applyChanges() {
        V2CProxySetting.resetStates();
        vpsReadProxySetting.save();
        vpsWriteProxySetting.save();
    }

    static HttpURLConnection openReadConnection(URL url) throws IOException {
        HttpURLConnection httpurlconnection;
        if (bUseProperty) {
            if (bNeedSynch) {
                V2CProxySetting.setReadProxy();
            }
            httpurlconnection = (HttpURLConnection)url.openConnection();
        } else {
            V2CProxySetting v2cproxysetting = vpsReadProxySetting;
            V2CProxyItem v2cproxyitem = null;
            if (!bUseSystemSetting && v2cproxysetting.bProxyUsed) {
                v2cproxyitem = new V2CProxyItem(v2cproxysetting.sHost, v2cproxysetting.nPort);
            }
            if (V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
                v2cproxyitem = V2CProxyScript.checkProxy(url, v2cproxyitem);
            }
            httpurlconnection = v2cproxyitem != null ? V2CJ2SE5Util.openConnection(url, v2cproxyitem.sHost, v2cproxyitem.nPort) : (HttpURLConnection)url.openConnection();
        }
        httpurlconnection.setUseCaches(false);
        return httpurlconnection;
    }

    static HttpURLConnection openWriteConnection(URL url) throws IOException {
        return V2CProxySetting.openWriteConnection(url, null);
    }

    static HttpURLConnection openWriteConnection(URL url, V2CProxyItem v2cproxyitem) throws IOException {
        HttpURLConnection httpurlconnection;
        if (bUseProperty) {
            if (bNeedSynch) {
                V2CProxySetting.setWriteProxy();
            }
            httpurlconnection = (HttpURLConnection)url.openConnection();
        } else {
            if (v2cproxyitem == null) {
                V2CProxySetting v2cproxysetting = vpsWriteProxySetting;
                if (!bUseSystemSetting && v2cproxysetting.bProxyUsed) {
                    v2cproxyitem = new V2CProxyItem(v2cproxysetting.sHost, v2cproxysetting.nPort);
                }
                if (V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
                    v2cproxyitem = V2CProxyScript.checkProxy(url, v2cproxyitem);
                }
            }
            httpurlconnection = v2cproxyitem != null ? V2CJ2SE5Util.openConnection(url, v2cproxyitem.sHost, v2cproxyitem.nPort) : (HttpURLConnection)url.openConnection();
        }
        httpurlconnection.setUseCaches(false);
        return httpurlconnection;
    }

    private static synchronized void setReadProxy() {
        while (V2CProxySetting.vpsWriteProxySetting.nProcs > 0) {
            try {
                V2CProxySetting.class.wait();
            }
            catch (InterruptedException interruptedexception) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        vpsReadProxySetting.inc();
    }

    private static synchronized void setWriteProxy() {
        while (V2CProxySetting.vpsReadProxySetting.nProcs > 0) {
            try {
                V2CProxySetting.class.wait();
            }
            catch (InterruptedException interruptedexception) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        vpsWriteProxySetting.inc();
    }

    static void resetReadProxy() {
        if (bUseProperty && bNeedSynch) {
            vpsReadProxySetting.dec();
        }
    }

    static void resetWriteProxy() {
        if (bUseProperty && bNeedSynch) {
            vpsWriteProxySetting.dec();
        }
    }

    static void reset() {
        System.setProperty(sProxySetKey, "false");
        System.setProperty(sHttpProxyHostKey, "");
        System.setProperty(sHttpsProxyHostKey, "");
        Authenticator.setDefault(null);
    }

    static void restore() {
        System.setProperty(sProxySetKey, sProxySet);
        System.setProperty(sHttpProxyHostKey, sHttpProxyHost);
        System.setProperty(sHttpProxyPortKey, sHttpProxyPort);
        System.setProperty(sHttpsProxyHostKey, sHttpsProxyHost);
        System.setProperty(sHttpsProxyPortKey, sHttpsProxyPort);
        Authenticator.setDefault(null);
    }

    public V2CProxySetting(String s) {
        V2CProperty v2cproperty = V2CMain.getUserProperty();
        this.sUseProxyKey = "Proxy.Use" + s + "Proxy";
        this.sHostKey = sKeyPrefix + s + "Host";
        this.sPortKey = sKeyPrefix + s + "Port";
        this.sIDKey = sKeyPrefix + s + "ID";
        this.sPWKey = sKeyPrefix + s + "PW";
        this.bProxyUsed = v2cproperty.getBoolean(this.sUseProxyKey);
        this.sHost = v2cproperty.get(this.sHostKey, "");
        this.nPort = v2cproperty.getInt(this.sPortKey);
        this.sID = v2cproperty.get(this.sIDKey, "");
        if (this.sID.length() > 0) {
            this.sID = V2CMiscUtil.hexDecode(this.sID);
        }
        this.sPW = v2cproperty.get(this.sPWKey, "");
        if (this.sPW.length() > 0) {
            this.sPW = V2CMiscUtil.hexDecode(this.sPW);
        }
    }

    void setProperty() {
        String s = this.nPort <= 0 ? "" : String.valueOf(this.nPort);
        System.setProperty(sProxySetKey, "true");
        System.setProperty(sHttpProxyHostKey, this.sHost);
        System.setProperty(sHttpProxyPortKey, s);
        System.setProperty(sHttpsProxyHostKey, this.sHost);
        System.setProperty(sHttpsProxyPortKey, s);
    }

    void inc() {
        if (!this.bProxyUsed) {
            V2CProxySetting.reset();
            return;
        }
        if (this.nProcs == 0) {
            this.setProperty();
        }
        ++this.nProcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dec() {
        if (!this.bProxyUsed) {
            return;
        }
        Class<V2CProxySetting> clazz = V2CProxySetting.class;
        synchronized (V2CProxySetting.class) {
            --this.nProcs;
            if (this.nProcs == 0) {
                V2CProxySetting.class.notifyAll();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void save() {
        V2CProperty v2cproperty = V2CMain.getUserProperty();
        v2cproperty.putBoolean(this.sUseProxyKey, this.bProxyUsed);
        if (this.sHost != null && this.sHost.length() > 0) {
            v2cproperty.put(this.sHostKey, this.sHost);
        } else {
            v2cproperty.remove(this.sHostKey);
        }
        if (this.nPort > 0) {
            v2cproperty.putInt(this.sPortKey, this.nPort);
        } else {
            v2cproperty.remove(this.sPortKey);
        }
        if (this.sID != null && this.sID.length() > 0) {
            v2cproperty.put(this.sIDKey, V2CMiscUtil.hexEncode(this.sID));
        } else {
            v2cproperty.remove(this.sIDKey);
        }
        if (this.sPW != null && this.sPW.length() > 0) {
            v2cproperty.put(this.sPWKey, V2CMiscUtil.hexEncode(this.sPW));
        } else {
            v2cproperty.remove(this.sPWKey);
        }
    }

    boolean proxyUsed() {
        return this.bProxyUsed;
    }

    String getHost() {
        return this.sHost;
    }

    InetAddress getSite() {
        if (this.bProxyUsed && this.iAddress == null && this.sHost.length() > 0) {
            try {
                this.iAddress = InetAddress.getByName(this.sHost);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.iAddress;
    }

    int getPort() {
        return this.nPort;
    }

    String getID() {
        return this.sID;
    }

    String getPW() {
        return this.sPW;
    }

    void setProxyUsed(boolean flag) {
        this.bProxyUsed = flag;
    }

    void setHost(String s) {
        this.sHost = s == null ? "" : s;
        this.iAddress = null;
    }

    void setPort(int i) {
        this.nPort = i;
    }

    void setID(String s) {
        this.sID = s;
    }

    void setPW(String s) {
        this.sPW = s;
    }

    private static class MyAuthenticator {
        PasswordAuthentication paRead;
        PasswordAuthentication paWrite;

        void resetIDPW() {
            this.paRead = MyAuthenticator.createPasswordAuthentication(vpsReadProxySetting);
            this.paWrite = MyAuthenticator.createPasswordAuthentication(vpsWriteProxySetting);
        }

        private static PasswordAuthentication createPasswordAuthentication(V2CProxySetting v2cproxysetting) {
            String s1;
            if (bUseSystemSetting || !v2cproxysetting.bProxyUsed) {
                return null;
            }
            String s = v2cproxysetting.sID;
            if (s == null) {
                s = "";
            }
            char[] ac = (s1 = v2cproxysetting.sPW) == null ? new char[]{} : s1.toCharArray();
            return new PasswordAuthentication(s, ac);
        }

        private static boolean checkHostAndPort(V2CProxySetting v2cproxysetting, InetAddress inetaddress, int i) {
            if (!v2cproxysetting.bProxyUsed) {
                return false;
            }
            InetAddress inetaddress1 = v2cproxysetting.getSite();
            return inetaddress1 != null && inetaddress1.equals(inetaddress) && i == v2cproxysetting.nPort;
        }

        PasswordAuthentication getPasswordAuthentication(InetAddress inetaddress, int i) {
            if (inetaddress == null) {
                return null;
            }
            if (MyAuthenticator.checkHostAndPort(vpsReadProxySetting, inetaddress, i)) {
                return this.paRead;
            }
            if (MyAuthenticator.checkHostAndPort(vpsWriteProxySetting, inetaddress, i)) {
                return this.paWrite;
            }
            return null;
        }

        private MyAuthenticator() {
        }
    }
}

