/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.File;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CQuickImageSaveEntry {
    String sName;
    String sLabel;
    char cMnemonic;
    final File fFolder;
    final boolean bOK;
    boolean bSeparator;

    static V2CQuickImageSaveEntry createSeparator() {
        return new V2CQuickImageSaveEntry();
    }

    static V2CQuickImageSaveEntry createEntry(String string, String string2) {
        return V2CQuickImageSaveEntry.createEntry(string, string2, '\u0000');
    }

    static V2CQuickImageSaveEntry createEntry(String string, String string2, char c) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        File file = new File(V2CLocalFileHandler.parseV2CRelativePath(string2));
        return new V2CQuickImageSaveEntry(string, file, c);
    }

    private V2CQuickImageSaveEntry() {
        this.fFolder = null;
        this.bOK = false;
        this.bSeparator = true;
    }

    public V2CQuickImageSaveEntry(String string, File file) {
        this(string, file, '\u0000');
    }

    public V2CQuickImageSaveEntry(String string, File file, char c) {
        this.setName(string);
        this.fFolder = file;
        this.bOK = file.isAbsolute();
        this.setMnemonic(c);
    }

    public V2CQuickImageSaveEntry(V2CQuickImageSaveEntry v2CQuickImageSaveEntry) {
        this.sName = v2CQuickImageSaveEntry.sName;
        this.fFolder = v2CQuickImageSaveEntry.fFolder;
        this.cMnemonic = v2CQuickImageSaveEntry.cMnemonic;
        this.sLabel = v2CQuickImageSaveEntry.sLabel;
        this.bOK = v2CQuickImageSaveEntry.bOK;
    }

    void setName(String string) {
        this.sName = V2CMiscUtil.replaceChar(string, '\t', ' ');
        this.sLabel = null;
    }

    String getName() {
        return this.sName;
    }

    void setMnemonic(char c) {
        this.cMnemonic = V2CSwingUtil.restrictMnemonic(c);
        this.sLabel = null;
    }

    char getMnemonic() {
        return this.cMnemonic;
    }

    File getFolder() {
        return this.fFolder;
    }

    boolean isOK() {
        return this.bOK;
    }

    boolean isSeparator() {
        return this.bSeparator;
    }

    String getToolTipText() {
        return this.fFolder != null ? this.fFolder.getAbsolutePath() : null;
    }

    public String toString() {
        if (this.bSeparator) {
            return "----- \u533a\u5207\u308a\u7dda -----";
        }
        String string = this.sLabel;
        if (string == null) {
            string = this.sName;
            if (this.cMnemonic > '\u0000') {
                string = string + " [" + this.cMnemonic + "]";
            }
            this.sLabel = string;
        }
        return string;
    }
}

