/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CClassStateSaver;
import org.monazilla.v2c.V2CFavoritePanel;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CNewUserDefinedItemPanel;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CRSSCategoryItem;
import org.monazilla.v2c.V2CRSSEntryList;
import org.monazilla.v2c.V2CRSSItem;
import org.monazilla.v2c.V2CRSSTreeModel;
import org.monazilla.v2c.V2CSendToMenu;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTree;
import org.monazilla.v2c.V2CWebBrowserUtil;

public class V2CRSSPanel
extends V2CTree {
    static final String sTreeStateKey = "RSS.TreeState";
    static V2CRSSPanel vRSSPanel;
    final ClassStateSaver classStateSaver = new ClassStateSaver(60);
    static Icon icRSS;

    static void createRSSPanel() {
        vRSSPanel = new V2CRSSPanel();
        V2CMain.registerRSS(vRSSPanel);
        V2CMain.addBoardTreeSeparator(false);
    }

    static void saveTreeStates() {
        if (vRSSPanel == null) {
            return;
        }
        V2CSwingUtil.saveTreeStates(vRSSPanel, sTreeStateKey);
    }

    public V2CRSSPanel() {
        super(new V2CRSSTreeModel(), true, false);
        this.getSelectionModel().setSelectionMode(1);
        MyRenderer myRenderer = new MyRenderer();
        if (fTreeFont != null) {
            myRenderer.setFont(fTreeFont);
        }
        this.setCellRenderer(myRenderer);
        this.setTextColors();
        this.vGestureMap = V2CGestureMap.getGestureMap("Other");
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.addMouseMotionListener(popupListener);
        V2CSwingUtil.restoreTreeStates(this, sTreeStateKey);
        V2CInputMap.setKeyBind(this, 0, "BoardTree");
    }

    public String getTitleString() {
        return "RSS";
    }

    public Icon getIcon() {
        return icRSS;
    }

    public Icon getDefaultIcon() {
        return icRSS;
    }

    void openSelectedItem(String string) {
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            if (string.equals("ON")) {
                bl = true;
            } else if (string.equals("BN")) {
                bl = true;
                bl2 = true;
            }
        }
        this.openSelectedItem(bl, bl2, false);
    }

    void openSelectedItem(boolean bl, boolean bl2) {
        this.openSelectedItem(bl, false, bl2);
    }

    private void openSelectedItem(boolean bl, boolean bl2, boolean bl3) {
        TreePath treePath;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof V2CRSSItem) {
            V2CMain.hideTreePaneFrame(false);
            ((V2CRSSItem)object).open(true, bl, bl2, bl3);
        } else if (object instanceof V2CRSSCategoryItem && (treePath = this.getSelectionPath()) != null) {
            this.expandTreeFolder(treePath, defaultMutableTreeNode);
        }
    }

    void copySelectedRSSItem() {
        V2CRSSItem v2CRSSItem = this.getSelectedRSSItem();
        if (v2CRSSItem == null) {
            return;
        }
        V2CFavoritePanel.copyRSSItem(v2CRSSItem);
    }

    V2CRSSItem getSelectedRSSItem() {
        Object object = ((DefaultMutableTreeNode)this.getLastSelectedPathComponent()).getUserObject();
        if (object instanceof V2CRSSItem) {
            return (V2CRSSItem)object;
        }
        return null;
    }

    void requestSaveAfterDnD() {
        if (!this.bChanged) {
            return;
        }
        this.bChanged = false;
        this.classStateSaver.requestSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewCategory() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.dTreeModel.getRoot();
        boolean bl = defaultMutableTreeNode == defaultMutableTreeNode2;
        Object object = defaultMutableTreeNode.getUserObject();
        if (!bl && !(object instanceof V2CRSSCategoryItem)) {
            return;
        }
        if (bl) {
            n = defaultMutableTreeNode2.getChildCount();
        } else {
            n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
            if (n < 0) {
                return;
            }
        }
        String string = V2CSwingUtil.showInputDialog("\u65b0\u3057\u3044\u30ab\u30c6\u30b4\u30ea\u30fc\u306e\u540d\u524d\uff1a");
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new V2CRSSCategoryItem(string));
        DefaultTreeModel defaultTreeModel = this.dTreeModel;
        synchronized (defaultTreeModel) {
            this.dTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
        }
        this.classStateSaver.requestSave();
        this.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
    }

    void renameCategory() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof V2CRSSCategoryItem)) {
            return;
        }
        V2CRSSCategoryItem v2CRSSCategoryItem = (V2CRSSCategoryItem)object;
        String string = V2CSwingUtil.showInputDialog(V2CMain.v2cMain, "\u65b0\u3057\u3044\u30ab\u30c6\u30b4\u30ea\u30fc\u306e\u540d\u524d\uff1a", v2CRSSCategoryItem.getName());
        if (string == null || string.length() == 0) {
            return;
        }
        v2CRSSCategoryItem.setName(string);
        this.classStateSaver.requestSave();
        this.dTreeModel.nodeChanged(defaultMutableTreeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteCategory() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof V2CRSSCategoryItem)) {
            return;
        }
        if (defaultMutableTreeNode.getChildCount() > 0 && !V2CSwingUtil.showOKCancelDialog("\u30ab\u30c6\u30b4\u30ea\u30fc\u304c\u7a7a\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002\n\u4e2d\u306e\u30a2\u30a4\u30c6\u30e0\u3082\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u30ab\u30c6\u30b4\u30ea\u30fc\u306e\u524a\u9664", 2)) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.dTreeModel;
        synchronized (defaultTreeModel) {
            this.dTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
        this.classStateSaver.requestSave();
    }

    void createNewUserDefinedFeed() {
        V2CNewUserDefinedItemPanel v2CNewUserDefinedItemPanel = V2CNewUserDefinedItemPanel.createPanelForRSS();
        if (!v2CNewUserDefinedItemPanel.showDialog()) {
            return;
        }
        String string = v2CNewUserDefinedItemPanel.getNewURLString();
        String string2 = v2CNewUserDefinedItemPanel.getNewName();
        V2CRSSItem v2CRSSItem = V2CRSSItem.getRSSItem(string);
        if (v2CRSSItem != null) {
            V2CSwingUtil.showErrorMessage("\u540c\u4e00\u306eRSS\u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
            return;
        }
        v2CRSSItem = new V2CRSSItem(string2, string);
        if (v2CRSSItem == null) {
            return;
        }
        this.insertRSS(v2CRSSItem);
    }

    void renameRSS() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof V2CRSSItem)) {
            return;
        }
        V2CRSSItem v2CRSSItem = (V2CRSSItem)object;
        String string = V2CSwingUtil.showInputDialog(V2CMain.v2cMain, "\u65b0\u3057\u3044RSS\u306e\u540d\u524d\uff1a", v2CRSSItem.getName());
        if (string == null || string.length() == 0) {
            return;
        }
        v2CRSSItem.setName(string);
        this.classStateSaver.requestSave();
        this.dTreeModel.nodeChanged(defaultMutableTreeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteUserDefinedRSS() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof V2CRSSItem)) {
            return;
        }
        if (!V2CSwingUtil.showOKCancelDialog("RSS\n\n\u300c" + ((V2CRSSItem)object).getName() + "\u300d\n\n\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "RSS\u306e\u524a\u9664", 2)) {
            return;
        }
        Object object2 = this.dTreeModel;
        synchronized (object2) {
            this.dTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
        this.classStateSaver.requestSave();
        object2 = (V2CRSSItem)object;
        V2CRSSEntryList v2CRSSEntryList = V2CRSSEntryList.getRSSEntryList((V2CRSSItem)object2);
        if (v2CRSSEntryList != null) {
            v2CRSSEntryList.setLocked(false);
            V2CMain.getTablePane().removePanel(v2CRSSEntryList);
        }
        V2CRSSItem.removeItem((V2CRSSItem)object2);
    }

    void insertRSS(V2CRSSItem v2CRSSItem) {
        if (v2CRSSItem == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(v2CRSSItem, false);
        this.insertRSS(defaultMutableTreeNode2, defaultMutableTreeNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertRSS(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, boolean bl) {
        Object object = defaultMutableTreeNode2.getUserObject();
        DefaultTreeModel defaultTreeModel = this.dTreeModel;
        synchronized (defaultTreeModel) {
            if (object instanceof V2CRSSCategoryItem) {
                if (bl) {
                    this.dTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                }
                this.dTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            } else if (object instanceof V2CRSSItem) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (bl) {
                    this.dTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                }
                this.dTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, defaultMutableTreeNode3.getIndex(defaultMutableTreeNode2));
            } else {
                System.out.println("???");
                return;
            }
        }
        this.classStateSaver.requestSave();
        this.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveCategory(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.dTreeModel.getRoot();
        boolean bl = defaultMutableTreeNode2 == defaultMutableTreeNode3;
        Object object = defaultMutableTreeNode2.getUserObject();
        if (!(bl || object instanceof V2CRSSCategoryItem && defaultMutableTreeNode3.getIndex(defaultMutableTreeNode2) >= 0)) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.dTreeModel;
        synchronized (defaultTreeModel) {
            this.dTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            int n = bl ? defaultMutableTreeNode3.getChildCount() : defaultMutableTreeNode3.getIndex(defaultMutableTreeNode2);
            this.dTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, n);
        }
        this.classStateSaver.requestSave();
        this.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pasteItem() {
        Object object = V2CFavoritePanel.getCopiedObject();
        if (object == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = ((V2CRSSTreeModel)this.dTreeModel).getNode(object);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode2 == null || defaultMutableTreeNode == defaultMutableTreeNode2) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.dTreeModel;
        synchronized (defaultTreeModel) {
            if (!(object instanceof V2CRSSItem)) {
                return;
            }
            this.insertRSS(defaultMutableTreeNode, defaultMutableTreeNode2, true);
        }
    }

    void showPopup(MouseEvent mouseEvent, Point point) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        String string = null;
        if (object instanceof V2CRSSItem) {
            string = "RSS";
        } else if (object instanceof V2CRSSCategoryItem) {
            string = "RSSCategory";
        } else if (object instanceof String) {
            string = "RSSRoot";
        } else {
            return;
        }
        JPopupMenu jPopupMenu = V2CMain.getPopupMenu(string);
        if (jPopupMenu == null) {
            return;
        }
        V2CAction.setEnabled("OpenRSSInside", V2CWebBrowserUtil.checkJDIC());
        V2CSendToMenu.setItemAndPoint(object, point);
        V2CPopupListener.showPopup(jPopupMenu, mouseEvent, this, point.x, point.y);
    }

    static {
        icRSS = V2CSwingUtil.getItemIcon("RSS");
    }

    private class PopupListener
    extends V2CTree.LabelPopupListener {
        private PopupListener() {
            super(V2CRSSPanel.this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (V2CRSSPanel.this.vGestureMap.mouseDragged(mouseEvent)) {
                mouseEvent.consume();
                return;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!V2CPopupListener.isDefined(mouseEvent)) {
                return;
            }
            this.nModifiersEx = mouseEvent.getModifiersEx();
            if (V2CRSSPanel.this.vGestureMap.mousePressed(mouseEvent, true)) {
                V2CRSSPanel.this.showPopup(mouseEvent);
            }
            if (V2CGestureMap.isInGesture()) {
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            if (!V2CPopupListener.isDefined(mouseEvent)) {
                return;
            }
            boolean bl = V2CGestureMap.isInGesture();
            if (V2CRSSPanel.this.vGestureMap.mouseReleased(mouseEvent)) {
                V2CRSSPanel.this.showPopup(mouseEvent);
                return;
            }
            if (V2CApp.isMacintosh() ? bl && V2CGestureMap.hasPointerMoved() : bl) {
                return;
            }
            if (mouseEvent.getClickCount() == 1) {
                object = V2CRSSPanel.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (object == null) {
                    return;
                }
                V2CRSSPanel.this.setSelectionPath((TreePath)object);
            }
            if ((object = V2CMouseClickManager.checkClickAction("G", mouseEvent)) != null) {
                V2CRSSPanel.this.openSelectedItem((String)object);
            }
        }
    }

    private static class MyRenderer
    extends DefaultTreeCellRenderer {
        MyRenderer() {
            this.setLeafIcon(V2CRSSItem.getIcon());
            this.setClosedIcon(V2CSwingUtil.getItemIcon("Category"));
            this.setOpenIcon(V2CSwingUtil.getItemIcon("CategoryOpen"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                this.setIcon(icRSS);
            }
            return this;
        }
    }

    private class ClassStateSaver
    extends V2CClassStateSaver {
        ClassStateSaver(int n) {
            super(n);
        }

        public void doSaveState() {
            ((V2CRSSTreeModel)V2CRSSPanel.this.dTreeModel).saveRSSTree();
        }
    }
}

