/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CGalleryEntry;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CNumberInputPanel;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSHA1Value;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadPopup;
import org.monazilla.v2c.V2CThumbnailStrip;

public class V2CSlideShowPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseWheelListener,
WindowListener {
    private static final String sConfKey = "SlideShow.Conf";
    private static final int DEF_INT = 1000;
    static boolean bShowThumbnailStrip;
    static boolean bAlwaysScale;
    static boolean bDontWrapTabSelection;
    static V2CSlideShowPanel vSlideShowPanel;
    static final Color cBG;
    JFrame jFrame;
    V2CThreadPanel vThreadPanel;
    V2CGalleryEntry[] vlGalleryEntry;
    int iCurrentIndex;
    V2CLink vCurrentLink;
    V2CImageSet vicCurrentImage;
    int nChangeInterval;
    Timer tSlideTimer;
    boolean bSlideDirection;
    V2CThumbnailStrip vThumbnailStrip;
    JScrollPane jScrollPane;
    Rectangle rNormalBounds;
    boolean bTemporaryDispose;
    long ltActivated;
    boolean bClickToActivate;
    V2CGalleryEntry vLastSelectedEntry;

    static V2CSlideShowPanel getInstance() {
        return vSlideShowPanel;
    }

    static boolean checkExistingPanel(V2CThreadPanel v2CThreadPanel) {
        V2CSlideShowPanel v2CSlideShowPanel = vSlideShowPanel;
        if (v2CSlideShowPanel == null || v2CSlideShowPanel.vThreadPanel != v2CThreadPanel) {
            return false;
        }
        v2CSlideShowPanel.jFrame.toFront();
        return true;
    }

    static void setFrameIcon(Image image) {
        V2CSlideShowPanel v2CSlideShowPanel = vSlideShowPanel;
        if (v2CSlideShowPanel != null) {
            v2CSlideShowPanel.jFrame.setIconImage(image);
        }
    }

    static GraphicsDevice getGraphicsDevice(JFrame jFrame) {
        if (V2CApp.isMacintosh() && V2CApp.getOSXVersion() == 3) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        return graphicsDevice.isFullScreenSupported() ? graphicsDevice : null;
    }

    static void close() {
        V2CSlideShowPanel v2CSlideShowPanel = vSlideShowPanel;
        if (v2CSlideShowPanel != null) {
            v2CSlideShowPanel.closeWindow();
        }
    }

    static void show(V2CThreadPanel v2CThreadPanel, V2CGalleryEntry[] v2CGalleryEntryArray, V2CLink v2CLink) {
        V2CSlideShowPanel v2CSlideShowPanel;
        V2CSlideShowPanel v2CSlideShowPanel2 = vSlideShowPanel;
        if (v2CSlideShowPanel2 != null) {
            v2CSlideShowPanel2.saveConfig();
            v2CSlideShowPanel2.closeWindow();
        }
        if (v2CGalleryEntryArray == null || v2CGalleryEntryArray.length == 0) {
            V2CSwingUtil.showErrorMessage("\u8868\u793a\u3059\u308b\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", "Slide Show");
            return;
        }
        vSlideShowPanel = v2CSlideShowPanel = new V2CSlideShowPanel(v2CThreadPanel, v2CGalleryEntryArray, v2CLink);
        v2CSlideShowPanel.showFrame();
    }

    private V2CSlideShowPanel(V2CThreadPanel v2CThreadPanel, V2CGalleryEntry[] v2CGalleryEntryArray, V2CLink v2CLink) {
        super(null);
        this.vThreadPanel = v2CThreadPanel;
        this.vlGalleryEntry = v2CGalleryEntryArray;
        this.enableInputMethods(false);
        this.addMouseListener(new PopupListener());
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        V2CInputMap.setKeyBind(this, 0, "ImageWindow");
        if (v2CLink != null && v2CLink.hasImageCache()) {
            V2CSHA1Value v2CSHA1Value = v2CLink.createSHA1Value();
            int n = v2CGalleryEntryArray.length;
            for (int i = 0; i < n; ++i) {
                if (!v2CSHA1Value.equals(v2CGalleryEntryArray[i].getLink().createSHA1Value())) continue;
                this.setCurrentIndex(i);
                break;
            }
        }
    }

    void showFrame() {
        JFrame jFrame;
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sConfKey);
        Rectangle rectangle = null;
        int n = 1000;
        if (v2CPackedPropValue != null) {
            bAlwaysScale = v2CPackedPropValue.getBoolean('A');
            rectangle = v2CPackedPropValue.getRectangle('B');
            n = v2CPackedPropValue.getInt('I', 1000);
            bShowThumbnailStrip = v2CPackedPropValue.getBoolean('T');
            bDontWrapTabSelection = v2CPackedPropValue.getBoolean('X');
        }
        this.nChangeInterval = n;
        this.jFrame = jFrame = new JFrame("\u753b\u50cf\u8868\u793a\u30a6\u30a3\u30f3\u30c9\u30a6");
        jFrame.setDefaultCloseOperation(2);
        if (!V2CApp.isMacintosh() && !V2CMain.bUseDefaultJavaIcon) {
            jFrame.setIconImage(V2CMain.getV2CIcon(true).getImage());
        }
        Container container = jFrame.getContentPane();
        container.add((Component)this, "Center");
        Rectangle rectangle2 = V2CMain.v2cMain.getBounds();
        Rectangle rectangle3 = rectangle != null ? rectangle : rectangle2;
        Rectangle rectangle4 = V2CSwingUtil.getScreenBoundsAt(rectangle3.x + rectangle3.width / 2, rectangle3.y + rectangle3.height / 2);
        int n2 = rectangle4.width;
        int n3 = rectangle4.height;
        if (rectangle != null) {
            if (rectangle.width > n2) {
                rectangle.width = n2;
            }
            if (rectangle.height > n3) {
                rectangle.height = n3;
            }
            if (rectangle.x < rectangle4.x) {
                rectangle.x = rectangle4.x;
            } else if (rectangle.x + rectangle.width > rectangle4.x + rectangle4.width) {
                rectangle.x = rectangle4.x + rectangle4.width - rectangle.width;
            }
            if (rectangle.y < rectangle4.y) {
                rectangle.y = rectangle4.y;
            } else if (rectangle.y + rectangle.height > rectangle4.y + rectangle4.height) {
                rectangle.y = rectangle4.y + rectangle4.height - rectangle.height;
            }
            jFrame.setBounds(rectangle);
        } else {
            jFrame.setBounds((int)((double)n2 * 0.1), (int)((double)n3 * 0.1), (int)((double)n2 * 0.8), (int)((double)n3 * 0.8));
        }
        if (container instanceof JComponent) {
            V2CInputMap.setKeyBind((JComponent)container, 1, "Global");
        }
        jFrame.setVisible(true);
        if (bShowThumbnailStrip) {
            this.toggleThumbnailPanel();
        }
        jFrame.addWindowListener(this);
        V2CLink.setSlideShowPanelShown(true);
    }

    private V2CImageSet getImageToDraw() {
        return this.getImageToDraw(this.iCurrentIndex);
    }

    private V2CImageSet getImageToDraw(int n) {
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vlGalleryEntry;
        int n2 = v2CGalleryEntryArray.length;
        V2CLink v2CLink = null;
        V2CImageSet v2CImageSet = null;
        if (n < n2 && (v2CImageSet = v2CGalleryEntryArray[n].getImage()) != null) {
            v2CLink = v2CGalleryEntryArray[n].getLink();
        }
        if (this.bSlideDirection) {
            int n3;
            if (v2CImageSet == null) {
                for (n3 = n + 1; n3 < n2; ++n3) {
                    v2CImageSet = v2CGalleryEntryArray[n3].getImage();
                    if (v2CImageSet == null) continue;
                    n = n3;
                    v2CLink = v2CGalleryEntryArray[n3].getLink();
                    break;
                }
            }
            if (v2CImageSet == null) {
                for (n3 = 0; n3 < n; ++n3) {
                    v2CImageSet = v2CGalleryEntryArray[n3].getImage();
                    if (v2CImageSet == null) continue;
                    n = n3;
                    v2CLink = v2CGalleryEntryArray[n3].getLink();
                    break;
                }
            }
        } else {
            int n4;
            if (v2CImageSet == null) {
                for (n4 = n - 1; n4 >= 0; --n4) {
                    v2CImageSet = v2CGalleryEntryArray[n4].getImage();
                    if (v2CImageSet == null) continue;
                    n = n4;
                    v2CLink = v2CGalleryEntryArray[n4].getLink();
                    break;
                }
            }
            if (v2CImageSet == null) {
                for (n4 = n2 - 1; n4 > n; --n4) {
                    v2CImageSet = v2CGalleryEntryArray[n4].getImage();
                    if (v2CImageSet == null) continue;
                    n = n4;
                    v2CLink = v2CGalleryEntryArray[n4].getLink();
                    break;
                }
            }
        }
        this.setCurrentIndex(n);
        this.vCurrentLink = v2CLink;
        this.vicCurrentImage = v2CImageSet;
        return v2CImageSet;
    }

    private void setCurrentIndex(int n) {
        Object object;
        this.iCurrentIndex = n;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vlGalleryEntry;
        String string = "\u753b\u50cf\u8868\u793a\u30a6\u30a3\u30f3\u30c9\u30a6";
        if (v2CGalleryEntryArray != null && n >= 0 && n < v2CGalleryEntryArray.length) {
            object = v2CGalleryEntryArray[n];
            if (object == this.vLastSelectedEntry) {
                return;
            }
            this.vLastSelectedEntry = object;
            if (object != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('[');
                stringBuffer.append(((V2CGalleryEntry)object).getResItem().getResIndex() + 1);
                stringBuffer.append(']');
                stringBuffer.append(' ');
                stringBuffer.append(((V2CGalleryEntry)object).getLink().getURLString());
                string = stringBuffer.toString();
            }
        }
        if ((object = this.jFrame) != null) {
            ((Frame)object).setTitle(string);
        }
    }

    V2CGalleryEntry[] getGalleryEntries() {
        return this.vlGalleryEntry;
    }

    V2CLink getCurrentLink() {
        return this.vlGalleryEntry[this.iCurrentIndex].getLink();
    }

    void openLinkOutside() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.openLinkOutside();
        }
    }

    void copyLinkLocation() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.copyLinkLocation();
        }
    }

    void disableLink() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.disable();
        }
    }

    void addToNGFile() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.addToNGFile();
        }
    }

    void deleteLinkCache() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.deleteHistory();
        }
    }

    void toggleMosaic() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.toggleMosaic();
            this.repaint();
        }
    }

    void increaseMosaicTileSize(boolean bl) {
        V2CLink v2CLink = this.vCurrentLink;
        V2CImageSet v2CImageSet = this.vicCurrentImage;
        if (v2CLink != null && v2CImageSet != null) {
            if (v2CImageSet.changeBlockSize(bl)) {
                v2CLink.toggleMosaic();
            }
            this.repaint();
        }
    }

    void toggleProtectCache() {
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null) {
            v2CLink.toggleProtectCache();
            if (this.vThumbnailStrip != null) {
                this.vThumbnailStrip.repaint();
            }
        }
    }

    void saveImage(File file, boolean bl) {
        this.saveImage(this.getCurrentLink(), file, bl);
    }

    void saveImage(V2CLink v2CLink, File file, boolean bl) {
        if (v2CLink != null) {
            v2CLink.saveImage(this.jFrame, file, this.vThreadPanel.getThreadItem(), bl);
        }
    }

    void imageThumbnailUpdated(V2CImageSet v2CImageSet) {
        V2CThumbnailStrip v2CThumbnailStrip;
        V2CLink v2CLink = this.getCurrentLink();
        if (v2CLink != null && v2CImageSet == v2CLink.getThumbnail()) {
            this.repaint();
        }
        if ((v2CThumbnailStrip = this.vThumbnailStrip) != null) {
            v2CThumbnailStrip.imageThumbnailUpdated(v2CImageSet);
        }
    }

    void linkStateChanged(V2CLink v2CLink) {
        V2CThumbnailStrip v2CThumbnailStrip;
        if (v2CLink == this.getCurrentLink()) {
            this.repaint();
        }
        if ((v2CThumbnailStrip = this.vThumbnailStrip) != null) {
            v2CThumbnailStrip.linkStateChanged(v2CLink);
        }
    }

    void performAction(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("Update")) {
            V2CGalleryEntry[] v2CGalleryEntryArray;
            boolean bl;
            this.stopSlideShow();
            boolean bl2 = bl = this.vThumbnailStrip != null;
            if (bl) {
                this.toggleThumbnailPanel();
            }
            if ((v2CGalleryEntryArray = this.vThreadPanel.createGalleryEntries()).length > 0) {
                this.vlGalleryEntry = v2CGalleryEntryArray;
                this.setCurrentIndex(0);
                this.vCurrentLink = null;
                this.vicCurrentImage = null;
            }
            if (bl) {
                this.toggleThumbnailPanel();
            }
        } else if (string.equals("SetInterval")) {
            V2CNumberInputPanel v2CNumberInputPanel = new V2CNumberInputPanel("\u753b\u50cf\u5909\u66f4\u306e\u6642\u9593\u9593\u9694\uff08msec\u5358\u4f4d\uff09\uff1a", this.nChangeInterval, "\u6642\u9593\u9593\u9694\u8a2d\u5b9a");
            if (v2CNumberInputPanel.showDialog(this.jFrame)) {
                this.nChangeInterval = V2CMiscUtil.restrictRange(1, v2CNumberInputPanel.getNumber(), 100000);
                this.saveConfig();
            }
        } else if (string.equals("OpenThread")) {
            V2CThreadItem v2CThreadItem = this.vThreadPanel.getThreadItem();
            V2CThreadPanel.openWithNewTab(v2CThreadItem, false);
        } else if (string.equals("ShowRes")) {
            int n = this.iCurrentIndex;
            V2CGalleryEntry[] v2CGalleryEntryArray = this.vlGalleryEntry;
            if (n >= 0 && n < v2CGalleryEntryArray.length) {
                int n2 = v2CGalleryEntryArray[n].getResItem().getResIndex();
                V2CThreadItem v2CThreadItem = this.vThreadPanel.getThreadItem();
                V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
                v2CThreadOpenRequest.setResNumToGo(n2);
                V2CThreadPanel.open(v2CThreadItem, false, true, v2CThreadOpenRequest);
            }
        }
    }

    void toggleAlwaysScale() {
        bAlwaysScale = !bAlwaysScale;
        this.saveConfig();
        this.repaint();
    }

    void toggleDontWrapTabSel() {
        bDontWrapTabSelection = !bDontWrapTabSelection;
        this.saveConfig();
        this.repaint();
    }

    void toggleThumbnailPanel() {
        V2CThumbnailStrip v2CThumbnailStrip = this.vThumbnailStrip;
        JScrollPane jScrollPane = this.jScrollPane;
        JComponent jComponent = (JComponent)this.jFrame.getContentPane();
        if (v2CThumbnailStrip != null) {
            jComponent.remove(jScrollPane);
            this.vThumbnailStrip = null;
            this.jScrollPane = null;
            bShowThumbnailStrip = false;
        } else {
            this.vThumbnailStrip = v2CThumbnailStrip = new V2CThumbnailStrip(this);
            this.jScrollPane = jScrollPane = new JScrollPane(v2CThumbnailStrip);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(V2CLink.getMaxThumbnailWidth());
            jComponent.add((Component)jScrollPane, "South");
            V2CLink.createThumbnailsBG(this.getLinks(), false);
            bShowThumbnailStrip = true;
        }
        jComponent.revalidate();
        jComponent.repaint();
    }

    V2CLink[] getLinks() {
        ArrayList<V2CLink> arrayList = new ArrayList<V2CLink>();
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vlGalleryEntry;
        int n = v2CGalleryEntryArray.length;
        for (int i = 0; i < n; ++i) {
            V2CLink v2CLink = v2CGalleryEntryArray[i].getLink();
            if (v2CLink == null) continue;
            arrayList.add(v2CLink);
        }
        return arrayList.toArray(new V2CLink[arrayList.size()]);
    }

    void closeWindow() {
        this.stopSlideShow();
        JFrame jFrame = this.jFrame;
        if (jFrame != null) {
            jFrame.setVisible(false);
            jFrame.dispose();
        }
    }

    void toggleFullScreenMode() {
        boolean bl;
        JFrame jFrame = this.jFrame;
        if (jFrame == null) {
            return;
        }
        GraphicsDevice graphicsDevice = V2CSlideShowPanel.getGraphicsDevice(jFrame);
        if (graphicsDevice == null) {
            V2CSwingUtil.showErrorMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u30e2\u30fc\u30c9\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        boolean bl2 = bl = graphicsDevice.getFullScreenWindow() == jFrame;
        if (!bl && V2CApp.isMacintosh()) {
            this.rNormalBounds = jFrame.getBounds();
        }
        jFrame.setVisible(false);
        this.bTemporaryDispose = true;
        jFrame.dispose();
        if (bl) {
            graphicsDevice.setFullScreenWindow(null);
            jFrame.setUndecorated(false);
            if (this.rNormalBounds != null) {
                jFrame.setBounds(this.rNormalBounds);
                this.rNormalBounds = null;
            }
        } else {
            this.saveConfig();
            jFrame.setUndecorated(true);
            graphicsDevice.setFullScreenWindow(jFrame);
        }
        jFrame.setVisible(true);
    }

    void startSlideShow(boolean bl) {
        this.bSlideDirection = bl;
        Timer timer = this.tSlideTimer;
        if (timer != null) {
            if (timer.isRunning()) {
                timer.stop();
            }
            timer.setDelay(this.nChangeInterval);
        } else {
            this.tSlideTimer = timer = new Timer(this.nChangeInterval, this);
            timer.setRepeats(false);
        }
        timer.start();
    }

    void stopSlideShow() {
        if (this.tSlideTimer != null) {
            this.tSlideTimer.stop();
            this.tSlideTimer = null;
        }
    }

    public void paintComponent(Graphics graphics) {
        Timer timer;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(cBG);
        graphics2D.fillRect(0, 0, n, n2);
        V2CImageSet v2CImageSet = this.getImageToDraw();
        if (v2CImageSet != null) {
            v2CImageSet.drawScaledAndCentered(graphics2D, n, n2, bAlwaysScale);
        }
        if (this.vThumbnailStrip != null) {
            this.vThumbnailStrip.setCurrentIndex(this.iCurrentIndex);
        }
        if ((timer = this.tSlideTimer) != null && !timer.isRunning()) {
            timer.start();
        }
    }

    void showNextImage(boolean bl, MouseWheelEvent mouseWheelEvent) {
        this.bSlideDirection = bl;
        int n = this.vlGalleryEntry.length;
        if (n <= 1) {
            return;
        }
        int n2 = this.iCurrentIndex;
        int n3 = bl ? (n2 + 1) % n : (n2 + n - 1) % n;
        if (bDontWrapTabSelection && n3 == (bl ? 0 : n - 1) && mouseWheelEvent != null && !mouseWheelEvent.isShiftDown()) {
            return;
        }
        this.setCurrentIndex(n3);
        this.repaint();
    }

    void saveConfig() {
        if (this.jFrame.getExtendedState() == 0) {
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            v2CPackedPropValue.setRectangle('B', this.jFrame.getBounds());
            if (this.nChangeInterval != 1000) {
                v2CPackedPropValue.setInt('I', this.nChangeInterval);
            }
            if (this.vThumbnailStrip != null) {
                v2CPackedPropValue.setBoolean('T', true);
            }
            v2CPackedPropValue.setBoolean('A', bAlwaysScale);
            v2CPackedPropValue.setBoolean('X', bDontWrapTabSelection);
            V2CApp.getUserProperty().putPackedValue(sConfKey, v2CPackedPropValue);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tSlideTimer) {
            this.showNextImage(this.bSlideDirection, null);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (this.bClickToActivate) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (component == this) {
            char c = V2CMouseClickManager.checkMouseClick(mouseEvent);
            if (c == 'A') {
                this.stopSlideShow();
                this.showNextImage(true, null);
            } else if (c == 'B') {
                this.stopSlideShow();
                this.showNextImage(false, null);
            } else if (c == 'a') {
                Point point = mouseEvent.getPoint();
                int n2 = this.getWidth() / 4;
                int n3 = this.getHeight() / 4;
                if (point.x > n2 && point.x < n2 * 3 && point.y > n3 && point.y < n3 * 3) {
                    this.stopSlideShow();
                    V2CThreadPopup v2CThreadPopup = this.vThreadPanel.popupResNumPopup(this.vlGalleryEntry[this.iCurrentIndex].getResItem().getResIndex(), mouseEvent, null, this.jFrame);
                } else if (this.tSlideTimer != null) {
                    this.stopSlideShow();
                } else {
                    this.startSlideShow(true);
                }
            }
        } else if (component == this.vThumbnailStrip && (n = this.vThumbnailStrip.indexAt(mouseEvent.getPoint())) >= 0) {
            this.stopSlideShow();
            this.setCurrentIndex(n);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.bClickToActivate = mouseEvent.getWhen() <= this.ltActivated;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        boolean bl2 = bl = mouseWheelEvent.getWheelRotation() > 0;
        if (mouseWheelEvent.isAltDown()) {
            this.increaseMosaicTileSize(!bl);
        } else {
            this.showNextImage(bl, mouseWheelEvent);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.bTemporaryDispose) {
            this.bTemporaryDispose = false;
            return;
        }
        V2CSlideShowPanel v2CSlideShowPanel = vSlideShowPanel;
        if (v2CSlideShowPanel != null) {
            if (v2CSlideShowPanel == this) {
                vSlideShowPanel = null;
            } else {
                return;
            }
        }
        V2CLink.setSlideShowPanelShown(false);
        this.stopSlideShow();
        this.saveConfig();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.ltActivated = System.currentTimeMillis() + 50L;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        cBG = Color.BLACK;
    }

    private class PopupListener
    extends V2CPopupListener {
        private PopupListener() {
        }

        JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
            V2CLink v2CLink = V2CSlideShowPanel.this.getCurrentLink();
            if (v2CLink == null) {
                return null;
            }
            GraphicsDevice graphicsDevice = V2CSlideShowPanel.getGraphicsDevice(V2CSlideShowPanel.this.jFrame);
            boolean bl = graphicsDevice != null;
            boolean bl2 = bl && graphicsDevice.getFullScreenWindow() == V2CSlideShowPanel.this.jFrame;
            V2CAction.setEnabled("ToggleFullScreenImageWindow", bl);
            V2CAction.setSelected("ToggleFullScreenImageWindow", bl2);
            V2CAction.setSelected("ToggleImageWindowAlwaysScale", bAlwaysScale);
            V2CAction.setSelected("ToggleImageWindowThumbnail", V2CSlideShowPanel.this.vThumbnailStrip != null);
            V2CAction.setSelected("ToggleImageWindowDontWrapTabSel", bDontWrapTabSelection);
            v2CLink.setupLinkActions();
            Point point = mouseEvent.getPoint();
            int n = V2CSlideShowPanel.this.getWidth() / 4;
            int n2 = V2CSlideShowPanel.this.getHeight() / 4;
            JPopupMenu jPopupMenu = V2CMain.getPopupMenu(point.x > n && point.x < n * 3 && point.y > n2 && point.y < n2 * 3 ? "SlideShowImage" : "SlideShow");
            if (jPopupMenu != null) {
                jPopupMenu.setLightWeightPopupEnabled(true);
            }
            return jPopupMenu;
        }
    }
}

