/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import org.monazilla.v2c.V2CAnonHighlightStyle;
import org.monazilla.v2c.V2CHighlightItem;
import org.monazilla.v2c.V2CHighlightStyle;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CTextMarkerSP;

public class V2CTextMarkerItem
implements V2CHighlightItem {
    static final int RANGE_OUTSIDE = 0;
    static final int RANGE_OVERLAP = 1;
    static final int RANGE_INCLUDED = 2;
    boolean bValid = true;
    int iResStart;
    int iResEnd;
    int iCharStart;
    int iCharEnd;
    boolean bSimple;
    String sStyleName;
    V2CHighlightStyle vStyle;
    V2CAnonHighlightStyle vAnonStyle;
    String sComment;
    long ltTime;

    public V2CTextMarkerItem(int n, int n2, int n3, int n4, long l, V2CTextMarkerSP v2CTextMarkerSP) {
        if (n > n3) {
            int n5 = n;
            n = n3;
            n3 = n5;
            n5 = n2;
            n2 = n4;
            n4 = n5;
        } else if (n == n3 && n2 > n4) {
            int n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        this.iResStart = n;
        this.iCharStart = n2;
        this.iResEnd = n3;
        this.iCharEnd = n4;
        this.ltTime = l;
        this.setHighlight(v2CTextMarkerSP);
        this.sComment = v2CTextMarkerSP.getComment();
    }

    public V2CTextMarkerItem(V2CPackedPropValue v2CPackedPropValue) {
        int[] nArray = v2CPackedPropValue.getIntArray('R', 4);
        if (nArray == null) {
            this.bValid = false;
            return;
        }
        this.iResStart = nArray[0];
        this.iCharStart = nArray[1];
        this.iResEnd = nArray[2];
        this.iCharEnd = nArray[3];
        this.bSimple = v2CPackedPropValue.getBoolean('d');
        if (this.bSimple) {
            this.vAnonStyle = new V2CAnonHighlightStyle(v2CPackedPropValue);
        } else {
            this.sStyleName = v2CPackedPropValue.getString('N');
            this.vStyle = V2CHighlightStyle.get(this.sStyleName);
        }
        this.sComment = v2CPackedPropValue.getString('C');
        this.ltTime = v2CPackedPropValue.getLong('T');
    }

    void invalidate() {
        this.bValid = false;
    }

    boolean isValid() {
        return this.bValid;
    }

    void setHighlight(V2CTextMarkerSP v2CTextMarkerSP) {
        boolean bl = this.bSimple = !v2CTextMarkerSP.getUseStyle();
        if (this.bSimple) {
            this.vAnonStyle = new V2CAnonHighlightStyle(v2CTextMarkerSP.getHighlightSelectionPanel());
        } else {
            this.vStyle = v2CTextMarkerSP.getHighlightStyle();
            if (this.vStyle == null) {
                this.vStyle = V2CHighlightStyle.getDefault();
            }
            this.sStyleName = this.vStyle.getName();
        }
        this.sComment = v2CTextMarkerSP.getComment();
    }

    V2CPackedPropValue getSaveValue() {
        V2CPackedPropValue v2CPackedPropValue;
        if (!this.bValid) {
            return null;
        }
        if (this.bSimple) {
            v2CPackedPropValue = this.vAnonStyle.getSaveValue();
            v2CPackedPropValue.setBoolean('d', true);
        } else {
            v2CPackedPropValue = new V2CPackedPropValue();
            v2CPackedPropValue.setString('N', this.sStyleName);
        }
        v2CPackedPropValue.setIntArray('R', new int[]{this.iResStart, this.iCharStart, this.iResEnd, this.iCharEnd});
        if (this.sComment != null && this.sComment.length() > 0) {
            v2CPackedPropValue.setString('C', this.sComment);
        }
        if (this.ltTime > 0L) {
            v2CPackedPropValue.setLong('T', this.ltTime);
        }
        return v2CPackedPropValue;
    }

    public V2CHighlightStyle getStyle() {
        return this.bSimple ? this.vAnonStyle : this.vStyle;
    }

    String getComment() {
        return this.sComment != null ? this.sComment : "";
    }

    long getTime() {
        return this.ltTime;
    }

    boolean rangeMatches(int n, int n2, int n3, int n4) {
        return n == this.iResStart && n2 == this.iCharStart && n3 == this.iResEnd && n4 == this.iCharEnd;
    }

    private int comparePosition(int n, int n2, int n3, int n4) {
        return n == n3 ? n2 - n4 : n - n3;
    }

    int checkRange(int n, int n2, int n3, int n4) {
        if (this.comparePosition(n3, n4, this.iResStart, this.iCharStart) <= 0 || this.comparePosition(n, n2, this.iResEnd, this.iCharEnd) >= 0) {
            return 0;
        }
        if (this.comparePosition(n, n2, this.iResStart, this.iCharStart) <= 0 && this.comparePosition(n3, n4, this.iResEnd, this.iCharEnd) >= 0) {
            return 2;
        }
        return 1;
    }

    boolean matchRange(V2CTextMarkerItem v2CTextMarkerItem) {
        return v2CTextMarkerItem.iResStart == this.iResStart && v2CTextMarkerItem.iCharStart == this.iCharStart && v2CTextMarkerItem.iResEnd == this.iResEnd && v2CTextMarkerItem.iCharEnd == this.iCharEnd;
    }

    boolean includesResNum(int n) {
        return n >= this.iResStart && n <= this.iResEnd;
    }

    int getBeginIndex(int n) {
        return n == this.iResStart ? this.iCharStart : 0;
    }

    int getEndIndex(int n, int n2) {
        return n == this.iResEnd ? this.iCharEnd : n2;
    }

    void copyFrom(V2CTextMarkerItem v2CTextMarkerItem) {
        this.bValid = v2CTextMarkerItem.bValid;
        this.iResStart = v2CTextMarkerItem.iResStart;
        this.iResEnd = v2CTextMarkerItem.iResEnd;
        this.iCharStart = v2CTextMarkerItem.iCharStart;
        this.iCharEnd = v2CTextMarkerItem.iCharEnd;
        this.bSimple = v2CTextMarkerItem.bSimple;
        this.sStyleName = v2CTextMarkerItem.sStyleName;
        this.vStyle = v2CTextMarkerItem.vStyle;
        this.vAnonStyle = v2CTextMarkerItem.vAnonStyle;
        this.sComment = v2CTextMarkerItem.sComment;
        this.ltTime = v2CTextMarkerItem.ltTime;
    }
}

