/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CPersistentState;
import org.monazilla.v2c.V2CSaveFile;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadRefHolder;
import org.monazilla.v2c.V2CTwitterBBS;

public class V2CThreadHashMap
implements V2CPersistentState {
    private final V2CBoardItem vBoardItem;
    private final HashMap hmThreads;
    private final File fFile;
    long lSaveRequestTime;

    public V2CThreadHashMap(V2CBoardItem v2CBoardItem) {
        this.vBoardItem = v2CBoardItem;
        this.fFile = v2CBoardItem.getLocalFile("threadst.txt");
        if (this.fFile == null) {
            System.out.println("fFile==null.");
            System.out.println("BBS: " + (v2CBoardItem.vBBS != null ? v2CBoardItem.vBBS.getID() : "null"));
            System.out.println("Name: " + v2CBoardItem.sName);
            System.out.println("URL: " + v2CBoardItem.sURL);
            System.out.println("MapKey: " + v2CBoardItem.sMapKey);
            System.out.println("HostDir: " + v2CBoardItem.sHostDir);
        }
        if (this.fFile != null) {
            this.hmThreads = new HashMap(Math.max((int)(this.fFile.length() / 150L), 10));
            this.restoreState(v2CBoardItem);
        } else {
            this.hmThreads = new HashMap();
        }
    }

    synchronized boolean contains(String string) {
        Object v = this.hmThreads.get(string);
        return v != null && (v instanceof V2CThreadItem || v instanceof V2CThreadRefHolder);
    }

    synchronized V2CThreadItem get(String string) {
        Object v = this.hmThreads.get(string);
        if (v instanceof V2CThreadItem) {
            return (V2CThreadItem)v;
        }
        if (v instanceof V2CThreadRefHolder) {
            return ((V2CThreadRefHolder)v).getThreadItem();
        }
        return null;
    }

    synchronized void remove(String string) {
        this.hmThreads.remove(string);
    }

    synchronized void put(String string, V2CThreadItem v2CThreadItem) {
        this.hmThreads.put(string, v2CThreadItem.isTwitter() || v2CThreadItem.getNResGet() > 0 ? v2CThreadItem : new V2CThreadRefHolder(v2CThreadItem));
    }

    synchronized void newLogCreated(V2CThreadItem v2CThreadItem) {
        String string = v2CThreadItem.getDatName();
        Object v = this.hmThreads.get(string);
        if (!(v instanceof V2CThreadItem)) {
            this.hmThreads.put(string, v2CThreadItem);
        }
    }

    synchronized int size() {
        return this.hmThreads.size();
    }

    synchronized V2CThreadItem[] getThreads(boolean bl) {
        int n = this.hmThreads.size();
        if (n == 0) {
            return null;
        }
        V2CThreadItem[] v2CThreadItemArray = new V2CThreadItem[n];
        int n2 = 0;
        Iterator iterator = this.hmThreads.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof V2CThreadItem) {
                v2CThreadItemArray[n2++] = (V2CThreadItem)v;
                continue;
            }
            if (bl) {
                v2CThreadItemArray[n2++] = ((V2CThreadRefHolder)v).getThreadItem();
                continue;
            }
            v2CThreadItemArray[n2++] = null;
        }
        return v2CThreadItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void putAllThreads(V2CThreadHashMap v2CThreadHashMap) {
        V2CThreadHashMap v2CThreadHashMap2 = v2CThreadHashMap;
        synchronized (v2CThreadHashMap2) {
            HashMap hashMap = v2CThreadHashMap.hmThreads;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = hashMap.get(k);
                if (v == null) continue;
                this.hmThreads.put(k, v);
            }
        }
    }

    synchronized void releaseMissingThreadRefs() {
        if (this.hmThreads.size() == 0) {
            return;
        }
        Iterator iterator = this.hmThreads.values().iterator();
        while (iterator.hasNext()) {
            V2CThreadRefHolder v2CThreadRefHolder;
            Object v = iterator.next();
            if (!(v instanceof V2CThreadRefHolder) || !(v2CThreadRefHolder = (V2CThreadRefHolder)v).isCleared()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void restoreState(V2CBoardItem v2CBoardItem) {
        BufferedReader bufferedReader;
        block13: {
            block12: {
                if (this.fFile == null) {
                    return;
                }
                bufferedReader = V2CLocalFileHandler.getSaveFileReader(this.fFile);
                if (bufferedReader == null) {
                    return;
                }
                try {
                    try {
                        String string;
                        int[] nArray = null;
                        while ((string = bufferedReader.readLine()) != null) {
                            char c;
                            if (string.length() == 0 || (c = string.charAt(0)) == '#') continue;
                            if (c >= 'A' && c <= 'Z') {
                                nArray = V2CThreadItem.parseSaveFieldOrder(string);
                                continue;
                            }
                            if (nArray == null) {
                                System.out.println("Field order line is missing !!: " + this.fFile);
                                Object var9_9 = null;
                                break block12;
                            }
                            V2CThreadItem v2CThreadItem = null;
                            try {
                                v2CThreadItem = new V2CThreadItem(string, nArray, v2CBoardItem);
                            }
                            catch (ParseException parseException) {
                                continue;
                            }
                            if (v2CThreadItem.getTitle() == null || v2CThreadItem.getBoardItem() == null) continue;
                            this.hmThreads.put(v2CThreadItem.getDatName(), v2CThreadItem);
                        }
                        break block13;
                    }
                    catch (IOException iOException) {
                        Object var9_11 = null;
                        V2CLocalFileHandler.closeReader(bufferedReader);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    V2CLocalFileHandler.closeReader(bufferedReader);
                    throw throwable;
                }
            }
            V2CLocalFileHandler.closeReader(bufferedReader);
            return;
        }
        Object var9_10 = null;
        V2CLocalFileHandler.closeReader(bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doSaveState() {
        V2CSaveFile v2CSaveFile;
        block9: {
            File file = this.fFile;
            if (file == null) {
                return;
            }
            if (this.hmThreads.size() == 0) {
                if (file.exists()) {
                    file.delete();
                }
                return;
            }
            v2CSaveFile = new V2CSaveFile(file);
            BufferedWriter bufferedWriter = v2CSaveFile.getWriter();
            if (bufferedWriter == null) {
                return;
            }
            try {
                try {
                    bufferedWriter.write(V2CThreadItem.getSaveFieldOrderString(this.vBoardItem));
                    bufferedWriter.newLine();
                    StringBuffer stringBuffer = new StringBuffer(240);
                    Iterator iterator = this.hmThreads.values().iterator();
                    while (iterator.hasNext()) {
                        V2CThreadItem v2CThreadItem;
                        Object v = iterator.next();
                        if (!(v instanceof V2CThreadItem) || ((v2CThreadItem = (V2CThreadItem)v).isTwitter() ? V2CTwitterBBS.hasHiddenDatName(v2CThreadItem) : v2CThreadItem.isStateUnknown() || v2CThreadItem.getNResGet() <= 0)) continue;
                        v2CThreadItem.getSaveString(stringBuffer);
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.newLine();
                    }
                    v2CSaveFile.setOK();
                }
                catch (IOException iOException) {
                    Object var9_10 = null;
                    V2CLocalFileHandler.closeWriter(bufferedWriter);
                    break block9;
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                V2CLocalFileHandler.closeWriter(bufferedWriter);
                throw throwable;
            }
            V2CLocalFileHandler.closeWriter(bufferedWriter);
        }
        v2CSaveFile.replaceTmpFile();
    }

    void threadStatusChanged() {
        this.lSaveRequestTime = System.currentTimeMillis() + 10000L;
        V2CApp.registerStateSave(this);
    }

    public long getSaveRequestTime() {
        return this.lSaveRequestTime;
    }
}

