/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CBoardList;
import org.monazilla.v2c.V2CKeyword;
import org.monazilla.v2c.V2CKeywordItem;
import org.monazilla.v2c.V2CKeywordSet;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNGWordItem;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadList;
import org.monazilla.v2c.V2CThreadNGWord;
import org.monazilla.v2c.V2CThreadTitleKeywordSet;
import org.monazilla.v2c.V2CThreadTitleNGWordSP;

public class V2CThreadNGWordSet
extends V2CKeywordSet {
    static final int[] ilColumns;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 8;
        nArray[6] = 10;
        nArray[7] = 16;
        nArray[8] = 18;
        ilColumns = nArray;
    }

    static void setNGWord(V2CBoardItem v2cboarditem) {
        V2CThreadTitleNGWordSP v2cthreadtitlengwordsp = V2CThreadNGWordSet.getConfPanel(v2cboarditem);
        if (v2cthreadtitlengwordsp == null) {
            return;
        }
        if (!v2cthreadtitlengwordsp.showDialog()) {
            return;
        }
        V2CThreadNGWordSet.applyChanges(v2cthreadtitlengwordsp);
    }

    static void applyChanges(V2CThreadTitleNGWordSP v2cthreadtitlengwordsp) {
        boolean flag = v2cthreadtitlengwordsp.isNGWordChanged();
        boolean flag1 = v2cthreadtitlengwordsp.isKeywordChanged();
        if (flag || flag1) {
            if (flag) {
                v2cthreadtitlengwordsp.npNGWord.vKeywordSet.itemChanged();
            }
            V2CBoardList.notifyNGWordChanged();
            V2CBoardItem.threadTitleKeywordChanged();
            V2CThreadList.threadTitleKeywordChanged();
        }
    }

    static V2CThreadTitleNGWordSP getConfPanel(V2CBoardItem v2cboarditem) {
        if (v2cboarditem == null) {
            V2CSwingUtil.showErrorMessage("\u677f\u306e\u30b9\u30ec\u4e00\u89a7\u3092\u958b\u3044\u3066\u304b\u3089\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return null;
        }
        V2CThreadNGWordSet v2cthreadngwordset = v2cboarditem.getThreadNGWordSet();
        if (v2cthreadngwordset == null) {
            return null;
        }
        v2cthreadngwordset.checkAppliedTimeChange();
        V2CThreadTitleKeywordSet v2cthreadtitlekeywordset = v2cboarditem.getThreadTitleKeywordSet();
        v2cthreadtitlekeywordset.checkAppliedTimeChange();
        V2CThreadTitleNGWordSP v2cthreadtitlengwordsp = new V2CThreadTitleNGWordSP(v2cthreadngwordset, v2cthreadtitlekeywordset);
        return v2cthreadtitlengwordsp;
    }

    public V2CThreadNGWordSet(V2CProperty v2cproperty) {
        super(v2cproperty, 0);
        V2CProperty[] av2cproperty = v2cproperty.getProperties();
        int i = this.getLevelCount();
        if (av2cproperty == null || av2cproperty.length != i) {
            return;
        }
        this.lKeyword = new V2CThreadNGWord[i];
        int j = 0;
        while (j < i) {
            this.lKeyword[j] = V2CThreadNGWord.getThreadNGWord(av2cproperty[j]);
            ++j;
        }
    }

    @Override
    V2CKeywordItem createItem(V2CKeyword v2ckeyword, String s, boolean flag, boolean flag1) {
        return new V2CNGWordItem(v2ckeyword, s, flag, flag1);
    }

    @Override
    V2CKeywordItem[] createKeywordItemArray(int i) {
        return new V2CNGWordItem[i];
    }

    V2CNGWordItem getNGWordItem(int i) {
        return (V2CNGWordItem)this.getItem(i);
    }

    V2CNGWordItem[] getNGWordItemArray() {
        return (V2CNGWordItem[])this.getItemArray();
    }

    V2CThreadNGWord getThreadNGWord(int i) {
        return (V2CThreadNGWord)this.get(i);
    }

    @Override
    int getLevelCount() {
        return 3;
    }

    @Override
    String getPopupMenuName() {
        return "KeywordEntry";
    }

    @Override
    int[] getKeywordColumns() {
        return ilColumns;
    }

    int check(V2CThreadItem v2cthreaditem, int i) {
        v2cthreaditem.setNGChecked();
        V2CNGWordItem[] av2cngworditem = this.getNGWordItemArray();
        String s = v2cthreaditem.getTitle();
        if (s == null || s.length() == 0) {
            return i;
        }
        boolean flag = i > 0;
        String s1 = null;
        int j = 0;
        while (j < av2cngworditem.length) {
            V2CNGWordItem v2cngworditem = av2cngworditem[j];
            if (v2cngworditem != null && v2cngworditem.isActive()) {
                int k = v2cngworditem.getWeight();
                if (!flag || !V2CResItem.skipNG(i, k, true, true)) {
                    boolean flag1;
                    boolean bl = flag1 = !v2cngworditem.isNot();
                    if (v2cngworditem.isRegEx()) {
                        Matcher matcher;
                        Pattern pattern = v2cngworditem.getPattern();
                        if (pattern != null && (matcher = pattern.matcher(s)).find() == flag1) {
                            flag = true;
                            v2cthreaditem.setNGWordItem(v2cngworditem);
                            i = k;
                            v2cngworditem.setApplied();
                        }
                    } else {
                        String s2 = v2cngworditem.getWord();
                        if (s2 != null && s2.length() != 0) {
                            String s3;
                            if (v2cngworditem.isCaseSensitive()) {
                                s3 = s;
                            } else {
                                if (s1 == null) {
                                    s1 = V2CMiscUtil.normalizeCase(s);
                                }
                                s3 = s1;
                            }
                            if (s3.indexOf(s2) >= 0 == flag1) {
                                flag = true;
                                v2cthreaditem.setNGWordItem(v2cngworditem);
                                i = k;
                                v2cngworditem.setApplied();
                            }
                        }
                    }
                }
            }
            ++j;
        }
        return i;
    }
}

