/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CTimePanel
extends JPanel {
    JSpinner jsHour;
    JSpinner jsMinute;

    public V2CTimePanel(int n) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        this.jsHour = this.createJSpinner(n2, true, gridBagConstraints);
        this.jsMinute = this.createJSpinner(n3, false, gridBagConstraints);
    }

    private JSpinner createJSpinner(int n, boolean bl, GridBagConstraints gridBagConstraints) {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n, 0, bl ? 23 : 59, 1));
        this.add((Component)jSpinner, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel(bl ? "\u6642" : "\u5206"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jSpinner;
    }

    void setTime(int n) {
        n = Math.max(0, Math.min(n, 86400));
        this.jsHour.setValue(new Integer(n / 3600));
        this.jsMinute.setValue(new Integer(n % 3600 / 60));
    }

    int getTime() {
        return this.getHour() * 3600 + this.getMin() * 60;
    }

    int getHour() {
        return (Integer)this.jsHour.getValue();
    }

    int getMin() {
        return (Integer)this.jsMinute.getValue();
    }
}

