/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CDnDUtil;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CToolBarButtonPanel;
import org.monazilla.v2c.V2CToolBarItemButtonPropertyPanel;
import org.monazilla.v2c.V2CToolBarItemButtonTransferable;

public abstract class V2CToolBarItemButton
extends JButton
implements Cloneable {
    static final Insets insButton;
    boolean bPopup;

    public V2CToolBarItemButton() {
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(this);
            V2CMacQuaquaSupport.setSquareButtonStyle(this);
            this.setMargin(new Insets(0, 1, 0, 1));
        } else {
            this.setMargin(insButton);
        }
        this.setFocusable(false);
        this.setIconTextGap(2);
        this.addMouseListener(new PopupListener());
        DnDListener dnDListener = new DnDListener();
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, dnDListener);
    }

    void pasteButton() {
        Container container = this.getParent();
        if (!(container instanceof V2CToolBarButtonPanel)) {
            return;
        }
        ((V2CToolBarButtonPanel)container).pasteButton(this);
    }

    void newURLButton() {
        Container container = this.getParent();
        if (!(container instanceof V2CToolBarButtonPanel)) {
            return;
        }
        ((V2CToolBarButtonPanel)container).newURLButton(this);
    }

    void newCMDButton() {
        Container container = this.getParent();
        if (!(container instanceof V2CToolBarButtonPanel)) {
            return;
        }
        ((V2CToolBarButtonPanel)container).newCMDButton(this);
    }

    void delete() {
        Container container = this.getParent();
        if (!(container instanceof V2CToolBarButtonPanel)) {
            return;
        }
        ((V2CToolBarButtonPanel)container).deleteButton(this);
    }

    void showProperty() {
        V2CToolBarItemButtonPropertyPanel v2CToolBarItemButtonPropertyPanel = new V2CToolBarItemButtonPropertyPanel(this);
        v2CToolBarItemButtonPropertyPanel.showDialog();
    }

    void move(String string) {
        if (string == null || string.length() != 1) {
            return;
        }
        Container container = this.getParent();
        if (!(container instanceof V2CToolBarButtonPanel)) {
            return;
        }
        ((V2CToolBarButtonPanel)container).moveButton(this, string.charAt(0) == 'R');
    }

    boolean getShowIcon() {
        return this.getIcon() != null;
    }

    String getIconSaveString() {
        return this.getIcon() != null ? ",i," : ",,";
    }

    abstract V2CToolBarItemButton copyButton();

    void openItemOutside() {
    }

    Object getItem() {
        return null;
    }

    void doMiddleClickAction(MouseEvent mouseEvent) {
    }

    abstract void doAction(MouseEvent var1);

    abstract String getSaveString();

    abstract String getOriginalName();

    abstract void setIcon(boolean var1);

    String getPopupMenuName() {
        return null;
    }

    static {
        Insets insets;
        if (V2CApp.isMacintosh()) {
            insets = new Insets(2, 3, 2, 3);
        } else {
            insets = new Insets(2, 1, 2, 1);
            if (V2CApp.isNimbus()) {
                insets = new Insets(-1, -7, -1, -7);
            }
        }
        insButton = insets;
    }

    private class DnDListener
    implements DragGestureListener,
    DragSourceListener {
        private DnDListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            V2CToolBarItemButtonTransferable v2CToolBarItemButtonTransferable = new V2CToolBarItemButtonTransferable(V2CToolBarItemButton.this);
            Cursor cursor = null;
            switch (dragGestureEvent.getDragAction()) {
                case 1: {
                    cursor = DragSource.DefaultCopyNoDrop;
                    break;
                }
                case 2: {
                    cursor = DragSource.DefaultMoveNoDrop;
                    break;
                }
                default: {
                    return;
                }
            }
            dragGestureEvent.getDragSource().startDrag(dragGestureEvent, cursor, v2CToolBarItemButtonTransferable, this);
            V2CToolBarItemButton.this.dispatchEvent(new MouseEvent(V2CToolBarItemButton.this, 505, System.currentTimeMillis(), 1024, -1, -1, 1, false, 1));
            V2CToolBarItemButton.this.dispatchEvent(new MouseEvent(V2CToolBarItemButton.this, 502, System.currentTimeMillis(), 0, -1, -1, 1, false, 1));
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            V2CDnDUtil.checkSourceDrag(dragSourceDragEvent);
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            V2CDnDUtil.checkSourceDrag(dragSourceDragEvent);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            V2CDnDUtil.checkSourceDrag(dragSourceDragEvent);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }
    }

    private class PopupListener
    extends V2CPopupListener {
        PopupListener() {
            super("ToolBarItemButton");
        }

        public void mousePressed(MouseEvent mouseEvent) {
            V2CToolBarItemButton.this.bPopup = false;
            super.mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (V2CToolBarItemButton.this.bPopup) {
                return;
            }
            Dimension dimension = V2CToolBarItemButton.this.getSize();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x <= dimension.width && point.y >= 0 && point.y <= dimension.height) {
                V2CToolBarItemButton.this.doAction(mouseEvent);
            }
        }

        void setupAction(MouseEvent mouseEvent) {
            V2CToolBarItemButton.this.bPopup = true;
        }

        JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
            String string = ((V2CToolBarItemButton)mouseEvent.getComponent()).getPopupMenuName();
            if (string == null) {
                string = this.sPopupName;
            }
            return V2CMain.getPopupMenu(string);
        }
    }
}

