/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.monazilla.v2c.V2CGestureMap;

public class V2CViewportDispatcher
extends MouseInputAdapter
implements MouseWheelListener {
    static V2CViewportDispatcher elViewportDispatcher;
    long ltLastTime;

    static void addDispatcher(JScrollPane jScrollPane) {
        int n;
        JViewport jViewport = jScrollPane.getViewport();
        V2CViewportDispatcher v2CViewportDispatcher = elViewportDispatcher;
        if (v2CViewportDispatcher == null) {
            elViewportDispatcher = v2CViewportDispatcher = new V2CViewportDispatcher();
        }
        jViewport.addMouseListener(v2CViewportDispatcher);
        jViewport.addMouseMotionListener(v2CViewportDispatcher);
        MouseWheelListener[] mouseWheelListenerArray = jScrollPane.getMouseWheelListeners();
        for (n = 0; n < mouseWheelListenerArray.length; ++n) {
            jScrollPane.removeMouseWheelListener(mouseWheelListenerArray[n]);
        }
        jScrollPane.addMouseWheelListener(v2CViewportDispatcher);
        for (n = 0; n < mouseWheelListenerArray.length; ++n) {
            jScrollPane.addMouseWheelListener(mouseWheelListenerArray[n]);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, true);
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl) {
        Component component = mouseEvent.getComponent();
        if (!(component instanceof JViewport) || bl && !component.isShowing()) {
            return;
        }
        JViewport jViewport = (JViewport)component;
        Component component2 = jViewport.getView();
        if (component2 == null) {
            return;
        }
        mouseEvent.consume();
        Point point = SwingUtilities.convertPoint(jViewport, mouseEvent.getPoint(), component2);
        component2.dispatchEvent(new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)point.getX(), (int)point.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWhen() == this.ltLastTime) {
            mouseWheelEvent.consume();
            return;
        }
        if (!V2CGestureMap.isInGesture()) {
            return;
        }
        Component component = mouseWheelEvent.getComponent();
        if (!(component instanceof JScrollPane) || !component.isShowing()) {
            return;
        }
        JScrollPane jScrollPane = (JScrollPane)component;
        Component component2 = jScrollPane.getViewport().getView();
        if (component2 == null) {
            return;
        }
        mouseWheelEvent.consume();
        this.ltLastTime = mouseWheelEvent.getWhen();
        Point point = SwingUtilities.convertPoint(jScrollPane, mouseWheelEvent.getPoint(), component2);
        component2.dispatchEvent(new MouseWheelEvent(component2, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (int)point.getX(), (int)point.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
    }
}

