/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.monazilla.v2c.V2CBaseFont;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CScrollablePopupMenu;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CWriteMessagePanel;

abstract class V2CAAMenu
extends V2CScrollablePopupMenu
implements ActionListener,
ChangeListener,
PopupMenuListener {
    private static final boolean bUseChangeEvent = true;
    V2CWriteMessagePanel vWriteMessagePanel;
    JTextArea jtaAA;
    Font fAAFont;
    Timer tCloseTimer;
    private JWindow jWindow;

    V2CAAMenu() {
        this.addPopupMenuListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof AAMenuItem) {
            this.vWriteMessagePanel.generateReferenceAndInsertText(((AAMenuItem)object).getInsertString());
        } else if (object == this.tCloseTimer) {
            this.jWindow.setVisible(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    void popupAAPreview(AAMenuItem aAMenuItem) {
        int n;
        Font font;
        V2CBaseFont v2CBaseFont;
        String string = aAMenuItem.getPopupString();
        if (string == null) {
            return;
        }
        JWindow jWindow = this.jWindow;
        JTextArea jTextArea = this.jtaAA;
        if (jWindow == null) {
            this.jWindow = jWindow = new JWindow(V2CMain.v2cMain);
            jTextArea = new JTextArea();
            jTextArea.setFocusable(false);
            jTextArea.setEditable(false);
            jTextArea.setMargin(new Insets(5, 5, 5, 5));
            jTextArea.setBackground(new Color(1.0f, 1.0f, 0.9f));
            jWindow.setContentPane(jTextArea);
            this.jtaAA = jTextArea;
            this.tCloseTimer = new Timer(100, this);
            this.tCloseTimer.setRepeats(false);
        }
        if (V2CSwingUtil.isAlwaysOnTopSupported()) {
            V2CJ2SE5Util.setAlwaysOnTop(jWindow, true);
        }
        if ((v2CBaseFont = V2CBaseFont.getBaseFont("ThreadAlt")) == null) {
            v2CBaseFont = V2CBaseFont.getBaseFont("ThreadDefault");
        }
        if ((font = v2CBaseFont.getFont()) != this.fAAFont) {
            this.fAAFont = font;
            jTextArea.setFont(font.deriveFont(16.0f));
        }
        if (this.tCloseTimer.isRunning()) {
            this.tCloseTimer.stop();
        }
        jTextArea.setText(V2CResItem.replaceEscapes(string));
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, aAMenuItem);
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
        Insets insets = jWindow.getInsets();
        Dimension dimension = jTextArea.getPreferredSize();
        Rectangle rectangle2 = aAMenuItem.getBounds();
        int n2 = 5;
        int n3 = rectangle.x + rectangle.width - (point.x + rectangle2.width + n2 + insets.left + dimension.width + insets.right);
        boolean bl = n3 >= 0 ? true : ((n = point.x - n2 - (insets.left + dimension.width + insets.right)) >= 0 ? false : n3 >= n);
        int n4 = bl ? point.x + rectangle2.width + n2 : point.x - n2 - (insets.left + dimension.width + insets.right);
        int n5 = point.y + insets.top + dimension.height + insets.bottom < rectangle.y + rectangle.height ? point.y : rectangle.y + rectangle.height - (insets.bottom + dimension.height + insets.top);
        jWindow.setLocation(n4, n5);
        jWindow.pack();
        jWindow.setVisible(true);
    }

    void startEndPopupTimer() {
        Timer timer;
        JWindow jWindow = this.jWindow;
        if (jWindow != null && jWindow.isVisible() && (timer = this.tCloseTimer) != null) {
            if (timer.isRunning()) {
                timer.stop();
            }
            timer.start();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (!(object instanceof AAMenuItem)) {
            return;
        }
        if (this.isScrolling()) {
            return;
        }
        AAMenuItem aAMenuItem = (AAMenuItem)object;
        if (aAMenuItem.isArmed()) {
            this.popupAAPreview(aAMenuItem);
        } else {
            this.startEndPopupTimer();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JWindow jWindow;
        if (!this.mouseMovedAction(mouseEvent)) {
            return;
        }
        Timer timer = this.tCloseTimer;
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
        if ((jWindow = this.jWindow) != null && jWindow.isVisible()) {
            this.jWindow.setVisible(false);
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        JWindow jWindow = this.jWindow;
        if (jWindow != null && jWindow.isVisible()) {
            if (this.tCloseTimer.isRunning()) {
                this.tCloseTimer.stop();
            }
            jWindow.setVisible(false);
        }
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    static abstract class AAMenuItem
    extends JMenuItem {
        AAMenuItem(String string) {
            super(string);
        }

        abstract String getPopupString();

        abstract String getInsertString();
    }
}

