/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSwingUtil;

public final class V2CColorSelectButton
extends JLabel {
    static final boolean bHasAlpha = V2CApp.javaVersionEqualOrGreaterThan(1, 7) && !V2CApp.isGTK();
    private static BGMouseListener bgMouseListener;
    final char cSaveKey;
    final boolean bAlpha;
    boolean bHasDefault;
    boolean bOverrideDefault;
    ArrayList alColorHistory;
    int nCurrentHistory;

    public V2CColorSelectButton() {
        this(null, '\u0000', false);
    }

    public V2CColorSelectButton(char c) {
        this(null, c, false);
    }

    public V2CColorSelectButton(Color color) {
        this(color, '\u0000', false);
    }

    public V2CColorSelectButton(Color color, boolean bl) {
        this(color, '\u0000', bl);
    }

    public V2CColorSelectButton(Color color, char c) {
        this(color, c, false);
    }

    public V2CColorSelectButton(Color color, char c, boolean bl) {
        super(" click ");
        this.cSaveKey = c;
        this.bAlpha = bl;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        if (color != null) {
            if (bl && !bHasAlpha) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            this.setColor(color);
        }
        this.setOpaque(true);
        if (bgMouseListener == null) {
            bgMouseListener = new BGMouseListener();
        }
        this.addMouseListener(bgMouseListener);
        this.addMouseListener(new V2CPopupListener("ColorSel"));
    }

    void setHasDefault() {
        this.bHasDefault = true;
    }

    boolean hasDefault() {
        return this.bHasDefault;
    }

    void setOverrideDefault(boolean bl) {
        if (this.bHasDefault) {
            this.bOverrideDefault = bl;
        }
    }

    boolean getOverrideDefault() {
        return this.bOverrideDefault;
    }

    void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.isShowing()) {
            int n;
            ArrayList<Color> arrayList = this.alColorHistory;
            if (arrayList == null) {
                this.alColorHistory = arrayList = new ArrayList<Color>();
                Color color2 = this.getBackground();
                if (color2 != null) {
                    arrayList.add(color2);
                }
            }
            if ((n = this.nCurrentHistory) + 1 < arrayList.size()) {
                for (int i = arrayList.size() - 1; i > n; --i) {
                    arrayList.remove(i);
                }
            }
            arrayList.add(color);
            this.nCurrentHistory = n + 1;
        }
        this.setBackground(color);
    }

    void undoColor() {
        ArrayList arrayList = this.alColorHistory;
        if (arrayList == null) {
            return;
        }
        int n = this.nCurrentHistory;
        if (n <= 0) {
            return;
        }
        this.nCurrentHistory = --n;
        this.setBackground((Color)arrayList.get(n));
    }

    void redoColor() {
        ArrayList arrayList = this.alColorHistory;
        if (arrayList == null) {
            return;
        }
        int n = this.nCurrentHistory;
        if (n + 1 >= arrayList.size()) {
            return;
        }
        this.nCurrentHistory = ++n;
        this.setBackground((Color)arrayList.get(n));
    }

    Color getColor() {
        return this.getBackground();
    }

    void pasteColor() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard == null) {
            return;
        }
        Transferable transferable = null;
        try {
            transferable = clipboard.getContents(null);
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println(illegalStateException.getMessage());
        }
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        Object object = null;
        try {
            object = transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (string.length() > 8) {
            return;
        }
        Matcher matcher = Pattern.compile("\\s*(?:#|0x)?((?:[0-9A-F]{3}){1,2})\\s*", 2).matcher(string);
        if (!matcher.matches()) {
            return;
        }
        Color color = V2CSwingUtil.parseHexColorString(matcher.group(1));
        if (color != null) {
            this.setColor(color);
        }
    }

    char getSaveKey() {
        return this.cSaveKey;
    }

    void performAction(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("Copy")) {
            String string2 = V2CSwingUtil.colorToString(this.getColor());
            if (string2 != null && string2.length() == 7 && string2.charAt(0) == '#') {
                V2CMain.copyString(string2.substring(1));
            }
        } else if (string.equals("Paste")) {
            this.pasteColor();
        } else if (string.equals("Undo")) {
            this.undoColor();
        } else if (string.equals("Redo")) {
            this.redoColor();
        }
    }

    private static class BGMouseListener
    extends MouseAdapter {
        private BGMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Color color;
            Component component;
            block14: {
                component = mouseEvent.getComponent();
                if (!(component instanceof V2CColorSelectButton)) {
                    return;
                }
                V2CColorSelectButton v2CColorSelectButton = (V2CColorSelectButton)component;
                color = null;
                try {
                    if (v2CColorSelectButton.bAlpha || !bHasAlpha) {
                        color = JColorChooser.showDialog(V2CMain.v2cMain, "Background Color", component.getBackground());
                    } else {
                        Component component2;
                        int n;
                        OpaqueColorSelectionModel opaqueColorSelectionModel = new OpaqueColorSelectionModel(component.getBackground());
                        JColorChooser jColorChooser = new JColorChooser(opaqueColorSelectionModel);
                        JTabbedPane jTabbedPane = null;
                        for (n = jColorChooser.getComponentCount() - 1; n >= 0; --n) {
                            component2 = jColorChooser.getComponent(n);
                            if (!(component2 instanceof JTabbedPane)) continue;
                            jTabbedPane = (JTabbedPane)component2;
                            break;
                        }
                        if (jTabbedPane != null) {
                            for (n = jTabbedPane.getTabCount() - 1; n >= 0; --n) {
                                int n2;
                                component2 = jTabbedPane.getComponentAt(n);
                                if (!(component2 instanceof Container)) continue;
                                Container container = (Container)component2;
                                String string = jTabbedPane.getTitleAt(n);
                                if (string.equals("CMYK")) {
                                    n2 = 4;
                                } else {
                                    if (!string.equals("HSV") && !string.equals("HSL") && !string.equals("RGB")) continue;
                                    n2 = 3;
                                }
                                if (container.getComponentCount() == 1) {
                                    component2 = container.getComponent(0);
                                }
                                try {
                                    Class<?> clazz = component2.getClass();
                                    Field field = clazz.getDeclaredField("panel");
                                    field.setAccessible(true);
                                    Object object = field.get(component2);
                                    field.setAccessible(false);
                                    Field field2 = object.getClass().getDeclaredField("spinners");
                                    field2.setAccessible(true);
                                    Object object2 = field2.get(object);
                                    field2.setAccessible(false);
                                    Object object3 = ((Object[])object2)[n2];
                                    Method method = object3.getClass().getDeclaredMethod("setVisible", Boolean.TYPE);
                                    method.setAccessible(true);
                                    method.invoke(object3, Boolean.FALSE);
                                    method.setAccessible(false);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        JDialog jDialog = JColorChooser.createDialog(V2CMain.v2cMain, "Background Color", true, jColorChooser, opaqueColorSelectionModel, null);
                        jDialog.setVisible(true);
                        jDialog.dispose();
                        color = opaqueColorSelectionModel.cSelColor;
                    }
                }
                catch (Throwable throwable) {
                    if (!V2CApp.isMacintosh() || !V2CMacQuaquaSupport.isQuaquaInstalled()) break block14;
                    V2CSwingUtil.showErrorMessage("\u8272\u9078\u629e\u30c0\u30a4\u30a2\u30ed\u30b0\u3092\u8868\u793a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\nQuaqua\u3092\u4f7f\u7528\u3057\u306a\u3044\u72b6\u614b\u3067\u8a2d\u5b9a\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
            if (color == null) {
                return;
            }
            ((V2CColorSelectButton)component).setColor(color);
        }
    }

    private static class OpaqueColorSelectionModel
    extends DefaultColorSelectionModel
    implements ActionListener {
        Color cSelColor;

        OpaqueColorSelectionModel(Color color) {
            super(color);
        }

        public void setSelectedColor(Color color) {
            super.setSelectedColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cSelColor = this.getSelectedColor();
        }
    }
}

