/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Font;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CHTMLPane;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLauncher;
import org.monazilla.v2c.V2CMD5Value;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPrintStream;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CReleaseInfo;
import org.monazilla.v2c.V2CSHA1Value;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CLocalFileHandler {
    static final char cBOM = '\ufeff';
    private static final String sV2CDirFName = "v2cdir.txt";
    private static final String sBrushMetalLookFile = "BrushMetalLook";
    static final String sDefCharset = "MS932";
    private static final String sConfigCharSet = "UTF-8";
    static DecimalFormat dfFNum;
    static DecimalFormat dfFNum2;
    static final String sFileSeparator;
    static final boolean bNeedsFSReplace;
    static final String sLogDir = "log";
    static File v2cDefDir;
    static File v2cDir;
    static File fLock;
    static boolean bLockFileAlreadyExists;
    static File fShareInf;
    static File fV2CLogFile;
    static File fBBSDir;
    static File fRSSDir;
    static File fWebSearchDir;
    static File fScriptTLDir;
    static File fLogDir;
    static File fResStyleDir;
    static File fImageDir;
    static File fThumbnailCacheDir;
    static File fImagePropDir;
    static File fTmpImageDir;
    static File fTmpDir;
    static File fExpImageDir;
    static File fListDir;
    static File fToolBarIconDir;
    static PrintStream vOutStream;
    static boolean bToolBarIconDirChecked;
    static File fSmallIconDir;
    static boolean bSmallIconDirChecked;
    static File fAvatarDir;
    static boolean bAvatarDirChecked;
    static File fInlineMsgImgDir;
    static boolean bInlineMsgImgDirChecked;
    static File fTabImgDir;
    static boolean bTabImgDirChecked;
    static File fCMDImgDir;
    static boolean bCMDImgDirChecked;
    static File fSoundDir;
    static boolean bSoundDirChecked;
    static String sAbsV2CPath;
    private static final boolean bUsePNGResource;
    static final String sFileLockedKey = "Locked";
    static final int LOCK_FAILED = 0;
    static final int LOCK_ERROR = 1;
    static final int LOCK_NOTSUPPORTED = 2;
    static final int LOCK_SUCCESS = 3;
    static int nFileLockStatus;
    static FileLock flFileLock;
    static FileChannel fchLockFile;
    static final String sNashi = "\uff08\u306a\u3057\uff09";
    static int iTempFileNumber;

    public static void initLocalFileHandler() {
        V2CLocalFileHandler.checkV2CDir();
        fV2CLogFile = new File(v2cDir, "v2clog.txt");
        fBBSDir = new File(v2cDir, "BBS");
        fRSSDir = new File(v2cDir, "RSS");
        fWebSearchDir = new File(v2cDir, "websrch");
        fScriptTLDir = new File(v2cDir, "tlbscr");
        fLogDir = new File(v2cDir, sLogDir);
        fResStyleDir = new File(v2cDir, "style");
        fImageDir = new File(v2cDir, "image");
        fThumbnailCacheDir = new File(fImageDir, "thumbs");
        fImagePropDir = new File(fImageDir, "props");
        fTmpDir = new File(v2cDir, "tmp");
        fTmpImageDir = new File(fTmpDir, "download");
        fExpImageDir = new File(fTmpDir, "img");
        fLock = new File(v2cDir, "lockfile");
        fShareInf = new File(v2cDir, "shareinf.txt");
        fListDir = new File(v2cDir, "list");
    }

    static File getLockFile() {
        return fLock;
    }

    static File getShareInfFile() {
        return fShareInf;
    }

    static boolean canDisplayJapanese() {
        return new Font("Dialog", 0, 1).canDisplay('\u4e9c');
    }

    static boolean isLockFileAlreadyExists() {
        return bLockFileAlreadyExists;
    }

    static boolean createLockFile(boolean bl, V2CProperty v2CProperty) {
        File file;
        int n;
        File file2 = fLock;
        bLockFileAlreadyExists = file2.exists();
        for (int i = 9; i >= 0; --i) {
            boolean bl2;
            n = 0;
            try {
                n = file2.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n != 0) break;
            if (i <= 0 || !file2.exists()) {
                V2CApp.errorExit(V2CLocalFileHandler.canDisplayJapanese() ? V2CJStr.getCantCreateLockFileMessage(file2) : "Couldn't create lockfile:\n\n" + file2);
            }
            if ((bl2 = V2CLocalFileHandler.askDeleteLockFile(bl, v2CProperty)) || !bl) continue;
            return false;
        }
        if ((file = fShareInf).exists() && !file.delete()) {
            V2CApp.errorExit(V2CLocalFileHandler.canDisplayJapanese() ? file + "\n\n\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : "Couldn't delete " + file);
        }
        file2.deleteOnExit();
        n = V2CLocalFileHandler.lockFile(false);
        if (n == 0) {
            V2CApp.errorExit(V2CLocalFileHandler.canDisplayJapanese() ? file + "\n\n\u3092\u30ed\u30c3\u30af\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : "Couldn't lock " + file2);
        }
        if (n == 3) {
            V2CLocalFileHandler.emptyShareInfFile();
        }
        fShareInf.deleteOnExit();
        return true;
    }

    static boolean createLockFile2(String string) {
        File file = fLock;
        Object[] objectArray = new Object[]{"\u7d9a\u884c (Continue)", "    \u7d42\u4e86 (Exit)    "};
        V2CHTMLPane v2CHTMLPane = new V2CHTMLPane("<html><body>\u30a8\u30e9\u30fc\uff1a " + string + "<br><br>\u5b9f\u884c\u4e2d\u306eV2C\u3078\u306e\u8981\u6c42\u9001\u51fa\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br>\u4e8c\u91cd\u8d77\u52d5\u3067\u306a\u3044\u3053\u3068\u304c\u78ba\u5b9f\u306a\u5834\u5408\u306f\u300c\u7d9a\u884c(Continue)\u300d\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br><br>\u3000<code><font size=\"+1\">" + file + "</font></code><br><br>\u3092\u524a\u9664\u3057\u3066\u73fe\u5728\u306e\u30d7\u30ed\u30bb\u30b9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002</body></html>");
        v2CHTMLPane.setAntiAliasing(true);
        int n = JOptionPane.showOptionDialog(null, v2CHTMLPane, "V2C \u591a\u91cd\u8d77\u52d5\u8b66\u544a", -1, 2, null, objectArray, objectArray[1]);
        if (n != 0) {
            V2CApp.immediateExit(0);
        }
        V2CLocalFileHandler.deleteLockFile(true);
        return V2CLocalFileHandler.createLockFile(false, null);
    }

    static void emptyShareInfFile() {
        V2CLocalFileHandler.addToShareInfFile(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void addToShareInfFile(String string) {
        block10: {
            File file;
            block11: {
                StringBuffer stringBuffer = new StringBuffer();
                if (nFileLockStatus == 3) {
                    stringBuffer.append(sFileLockedKey);
                    stringBuffer.append("=true\n");
                }
                if (string != null) {
                    stringBuffer.append(string);
                }
                file = fShareInf;
                if (stringBuffer.length() <= 0) break block11;
                BufferedWriter bufferedWriter = V2CLocalFileHandler.getBufferedWriter(file);
                if (bufferedWriter == null) break block10;
                bufferedWriter.write(stringBuffer.toString());
                Object var6_4 = null;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break block10;
                {
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var6_5 = null;
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
            }
            file.delete();
        }
    }

    static void deleteLockFile(boolean bl) {
        if (fchLockFile != null) {
            try {
                fchLockFile.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            fchLockFile = null;
        }
        flFileLock = null;
        fLock.delete();
        fShareInf.delete();
        if (bl && fLock.exists()) {
            V2CApp.errorExit(V2CJStr.getCantDeleteLockFileMessage(fLock));
        }
    }

    static int lockFile(boolean bl) {
        int n;
        FileLock fileLock;
        FileChannel fileChannel;
        block7: {
            RandomAccessFile randomAccessFile = null;
            fileChannel = null;
            fileLock = null;
            n = 2;
            try {
                randomAccessFile = new RandomAccessFile(fLock, bl ? "r" : "rw");
                fileChannel = randomAccessFile.getChannel();
                fileLock = fileChannel.tryLock(0L, Long.MAX_VALUE, bl);
                n = fileLock != null ? 3 : 0;
            }
            catch (Exception exception) {
                n = 1;
                exception.printStackTrace();
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (randomAccessFile == null) break block7;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        nFileLockStatus = n;
        fchLockFile = fileChannel;
        flFileLock = fileLock;
        return n;
    }

    static boolean askDeleteLockFile(boolean bl, V2CProperty v2CProperty) {
        int n;
        V2CHTMLPane v2CHTMLPane;
        int n2;
        Object[] objectArray;
        int n3;
        File file = fLock;
        boolean bl2 = false;
        V2CProperty v2CProperty2 = new V2CProperty(fShareInf);
        if (v2CProperty2.getBoolean(sFileLockedKey)) {
            n3 = V2CLocalFileHandler.lockFile(false);
            if (n3 == 3) {
                bl2 = true;
            } else if (n3 == 0) {
                if (bl) {
                    return false;
                }
                V2CApp.errorExit(V2CLocalFileHandler.canDisplayJapanese() ? V2CLocalFileHandler.getV2CDir() + "\n\n\u3092\u4f7f\u7528\u3059\u308bV2C\u304c\u65e2\u306b\u5b9f\u884c\u4e2d\u3067\u3059\u3002" : "Other V2C using \n " + V2CLocalFileHandler.getV2CDir() + "\nis now executing.");
            }
        }
        if (bl && !bl2) {
            return false;
        }
        if (v2CProperty != null) {
            objectArray = v2CProperty.getPackedValue("CrashWarningConf");
            if (objectArray != null) {
                n3 = objectArray.getBoolean('c') ? 1 : 0;
                n2 = objectArray.getBoolean('w') ? 1 : 0;
            } else {
                n2 = 0;
                n3 = 0;
            }
        } else {
            n2 = 1;
            n3 = 1;
        }
        if (bl2 && n3 != 0) {
            V2CLocalFileHandler.deleteLockFile(true);
            return true;
        }
        objectArray = new Object[]{"\u7d9a\u884c (Continue)", "    \u7d42\u4e86 (Exit)    "};
        if (!bl2) {
            v2CHTMLPane = new V2CHTMLPane("<html><body>\u524d\u56deV2C\u304c\u7570\u5e38\u7d42\u4e86\u3057\u305f\u304b\u3001\u4ed6\u306b<br>\u3000<code><font size=\"+1\">" + V2CLocalFileHandler.getV2CDir() + "</font></code><br>\u3092\u4f7f\u7528\u3059\u308bV2C\u304c\u65e2\u306b\u5b9f\u884c\u4e2d\u3067\u3059\u3002<br>\u4e8c\u91cd\u8d77\u52d5\u306f\u30ed\u30b0\u3084\u8a2d\u5b9a\u3092\u7834\u58ca\u3059\u308b\u539f\u56e0\u306b\u306a\u308a\u307e\u3059\u3002<br>\u4e8c\u91cd\u8d77\u52d5\u3067\u306a\u3044\u5834\u5408\u306e\u307f\u7d9a\u884c(Continue)\u3057\u3066\u304f\u3060\u3055\u3044\u3002</body></html>");
            v2CHTMLPane.setAntiAliasing(true);
            n = JOptionPane.showOptionDialog(V2CMain.v2cMain, v2CHTMLPane, "V2C \u591a\u91cd\u8d77\u52d5\u8b66\u544a", -1, 2, null, objectArray, objectArray[1]);
            if (n != 0) {
                V2CApp.immediateExit(0);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        if (bl2) {
            stringBuffer.append("\u524d\u56deV2C\u304c\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002<br>");
        }
        stringBuffer.append("V2C\u304c\u8d77\u52d5\u4e2d\u3067\u3042\u308b\u3053\u3068\u3092\u793a\u3059\u30d5\u30a1\u30a4\u30eb<br>\u3000<code><font size=\"+1\">");
        stringBuffer.append(file.toString());
        stringBuffer.append("</font></code><br>\u3092\u524a\u9664\u3057\u3066\u7d9a\u884c(Continue)\u3057\u307e\u3059\u3002</body></html>");
        v2CHTMLPane = new V2CHTMLPane(stringBuffer.toString());
        v2CHTMLPane.setAntiAliasing(true);
        n = JOptionPane.showOptionDialog(V2CMain.v2cMain, v2CHTMLPane, "V2C \u591a\u91cd\u8d77\u52d5\u8b66\u544a", -1, 2, null, objectArray, objectArray[1]);
        if (n != 0) {
            V2CApp.immediateExit(0);
        }
        V2CLocalFileHandler.deleteLockFile(true);
        if (n2 == 0 && V2CApp.isWinType() && !V2CLauncher.getStartedByInvocationAPI()) {
            v2CHTMLPane = new V2CHTMLPane("<html><body>\u524d\u56deV2C\u8d77\u52d5\u4e2d\u306bWindows\u3092\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3057\u305f\u5834\u5408\u306e\u6ce8\u610f\uff1a<br><br>\u73fe\u5728V2C\u3092\u8d77\u52d5\u4e2d\u306bWindows\u3092\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3059\u308b\u305f\u3081\u306e\u6700\u5584\u306e\u65b9\u6cd5\u306f\u3001<br>V2C.exe\u306b\"/T\"\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u4ed8\u3051\u305f\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8\u3067\u8d77\u52d5\u3059\u308b\u3053\u3068\u3067\u3059\u3002<br>\uff08\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9\u3067\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u3044\u308b\u5834\u5408\u306f<br>\u3000\u30b9\u30bf\u30fc\u30c8\u30e1\u30cb\u30e5\u30fc\u306e\u300cV2C\uff08\u30b3\u30de\u30f3\u30c9\u30d7\u30ed\u30f3\u30d7\u30c8\uff09\u300d\u3067\u3082\u53ef\u3002\uff09<br>V2C\u306e\u8d77\u52d5\u3068\u540c\u6642\u306b\u8868\u793a\u3055\u308c\u308b\u30b3\u30de\u30f3\u30c9\u30d7\u30ed\u30f3\u30d7\u30c8\u306f\u6700\u5c0f\u5316\u3057\u3066\u3082\u304b\u307e\u3044\u307e\u305b\u3093\u3002</body></html>");
            v2CHTMLPane.setAntiAliasing(true);
            JOptionPane.showMessageDialog(V2CMain.v2cMain, v2CHTMLPane, "V2C \u591a\u91cd\u8d77\u52d5\u8b66\u544a", 2);
        }
        return true;
    }

    private static File getBackupDir() {
        return new File(V2CLocalFileHandler.getV2CDir(), "backup");
    }

    private static void deleteOldBackups() {
        Object object;
        File file = V2CLocalFileHandler.getBackupDir();
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = V2CLocalFileHandler.getBackupNames();
        if (stringArray == null) {
            return;
        }
        long l = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        for (int i = 5; i < stringArray.length; ++i) {
            object = null;
            try {
                object = simpleDateFormat.parse(stringArray[i]);
            }
            catch (ParseException parseException) {
                continue;
            }
            if (((Date)object).getTime() >= l - 432000000L) continue;
            new File(file, stringArray[i] + ".zip").delete();
        }
        Matcher matcher = Pattern.compile("\\d{14}\\.zip").matcher("");
        object = file.listFiles();
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i];
            if (!((File)object2).isFile()) continue;
            String string = ((File)object2).getName();
            matcher.reset(string);
            if (matcher.matches()) continue;
            ((File)object2).delete();
        }
    }

    private static ArrayList getBackupFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{"usrprops", "favorite", "gesture", "inputmap", "linkhist", "listhist", "NGFiles", "ngfile", "shrtphrs", "tbbutton", "thrdhist", "toolbar", "basefont_def", "basefont_win", "basefont_mac", "extcmd_def", "extcmd_win", "extcmd_mac", "color", "cookie"};
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        String string = File.separator;
        arrayList.add("list" + string + "resnote");
        arrayList.add("list" + string + "txmarker");
        String[] stringArray2 = new String[]{"2ch", "2chEq", "JBBSShitaraba", "Machi", "Twitter", "UserDefined"};
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            if (!string2.equals("JBBSShitaraba") && !string2.equals("Twitter")) {
                arrayList.add("BBS" + string + string2 + string + "bbstree");
            }
            arrayList.add("BBS" + string + string2 + string + "bbsprops");
            if (string2.equals("UserDefined") || string2.equals("Twitter")) continue;
            arrayList.add("BBS" + string + string2 + string + "samba24");
        }
        arrayList.add("BBS" + string + "2ch" + string + "beid");
        arrayList.add("BBS" + string + "UserDefined" + string + "otherbrd");
        return arrayList;
    }

    static String[] getBackupNames() {
        int n;
        File file = V2CLocalFileHandler.getBackupDir();
        if (!file.isDirectory()) {
            return null;
        }
        Matcher matcher = Pattern.compile("\\d{14}\\.zip").matcher("");
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            File file2 = fileArray[n];
            if (!file2.isFile()) continue;
            String string = file2.getName();
            matcher.reset(string);
            if (!matcher.matches()) continue;
            arrayList.add(string.substring(0, 14));
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        return arrayList.toArray(new String[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void checkRestoreBackup() {
        block27: {
            block23: {
                block22: {
                    var0 = V2CLocalFileHandler.getBackupDir();
                    if (!var0.isDirectory()) {
                        return;
                    }
                    var1_1 = new File(var0, "restore.txt");
                    if (!var1_1.exists()) {
                        return;
                    }
                    try {
                        block24: {
                            var2_2 = V2CLocalFileHandler.restoreFromFile(var1_1);
                            if (var2_2 == null) {
                                var21_3 = null;
                                var1_1.delete();
                                return;
                            }
                            if ((var2_2 = var2_2.trim()).length() == 0) {
                                break block22;
                            }
                            var3_8 = new File(var0, var2_2);
                            if (!var3_8.isFile()) {
                                break block23;
                            }
                            var4_9 = null;
                            var5_10 = null;
                            var6_11 = null;
                            try {
                                try {
                                    var7_12 = V2CLocalFileHandler.getV2CDir();
                                    var8_14 = new byte[1024];
                                    var6_11 = new ZipFile(var3_8, 1);
                                    var9_15 = var6_11.entries();
                                    block10: while (var9_15.hasMoreElements()) {
                                        var10_16 = var9_15.nextElement();
                                        if (!(var10_16 instanceof ZipEntry)) continue;
                                        var11_17 = var10_16;
                                        var12_18 = var11_17.getName();
                                        if (var12_18.indexOf(47) >= 0) {
                                            if (var12_18.charAt(0) == '/' || var12_18.charAt(var12_18.length() - 1) == '/') continue;
                                            var13_19 = var7_12;
                                            var14_20 = V2CMiscUtil.split(var12_18, '/', false);
                                            for (var15_22 = 0; var15_22 < var14_20.length; ++var15_22) {
                                                var16_24 = var14_20[var15_22];
                                                if (var16_24.length() == 0) continue block10;
                                                var13_19 = new File(var13_19, var16_24);
                                            }
                                        } else {
                                            var13_19 = new File(var7_12, var12_18);
                                        }
                                        var4_9 = new BufferedInputStream(var6_11.getInputStream(var11_17));
                                        var5_10 = new BufferedOutputStream(new FileOutputStream(var13_19));
                                        while ((var14_21 = var4_9.read(var8_14)) >= 0) {
                                            if (var14_21 == 0) continue;
                                            var5_10.write(var8_14, 0, var14_21);
                                        }
                                        var5_10.close();
                                        var5_10 = null;
                                        var4_9.close();
                                        var4_9 = null;
                                        var15_23 = var11_17.getTime();
                                        if (var15_23 <= 0L) continue;
                                        var13_19.setLastModified(var15_23);
                                    }
                                    var18_25 = null;
                                    if (var6_11 == null) break block24;
                                }
                                catch (IOException var7_13) {
                                    var7_13.printStackTrace();
                                    var18_26 = null;
                                    if (var6_11 != null) {
                                        try {
                                            var6_11.close();
                                        }
                                        catch (IOException var19_29) {
                                            // empty catch block
                                        }
                                    }
                                    V2CLocalFileHandler.closeOutputStream(var5_10);
                                    V2CLocalFileHandler.closeInputStream(var4_9);
                                    break block27;
                                }
                            }
                            catch (Throwable var17_31) {
                                block28: {
                                    var18_27 = null;
                                    if (var6_11 != null) {
                                        ** try [egrp 3[TRYBLOCK] [4 : 426->434)] { 
lbl83:
                                        // 1 sources

                                        var6_11.close();
                                        break block28;
lbl85:
                                        // 1 sources

                                        catch (IOException var19_30) {
                                            // empty catch block
                                        }
                                    }
                                }
                                V2CLocalFileHandler.closeOutputStream(var5_10);
                                V2CLocalFileHandler.closeInputStream(var4_9);
                                throw var17_31;
                            }
                            ** try [egrp 3[TRYBLOCK] [4 : 426->434)] { 
lbl93:
                            // 1 sources

                            var6_11.close();
                            break block24;
lbl95:
                            // 1 sources

                            catch (IOException var19_28) {
                                // empty catch block
                            }
                        }
                        V2CLocalFileHandler.closeOutputStream(var5_10);
                        V2CLocalFileHandler.closeInputStream(var4_9);
                        break block27;
                    }
                    catch (Throwable var20_32) {
                        var21_7 = null;
                        var1_1.delete();
                        throw var20_32;
                    }
                }
                var21_4 = null;
                var1_1.delete();
                return;
            }
            var21_5 = null;
            var1_1.delete();
            return;
        }
        var21_6 = null;
        var1_1.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void createSettingBackup(String string, boolean bl) {
        boolean bl2;
        File file;
        String string2;
        File file2;
        block18: {
            Object object;
            Object object2;
            int n;
            file2 = V2CLocalFileHandler.getBackupDir();
            if (!file2.isDirectory() && !file2.mkdir()) {
                return;
            }
            if (string != null) {
                string = string + ".zip";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            string2 = simpleDateFormat.format(new Date()) + ".zip";
            File[] fileArray = file2.listFiles();
            boolean bl3 = false;
            if (string != null) {
                for (n = 0; n < fileArray.length; ++n) {
                    object2 = fileArray[n];
                    if (!((File)object2).isFile() || !string.equals(((File)object2).getName())) continue;
                    object = new File(file2, "restore.txt");
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    if (!V2CLocalFileHandler.saveToFile((File)object, string)) break;
                    bl3 = true;
                    break;
                }
            }
            for (n = 0; n < fileArray.length; ++n) {
                object2 = fileArray[n];
                if (!((File)object2).isFile()) continue;
                object = ((File)object2).getName();
                if (!(bl3 ? ((String)object).equals(string2) : ((String)object).regionMatches(0, string2, 0, 8))) continue;
                return;
            }
            file = new File(file2, "backup.zip");
            if (file.exists()) {
                file.delete();
            }
            object2 = null;
            object = null;
            bl2 = false;
            try {
                try {
                    CRC32 cRC32 = new CRC32();
                    object = new ZipOutputStream(new FileOutputStream(file));
                    File file3 = V2CLocalFileHandler.getV2CDir();
                    byte[] byArray = new byte[1024];
                    ArrayList arrayList = V2CLocalFileHandler.getBackupFiles();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        int n2;
                        int n3;
                        File file4;
                        String string3 = (String)arrayList.get(i);
                        if (!bl && string3.equals("linkhist") || !(file4 = new File(file3, string3 = string3 + ".txt")).isFile()) continue;
                        if (string3.indexOf(92) >= 0) {
                            string3 = V2CMiscUtil.replaceAll(string3, "\\", "/");
                        }
                        ZipEntry zipEntry = new ZipEntry(string3);
                        long l = file4.lastModified();
                        if (l > 0L) {
                            zipEntry.setTime(l);
                        }
                        if ((n3 = (int)file4.length()) == 0) {
                            zipEntry.setMethod(0);
                            zipEntry.setCrc(0L);
                            zipEntry.setSize(0L);
                            zipEntry.setCompressedSize(0L);
                            ((ZipOutputStream)object).putNextEntry(zipEntry);
                            ((ZipOutputStream)object).closeEntry();
                            continue;
                        }
                        if (n3 <= 128) {
                            byte[] byArray2 = V2CLocalFileHandler.restoreBytesFromFile(file4);
                            if (byArray2 == null || byArray2.length != n3) continue;
                            zipEntry.setMethod(0);
                            cRC32.reset();
                            cRC32.update(byArray2);
                            zipEntry.setCrc(cRC32.getValue());
                            zipEntry.setSize(n3);
                            zipEntry.setCompressedSize(n3);
                            ((ZipOutputStream)object).putNextEntry(zipEntry);
                            ((FilterOutputStream)object).write(byArray2);
                            ((ZipOutputStream)object).closeEntry();
                            continue;
                        }
                        object2 = new BufferedInputStream(new FileInputStream(file4));
                        ((ZipOutputStream)object).putNextEntry(zipEntry);
                        while ((n2 = ((FilterInputStream)object2).read(byArray)) >= 0) {
                            if (n2 == 0) continue;
                            ((ZipOutputStream)object).write(byArray, 0, n2);
                        }
                        ((ZipOutputStream)object).closeEntry();
                        ((BufferedInputStream)object2).close();
                        object2 = null;
                    }
                    bl2 = true;
                }
                catch (Exception exception) {
                    Object var24_26 = null;
                    V2CLocalFileHandler.closeInputStream((InputStream)object2);
                    V2CLocalFileHandler.closeOutputStream((OutputStream)object);
                    break block18;
                }
                Object var24_25 = null;
            }
            catch (Throwable throwable) {
                Object var24_27 = null;
                V2CLocalFileHandler.closeInputStream((InputStream)object2);
                V2CLocalFileHandler.closeOutputStream((OutputStream)object);
                throw throwable;
            }
            V2CLocalFileHandler.closeInputStream((InputStream)object2);
            V2CLocalFileHandler.closeOutputStream((OutputStream)object);
        }
        if (bl2) {
            file.renameTo(new File(file2, string2));
            return;
        }
        file.delete();
    }

    static void closeSystemOut() {
        if (vOutStream != null) {
            V2CLocalFileHandler.closeOutputStream(vOutStream);
        }
    }

    static boolean redirectOutput() {
        Object object;
        File file = fV2CLogFile;
        if (file.exists()) {
            object = new File(V2CLocalFileHandler.getV2CDir(), "v2clog0.txt");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            if (((File)object).exists() ? !file.delete() : !file.renameTo((File)object)) {
                return false;
            }
        }
        try {
            vOutStream = object = new V2CPrintStream(file);
            System.setOut((PrintStream)object);
            System.setErr((PrintStream)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    static String getV2CDirTxt() {
        File file = V2CLauncher.getJarDir();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, sV2CDirFName);
        if (!file2.exists() || !file2.isFile()) {
            return null;
        }
        if (file2.length() == 0L) {
            return "";
        }
        String string = V2CLocalFileHandler.restoreFromFile(file2);
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.indexOf(10);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    static void checkSubDirectories() {
        String[] stringArray = new String[]{"script", "sound", "userdata"};
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(v2cDir, stringArray[i]);
            if (file.exists()) continue;
            file.mkdir();
        }
        File[] fileArray = V2CLocalFileHandler.getImageSubFolders();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.isDirectory()) continue;
            if (file.isFile()) {
                file.delete();
            }
            file.mkdirs();
        }
    }

    static void deleteTempFiles() {
        File file = V2CLocalFileHandler.getTempFile("v2c_post.html");
        if (file.isFile()) {
            file.delete();
        }
        V2CLocalFileHandler.deleteOldBackups();
    }

    static void setBrushMetalLook(boolean bl) {
        V2CLocalFileHandler.checkFile(sBrushMetalLookFile, bl);
    }

    public static boolean isBrushMetalLook() {
        return V2CLocalFileHandler.checkFile(sBrushMetalLookFile);
    }

    static boolean extractToolBarIcons(File file) {
        return V2CLocalFileHandler.extractIcons(file, "toolbar");
    }

    static boolean extractItemIcons(File file) {
        return V2CLocalFileHandler.extractIcons(file, "item");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean extractIcons(File file, String string) {
        block28: {
            IOException iOException322;
            InputStream inputStream;
            ZipFile zipFile;
            block27: {
                block24: {
                    IOException iOException2222;
                    boolean bl;
                    block25: {
                        if (!file.exists()) {
                            return false;
                        }
                        zipFile = null;
                        inputStream = null;
                        if (file.length() != 0L) break block24;
                        bl = false;
                        Object var17_7 = null;
                        if (inputStream == null) break block25;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2222) {
                            // empty catch block
                        }
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException2222) {
                            // empty catch block
                        }
                    }
                    file.delete();
                    return bl;
                }
                File file2 = new File(V2CLocalFileHandler.getUserConfigFile("icon"), string);
                Pattern pattern = Pattern.compile(string + "/([a-zA-Z0-9]\\w+)");
                zipFile = new ZipFile(file, 1);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n;
                    ZipEntry zipEntry;
                    String string2;
                    Matcher matcher;
                    ZipEntry zipEntry2 = enumeration.nextElement();
                    if (!(zipEntry2 instanceof ZipEntry) || !(matcher = pattern.matcher(string2 = (zipEntry = zipEntry2).getName())).matches()) continue;
                    File file3 = new File(file2, matcher.group(1));
                    int n2 = (int)zipEntry.getSize();
                    if (n2 <= 0) continue;
                    byte[] byArray = new byte[n2];
                    inputStream = zipFile.getInputStream(zipEntry);
                    int n3 = 0;
                    while ((n = inputStream.read(byArray, n3, n2 - n3)) >= 0 && n3 + n < n2) {
                        n3 += n;
                    }
                    inputStream.close();
                    inputStream = null;
                    V2CLocalFileHandler.saveToFile(file3, byArray);
                }
                Object var17_8 = null;
                if (inputStream == null) break block27;
                try {
                    inputStream.close();
                }
                catch (IOException iOException322) {
                    // empty catch block
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                    break block28;
                }
                catch (IOException iOException322) {
                    // empty catch block
                }
                {
                }
            }
            break block28;
            {
                catch (IOException iOException4) {
                    IOException iOException5222;
                    boolean bl = false;
                    Object var17_9 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException5222) {
                            // empty catch block
                        }
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException5222) {
                            // empty catch block
                        }
                    }
                    file.delete();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOException iOException6222;
                Object var17_10 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException6222) {
                        // empty catch block
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException6222) {
                        // empty catch block
                    }
                }
                file.delete();
                throw throwable;
            }
        }
        file.delete();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int getV2CJarID(File file) {
        byte[] byArray;
        block25: {
            JarEntry jarEntry;
            InputStream inputStream;
            JarFile jarFile;
            block22: {
                block20: {
                    if (file.length() == 0L) {
                        return 0;
                    }
                    byArray = null;
                    jarFile = null;
                    inputStream = null;
                    jarFile = new JarFile(file, false, 1);
                    jarEntry = jarFile.getJarEntry("org/monazilla/v2c/id");
                    if (jarEntry != null) break block20;
                    int n = 0;
                    Object var10_8 = null;
                    V2CLocalFileHandler.closeInputStream(inputStream);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return n;
                }
                if ((int)jarEntry.getSize() >= 4) break block22;
                int n = 0;
                Object var10_9 = null;
                V2CLocalFileHandler.closeInputStream(inputStream);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return n;
            }
            try {
                int n;
                byte[] byArray2 = new byte[4];
                inputStream = jarFile.getInputStream(jarEntry);
                int n2 = 0;
                while ((n = inputStream.read(byArray2, n2, 4 - n2)) >= 0 && n2 + n < 4) {
                    n2 += n;
                }
                byArray = byArray2;
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                V2CLocalFileHandler.closeInputStream(inputStream);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            V2CLocalFileHandler.closeInputStream(inputStream);
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
            break block25;
            {
                catch (IOException iOException) {
                    int n = 0;
                    Object var10_11 = null;
                    V2CLocalFileHandler.closeInputStream(inputStream);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    return n;
                }
            }
        }
        if (byArray == null || byArray[0] != 0) {
            return 0;
        }
        return V2CReleaseInfo.createUniqueRelSeqNum(byArray[1], byArray[2], byArray[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static byte[] getBytesFromJar(File file, String string) {
        byte[] byArray;
        block24: {
            int n;
            JarEntry jarEntry;
            InputStream inputStream;
            JarFile jarFile;
            block21: {
                block19: {
                    if (file == null) {
                        return null;
                    }
                    jarFile = null;
                    inputStream = null;
                    byArray = null;
                    jarFile = new JarFile(file, false, 1);
                    jarEntry = jarFile.getJarEntry(string);
                    if (jarEntry != null) break block19;
                    byte[] byArray2 = null;
                    Object var10_10 = null;
                    V2CLocalFileHandler.closeInputStream(inputStream);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return byArray2;
                }
                n = (int)jarEntry.getSize();
                if (n > 0) break block21;
                byte[] byArray3 = new byte[]{};
                Object var10_11 = null;
                V2CLocalFileHandler.closeInputStream(inputStream);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return byArray3;
            }
            try {
                int n2;
                byArray = new byte[n];
                inputStream = jarFile.getInputStream(jarEntry);
                int n3 = 0;
                while ((n2 = inputStream.read(byArray, n3, n - n3)) >= 0 && n3 + n2 < n) {
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                V2CLocalFileHandler.closeInputStream(inputStream);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            V2CLocalFileHandler.closeInputStream(inputStream);
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
            break block24;
            {
                catch (Exception exception) {
                    byte[] byArray4 = null;
                    Object var10_13 = null;
                    V2CLocalFileHandler.closeInputStream(inputStream);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return byArray4;
                }
            }
        }
        return byArray;
    }

    static String getV2CRelativePath(File file) {
        CharSequence charSequence;
        ArrayList<String> arrayList;
        block5: {
            String string = file.getAbsolutePath();
            if (!string.startsWith(sAbsV2CPath)) {
                return string;
            }
            if (string.equals(sAbsV2CPath)) {
                return "V2C";
            }
            int n = sAbsV2CPath.length();
            File file2 = new File(string);
            arrayList = new ArrayList<String>();
            do {
                arrayList.add(file2.getName());
                file2 = file2.getParentFile();
                if (file2 == null) {
                    return string;
                }
                charSequence = file2.getAbsolutePath();
                if (((String)charSequence).equals(sAbsV2CPath)) break block5;
            } while (((String)charSequence).length() > n);
            return string;
        }
        charSequence = new StringBuffer("V2C");
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ((StringBuffer)charSequence).append(',');
            ((StringBuffer)charSequence).append(V2CMiscUtil.escapeComma((String)arrayList.get(i)));
        }
        arrayList.clear();
        return ((StringBuffer)charSequence).toString();
    }

    static String parseV2CRelativePath(String string) {
        if (string.equals("V2C")) {
            return sAbsV2CPath;
        }
        if (!string.startsWith("V2C,")) {
            return string;
        }
        if (string.length() == 4) {
            return sAbsV2CPath;
        }
        File file = v2cDir;
        String[] stringArray = V2CMiscUtil.split(string.substring(4));
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(file, stringArray[i]);
        }
        return file.getAbsolutePath();
    }

    static String getAbsolutePathInV2CDir(String string) {
        File file = new File(v2cDir, string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    static File getObjectSaveDir(String string) {
        File file = null;
        String string2 = V2CApp.getUserProperty().get(string);
        if (string2 != null) {
            file = new File(V2CLocalFileHandler.parseV2CRelativePath(string2));
        }
        if (file == null || !file.isDirectory()) {
            file = V2CLocalFileHandler.getV2CDir();
        }
        return file;
    }

    static void saveObjectSaveDir(String string, File file, boolean bl) {
        String string2 = V2CLocalFileHandler.getV2CRelativePath(bl ? file.getParentFile() : file);
        if (string2 != null) {
            V2CApp.getUserProperty().put(string, string2);
        }
    }

    static File getScriptFile(String string) {
        return V2CLocalFileHandler.getScriptFile(null, string);
    }

    static File getScriptFile(File file, String string) {
        int n;
        boolean bl;
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("[\\\\/]");
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        boolean bl2 = bl = stringArray[0].length() == 0;
        if (bl && stringArray.length == 1) {
            return null;
        }
        File file2 = file != null && !bl ? file : new File(V2CLocalFileHandler.getV2CDir(), "script");
        int n2 = n = bl ? 1 : 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.length() == 0) {
                return null;
            }
            file2 = new File(file2, string2);
            ++n;
        }
        return file2;
    }

    static File getSystemScriptFile(String string) {
        return new File(V2CLocalFileHandler.getScriptFile("system"), string);
    }

    static String getV2CIconFileName() {
        return V2CLocalFileHandler.getAbsolutePathInV2CDir("iconimg");
    }

    private static String replaceFileSeparators(String string) {
        String string2 = sFileSeparator;
        if (!string2.equals("/")) {
            string = V2CMiscUtil.replaceAll(string, "/", string2);
        }
        if (!string2.equals("\\")) {
            string = V2CMiscUtil.replaceAll(string, "\\", string2);
        }
        return string;
    }

    static boolean iconDirExists() {
        if (!bSmallIconDirChecked) {
            bSmallIconDirChecked = true;
            fSmallIconDir = V2CLocalFileHandler.getIconDir("item");
        }
        return fSmallIconDir != null;
    }

    static V2CImageSet getAvatarImage(String string) {
        if (!bAvatarDirChecked) {
            bAvatarDirChecked = true;
            fAvatarDir = V2CLocalFileHandler.getIconDir("avatar");
        }
        return V2CLocalFileHandler.getSubIconImage(fAvatarDir, string, false);
    }

    static V2CImageSet getInlineMsgImg(String string) {
        if (!bInlineMsgImgDirChecked) {
            bInlineMsgImgDirChecked = true;
            fInlineMsgImgDir = V2CLocalFileHandler.getIconDir("message");
        }
        return V2CLocalFileHandler.getSubIconImage(fInlineMsgImgDir, V2CLocalFileHandler.replaceFileSeparators(string), true);
    }

    static V2CImageSet getTabImg(String string) {
        if (!bTabImgDirChecked) {
            bTabImgDirChecked = true;
            fTabImgDir = V2CLocalFileHandler.getIconDir("tab");
        }
        return V2CLocalFileHandler.getSubIconImage(fTabImgDir, V2CLocalFileHandler.replaceFileSeparators(string), false);
    }

    static V2CImageSet getCMDImg(String string) {
        if (!bCMDImgDirChecked) {
            bCMDImgDirChecked = true;
            fCMDImgDir = V2CLocalFileHandler.getIconDir("command");
        }
        return V2CLocalFileHandler.getSubIconImage(fCMDImgDir, V2CLocalFileHandler.replaceFileSeparators(string), false);
    }

    static V2CImageSet getSubIconImage(File file, String string, boolean bl) {
        String[] stringArray;
        if (file == null) {
            return null;
        }
        if (bl && string.indexOf(46) > 0 && (stringArray = new File(file, string)).getName().indexOf(46) >= 0) {
            Object var4_4 = null;
            return stringArray.isFile() ? V2CImageSet.createImageSet(stringArray, false) : null;
        }
        stringArray = new String[]{".png", ".gif", ".jpg"};
        for (int i = 0; i < stringArray.length; ++i) {
            V2CImageSet v2CImageSet;
            File file2 = new File(file, string + stringArray[i]);
            if (!file2.isFile() || (v2CImageSet = V2CImageSet.createImageSet(file2, false)) == null || !v2CImageSet.isOK()) continue;
            return v2CImageSet;
        }
        return null;
    }

    static String[] listAvatarDir() {
        if (!bAvatarDirChecked) {
            bAvatarDirChecked = true;
            fAvatarDir = V2CLocalFileHandler.getIconDir("avatar");
        }
        return V2CLocalFileHandler.listIconSubDir(fAvatarDir, true);
    }

    static String[] listInlineMsgImgDir() {
        if (!bInlineMsgImgDirChecked) {
            bInlineMsgImgDirChecked = true;
            fInlineMsgImgDir = V2CLocalFileHandler.getIconDir("message");
        }
        return V2CLocalFileHandler.listIconSubDir(fInlineMsgImgDir, true);
    }

    static String[] listTabImgDir() {
        if (!bTabImgDirChecked) {
            bTabImgDirChecked = true;
            fTabImgDir = V2CLocalFileHandler.getIconDir("tab");
        }
        return V2CLocalFileHandler.listIconSubDir(fTabImgDir, true);
    }

    static String[] listCMDImgDir() {
        if (!bCMDImgDirChecked) {
            bCMDImgDirChecked = true;
            fCMDImgDir = V2CLocalFileHandler.getIconDir("command");
        }
        return V2CLocalFileHandler.listIconSubDir(fCMDImgDir, false);
    }

    private static String[] listIconSubDir(File file, boolean bl) {
        int n;
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(bl ? sNashi : "\uff08\u30c7\u30d5\u30a9\u30eb\u30c8\uff09");
        if (file != null && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            boolean bl2 = V2CApp.isWinType();
            block0: for (int i = 0; i < fileArray.length; ++i) {
                String string;
                int n2;
                File file2 = fileArray[i];
                if (!file2.isFile() || file2.length() == 0L || (n2 = (string = file2.getName()).length()) <= 4 || string.charAt(n2 - 4) != '.') continue;
                String string2 = string.substring(n2 - 3);
                if (bl2) {
                    string2 = string2.toLowerCase();
                }
                if (!string2.equals("png") && !string2.equals("gif") && !string2.equals("jpg")) continue;
                string = string.substring(0, n2 - 4);
                for (int j = arrayList.size() - 1; j >= 0; --j) {
                    String string3 = (String)arrayList.get(j);
                    if (bl2 ? string.equalsIgnoreCase(string3) : string.equals(string3)) continue block0;
                }
                arrayList.add(string);
            }
        }
        if ((n = arrayList.size()) > 1) {
            Collections.sort(arrayList.subList(1, n));
        }
        return arrayList.toArray(new String[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getResource(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        InputStream inputStream;
        block9: {
            inputStream = null;
            n4 = n5 = byArray[0] & 0xFF;
            if (n2 != 0) {
                n3 = n5 - 1;
                while (n3 >= 1) {
                    int n6 = n3--;
                    byArray[n6] = (byte)(byArray[n6] + n2);
                }
            }
            if ((inputStream = V2CLocalFileHandler.class.getResourceAsStream(new String(byArray, 1, n))) != null) break block9;
            n3 = -1;
            Object var9_8 = null;
            V2CLocalFileHandler.closeInputStream(inputStream);
            return n3;
        }
        try {
            try {
                int n7;
                n3 = byArray.length;
                while ((n7 = inputStream.read(byArray, n4, n3 - n4)) >= 0) {
                    if (n7 <= 0 || (n4 += n7) < n3) continue;
                }
            }
            catch (Exception exception) {
                int n8 = -1;
                Object var9_10 = null;
                V2CLocalFileHandler.closeInputStream(inputStream);
                return n8;
            }
            {
                break;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            V2CLocalFileHandler.closeInputStream(inputStream);
            throw throwable;
        }
        V2CLocalFileHandler.closeInputStream(inputStream);
        if (n2 != 0) {
            V2CMiscUtil.convertResource(byArray, n5, n4 - n5);
        }
        return n4 - n5;
    }

    static V2CImageSet getSystemImageSet(String string) {
        V2CImageSet v2CImageSet = V2CImageSet.createImageSet(V2CLocalFileHandler.getSystemIconImage(string, true));
        return v2CImageSet.isOK() ? v2CImageSet : null;
    }

    static ImageIcon getSystemIcon(String string, boolean bl) {
        BufferedImage bufferedImage = V2CLocalFileHandler.getSystemIconImage(string, bl);
        return bufferedImage != null ? new ImageIcon(bufferedImage) : null;
    }

    private static BufferedImage getSystemIconImage(String string, boolean bl) {
        File file;
        BufferedImage bufferedImage = null;
        if (bl && V2CLocalFileHandler.iconDirExists() && (file = new File(fSmallIconDir, string)).isFile()) {
            try {
                bufferedImage = ImageIO.read(file);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        if ((bufferedImage == null || bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) && bufferedImage == null) {
            if (bUsePNGResource) {
                bufferedImage = V2CLocalFileHandler.createImageFromPNGResource("pngicon", string);
            }
            if (bufferedImage == null) {
                bufferedImage = V2CLocalFileHandler.createImageFromResource("icon", string);
            }
        }
        return bufferedImage != null && bufferedImage.getWidth() > 0 && bufferedImage.getHeight() > 0 ? bufferedImage : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] getIconBytesFromResource(String string) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byte[] byArray2;
            block12: {
                byte[] byArray3;
                block10: {
                    ClassLoader classLoader = V2CLocalFileHandler.class.getClassLoader();
                    URL uRL = classLoader.getResource("org/monazilla/v2c/tbicon/" + string);
                    if (uRL == null) {
                        return null;
                    }
                    byArray = null;
                    inputStream = null;
                    try {
                        try {
                            int n;
                            boolean bl = V2CApp.bJWS;
                            URLConnection uRLConnection = uRL.openConnection();
                            int n2 = uRLConnection.getContentLength();
                            if (n2 <= 3) {
                                byArray3 = null;
                                Object var12_11 = null;
                                break block10;
                            }
                            if (bl && n2 > 20000) {
                                n2 = 20000;
                            }
                            byArray = new byte[n2];
                            inputStream = uRLConnection.getInputStream();
                            int n3 = 0;
                            while ((n = inputStream.read(byArray, n3, n2 - n3)) >= 0 && (n3 += n) < n2) {
                            }
                            if (!(bl ? n3 < 1000 : n3 < n2)) break block11;
                            byArray2 = null;
                            break block12;
                        }
                        catch (IOException iOException) {
                            System.out.println(iOException.getMessage());
                            Object var12_14 = null;
                            V2CLocalFileHandler.closeInputStream(inputStream);
                            return byArray;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        V2CLocalFileHandler.closeInputStream(inputStream);
                        throw throwable;
                    }
                }
                V2CLocalFileHandler.closeInputStream(inputStream);
                return byArray3;
            }
            Object var12_12 = null;
            V2CLocalFileHandler.closeInputStream(inputStream);
            return byArray2;
        }
        Object var12_13 = null;
        V2CLocalFileHandler.closeInputStream(inputStream);
        return byArray;
    }

    private static BufferedImage createImageFromResource(String string, String string2) {
        ClassLoader classLoader = V2CLocalFileHandler.class.getClassLoader();
        URL uRL = classLoader.getResource("org/monazilla/v2c/" + string + '/' + string2);
        if (uRL == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            int n2 = uRLConnection.getContentLength();
            if (n2 <= 6) {
                return null;
            }
            byte[] byArray = new byte[n2];
            InputStream inputStream = uRLConnection.getInputStream();
            int n3 = 0;
            while ((n = inputStream.read(byArray, n3, n2 - n3)) >= 0 && (n3 += n) < n2) {
            }
            if (n3 < n2) {
                return null;
            }
            int n4 = byArray[n2 - 2] & 0xFF;
            int n5 = byArray[n2 - 1] & 0xFF;
            int n6 = n4 * n5 * 4;
            if (n6 != n2 - 2) {
                return null;
            }
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, n6);
            WritableRaster writableRaster = WritableRaster.createInterleavedRaster(dataBufferByte, n4, n5, 4 * n4, 4, new int[]{3, 2, 1, 0}, new Point(0, 0));
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return bufferedImage;
    }

    static ImageIcon getSystemImage(String string) {
        BufferedImage bufferedImage = null;
        bufferedImage = V2CLocalFileHandler.createImageFromPNGResource("image", string);
        return bufferedImage != null ? new ImageIcon(bufferedImage) : null;
    }

    private static BufferedImage createImageFromPNGResource(String string, String string2) {
        ClassLoader classLoader = V2CLocalFileHandler.class.getClassLoader();
        URL uRL = classLoader.getResource("org/monazilla/v2c/" + string + '/' + string2 + ".png");
        BufferedImage bufferedImage = null;
        if (uRL != null) {
            try {
                bufferedImage = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println(noClassDefFoundError.getMessage());
            }
        }
        return bufferedImage != null && bufferedImage.getWidth() > 0 && bufferedImage.getHeight() > 0 ? bufferedImage : null;
    }

    static File getToolBarIconFile(String string) {
        if (string == null) {
            return null;
        }
        if (!bToolBarIconDirChecked) {
            bToolBarIconDirChecked = true;
            fToolBarIconDir = V2CLocalFileHandler.getIconDir("toolbar");
        }
        if (fToolBarIconDir == null) {
            return null;
        }
        File file = new File(fToolBarIconDir, string);
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    private static File getIconDir(String string) {
        File file = new File(v2cDir, "icon");
        if (!file.isDirectory()) {
            return null;
        }
        if ((file = new File(file, string)).isDirectory()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void saveThumbnail(File file, BufferedImage bufferedImage) {
        OutputStream outputStream;
        block12: {
            block11: {
                if (file == null) return;
                if (bufferedImage == null) {
                    return;
                }
                outputStream = null;
                try {
                    try {
                        int n;
                        int n2 = bufferedImage.getWidth();
                        int n3 = bufferedImage.getHeight();
                        int n4 = n2 * n3;
                        if (n4 <= 0) {
                            Object var13_7 = null;
                            break block11;
                        }
                        outputStream = new FileOutputStream(file);
                        outputStream = new BufferedOutputStream(outputStream);
                        int[] nArray = new int[n4];
                        bufferedImage.getRGB(0, 0, n2, n3, nArray, 0, n2);
                        boolean bl = false;
                        for (n = 0; n < n4; ++n) {
                            if ((nArray[n] & 0xFF000000) == -16777216) continue;
                            bl = true;
                            break;
                        }
                        n = 12 + n4 * (bl ? 4 : 3) > 512 ? 1 : 0;
                        byte[] byArray = new byte[]{86, 50, 67, (byte)(n != 0 ? 1 : 0)};
                        outputStream.write(byArray, 0, 4);
                        if (n != 0) {
                            outputStream = new GZIPOutputStream(outputStream);
                        }
                        byArray[0] = (byte)(bl ? 1 : 0);
                        byArray[1] = (byte)(n2 >>> 16);
                        byArray[2] = (byte)(n2 >>> 8);
                        byArray[3] = (byte)n2;
                        outputStream.write(byArray, 0, 4);
                        byArray[0] = 0;
                        byArray[1] = (byte)(n3 >>> 16);
                        byArray[2] = (byte)(n3 >>> 8);
                        byArray[3] = (byte)n3;
                        outputStream.write(byArray, 0, 4);
                        for (int i = 0; i < n4; ++i) {
                            int n5 = nArray[i];
                            byArray[1] = (byte)(n5 >>> 16);
                            byArray[2] = (byte)(n5 >>> 8);
                            byArray[3] = (byte)n5;
                            if (bl) {
                                byArray[0] = (byte)(n5 >>> 24);
                                outputStream.write(byArray, 0, 4);
                                continue;
                            }
                            outputStream.write(byArray, 1, 3);
                        }
                        break block12;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var13_9 = null;
                        V2CLocalFileHandler.closeOutputStream(outputStream);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    V2CLocalFileHandler.closeOutputStream(outputStream);
                    throw throwable;
                }
            }
            V2CLocalFileHandler.closeOutputStream(outputStream);
            return;
        }
        Object var13_8 = null;
        V2CLocalFileHandler.closeOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BufferedImage tryRestoreThumbnail(File file) {
        InputStream inputStream;
        BufferedImage bufferedImage;
        block23: {
            BufferedImage bufferedImage2;
            block22: {
                BufferedImage bufferedImage3;
                block21: {
                    BufferedImage bufferedImage4;
                    block20: {
                        BufferedImage bufferedImage5;
                        block19: {
                            BufferedImage bufferedImage6;
                            block18: {
                                BufferedImage bufferedImage7;
                                block17: {
                                    BufferedImage bufferedImage8;
                                    block16: {
                                        if (file == null) {
                                            return null;
                                        }
                                        bufferedImage = null;
                                        inputStream = null;
                                        try {
                                            try {
                                                boolean bl;
                                                inputStream = new FileInputStream(file);
                                                inputStream = new BufferedInputStream(inputStream);
                                                byte[] byArray = new byte[4];
                                                if (inputStream.read(byArray, 0, 4) != 4) {
                                                    bufferedImage8 = null;
                                                    Object var17_8 = null;
                                                    break block16;
                                                }
                                                if (byArray[0] != 86 || byArray[1] != 50 || byArray[2] != 67) {
                                                    bufferedImage7 = null;
                                                    break block17;
                                                }
                                                byte by = byArray[3];
                                                if ((by & 0xFE) != 0) {
                                                    bufferedImage6 = null;
                                                    break block18;
                                                }
                                                boolean bl2 = bl = (by & 1) != 0;
                                                if (bl) {
                                                    inputStream = new GZIPInputStream(inputStream);
                                                }
                                                if (inputStream.read(byArray, 0, 4) != 4) {
                                                    bufferedImage5 = null;
                                                    break block19;
                                                }
                                                boolean bl3 = (byArray[0] & 1) != 0;
                                                int n = (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                                                if (inputStream.read(byArray, 0, 4) != 4) {
                                                    bufferedImage4 = null;
                                                    break block20;
                                                }
                                                if (byArray[0] != 0) {
                                                    bufferedImage3 = null;
                                                    break block21;
                                                }
                                                int n2 = (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                                                int n3 = n * n2;
                                                if (n3 <= 0) {
                                                    bufferedImage2 = null;
                                                    break block22;
                                                }
                                                int n4 = bl3 ? 4 : 3;
                                                int[] nArray = new int[n3];
                                                for (int i = 0; i < n3; ++i) {
                                                    int n5;
                                                    for (int j = n4; j > 0; j -= n5) {
                                                        n5 = inputStream.read(byArray, 4 - j, j);
                                                        if (n5 > 0) continue;
                                                        BufferedImage bufferedImage9 = null;
                                                        Object var17_15 = null;
                                                        V2CLocalFileHandler.closeInputStream(inputStream);
                                                        return bufferedImage9;
                                                    }
                                                    nArray[i] = (bl3 ? byArray[0] << 24 : -16777216) | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                                                }
                                                bufferedImage = new BufferedImage(n, n2, 2);
                                                bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
                                                break block23;
                                            }
                                            catch (IOException iOException) {
                                                iOException.printStackTrace();
                                                Object var17_17 = null;
                                                V2CLocalFileHandler.closeInputStream(inputStream);
                                                return bufferedImage;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var17_18 = null;
                                            V2CLocalFileHandler.closeInputStream(inputStream);
                                            throw throwable;
                                        }
                                    }
                                    V2CLocalFileHandler.closeInputStream(inputStream);
                                    return bufferedImage8;
                                }
                                Object var17_9 = null;
                                V2CLocalFileHandler.closeInputStream(inputStream);
                                return bufferedImage7;
                            }
                            Object var17_10 = null;
                            V2CLocalFileHandler.closeInputStream(inputStream);
                            return bufferedImage6;
                        }
                        Object var17_11 = null;
                        V2CLocalFileHandler.closeInputStream(inputStream);
                        return bufferedImage5;
                    }
                    Object var17_12 = null;
                    V2CLocalFileHandler.closeInputStream(inputStream);
                    return bufferedImage4;
                }
                Object var17_13 = null;
                V2CLocalFileHandler.closeInputStream(inputStream);
                return bufferedImage3;
            }
            Object var17_14 = null;
            V2CLocalFileHandler.closeInputStream(inputStream);
            return bufferedImage2;
        }
        Object var17_16 = null;
        V2CLocalFileHandler.closeInputStream(inputStream);
        return bufferedImage;
    }

    static File getSoundFile(String string) {
        if (!bSoundDirChecked) {
            bSoundDirChecked = true;
            fSoundDir = V2CLocalFileHandler.getSoundDir();
        }
        if (fSoundDir == null) {
            return null;
        }
        String[] stringArray = new String[]{".wav", ".WAV", ".au", ".AU", ".af", ".AF", ".aiff", ".AIFF"};
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(fSoundDir, string + stringArray[i]);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    static File getSoundDir() {
        File file = new File(v2cDir, "sound");
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    static File getListFile(String string) {
        return new File(fListDir, string);
    }

    static BufferedReader getConfigReader(String string) {
        return V2CLocalFileHandler.getJarFileReader("org/monazilla/v2c/conf/" + string, sConfigCharSet);
    }

    static BufferedReader getJarFileReader(String string, String string2) {
        ClassLoader classLoader = V2CLocalFileHandler.class.getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = uRL.openStream();
            if (inputStream == null) {
                return null;
            }
            inputStreamReader = new InputStreamReader(inputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(nullPointerException.getMessage());
        }
        if (inputStreamReader == null) {
            return null;
        }
        return new BufferedReader(inputStreamReader);
    }

    static BufferedInputStream getJarFileInputStream(String string) {
        ClassLoader classLoader = V2CLocalFileHandler.class.getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(nullPointerException.getMessage());
        }
        return inputStream != null ? new BufferedInputStream(inputStream) : null;
    }

    static File getUserConfigFile(String string) {
        return new File(v2cDir, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String restoreTextResource(String string) {
        URL uRL = V2CLocalFileHandler.class.getClassLoader().getResource(string);
        if (uRL == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), sConfigCharSet));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('\n');
                }
                Object var7_6 = null;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                String string3 = null;
                Object var7_7 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            V2CLocalFileHandler.closeReader(bufferedReader);
            throw throwable;
        }
        V2CLocalFileHandler.closeReader(bufferedReader);
        return stringBuffer.toString();
    }

    static BufferedReader getUserConfigReader(String string) {
        return V2CLocalFileHandler.getUserConfigReader(string, sConfigCharSet);
    }

    static BufferedReader getUserConfigReader(String string, String string2) {
        File file = new File(v2cDir, string);
        InputStreamReader inputStreamReader = V2CLocalFileHandler.getInputStreamReader(file, string2);
        if (inputStreamReader == null) {
            return null;
        }
        return new BufferedReader(inputStreamReader);
    }

    static BufferedWriter getUserConfigWriter(String string) {
        return V2CLocalFileHandler.getUserConfigWriter(string, sConfigCharSet, false);
    }

    static BufferedWriter getUserConfigWriter(String string, boolean bl) {
        return V2CLocalFileHandler.getUserConfigWriter(string, sConfigCharSet, bl);
    }

    static BufferedWriter getUserConfigWriter(String string, String string2) {
        return V2CLocalFileHandler.getUserConfigWriter(string, string2, false);
    }

    static BufferedWriter getUserConfigWriter(String string, String string2, boolean bl) {
        File file = new File(v2cDir, string);
        OutputStreamWriter outputStreamWriter = V2CLocalFileHandler.getOutputStreamWriter(file, bl, string2);
        if (outputStreamWriter == null) {
            return null;
        }
        return new BufferedWriter(outputStreamWriter);
    }

    static File getBBSDir() {
        return fBBSDir;
    }

    static File getBBSPropertyFile(V2CBBS v2CBBS) {
        return new File(new File(fBBSDir, v2CBBS.getID()), "bbsprops.txt");
    }

    static File getFileInBBSDir(V2CBBS v2CBBS, String string) {
        return new File(new File(fBBSDir, v2CBBS.getID()), string);
    }

    static boolean checkLCBBSDir() {
        if (fBBSDir.isDirectory()) {
            return false;
        }
        File file = new File(v2cDir, "bbs");
        return file.isDirectory();
    }

    static BufferedReader getRSSReader(String string) {
        return V2CLocalFileHandler.getBufferedReader(new File(fRSSDir, string), sConfigCharSet);
    }

    static BufferedWriter getRSSWriter(String string) {
        return V2CLocalFileHandler.getBufferedWriter(new File(fRSSDir, string), false, sConfigCharSet);
    }

    static File getWebSearchFile(String string) {
        return new File(fWebSearchDir, string);
    }

    static File getScriptTLFile(String string) {
        return new File(fScriptTLDir, string);
    }

    static void createTmpDir() {
        if (!fTmpDir.exists()) {
            fTmpDir.mkdir();
        }
    }

    static File getTempFile(String string) {
        V2CLocalFileHandler.createTmpDir();
        return new File(fTmpDir, string);
    }

    static synchronized File getTempFile() {
        File file;
        do {
            if (!(file = V2CLocalFileHandler.getTempFile("tmp" + iTempFileNumber++)).exists()) continue;
            file.delete();
        } while (file.exists());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean fileEndEquals(File var0, byte[] var1_1, int var2_2) {
        block14: {
            block13: {
                var3_3 = (int)var0.length();
                if (var3_3 < var2_2) {
                    return false;
                }
                var4_4 = V2CLocalFileHandler.getRandomAccessFile(var0);
                if (var4_4 == null) {
                    return false;
                }
                try {
                    try {
                        var4_4.seek(var3_3 - var2_2);
                        var5_5 = true;
                        for (var6_7 = 0; var6_7 < var2_2; ++var6_7) {
                            if (var1_1[var6_7] == var4_4.readByte()) continue;
                            var7_9 = false;
                            var9_10 = null;
                            break block13;
                        }
                        break block14;
                    }
                    catch (IOException var5_6) {
                        System.out.println(var5_6.getMessage());
                        var6_8 = false;
                        var9_12 = null;
                        try {
                            var4_4.close();
                            return var6_8;
                        }
                        catch (IOException var10_16) {
                            // empty catch block
                        }
                        return var6_8;
                    }
                }
                catch (Throwable var8_18) {
                    var9_13 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 112->120)] { 
lbl33:
                    // 1 sources

                    var4_4.close();
                    throw var8_18;
lbl35:
                    // 1 sources

                    catch (IOException var10_17) {
                        // empty catch block
                    }
                    throw var8_18;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 112->120)] { 
lbl40:
            // 1 sources

            var4_4.close();
            return var7_9;
lbl42:
            // 1 sources

            catch (IOException var10_14) {
                // empty catch block
            }
            return var7_9;
        }
        var9_11 = null;
        try {}
        catch (IOException var10_15) {}
        var4_4.close();
        return true;
        return true;
    }

    static File getResStyleDir() {
        return fResStyleDir;
    }

    static File getResStyleDir(String string) {
        return string != null ? new File(fResStyleDir, string) : null;
    }

    static BufferedImage readImage(File file, String string) {
        if (!sFileSeparator.equals("/")) {
            string = V2CMiscUtil.replaceAll(string, "/", sFileSeparator);
        }
        File file2 = new File(file, string);
        BufferedImage bufferedImage = null;
        if (file2.isFile()) {
            try {
                bufferedImage = ImageIO.read(file2);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        return bufferedImage;
    }

    static File[] getImageSubFolders() {
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        File[] fileArray = new File[16];
        for (int i = 0; i < 16; ++i) {
            fileArray[i] = new File(fImageDir, stringArray[i]);
        }
        return fileArray;
    }

    static File[] getThumbnailCacheSubFolders() {
        return V2CLocalFileHandler.getSubImageSubFolders(true);
    }

    static File[] getImagePropertySubFolders() {
        return V2CLocalFileHandler.getSubImageSubFolders(false);
    }

    private static File[] getSubImageSubFolders(boolean bl) {
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V"};
        File[] fileArray = new File[32];
        for (int i = 0; i < 32; ++i) {
            fileArray[i] = new File(bl ? fThumbnailCacheDir : fImagePropDir, stringArray[i]);
        }
        return fileArray;
    }

    static boolean isThumbnailCacheRootExists() {
        return fThumbnailCacheDir.exists();
    }

    static File getThumbnailCacheFile(int n, long l, long l2) {
        String string = V2CSHA1Value.toB32HString(n, l, l2);
        return new File(new File(fThumbnailCacheDir, string.substring(0, 1)), string);
    }

    static File getImagePropFile(int n, long l, long l2) {
        String string = V2CSHA1Value.toString(n, l, l2) + ".txt";
        return new File(new File(fImagePropDir, string.substring(0, 1)), string);
    }

    static File getImageFile(int n, long l, long l2, String string) {
        String string2 = V2CSHA1Value.toString(n, l, l2);
        if (string != null) {
            string2 = string2 + string;
        }
        return new File(new File(fImageDir, string2.substring(0, 1)), string2);
    }

    static File getTmpImageCacheFile(int n) {
        return new File(fTmpImageDir, "img" + dfFNum.format(n));
    }

    static boolean renameTmpImageFile(File file, int n, long l, long l2, String string) {
        File file2 = V2CLocalFileHandler.getImageFile(n, l, l2, string);
        if (file2.exists()) {
            file.delete();
            return true;
        }
        File file3 = file2.getParentFile();
        if (!file3.isDirectory()) {
            if (file3.isFile() && !file3.delete()) {
                return false;
            }
            if (!file3.mkdirs()) {
                return false;
            }
        }
        if (file.renameTo(file2)) {
            return true;
        }
        boolean bl = V2CLocalFileHandler.copyFile(file, file2, false);
        file.delete();
        return bl;
    }

    static File createExpImageFile(int n, long l, long l2, String string, String string2) {
        File file;
        File file2 = V2CLocalFileHandler.getImageFile(n, l, l2, string);
        if (!file2.isFile() || file2.length() == 0L) {
            return null;
        }
        if (!fExpImageDir.isDirectory()) {
            if (fExpImageDir.isFile()) {
                fExpImageDir.delete();
            }
            fExpImageDir.mkdirs();
            if (!fExpImageDir.isDirectory()) {
                return null;
            }
        }
        return V2CLocalFileHandler.copyFile(file2, file = new File(fExpImageDir, string2), true) ? file : null;
    }

    static void clearExpImageFiles() {
        if (!fExpImageDir.isDirectory()) {
            return;
        }
        File[] fileArray = fExpImageDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    static void clearTempYTFiles() {
        if (!fTmpDir.isDirectory()) {
            return;
        }
        File[] fileArray = fTmpDir.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                File file = fileArray[i];
                if (!file.isFile() || !(string = file.getName()).startsWith("YT_") || !string.endsWith(".html")) continue;
                file.delete();
            }
        }
    }

    static File getRSSCacheFile(int n) {
        return new File(fRSSDir, "rss" + dfFNum.format(n) + ".rdf");
    }

    static File getRSSPropertyFile(int n) {
        return new File(fRSSDir, "rss" + dfFNum.format(n) + ".txt");
    }

    static File getRSSLastLinkFile(int n) {
        return new File(fRSSDir, "rsl" + dfFNum.format(n) + ".txt");
    }

    static File getThreadCacheFile(int n) {
        return new File(fWebSearchDir, "wsc" + dfFNum.format(n) + ".txt");
    }

    static File getSTLCacheFile(int n) {
        return new File(fScriptTLDir, "stl" + dfFNum.format(n) + ".txt");
    }

    private static File getMemoFile(int n) {
        return n > 0 ? new File(new File(v2cDir, "memo"), String.valueOf(n)) : null;
    }

    static String getMemoText(int n) {
        return V2CLocalFileHandler.restoreFromFile(V2CLocalFileHandler.getMemoFile(n), sConfigCharSet);
    }

    static void saveMemoText(int n, String string) {
        File file = V2CLocalFileHandler.getMemoFile(n);
        if (file == null) {
            return;
        }
        if (string != null && string.length() > 0) {
            V2CLocalFileHandler.saveToFile(file, string, sConfigCharSet);
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkFileContents(File file, byte[] byArray) {
        InputStream inputStream;
        block14: {
            boolean bl;
            block13: {
                int n;
                block12: {
                    if (file == null) return false;
                    if (byArray == null) {
                        return false;
                    }
                    int n2 = byArray.length;
                    int n3 = (int)file.length();
                    if (!file.isFile()) return false;
                    if (n3 > n2) {
                        return false;
                    }
                    if (n3 == 0) {
                        return true;
                    }
                    inputStream = V2CLocalFileHandler.getInputStream(file);
                    if (inputStream == null) {
                        return false;
                    }
                    byte[] byArray2 = new byte[1024];
                    try {
                        try {
                            int n4;
                            int n5 = 0;
                            while ((n4 = inputStream.read(byArray2)) > 0) {
                                if (n5 + n4 > n2) {
                                    n = 0;
                                    Object var11_11 = null;
                                    break block12;
                                }
                                for (n = 0; n < n4; ++n) {
                                    if (byArray2[n] == byArray[n5++]) continue;
                                    bl = false;
                                    break block13;
                                }
                            }
                            break block14;
                        }
                        catch (IOException iOException) {
                            boolean bl2 = false;
                            Object var11_14 = null;
                            V2CLocalFileHandler.closeInputStream(inputStream);
                            return bl2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        V2CLocalFileHandler.closeInputStream(inputStream);
                        throw throwable;
                    }
                }
                V2CLocalFileHandler.closeInputStream(inputStream);
                return n != 0;
            }
            Object var11_12 = null;
            V2CLocalFileHandler.closeInputStream(inputStream);
            return bl;
        }
        Object var11_13 = null;
        V2CLocalFileHandler.closeInputStream(inputStream);
        return true;
    }

    static String restoreFromFile(File file) {
        return V2CLocalFileHandler.restoreFromFile(file, sDefCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String restoreFromFile(File var0, String var1_1) {
        block11: {
            if (var0 == null) return null;
            if (var0.isFile() == false) return null;
            var2_2 = (int)var0.length();
            if (var2_2 == 0) {
                return null;
            }
            var3_3 = "EUC-JP".equals(var1_1);
            if (var3_3) {
                var1_1 = "ISO-8859-1";
            }
            var4_4 = new StringBuffer(var2_2);
            var6_5 = null;
            try {
                try {
                    var6_5 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(var0), var1_1));
                    var8_6 = new char[1024];
                    while ((var7_8 = var6_5.read(var8_6, 0, 1024)) > 0 && var7_8 >= 0) {
                        if (var7_8 <= 0) continue;
                        var4_4.append(var8_6, 0, var7_8);
                    }
                    var10_11 = null;
                    if (var6_5 == null) break block11;
                }
                catch (IOException var7_9) {
                    var8_7 = null;
                    var10_12 = null;
                    if (var6_5 == null) return var8_7;
                    try {
                        var6_5.close();
                        return var8_7;
                    }
                    catch (IOException var11_15) {
                        // empty catch block
                    }
                    return var8_7;
                }
            }
            catch (Throwable var9_17) {
                var10_13 = null;
                if (var6_5 == null) throw var9_17;
                ** try [egrp 2[TRYBLOCK] [4 : 160->168)] { 
lbl39:
                // 1 sources

                var6_5.close();
                throw var9_17;
lbl41:
                // 1 sources

                catch (IOException var11_16) {
                    // empty catch block
                }
                throw var9_17;
            }
            try {}
            catch (IOException var11_14) {}
            var6_5.close();
        }
        var7_10 = var4_4.toString();
        if (var3_3 == false) return var7_10;
        return V2CJPConverter.convertISO88591ToCP51232(var7_10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String[] readLines(File file, String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        Object var7_6 = null;
        if (bufferedReader == null) return arrayList.toArray(new String[arrayList.size()]);
        try {
            bufferedReader.close();
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException iOException) {}
        return arrayList.toArray(new String[arrayList.size()]);
        {
            catch (IOException iOException) {
                String[] stringArray = null;
                Object var7_7 = null;
                if (bufferedReader == null) return stringArray;
                try {
                    bufferedReader.close();
                    return stringArray;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean restoreFromFile(File file, StringBuffer stringBuffer) {
        int n;
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), sDefCharset));
        char[] cArray = new char[1024];
        while ((n = bufferedReader.read(cArray, 0, 1024)) > 0 && n >= 0) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        Object var7_7 = null;
        if (bufferedReader == null) return true;
        try {
            bufferedReader.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        {
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                boolean bl = false;
                Object var7_8 = null;
                if (bufferedReader == null) return bl;
                try {
                    bufferedReader.close();
                    return bl;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static byte[] restoreBytesFromFile(File file) {
        return V2CLocalFileHandler.restoreBytesFromFile(file, (int)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static byte[] restoreBytesFromFile(File file, int n) {
        byte[] byArray;
        block12: {
            int n2;
            if (n == 0 || n > (int)file.length()) {
                return null;
            }
            InputStream inputStream = V2CLocalFileHandler.getInputStream(file);
            if (inputStream == null) {
                return null;
            }
            byArray = new byte[n];
            int n3 = 0;
            while ((n2 = inputStream.read(byArray, n3, n - n3)) >= 0 && n3 + n2 < n) {
                n3 += n2;
            }
            Object var8_7 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    byte[] byArray2 = null;
                    Object var8_8 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return byArray2;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readLogFile() {
        block13: {
            var1 = new String[1000];
            var2_1 = null;
            var3_2 = 0;
            try {
                try {
                    var2_1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(V2CLocalFileHandler.fV2CLogFile), "UTF-8"));
                    while ((var4_3 = var2_1.readLine()) != null) {
                        var1[var3_2++ % 1000] = var4_3;
                    }
                    var7_5 = null;
                    if (var2_1 == null) break block13;
                }
                catch (IOException var4_4) {
                    var5_11 = null;
                    var7_6 = null;
                    if (var2_1 == null) return var5_11;
                    try {
                        var2_1.close();
                        return var5_11;
                    }
                    catch (IOException var8_9) {
                        // empty catch block
                    }
                    return var5_11;
                }
            }
            catch (Throwable var6_13) {
                var7_7 = null;
                if (var2_1 == null) throw var6_13;
                ** try [egrp 2[TRYBLOCK] [4 : 95->102)] { 
lbl29:
                // 1 sources

                var2_1.close();
                throw var6_13;
lbl31:
                // 1 sources

                catch (IOException var8_10) {
                    // empty catch block
                }
                throw var6_13;
            }
            try {}
            catch (IOException var8_8) {}
            var2_1.close();
        }
        if (var3_2 == 0) {
            return "";
        }
        var4_3 = new StringBuffer();
        if (var3_2 > 1000) {
            var4_3.append("\u2026 ");
            var4_3.append(var3_2 - 1000);
            var4_3.append(" \u884c\u304c\u7701\u7565\u3055\u308c\u307e\u3057\u305f \u2026\n\n");
            for (var5_12 = var3_2 %= 1000; var5_12 < 1000; ++var5_12) {
                var4_3.append(var1[var5_12]);
                var4_3.append('\n');
            }
        }
        var5_12 = 0;
        while (var5_12 < var3_2) {
            var4_3.append(var1[var5_12]);
            var4_3.append('\n');
            ++var5_12;
        }
        return var4_3.toString();
    }

    static BufferedReader getUserSaveFileReader(String string) {
        return V2CLocalFileHandler.getSaveFileReader(V2CLocalFileHandler.getUserConfigFile(string), sConfigCharSet);
    }

    static BufferedReader getUserSaveFileReader(String string, String string2) {
        return V2CLocalFileHandler.getSaveFileReader(V2CLocalFileHandler.getUserConfigFile(string), string2);
    }

    static BufferedReader getSaveFileReader(File file) {
        return V2CLocalFileHandler.getSaveFileReader(file, sConfigCharSet);
    }

    static BufferedReader getSaveFileReader(File file, String string) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            File file2 = V2CLocalFileHandler.getTmpSaveFile(file);
            if (file2 == null || !file2.exists()) {
                return null;
            }
            file2.renameTo(file);
            if (!file.exists()) {
                return null;
            }
        }
        return V2CLocalFileHandler.getBufferedReader(file, string);
    }

    static File getTmpSaveFile(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getName();
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n <= 4 || !string.endsWith(".txt")) {
            return null;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return null;
        }
        return new File(file2, string.substring(0, n - 4) + "_new" + string.substring(n - 4));
    }

    static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void closeRandomAccessFile(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static RandomAccessFile getRandomAccessFile(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        return randomAccessFile;
    }

    static DataInputStream getDataInputStream(File file) {
        BufferedInputStream bufferedInputStream = V2CLocalFileHandler.getBufferedInputStream(file);
        return bufferedInputStream != null ? new DataInputStream(bufferedInputStream) : null;
    }

    static BufferedInputStream getBufferedInputStream(File file) {
        InputStream inputStream = V2CLocalFileHandler.getInputStream(file);
        if (inputStream == null) {
            return null;
        }
        return new BufferedInputStream(inputStream);
    }

    static InputStream getInputStream(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return fileInputStream;
    }

    static DataOutputStream getDataOutputStream(File file) {
        BufferedOutputStream bufferedOutputStream = V2CLocalFileHandler.getBufferedOutputStream(file, false);
        return bufferedOutputStream != null ? new DataOutputStream(bufferedOutputStream) : null;
    }

    static BufferedOutputStream getBufferedOutputStream(File file) {
        return V2CLocalFileHandler.getBufferedOutputStream(file, false);
    }

    static BufferedOutputStream getBufferedOutputStream(File file, boolean bl) {
        OutputStream outputStream = V2CLocalFileHandler.getOutputStream(file, bl);
        return outputStream != null ? new BufferedOutputStream(outputStream) : null;
    }

    static OutputStream getOutputStream(File file) {
        return V2CLocalFileHandler.getOutputStream(file, false);
    }

    static OutputStream getOutputStream(File file, boolean bl) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        return fileOutputStream;
    }

    static BufferedReader getBufferedReader(File file) {
        return V2CLocalFileHandler.getBufferedReader(file, sDefCharset);
    }

    static BufferedReader getBufferedReader(File file, String string) {
        InputStreamReader inputStreamReader = V2CLocalFileHandler.getInputStreamReader(file, string);
        if (inputStreamReader == null) {
            return null;
        }
        return new BufferedReader(inputStreamReader);
    }

    static InputStreamReader getInputStreamReader(File file) {
        return V2CLocalFileHandler.getInputStreamReader(file, sDefCharset);
    }

    static InputStreamReader getInputStreamReader(File file, String string) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return inputStreamReader;
    }

    static BufferedWriter getBufferedWriter(File file) {
        return V2CLocalFileHandler.getBufferedWriter(file, false, sDefCharset);
    }

    static BufferedWriter getBufferedWriter(File file, boolean bl) {
        return V2CLocalFileHandler.getBufferedWriter(file, bl, sDefCharset);
    }

    static BufferedWriter getBufferedWriter(File file, String string) {
        return V2CLocalFileHandler.getBufferedWriter(file, false, string);
    }

    static BufferedWriter getBufferedWriter(File file, boolean bl, String string) {
        OutputStreamWriter outputStreamWriter = V2CLocalFileHandler.getOutputStreamWriter(file, bl, string);
        if (outputStreamWriter == null) {
            return null;
        }
        return new BufferedWriter(outputStreamWriter);
    }

    static OutputStreamWriter getOutputStreamWriter(File file, boolean bl) {
        return V2CLocalFileHandler.getOutputStreamWriter(file, bl, sDefCharset);
    }

    static OutputStreamWriter getOutputStreamWriter(File file, boolean bl, String string) {
        File file2 = file.getParentFile();
        if (file2 == null || !file2.exists() && !file2.mkdirs()) {
            return null;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        return outputStreamWriter;
    }

    static boolean saveUserConfig(String string, String string2) {
        return V2CLocalFileHandler.saveToFile(new File(v2cDir, string), string2, sConfigCharSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean contentsEquals(File var0, byte[] var1_1) {
        if (var0 == null) return false;
        if (var1_1 == null) {
            return false;
        }
        if (var0.isFile() == false) return false;
        if (var0.length() != (long)var1_1.length) {
            return false;
        }
        var2_2 = V2CLocalFileHandler.getBufferedInputStream(var0);
        if (var2_2 == null) {
            return false;
        }
        var3_3 = new byte[1024];
        var5_4 = 0;
        try {
            try {}
            catch (IOException var6_7) {
                System.out.println("error in contentsEquals !");
                var6_7.printStackTrace();
                var7_9 = false;
                var9_12 = null;
                try {
                    var2_2.close();
                    return var7_9;
                }
                catch (IOException var10_16) {
                    // empty catch block
                }
                return var7_9;
            }
        }
        catch (Throwable var8_18) {
            var9_13 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 156->163)] { 
lbl31:
            // 1 sources

            var2_2.close();
            throw var8_18;
lbl33:
            // 1 sources

            catch (IOException var10_17) {
                // empty catch block
            }
            throw var8_18;
        }
        while ((var4_5 = var2_2.read(var3_3)) >= 0) {
            if (var4_5 <= 0) continue;
            for (var6_6 = 0; var6_6 < var4_5; ++var6_6) {
                if (var3_3[var6_6] == var1_1[var5_4 + var6_6]) continue;
                var7_8 = false;
                var9_10 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 156->163)] { 
lbl45:
                // 1 sources

                var2_2.close();
                return var7_8;
lbl47:
                // 1 sources

                catch (IOException var10_14) {
                    // empty catch block
                }
                return var7_8;
            }
            var5_4 += var4_5;
        }
        var9_11 = null;
        try {}
        catch (IOException var10_15) {}
        var2_2.close();
        if (var5_4 == var1_1.length) return true;
        return false;
    }

    static boolean saveToFile(File file, String string) {
        return V2CLocalFileHandler.saveToFile(file, string, false, sDefCharset);
    }

    static boolean saveToFile(File file, String string, String string2) {
        return V2CLocalFileHandler.saveToFile(file, string, false, string2);
    }

    static boolean appendToFile(File file, String string, String string2) {
        return V2CLocalFileHandler.saveToFile(file, string, true, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean saveToFile(File file, String string, boolean bl, String string2) {
        OutputStreamWriter outputStreamWriter;
        if ("EUC-JP".equals(string2)) {
            string = V2CJPConverter.convertCP51232ToISO88591(string);
            string2 = "ISO-8859-1";
        }
        if ((outputStreamWriter = V2CLocalFileHandler.getOutputStreamWriter(file, bl, string2)) == null) {
            System.out.println("error in getOutputStreamWriter: " + file);
            return false;
        }
        try {
            try {
                outputStreamWriter.write(string, 0, string.length());
            }
            catch (IOException iOException) {
                System.out.println("error in saveToFile: write to " + file);
                boolean bl2 = false;
                Object var8_6 = null;
                V2CLocalFileHandler.closeWriter(outputStreamWriter);
                return bl2;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            V2CLocalFileHandler.closeWriter(outputStreamWriter);
            throw throwable;
        }
        V2CLocalFileHandler.closeWriter(outputStreamWriter);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean saveToFile(File file, byte[] byArray) {
        OutputStream outputStream = V2CLocalFileHandler.getOutputStream(file);
        if (outputStream == null) {
            System.out.println("error in getOutputStream: " + file);
            return false;
        }
        try {
            try {
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                System.out.println("error in saveToFile: write to " + file);
                boolean bl = false;
                Object var6_4 = null;
                V2CLocalFileHandler.closeOutputStream(outputStream);
                return bl;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            V2CLocalFileHandler.closeOutputStream(outputStream);
            throw throwable;
        }
        V2CLocalFileHandler.closeOutputStream(outputStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean copyFromJarFile(String string, File file) {
        block20: {
            int n;
            BufferedInputStream bufferedInputStream = V2CLocalFileHandler.getJarFileInputStream(string);
            if (bufferedInputStream == null) {
                return false;
            }
            BufferedOutputStream bufferedOutputStream = null;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                if (n <= 0) continue;
                bufferedOutputStream.write(byArray, 0, n);
            }
            Object var7_8 = null;
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            break block20;
            {
                catch (IOException iOException) {
                    boolean bl = false;
                    Object var7_9 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (bufferedOutputStream != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void checkDefaultFile(String string) {
        BufferedWriter bufferedWriter;
        BufferedReader bufferedReader;
        block12: {
            block11: {
                block10: {
                    File file = new File(v2cDir, string);
                    if (file.exists()) {
                        return;
                    }
                    File file2 = V2CLocalFileHandler.getTmpSaveFile(file);
                    if (file2 != null && file2.exists()) {
                        return;
                    }
                    bufferedReader = null;
                    bufferedWriter = null;
                    try {
                        try {
                            String string2;
                            bufferedReader = V2CLocalFileHandler.getJarFileReader("org/monazilla/v2c/deffile/" + string, sConfigCharSet);
                            if (bufferedReader == null) {
                                Object var7_5 = null;
                                break block10;
                            }
                            bufferedWriter = V2CLocalFileHandler.getBufferedWriter(file, false, sConfigCharSet);
                            if (bufferedWriter == null) {
                                break block11;
                            }
                            while ((string2 = bufferedReader.readLine()) != null) {
                                bufferedWriter.write(string2);
                                bufferedWriter.newLine();
                            }
                            break block12;
                        }
                        catch (IOException iOException) {
                            Object var7_8 = null;
                            V2CLocalFileHandler.closeReader(bufferedReader);
                            V2CLocalFileHandler.closeWriter(bufferedWriter);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        V2CLocalFileHandler.closeReader(bufferedReader);
                        V2CLocalFileHandler.closeWriter(bufferedWriter);
                        throw throwable;
                    }
                }
                V2CLocalFileHandler.closeReader(bufferedReader);
                V2CLocalFileHandler.closeWriter(bufferedWriter);
                return;
            }
            Object var7_6 = null;
            V2CLocalFileHandler.closeReader(bufferedReader);
            V2CLocalFileHandler.closeWriter(bufferedWriter);
            return;
        }
        Object var7_7 = null;
        V2CLocalFileHandler.closeReader(bufferedReader);
        V2CLocalFileHandler.closeWriter(bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean calcDigest(File var0, V2CMD5Value var1_1) {
        block9: {
            var2_2 = null;
            try {
                try {
                    var2_2 = new FileInputStream(var0);
                    var3_3 = new byte[1024];
                    while ((var4_5 = var2_2.read(var3_3)) >= 0) {
                        if (var4_5 == 0) continue;
                        var1_1.update(var3_3, 0, var4_5);
                    }
                    var6_7 = null;
                    if (var2_2 == null) break block9;
                }
                catch (IOException var3_4) {
                    System.out.println(var3_4.getMessage());
                    var4_6 = false;
                    var6_8 = null;
                    if (var2_2 == null) return var4_6;
                    try {
                        var2_2.close();
                        return var4_6;
                    }
                    catch (IOException var7_11) {
                        // empty catch block
                    }
                    return var4_6;
                }
            }
            catch (Throwable var5_13) {
                var6_9 = null;
                if (var2_2 == null) throw var5_13;
                ** try [egrp 2[TRYBLOCK] [4 : 87->94)] { 
lbl30:
                // 1 sources

                var2_2.close();
                throw var5_13;
lbl32:
                // 1 sources

                catch (IOException var7_12) {
                    // empty catch block
                }
                throw var5_13;
            }
            try {}
            catch (IOException var7_10) {}
            var2_2.close();
        }
        var1_1.digest();
        return true;
    }

    static boolean skipInputStream(InputStream inputStream, int n) throws IOException {
        int n2;
        if (n <= 0) {
            return true;
        }
        while ((n2 = (int)inputStream.skip(n)) > 0 && (n -= n2) > 0) {
        }
        return n == 0;
    }

    static boolean copyFile(File file, File file2, boolean bl) {
        return V2CLocalFileHandler.copyFile(file, file2, 0, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean copyFile(File file, File file2, int n, V2CSHA1Value v2CSHA1Value, boolean bl) {
        OutputStream outputStream;
        FileInputStream fileInputStream;
        block10: {
            block9: {
                if (file == null || file2 == null || !file.exists() || file.equals(file2) || !bl && file2.exists()) {
                    return false;
                }
                fileInputStream = null;
                outputStream = null;
                fileInputStream = new FileInputStream(file);
                if (V2CLocalFileHandler.skipInputStream(fileInputStream, n)) break block9;
                boolean bl2 = false;
                Object var10_12 = null;
                V2CLocalFileHandler.closeOutputStream(outputStream);
                V2CLocalFileHandler.closeInputStream(fileInputStream);
                return bl2;
            }
            outputStream = V2CLocalFileHandler.getOutputStream(file2);
            if (outputStream != null) break block10;
            boolean bl3 = false;
            Object var10_13 = null;
            V2CLocalFileHandler.closeOutputStream(outputStream);
            V2CLocalFileHandler.closeInputStream(fileInputStream);
            return bl3;
        }
        try {
            try {
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = fileInputStream.read(byArray)) >= 0) {
                    if (n2 == 0) continue;
                    outputStream.write(byArray, 0, n2);
                    if (v2CSHA1Value == null) continue;
                    v2CSHA1Value.update(byArray, 0, n2);
                }
                Object var10_14 = null;
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                boolean bl4 = false;
                Object var10_15 = null;
                V2CLocalFileHandler.closeOutputStream(outputStream);
                V2CLocalFileHandler.closeInputStream(fileInputStream);
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            V2CLocalFileHandler.closeOutputStream(outputStream);
            V2CLocalFileHandler.closeInputStream(fileInputStream);
            throw throwable;
        }
        V2CLocalFileHandler.closeOutputStream(outputStream);
        V2CLocalFileHandler.closeInputStream(fileInputStream);
        long l = file.lastModified();
        if (l > 0L) {
            file2.setLastModified(l);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static V2CSHA1Value calcSHA1Value(File var0) {
        block11: {
            if (var0 == null) return null;
            if (!var0.isFile()) {
                return null;
            }
            var1_1 = V2CSHA1Value.createInstance();
            if (var1_1 == null) {
                return null;
            }
            var2_2 = null;
            try {
                try {
                    var2_2 = new FileInputStream(var0);
                    var3_3 = new byte[1024];
                    while ((var4_5 = var2_2.read(var3_3)) >= 0) {
                        if (var4_5 <= 0) continue;
                        var1_1.update(var3_3, 0, var4_5);
                    }
                    var6_7 = null;
                    if (var2_2 == null) break block11;
                }
                catch (IOException var3_4) {
                    var4_6 = null;
                    var6_8 = null;
                    if (var2_2 == null) return var4_6;
                    try {
                        var2_2.close();
                        return var4_6;
                    }
                    catch (IOException var7_11) {
                        // empty catch block
                    }
                    return var4_6;
                }
            }
            catch (Throwable var5_13) {
                var6_9 = null;
                if (var2_2 == null) throw var5_13;
                ** try [egrp 2[TRYBLOCK] [4 : 97->104)] { 
lbl35:
                // 1 sources

                var2_2.close();
                throw var5_13;
lbl37:
                // 1 sources

                catch (IOException var7_12) {
                    // empty catch block
                }
                throw var5_13;
            }
            try {}
            catch (IOException var7_10) {}
            var2_2.close();
        }
        var1_1.digest();
        return var1_1;
    }

    static boolean appendFile(File file, File file2) {
        return V2CLocalFileHandler.appendFile(file, file2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean appendFile(File file, File file2, int n) {
        OutputStream outputStream;
        FileInputStream fileInputStream;
        block10: {
            block9: {
                if (file == null || file2 == null || file.equals(file2)) {
                    return false;
                }
                if (!file.exists()) {
                    return true;
                }
                fileInputStream = null;
                outputStream = null;
                fileInputStream = new FileInputStream(file);
                if (V2CLocalFileHandler.skipInputStream(fileInputStream, n)) break block9;
                boolean bl = false;
                Object var8_9 = null;
                V2CLocalFileHandler.closeOutputStream(outputStream);
                V2CLocalFileHandler.closeInputStream(fileInputStream);
                return bl;
            }
            outputStream = V2CLocalFileHandler.getOutputStream(file2, true);
            if (outputStream != null) break block10;
            boolean bl = false;
            Object var8_10 = null;
            V2CLocalFileHandler.closeOutputStream(outputStream);
            V2CLocalFileHandler.closeInputStream(fileInputStream);
            return bl;
        }
        try {
            try {
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = fileInputStream.read(byArray)) >= 0) {
                    if (n2 == 0) continue;
                    outputStream.write(byArray, 0, n2);
                }
                Object var8_11 = null;
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                boolean bl = false;
                Object var8_12 = null;
                V2CLocalFileHandler.closeOutputStream(outputStream);
                V2CLocalFileHandler.closeInputStream(fileInputStream);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            V2CLocalFileHandler.closeOutputStream(outputStream);
            V2CLocalFileHandler.closeInputStream(fileInputStream);
            throw throwable;
        }
        V2CLocalFileHandler.closeOutputStream(outputStream);
        V2CLocalFileHandler.closeInputStream(fileInputStream);
        return true;
    }

    static void checkV2CFolderConsistency() {
        if (!V2CSwingUtil.showOKCancelDialog("V2C\u306e\u4fdd\u5b58\u7528\u30d5\u30a9\u30eb\u30c0\n\n" + V2CLocalFileHandler.getV2CDir() + "\n\n\u3092\u30c1\u30a7\u30c3\u30af\u3057\u307e\u3059\u3002", "V2C\u4fdd\u5b58\u7528\u30d5\u30a9\u30eb\u30c0\u306e\u30c1\u30a7\u30c3\u30af", -1)) {
            return;
        }
        V2CLocalFileHandler.checkLogFolder(fLogDir, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void checkLogFolder(File file, int n, String string, ArrayList arrayList) {
        block9: {
            Object object;
            if (++n > 0) {
                object = file.getName();
                arrayList.add((String)object);
                string = string + (String)object + '/';
                System.out.println(n + ": " + string);
            } else {
                string = "http://";
                arrayList = new ArrayList();
            }
            try {
                boolean bl;
                if (n >= 2) {
                    object = V2CBoardItem.getBoardItem(string);
                    bl = object != null;
                } else {
                    object = null;
                    bl = false;
                }
                if (bl) {
                    System.out.println(arrayList.size());
                    System.out.println(((V2CBoardItem)object).getName());
                    break block9;
                }
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    Object var10_7 = null;
                    if (n <= 0) return;
                    arrayList.remove(n - 1);
                    return;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.isDirectory()) continue;
                    V2CLocalFileHandler.checkLogFolder(file2, n, string, arrayList);
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (n <= 0) throw throwable;
                arrayList.remove(n - 1);
                throw throwable;
            }
        }
        Object var10_8 = null;
        if (n <= 0) return;
        arrayList.remove(n - 1);
    }

    static File getV2CDir() {
        return v2cDir;
    }

    static String getV2CDirPath() {
        return v2cDir.getAbsolutePath() + sFileSeparator;
    }

    static boolean isDefaultV2CDirUsed() {
        return v2cDir.equals(V2CLocalFileHandler.getDefaultV2CDir());
    }

    static String getRelativeDefaultDir() {
        if (V2CApp.isWinType()) {
            return "V2C";
        }
        if (V2CApp.isMacintosh()) {
            return "Library/Application Support/V2C";
        }
        return ".v2c";
    }

    static File getDefaultV2CDir() {
        if (v2cDefDir == null) {
            String string = V2CLocalFileHandler.getRelativeDefaultDir();
            if (!V2CLauncher.startedByLauncher() && V2CReleaseInfo.getReleaseName().charAt(0) == 'H') {
                string = string + 'h';
            }
            v2cDefDir = new File(new File(System.getProperty("user.home")), string);
        }
        return v2cDefDir;
    }

    public static File checkV2CDir(String string) {
        v2cDir = V2CLocalFileHandler.getDefaultV2CDir();
        File file = null;
        if (string == null) {
            if (v2cDir.isFile()) {
                if (v2cDir.length() < 1024L) {
                    String string2 = V2CLocalFileHandler.restoreFromFile(v2cDir);
                    if (string2 != null && string2.length() > 0) {
                        for (int i = 0; i < string2.length(); ++i) {
                            if (string2.charAt(i) != '\n' && string2.charAt(i) != '\r') continue;
                            string2 = string2.substring(0, i);
                            break;
                        }
                        if (string2.length() > 0) {
                            file = new File(string2);
                        } else {
                            V2CApp.errorExit("file path length is 0 !!");
                        }
                    } else {
                        V2CApp.errorExit(v2cDir + " has no contents !!");
                    }
                } else {
                    V2CApp.errorExit("length of " + v2cDir + " is " + v2cDir.length() + " >= 1024 !!");
                }
            }
        } else {
            file = new File(string);
        }
        if (file != null) {
            if (!file.isAbsolute()) {
                V2CApp.errorExit(file + " is not absolute !!");
            }
            v2cDir = file;
        }
        sAbsV2CPath = v2cDir.getAbsolutePath();
        return v2cDir;
    }

    static void checkV2CDir() {
        if (v2cDir.exists()) {
            if (!v2cDir.isDirectory()) {
                System.out.println(v2cDir + " is not a directory !");
                V2CApp.errorExit(v2cDir + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        } else if (!v2cDir.mkdirs()) {
            V2CApp.errorExit(V2CJStr.getCantCreateDirectoryMessage(v2cDir));
        }
    }

    static void check2chLogFolder() {
        File[] fileArray = fLogDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = fileArray.length - 1; i >= 0; --i) {
            String string;
            File file = fileArray[i];
            if (!file.isDirectory()) continue;
            String string2 = file.getName();
            if (string2.endsWith(".2ch.net")) {
                string = "2ch_";
            } else {
                if (!string2.endsWith(".bbspink.com")) continue;
                string = "bbspink_";
            }
            File[] fileArray2 = file.listFiles();
            if (fileArray2 == null || fileArray2.length == 0) {
                file.delete();
                continue;
            }
            boolean bl = true;
            for (int j = fileArray2.length - 1; j >= 0; --j) {
                File file2 = fileArray2[j];
                if (!file2.isDirectory()) {
                    bl = false;
                    continue;
                }
                String string3 = file2.getName();
                if (!string3.matches("\\w+")) {
                    bl = false;
                    continue;
                }
                File file3 = new File(new File(fLogDir, string), string3);
                if (file3.exists()) {
                    bl = false;
                    continue;
                }
                file2.renameTo(file3);
            }
            if (!bl) continue;
            file.delete();
        }
    }

    static File getLocalFileRoot() {
        return fLogDir;
    }

    static File getLocalFileFromURL(String string, String string2) {
        return V2CLocalFileHandler.getLocalFileFromURL(string, string2, fLogDir);
    }

    static File getLocalFileFromURL(String string, String string2, File file) {
        int n;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            V2CMiscUtil.printMalformedURLException(malformedURLException);
            return null;
        }
        if (string2 == null) {
            string2 = uRL.getHost();
            n = uRL.getPort();
            if (n > 0) {
                string2 = string2 + "_" + n;
            }
        }
        if (string2 == null) {
            return null;
        }
        n = string2.length();
        if (n >= 2 && string2.charAt(0) == '[' && string2.charAt(n - 1) == ']') {
            string2 = V2CMiscUtil.replaceChar(string2, ':', ' ');
        }
        String string3 = null;
        if (bNeedsFSReplace) {
            char c = sFileSeparator.charAt(0);
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n2 = stringBuffer.length();
            stringBuffer.append(uRL.getPath());
            int n3 = stringBuffer.length();
            for (int i = n2; i < n3; ++i) {
                if (stringBuffer.charAt(i) != '/') continue;
                stringBuffer.setCharAt(i, c);
            }
            string3 = stringBuffer.toString();
        } else {
            string3 = string2 + uRL.getPath();
        }
        return new File(file, string3);
    }

    static boolean checkETag(File file, String string) {
        if (file == null || string == null) {
            return true;
        }
        Pattern pattern = Pattern.compile("\"([a-f\\d]+)-([a-f\\d]+)-([a-f\\d]+)\"");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return true;
        }
        int n = -1;
        try {
            n = Integer.parseInt(matcher.group(2), 16);
        }
        catch (Exception exception) {
            return true;
        }
        return n < 0 || (long)n == file.length();
    }

    static String checkFileName(String string, String string2) {
        String string3 = V2CLocalFileHandler.checkFileName(string);
        return string3 != null && string3.length() > 0 ? string3 : string2;
    }

    static String checkFileName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (V2CApp.isWinType()) {
            int n;
            int n2 = string.length();
            String[] stringArray = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"};
            for (n = 0; n < stringArray.length; ++n) {
                string = V2CMiscUtil.replaceAll(string, stringArray[n], "_");
            }
            if (string.charAt(0) == '.') {
                string = '_' + string.substring(1);
            }
            if (string.charAt(n2 - 1) == '.') {
                string = string.substring(0, n2 - 1) + '_';
            }
            n = 0;
            for (int i = 1; i < n2; ++i) {
                int n3;
                int n4 = n3 = string.charAt(i) == '.' ? 1 : 0;
                if (n3 != 0 && n != 0) {
                    string = string.substring(0, i) + '_' + string.substring(i + 1);
                    n3 = 0;
                }
                n = n3;
            }
        } else {
            string = V2CMiscUtil.replaceAll(string, "/", "_");
        }
        return string;
    }

    static boolean createHardLink(File file, File file2) {
        String string;
        if (file == null || !file.isFile() || file2 == null || file2.exists()) {
            return false;
        }
        if (V2CApp.isWinType()) {
            String string2 = file.getAbsolutePath();
            String string3 = file2.getAbsolutePath();
            if (string2.charAt(0) != string3.charAt(0)) {
                return false;
            }
            string = V2CApp.isWindows(6) ? "cmd /e:off /c mklink /h \"" : "fsutil hardlink create \"";
            string = string + string3 + "\" \"" + string2 + '\"';
        } else {
            String string4 = V2CMiscUtil.escapeUNIXArgument(file.getAbsolutePath());
            String string5 = V2CMiscUtil.escapeUNIXArgument(file2.getAbsolutePath());
            string = "ln " + string4 + ' ' + string5;
        }
        V2CMiscUtil.execCommandString(string, null, true);
        return file2.isFile() && file2.length() == file.length() && file2.lastModified() == file.lastModified();
    }

    static boolean checkFile(String string) {
        File file = new File(v2cDir, string);
        return file.exists();
    }

    static void checkFile(String string, boolean bl) {
        File file = new File(v2cDir, string);
        if (bl) {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    static String getFileExtension(File file) {
        int n;
        String string = file.getName();
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    static {
        String string;
        dfFNum = new DecimalFormat("00000");
        dfFNum2 = new DecimalFormat("000000");
        sFileSeparator = string = System.getProperty("file.separator");
        if (string == null || string.length() != 1) {
            System.out.println("Sorry, currently not supporting multi character file separator.");
            V2CApp.immediateExit(1);
        }
        bNeedsFSReplace = sFileSeparator.charAt(0) != '/';
        bUsePNGResource = V2CApp.isJavaWebStart() && (V2CApp.javaVersionEqualOrGreaterThan(1, 6) || V2CApp.isMacintosh() && System.getProperty("os.version").startsWith("10.5")) || V2CApp.isMacintosh() && System.getProperty("os.version").startsWith("10.2");
    }
}

