/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CResNoteSP;
import org.monazilla.v2c.V2CResNoteStyle;
import org.monazilla.v2c.V2CTextSegment;

public class V2CResNoteItem {
    boolean bValid;
    int iRes;
    int iNoteStyle;
    String sKeyword;
    long ltCreationTime;
    long ltModificationTime;
    char[] clNote;
    V2CTextSegment[] tslNoteSegments;

    public V2CResNoteItem(int n, long l, V2CResNoteSP v2CResNoteSP) {
        this.iRes = n;
        this.setHighlight(v2CResNoteSP, l);
        this.bValid = this.clNote != null;
    }

    public V2CResNoteItem(V2CPackedPropValue v2CPackedPropValue) {
        this.iRes = v2CPackedPropValue.getInt('R');
        if (this.iRes < 0) {
            return;
        }
        String string = v2CPackedPropValue.getMultiLineString('W');
        if (string == null || string.length() == 0) {
            return;
        }
        int n = v2CPackedPropValue.getIntGE('I', 0);
        this.iNoteStyle = n < 10 ? n : 0;
        this.sKeyword = v2CPackedPropValue.getString('K');
        long[] lArray = v2CPackedPropValue.getLongArrayUpTo('T', 2);
        if (lArray != null && lArray.length > 0) {
            this.ltCreationTime = lArray[0] * 1000L;
            this.ltModificationTime = lArray.length >= 2 ? lArray[1] * 1000L : this.ltCreationTime;
        }
        this.parseNote(string);
        this.bValid = true;
    }

    void invalidate() {
        this.bValid = false;
    }

    boolean isValid() {
        return this.bValid;
    }

    void parseNote(String string) {
        char[] cArray;
        int n = string.length();
        if (string.charAt(n - 1) == '\n') {
            cArray = new char[n];
            string.getChars(0, n, cArray, 0);
        } else {
            cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            cArray[n] = 10;
            ++n;
        }
        this.clNote = cArray;
        ArrayList<V2CTextSegment> arrayList = new ArrayList<V2CTextSegment>();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != '\n') continue;
            V2CTextSegment v2CTextSegment = new V2CTextSegment(cArray, n2, i, 1);
            v2CTextSegment.setNewLineNext(true);
            arrayList.add(v2CTextSegment);
            n2 = i + 1;
        }
        if (n2 < n) {
            arrayList.add(new V2CTextSegment(cArray, n2, n, 1));
        }
        this.tslNoteSegments = arrayList.toArray(new V2CTextSegment[arrayList.size()]);
    }

    void setHighlight(V2CResNoteSP v2CResNoteSP, long l) {
        if (this.ltCreationTime <= 0L) {
            this.ltCreationTime = l;
        }
        this.iNoteStyle = v2CResNoteSP.getNoteStyle();
        this.sKeyword = v2CResNoteSP.getKeyword();
        char[] cArray = this.clNote;
        this.parseNote(v2CResNoteSP.getNote());
        char[] cArray2 = this.clNote;
        boolean bl = false;
        if (cArray == null || cArray2.length != cArray.length) {
            bl = true;
        } else {
            for (int i = cArray2.length - 1; i >= 0; --i) {
                if (cArray2[i] == cArray[i]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.ltModificationTime = l;
        } else if (this.ltModificationTime < this.ltCreationTime) {
            this.ltModificationTime = l;
        }
    }

    V2CPackedPropValue getSaveValue() {
        if (!this.bValid) {
            return null;
        }
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue('W');
        v2CPackedPropValue.setInt('R', this.iRes);
        v2CPackedPropValue.setInt('I', this.iNoteStyle);
        if (this.sKeyword != null && this.sKeyword.length() > 0) {
            v2CPackedPropValue.setString('K', this.sKeyword);
        }
        if (this.ltCreationTime > 0L) {
            if (this.ltModificationTime > this.ltCreationTime) {
                long[] lArray = new long[]{this.ltCreationTime / 1000L, this.ltModificationTime / 1000L};
                v2CPackedPropValue.setLongArray('T', lArray);
            } else {
                v2CPackedPropValue.setLong('T', this.ltCreationTime / 1000L);
            }
        }
        v2CPackedPropValue.setMultiLineString('W', this.getNote());
        return v2CPackedPropValue;
    }

    void copyFrom(V2CResNoteItem v2CResNoteItem) {
        if (v2CResNoteItem == null) {
            return;
        }
        this.bValid = v2CResNoteItem.bValid;
        this.iRes = v2CResNoteItem.iRes;
        this.iNoteStyle = v2CResNoteItem.iNoteStyle;
        this.sKeyword = v2CResNoteItem.sKeyword;
        this.ltCreationTime = v2CResNoteItem.ltCreationTime;
        this.ltModificationTime = v2CResNoteItem.ltModificationTime;
        this.clNote = v2CResNoteItem.clNote;
        this.tslNoteSegments = v2CResNoteItem.tslNoteSegments;
    }

    int getResIndex() {
        return this.iRes;
    }

    void setResIndex(int n) {
        this.iRes = n;
    }

    String getKeyword() {
        return this.sKeyword != null ? this.sKeyword : "";
    }

    long getCreationTime() {
        return this.ltCreationTime;
    }

    long getModificationTime() {
        return this.ltModificationTime;
    }

    V2CTextSegment[] getNoteSegments() {
        return this.tslNoteSegments;
    }

    String getNote() {
        return new String(this.clNote);
    }

    int getStyleIndex() {
        return this.iNoteStyle;
    }

    V2CResNoteStyle getStyle() {
        return V2CResNoteStyle.get(this.iNoteStyle);
    }
}

