/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.GradientPaint;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSSColor;
import org.monazilla.v2c.V2CSSDistance;
import org.monazilla.v2c.V2CStyleSheet;

public class V2CSSColorGradation {
    final boolean bLeft;
    final Color[] clColor;
    final V2CSSDistance[] dlDistance;
    final int[] ilDistance;
    final GradientPaint[] gplPaint;

    static V2CSSColorGradation parse(String string) {
        Object object;
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String[] stringArray = V2CMiscUtil.split(string, ' ', true);
        if (stringArray == null || (n2 = stringArray.length) < 3) {
            return null;
        }
        String string2 = stringArray[0];
        boolean bl = string2.equals("left");
        if (bl || string2.equals("top")) {
            for (int i = 1; i < n2; ++i) {
                stringArray[i - 1] = stringArray[i];
            }
            --n2;
        }
        if (n2 % 2 == 0) {
            return null;
        }
        Color[] colorArray = new Color[(n2 /= 2) + 1];
        V2CSSDistance[] v2CSSDistanceArray = new V2CSSDistance[n2];
        for (n = 0; n <= n2; ++n) {
            object = V2CSSColor.parseColor(stringArray[2 * n]);
            if (object == null) {
                return null;
            }
            colorArray[n] = ((V2CSSColor)object).getColor();
        }
        for (n = 0; n < n2; ++n) {
            object = V2CSSDistance.parse(stringArray[2 * n + 1], 32);
            if (object == null || ((V2CSSDistance)object).getValue() < 0.0f) {
                return null;
            }
            v2CSSDistanceArray[n] = object;
        }
        return new V2CSSColorGradation(bl, colorArray, v2CSSDistanceArray);
    }

    public V2CSSColorGradation(boolean bl, Color[] colorArray, V2CSSDistance[] v2CSSDistanceArray) {
        this.bLeft = bl;
        this.clColor = colorArray;
        this.dlDistance = v2CSSDistanceArray;
        this.ilDistance = new int[v2CSSDistanceArray.length];
        this.gplPaint = new GradientPaint[v2CSSDistanceArray.length];
    }

    boolean isLeft() {
        return this.bLeft;
    }

    void calcFixedDistance(V2CStyleSheet v2CStyleSheet) {
        V2CSSDistance[] v2CSSDistanceArray = this.dlDistance;
        int[] nArray = this.ilDistance;
        int n = v2CSSDistanceArray.length;
        for (int i = 0; i < n; ++i) {
            V2CSSDistance v2CSSDistance = v2CSSDistanceArray[i];
            if (v2CSSDistance.isPercent()) continue;
            nArray[i] = (int)v2CStyleSheet.getValue(v2CSSDistance);
        }
    }

    GradientPaint[] getPaints(int n, int n2) {
        float f;
        int n3;
        float f2 = n;
        Color[] colorArray = this.clColor;
        Color color = colorArray[0];
        V2CSSDistance[] v2CSSDistanceArray = this.dlDistance;
        int[] nArray = this.ilDistance;
        GradientPaint[] gradientPaintArray = this.gplPaint;
        int n4 = 0;
        float f3 = 0.0f;
        int n5 = v2CSSDistanceArray.length;
        for (n3 = 0; n3 < n5; ++n3) {
            V2CSSDistance v2CSSDistance = v2CSSDistanceArray[n3];
            if (v2CSSDistance.isPercent()) {
                f3 += v2CSSDistance.getValue();
                continue;
            }
            n4 += nArray[n3];
        }
        if (n4 < n2 && f3 > 0.0f) {
            n3 = n2 - n4;
            f = f3 > 1.0f ? 1.0f / f3 : 1.0f;
        } else {
            n3 = 0;
            f = 0.0f;
        }
        for (int i = 0; i < n5; ++i) {
            V2CSSDistance v2CSSDistance = v2CSSDistanceArray[i];
            float f4 = v2CSSDistance.isPercent() ? f * v2CSSDistance.getValue() * (float)n3 : (float)nArray[i];
            float f5 = f2 + f4;
            Color color2 = colorArray[i + 1];
            int n6 = Math.round(f5);
            GradientPaint gradientPaint = n6 > n ? (this.bLeft ? new GradientPaint(n, 0.0f, color, n6, 0.0f, color2) : new GradientPaint(0.0f, n, color, 0.0f, n6, color2)) : null;
            gradientPaintArray[i] = gradientPaint;
            color = color2;
            f2 = f5;
            n = n6;
        }
        return gradientPaintArray;
    }
}

