/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.monazilla.v2c.V2CCountHighlight;
import org.monazilla.v2c.V2CCountHighlightItem;
import org.monazilla.v2c.V2CCountHighlightItemSP;
import org.monazilla.v2c.V2CHighlightSelectionPanel;
import org.monazilla.v2c.V2CHighlightStyle;
import org.monazilla.v2c.V2CHighlightTableCellRenderer;
import org.monazilla.v2c.V2CHighlightTableModel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTablePopupListener;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CCountHighlightSP
extends JPanel
implements ActionListener {
    private static final String[] slLabels = new String[]{"\u3057\u304d\u3044\u5024", "\u30b5\u30f3\u30d7\u30eb", "\u30cf\u30a4\u30e9\u30a4\u30c8"};
    private static final int THRESHOLD = 0;
    private static final int SAMPLE = 1;
    private static final int HIGHLIGHT = 2;
    final int iCountHighlightIndex;
    CountHighlightTableModel chTableModel;
    JTable jTable;
    String sSample;
    JButton jbAdd;
    JButton jbEdit;
    JButton jbDelete;
    int nMinimumValue;
    JCheckBox jcbShowCount;
    JCheckBox jcbHighlightInRes;
    JCheckBox jcbUnderline;

    public V2CCountHighlightSP(int n, String string, String string2, boolean bl, String string3, boolean bl2, String string4, boolean bl3, String string5) {
        super(new GridBagLayout());
        V2CSSFont v2CSSFont;
        JTable jTable;
        this.iCountHighlightIndex = n;
        this.sSample = string;
        boolean bl4 = string2 == null;
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 0;
        if (!bl4) {
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.add((Component)new JLabel(string2), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 17;
        }
        if (string3 != null) {
            gridBagConstraints.insets = new Insets(0, 20, 0, 20);
            this.jcbShowCount = V2CSwingUtil.addCheckBox(string3, bl, this, gridBagConstraints, true);
        }
        if (string5 != null) {
            this.jcbHighlightInRes = V2CSwingUtil.addCheckBox(string5, bl3, this, gridBagConstraints, true);
        }
        if (string4 != null) {
            this.jcbUnderline = V2CSwingUtil.addCheckBox(string4, bl2, this, gridBagConstraints, true);
            gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        }
        this.chTableModel = new CountHighlightTableModel(n);
        this.nMinimumValue = this.chTableModel.vCountHighlight.getMinimumThreshold();
        this.jTable = jTable = new JTable(this.chTableModel);
        if (bl4 && (v2CSSFont = V2CSSFont.getDefaultFont()) != null) {
            jTable.setFont(v2CSSFont.getAwtFont());
        }
        jTable.setSelectionMode(0);
        v2CSSFont = V2CSSFont.getDefaultFont();
        Color color = v2CSSFont != null ? v2CSSFont.getForeground() : null;
        Color color2 = V2CThreadStyle.getDefaultBackground();
        jTable.getColumnModel().getColumn(1).setCellRenderer(new V2CHighlightTableCellRenderer(jTable, color, color2, false));
        if (this.chTableModel.getRowCount() > 0) {
            jTable.setRowSelectionInterval(0, 0);
        }
        jTable.addMouseListener(new ColorCellMouseListener("EditAndDeleteEntry", this, jTable));
        JScrollPane jScrollPane = V2CSwingUtil.createScrollPaneForTable(jTable, 150, 20);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.jbAdd = this.createButton("\u65b0\u898f", gridBagConstraints);
        this.jbEdit = this.createButton("\u7de8\u96c6", gridBagConstraints);
        this.jbDelete = this.createButton("\u524a\u9664", gridBagConstraints);
    }

    private JButton createButton(String string, GridBagConstraints gridBagConstraints) {
        JButton jButton = new JButton(string);
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        this.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jButton;
    }

    boolean showDialog() {
        int n = JOptionPane.showOptionDialog(V2CMain.v2cMain, this, "\u3057\u304d\u3044\u5024\u30fb\u30cf\u30a4\u30e9\u30a4\u30c8\u306e\u8a2d\u5b9a", 2, -1, null, null, null);
        return n == 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbAdd) {
            V2CCountHighlightItemSP v2CCountHighlightItemSP = new V2CCountHighlightItemSP(this.nMinimumValue);
            int n = v2CCountHighlightItemSP.showDialog();
            if (n >= 0) {
                this.chTableModel.add(n, v2CCountHighlightItemSP.getHighlightSelectionPanel());
            }
        } else if (object == this.jbEdit) {
            this.editOrDeleteSelectedItem(true);
        } else if (object == this.jbDelete) {
            this.editOrDeleteSelectedItem(false);
        }
    }

    boolean getShowCount() {
        return this.jcbShowCount != null ? this.jcbShowCount.isSelected() : false;
    }

    boolean getUnderline() {
        return this.jcbUnderline != null ? this.jcbUnderline.isSelected() : false;
    }

    boolean getHighlightInRes() {
        return this.jcbHighlightInRes != null ? this.jcbHighlightInRes.isSelected() : false;
    }

    int getCountHighlightIndex() {
        return this.iCountHighlightIndex;
    }

    V2CCountHighlight getCountHighlight() {
        return this.chTableModel.vCountHighlight;
    }

    private void editOrDeleteSelectedItem(boolean bl) {
        int n = this.jTable.getSelectedRow();
        if (n >= 0) {
            if (bl) {
                V2CCountHighlightItemSP v2CCountHighlightItemSP = new V2CCountHighlightItemSP(this.chTableModel.getItem(n), this.nMinimumValue);
                int n2 = v2CCountHighlightItemSP.showDialog();
                if (n2 >= 0) {
                    this.chTableModel.change(n, n2, v2CCountHighlightItemSP.getHighlightSelectionPanel());
                }
            } else {
                this.chTableModel.remove(n);
            }
        }
    }

    void editSelectedEntry() {
        this.editOrDeleteSelectedItem(true);
    }

    void deleteSelectedEntry() {
        this.editOrDeleteSelectedItem(false);
    }

    private class ColorCellMouseListener
    extends V2CTablePopupListener {
        ColorCellMouseListener(String string, Component component, JTable jTable) {
            super(string, component, jTable);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 1 || !V2CSwingUtil.isSimpleClick(mouseEvent)) {
                return;
            }
            JTable jTable = this.jTable;
            Point point = mouseEvent.getPoint();
            int n = jTable.rowAtPoint(point);
            if (n < 0) {
                return;
            }
            int n2 = jTable.convertColumnIndexToModel(jTable.columnAtPoint(point));
            if (n2 != 1) {
                return;
            }
            V2CHighlightStyle v2CHighlightStyle = V2CCountHighlightSP.this.chTableModel.getHighlightStyle(n, n2);
            V2CHighlightSelectionPanel v2CHighlightSelectionPanel = new V2CHighlightSelectionPanel(v2CHighlightStyle, false);
            if (!v2CHighlightSelectionPanel.showDialog()) {
                return;
            }
            V2CCountHighlightSP.this.chTableModel.change(n, -1, v2CHighlightSelectionPanel);
        }
    }

    private class CountHighlightTableModel
    extends AbstractTableModel
    implements V2CHighlightTableModel {
        V2CCountHighlight vCountHighlight;

        CountHighlightTableModel(int n) {
            this.vCountHighlight = V2CCountHighlight.duplicate(n);
        }

        public int getRowCount() {
            return this.vCountHighlight.size();
        }

        public int getColumnCount() {
            return slLabels.length;
        }

        public String getColumnName(int n) {
            return slLabels[n];
        }

        public int getHorizontalAlignment(int n) {
            return n == 0 ? 4 : 2;
        }

        public Color getDefaultBG(int n, int n2) {
            return V2CCountHighlightSP.this.jTable.getBackground();
        }

        public V2CHighlightStyle getHighlightStyle(int n, int n2) {
            return n2 == 1 ? this.getItem(n).getStyle() : null;
        }

        void add(int n, V2CHighlightSelectionPanel v2CHighlightSelectionPanel) {
            int n2 = this.vCountHighlight.add(n, v2CHighlightSelectionPanel);
            if (n2 >= 0) {
                this.fireTableRowsInserted(n2, n2);
            }
        }

        void remove(int n) {
            if (this.vCountHighlight.remove(n)) {
                this.fireTableRowsDeleted(n, n);
            }
        }

        void change(int n, int n2, V2CHighlightSelectionPanel v2CHighlightSelectionPanel) {
            if (this.vCountHighlight.change(n, n2, v2CHighlightSelectionPanel)) {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }

        V2CCountHighlightItem getItem(int n) {
            return this.vCountHighlight.get(n);
        }

        public Object getValueAt(int n, int n2) {
            V2CCountHighlightItem v2CCountHighlightItem = this.getItem(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(v2CCountHighlightItem.getThreshold());
                }
                case 1: {
                    return V2CCountHighlightSP.this.sSample;
                }
                case 2: {
                    return v2CCountHighlightItem.toString();
                }
            }
            return null;
        }
    }
}

