/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CFixedWidthLabel;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CDownloader
extends JPanel
implements Runnable {
    private static final String sSaveDirKey = "DownloadDir";
    static final HashMap hmURLs = new HashMap();
    final String sURL;
    final File fSaveFile;
    final BufferedOutputStream bosSaveStream;
    PipedOutputStream pOutputStream;
    boolean bGZIP;
    JDialog jDialog;
    JLabel jlFileName;
    JLabel jlStopButton;
    JLabel jlStatus;
    JProgressBar jProgressBar;
    Thread thDownload;
    int nContentLength = -1;
    String sErrorMessage;
    long ltLastUpdate;
    GUnzipper gUnzipper;

    static void download(String string) {
        int n;
        URL uRL;
        if (string == null) {
            return;
        }
        File file = V2CLocalFileHandler.getObjectSaveDir(sSaveDirKey);
        JFileChooser jFileChooser = V2CSwingUtil.createFileChooser(file);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String string2 = uRL.getPath();
        if (string2 != null && string2.length() > 0 && (n = string2.lastIndexOf(47)) >= 0 && n < string2.length()) {
            string2 = string2.substring(n + 1);
            jFileChooser.setDialogTitle("\u4fdd\u5b58\uff1a " + string2);
            jFileChooser.setSelectedFile(new File(file, string2));
        }
        if ((n = jFileChooser.showSaveDialog(V2CMain.v2cMain)) != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        V2CLocalFileHandler.saveObjectSaveDir(sSaveDirKey, file2, true);
        if (file2.exists() && !V2CSwingUtil.showOKCancelDialog(V2CJStr.getFileExistsMessage(file2), "\u8b66\u544a", 2)) {
            return;
        }
        V2CDownloader.download(string, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void download(String string, File file) {
        HashMap hashMap = hmURLs;
        synchronized (hashMap) {
            if (hmURLs.containsKey(string)) {
                JDialog jDialog = (JDialog)hmURLs.get(string);
                if (jDialog != null) {
                    jDialog.toFront();
                }
            } else {
                BufferedOutputStream bufferedOutputStream = V2CLocalFileHandler.getBufferedOutputStream(file);
                if (bufferedOutputStream == null) {
                    V2CSwingUtil.showErrorMessage("\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u307f\u7528\u306b\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                    return;
                }
                V2CDownloader v2CDownloader = new V2CDownloader(string, file, bufferedOutputStream);
                v2CDownloader.showDialog();
                hmURLs.put(string, v2CDownloader.jDialog);
            }
        }
    }

    public V2CDownloader(String string, File file, BufferedOutputStream bufferedOutputStream) {
        super(new GridBagLayout());
        this.sURL = string;
        this.fSaveFile = file;
        this.bosSaveStream = bufferedOutputStream;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.jlFileName = new V2CFixedWidthLabel(file.getName(), 200);
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.jlFileName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.jProgressBar = new JProgressBar();
        this.jProgressBar.setIndeterminate(true);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.jProgressBar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.jlStopButton = new JLabel(V2CSwingUtil.getItemIcon("Stop"));
        this.jlStopButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (V2CSwingUtil.isSimpleClick(mouseEvent)) {
                    V2CDownloader.this.jDialog.dispose();
                }
            }
        });
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jlStopButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jlStatus = new V2CFixedWidthLabel(" - / - ", 200);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jlStatus, gridBagConstraints);
    }

    void showDialog() {
        this.jDialog = new JDialog(V2CMain.v2cMain, "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9 " + this.fSaveFile.getName(), false);
        this.jDialog.setDefaultCloseOperation(2);
        this.jDialog.setContentPane(this);
        this.jDialog.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                Object object = hmURLs;
                synchronized (object) {
                    hmURLs.remove(V2CDownloader.this.sURL);
                }
                object = V2CDownloader.this.thDownload;
                if (object != null && ((Thread)object).isAlive()) {
                    ((Thread)object).interrupt();
                }
            }
        });
        this.thDownload = new Thread(this);
        this.thDownload.start();
        this.jDialog.pack();
        Point point = V2CSwingUtil.getMouseLocationOnScreen(null);
        if (point != null) {
            this.jDialog.setLocation(point);
        }
        this.jDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Exception exception3;
        String string;
        block13: {
            string = null;
            try {
                string = V2CHttpUtil.downloadFile(this.sURL, 2, this);
                Object var3_2 = null;
                if (!this.bGZIP) break block13;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var3_3 = null;
                if (this.bGZIP) {
                    try {
                        this.pOutputStream.close();
                    }
                    catch (IOException exception22) {
                        // empty catch block
                    }
                    try {
                        this.gUnzipper.join();
                    }
                    catch (InterruptedException exception22) {
                        // empty catch block
                    }
                }
                try {
                    this.bosSaveStream.close();
                }
                catch (IOException exception22) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.pOutputStream.close();
            }
            catch (IOException exception3) {
                // empty catch block
            }
            try {
                this.gUnzipper.join();
            }
            catch (InterruptedException exception3) {
                // empty catch block
            }
        }
        try {
            this.bosSaveStream.close();
        }
        catch (IOException exception3) {}
        if (string != null) {
            this.sErrorMessage = string;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                V2CDownloader.this.jDialog.dispose();
                if (V2CDownloader.this.sErrorMessage != null) {
                    if (V2CDownloader.this.fSaveFile.exists() && V2CDownloader.this.fSaveFile.length() == 0L) {
                        V2CDownloader.this.fSaveFile.delete();
                    }
                    Toolkit.getDefaultToolkit().beep();
                    V2CSwingUtil.showErrorMessage(V2CDownloader.this.sErrorMessage);
                }
            }
        });
    }

    boolean setHeaderFields(HttpURLConnection httpURLConnection) {
        try {
            String string;
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                this.sErrorMessage = "Response Code: " + n + " " + httpURLConnection.getResponseMessage();
                return false;
            }
            this.nContentLength = httpURLConnection.getContentLength();
            if (this.nContentLength > 0) {
                this.jProgressBar.setStringPainted(true);
                this.jProgressBar.setIndeterminate(false);
                this.jProgressBar.setMinimum(0);
                this.jProgressBar.setMaximum(this.nContentLength);
                this.jProgressBar.setString("0%");
            }
            boolean bl = this.bGZIP = (string = httpURLConnection.getContentEncoding()) != null && string.equals("gzip");
            if (this.bGZIP) {
                this.pOutputStream = new PipedOutputStream();
                this.gUnzipper = new GUnzipper();
                this.gUnzipper.start();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.sErrorMessage = V2CMiscUtil.getMessage(iOException);
            return false;
        }
        return true;
    }

    boolean appendBytes(byte[] byArray, int n, final int n2) {
        try {
            if (this.bGZIP) {
                this.pOutputStream.write(byArray, 0, n);
            } else {
                this.bosSaveStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            this.sErrorMessage = V2CMiscUtil.getMessage(iOException);
            return false;
        }
        long l = System.currentTimeMillis();
        if (l > this.ltLastUpdate + 50L) {
            this.ltLastUpdate = l;
            final int n3 = this.nContentLength;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    V2CDownloader.this.jlStatus.setText(n2 + " / " + (n3 > 0 ? String.valueOf(n3) : "-"));
                    if (n3 > 0) {
                        V2CDownloader.this.jProgressBar.setValue(n2);
                        V2CDownloader.this.jProgressBar.setString((int)((float)n2 * 100.0f / (float)n3) + " %");
                    }
                }
            });
        }
        return true;
    }

    private class GUnzipper
    extends Thread {
        PipedInputStream pInputStream;

        GUnzipper() throws IOException {
            this.pInputStream = new PipedInputStream(V2CDownloader.this.pOutputStream);
        }

        public void run() {
            byte[] byArray = new byte[1024];
            try {
                int n;
                GZIPInputStream gZIPInputStream = new GZIPInputStream(this.pInputStream);
                while ((n = gZIPInputStream.read(byArray)) >= 0) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (n <= 0) continue;
                    V2CDownloader.this.bosSaveStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

