/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CJSE6Util;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMoviePanel;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CReleaseInfo;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CExtServer
extends Thread {
    private static final String sServerPortKey = "ServerPort";
    private static final String sInetAddressKey = "InetAddress";
    private static final String sHWAddressKey = "HWAddress";
    private static V2CExtServer vExtServer;
    private static int nServerPort;
    ServerSocket sServer;

    static int getServerPort() {
        return nServerPort;
    }

    static void setAcceptExtRequest(boolean bl) {
        if (bl) {
            V2CExtServer.startServer(true);
        } else {
            V2CLocalFileHandler.emptyShareInfFile();
        }
    }

    static synchronized boolean startServer(boolean bl) {
        boolean bl2;
        V2CExtServer v2CExtServer = vExtServer;
        boolean bl3 = bl2 = v2CExtServer == null || !v2CExtServer.isAlive();
        if (bl2) {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket();
                serverSocket.bind(null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            nServerPort = serverSocket.getLocalPort();
            vExtServer = v2CExtServer = new V2CExtServer(serverSocket);
            v2CExtServer.start();
        }
        if (bl2 || bl) {
            V2CExtServer.writeServerInfo();
        }
        return true;
    }

    static String sendRequest(String[] stringArray) throws IOException {
        Object object;
        int n = V2CExtServer.getRequestPort();
        if (n <= 0) {
            return "Request Port Unknown";
        }
        StringBuffer stringBuffer = new StringBuffer("url=");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (object == null || !((String)object).startsWith("ttp") && !((String)object).startsWith("http") && (((String)object).length() != 2 || ((String)object).charAt(0) != '-')) continue;
            bl = true;
            stringBuffer.append(URLEncoder.encode((String)object, "UTF-8"));
            stringBuffer.append("%0A");
        }
        stringBuffer.append("\r\n");
        URL uRL = new URL("http://127.0.0.1:" + n + "/V2C/R");
        object = (HttpURLConnection)uRL.openConnection();
        ((HttpURLConnection)object).setRequestMethod("POST");
        ((URLConnection)object).setDoOutput(true);
        ((URLConnection)object).setUseCaches(false);
        ((URLConnection)object).setAllowUserInteraction(false);
        ((URLConnection)object).setRequestProperty("Host", "127.0.0.1:" + n);
        ((URLConnection)object).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printWriter = new PrintWriter(((URLConnection)object).getOutputStream());
        printWriter.print(stringBuffer.toString());
        printWriter.close();
        int n2 = ((HttpURLConnection)object).getResponseCode();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream(), "UTF-8"));
        String string = bufferedReader.readLine();
        if (string != null && Pattern.compile("\\d+").matcher(string).matches()) {
            V2CApp.setActiveV2CWindowHandle(Long.parseLong(string));
        }
        bufferedReader.close();
        return null;
    }

    static int getRequestPort() {
        File file = V2CLocalFileHandler.getShareInfFile();
        if (file.length() == 0L) {
            return -1;
        }
        V2CProperty v2CProperty = new V2CProperty(file, null, null);
        v2CProperty.setReadOnly(true);
        int n = v2CProperty.getInt(sServerPortKey);
        if (n <= 0) {
            return -1;
        }
        boolean bl = V2CApp.javaVersionEqualOrGreaterThan(1, 6);
        String string = null;
        boolean bl2 = false;
        if (bl && (string = v2CProperty.get(sHWAddressKey)) != null) {
            bl2 = true;
        }
        if (!bl2) {
            string = v2CProperty.get(sInetAddressKey);
        }
        if (string == null) {
            return n;
        }
        String[] stringArray = V2CMiscUtil.split(string, ':', true);
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = V2CMiscUtil.parseInt(stringArray[i]);
        }
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object;
                NetworkInterface networkInterface = enumeration.nextElement();
                if (bl) {
                    if (V2CJSE6Util.isLoopback(networkInterface)) continue;
                    if (bl2) {
                        object = V2CJSE6Util.getHardwareAddress(networkInterface);
                        if (object == null || ((Object)object).length != n2) continue;
                        boolean bl3 = true;
                        for (int i = 0; i < n2; ++i) {
                            if ((object[i] & 0xFF) == nArray[i]) continue;
                            bl3 = false;
                            break;
                        }
                        if (!bl3) continue;
                        return n;
                    }
                }
                if ((object = networkInterface.getInetAddresses()) == null) continue;
                while (object.hasMoreElements()) {
                    byte[] byArray;
                    InetAddress inetAddress = (InetAddress)object.nextElement();
                    if (inetAddress.isLoopbackAddress() || (byArray = inetAddress.getAddress()) == null || byArray.length != n2) continue;
                    boolean bl4 = true;
                    for (int i = 0; i < n2; ++i) {
                        if ((byArray[i] & 0xFF) == nArray[i]) continue;
                        bl4 = false;
                        break;
                    }
                    if (!bl4) continue;
                    return n;
                }
            }
        }
        return -1;
    }

    static void writeServerInfo() {
        Object object;
        Object object2;
        if (!V2CApp.acceptExtRequest()) {
            return;
        }
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = V2CApp.javaVersionEqualOrGreaterThan(1, 6);
        Object object3 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (bl) {
                    if (V2CJSE6Util.isLoopback((NetworkInterface)object2)) continue;
                    if (object3 == null && (object = (Object)V2CJSE6Util.getHardwareAddress((NetworkInterface)object2)) != null) {
                        object3 = object;
                    }
                }
                if ((object = ((NetworkInterface)object2).getInetAddresses()) != null) {
                    while (object.hasMoreElements()) {
                        byte[] byArray3;
                        InetAddress inetAddress = (InetAddress)object.nextElement();
                        if (inetAddress.isLoopbackAddress() || (byArray3 = inetAddress.getAddress()) == null) continue;
                        if (byArray3.length == 4) {
                            byArray = byArray3;
                            break;
                        }
                        if (byArray2 != null || byArray3.length != 16) continue;
                        byArray2 = byArray3;
                    }
                }
                if (byArray == null) continue;
                break;
            }
        }
        object2 = new StringBuffer();
        ((StringBuffer)object2).append(sServerPortKey);
        ((StringBuffer)object2).append('=');
        ((StringBuffer)object2).append(nServerPort);
        ((StringBuffer)object2).append('\n');
        object = byArray;
        if (object == null) {
            object = byArray2;
        }
        if (object != null) {
            ((StringBuffer)object2).append(sInetAddressKey);
            ((StringBuffer)object2).append('=');
            for (int i = 0; i < ((Object)object).length; ++i) {
                ((StringBuffer)object2).append((int)(object[i] & 0xFF));
                ((StringBuffer)object2).append(':');
            }
            ((StringBuffer)object2).setCharAt(((StringBuffer)object2).length() - 1, '\n');
        }
        if (object3 != null) {
            ((StringBuffer)object2).append(sHWAddressKey);
            ((StringBuffer)object2).append('=');
            for (int i = 0; i < ((Object)object3).length; ++i) {
                ((StringBuffer)object2).append((int)(object3[i] & 0xFF));
                ((StringBuffer)object2).append(':');
            }
            ((StringBuffer)object2).setCharAt(((StringBuffer)object2).length() - 1, '\n');
        }
        V2CLocalFileHandler.addToShareInfFile(((StringBuffer)object2).toString());
    }

    public V2CExtServer(ServerSocket serverSocket) {
        this.setDaemon(true);
        this.sServer = serverSocket;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = this.sServer.accept();
                    if (V2CApp.isQuitting()) continue;
                    Thread thread = new Thread(new SendThread(socket));
                    thread.start();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    static void openExtRequestLater(String string) {
        if (string == null || !V2CApp.acceptExtRequest()) {
            return;
        }
        if (!string.startsWith("url=")) {
            return;
        }
        try {
            string = URLDecoder.decode(string.substring(4), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string != null) {
            final String[] stringArray = V2CMiscUtil.split(string, '\n', true);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (stringArray != null) {
                        boolean bl = V2CApp.assumeBoardURL();
                        boolean bl2 = true;
                        boolean bl3 = false;
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = stringArray[i];
                            if (string == null) continue;
                            if (string.startsWith("ttp")) {
                                string = 'h' + string;
                            }
                            if (string.equals("-c")) {
                                bl2 = false;
                                continue;
                            }
                            if (string.equals("-w")) {
                                bl3 = true;
                                continue;
                            }
                            if (!string.startsWith("http")) continue;
                            if (!V2CMiscUtil.openUnknownLink(string, true, bl2, false, false, false, false, true, bl) && bl3) {
                                V2CExtServer.showOpenFailDialog(string);
                            }
                            bl2 = true;
                        }
                    }
                    V2CMain.v2cMain.activateToFront(true);
                }
            });
        }
    }

    static void showOpenFailDialog(String string) {
        String[] stringArray = new String[]{"\u9589\u3058\u308b", "\u30b3\u30d4\u30fc"};
        Object[] objectArray = V2CSwingUtil.createJButtonForOptionPane(stringArray);
        String string2 = "\u5916\u90e8\u304b\u3089\u306eURL\n\n" + string + "\n\n\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        JComponent jComponent = V2CSwingUtil.wrapStringIntoComponent(string2);
        int n = JOptionPane.showOptionDialog(V2CMain.v2cMain, jComponent, "\u30a8\u30e9\u30fc", -1, -1, null, objectArray, objectArray[0]);
        if (n == 1) {
            V2CMain.copyString(string);
        }
    }

    static {
        nServerPort = -1;
    }

    private static class SendThread
    implements Runnable {
        final Socket sSocket;
        BufferedReader brRequest;
        OutputStream osResponse;
        String sReqSiteID;
        String sReqID;
        String sPostContents;
        char cCmd;
        boolean bExtRequest;

        SendThread(Socket socket) {
            this.sSocket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block28: {
                IOException iOException2222;
                block26: {
                    block25: {
                        block24: {
                            if (!this.parseRequest()) break block24;
                            if (this.bExtRequest) {
                                V2CExtServer.openExtRequestLater(this.sPostContents);
                                this.sendResult();
                                break block24;
                            }
                            V2CMoviePanel v2CMoviePanel = V2CMoviePanel.getPanel(this.sReqSiteID, this.sReqID);
                            if (v2CMoviePanel == null || !v2CMoviePanel.executeCommand(this.cCmd)) break block24;
                            this.sendResult(v2CMoviePanel);
                        }
                        Object var3_3 = null;
                        if (this.brRequest == null) break block25;
                        try {
                            this.brRequest.close();
                        }
                        catch (IOException iOException2222) {}
                        break block26;
                    }
                    try {
                        this.sSocket.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (this.osResponse != null) {
                    try {
                        this.osResponse.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block28;
                {
                    catch (IOException iOException3) {
                        IOException iOException42222;
                        iOException3.printStackTrace();
                        Object var3_4 = null;
                        if (this.brRequest != null) {
                            try {
                                this.brRequest.close();
                            }
                            catch (IOException iOException42222) {}
                        } else {
                            try {
                                this.sSocket.close();
                            }
                            catch (IOException iOException42222) {
                                // empty catch block
                            }
                        }
                        if (this.osResponse != null) {
                            try {
                                this.osResponse.close();
                            }
                            catch (IOException iOException42222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException52222;
                    Object var3_5 = null;
                    if (this.brRequest != null) {
                        try {
                            this.brRequest.close();
                        }
                        catch (IOException iOException52222) {}
                    } else {
                        try {
                            this.sSocket.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (this.osResponse != null) {
                        try {
                            this.osResponse.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }

        boolean parseRequest() throws IOException {
            Matcher matcher;
            Pattern pattern;
            boolean bl;
            BufferedReader bufferedReader;
            boolean bl2 = false;
            this.brRequest = bufferedReader = new BufferedReader(new InputStreamReader(this.sSocket.getInputStream(), "ISO-8859-1"));
            boolean bl3 = false;
            String string = bufferedReader.readLine();
            if (string == null) {
                return false;
            }
            Pattern pattern2 = Pattern.compile("POST\\s+/V2C/R\\s+");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.lookingAt()) {
                this.bExtRequest = true;
                bl = true;
                this.cCmd = (char)82;
            } else {
                pattern = Pattern.compile("(GET|POST)\\s+/(\\w{2})/([A-Za-z0-9_-]{4,15})/([GRX])\\s+");
                matcher = pattern.matcher(string);
                if (!matcher.lookingAt()) {
                    return false;
                }
                bl = matcher.group(1).equals("POST");
                this.cCmd = matcher.group(4).charAt(0);
                if (bl && this.cCmd != 'R') {
                    return false;
                }
                this.sReqSiteID = matcher.group(2);
                this.sReqID = matcher.group(3);
            }
            pattern = Pattern.compile("Host:\\s*127\\.0\\.0\\.1:\\d+\\s*", 2);
            while ((string = bufferedReader.readLine()) != null && string.length() != 0) {
                matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                bl2 = true;
            }
            if (!bl || !bl2) {
                return bl2;
            }
            this.sPostContents = bufferedReader.readLine();
            return true;
        }

        void sendResult(V2CMoviePanel v2CMoviePanel) throws IOException {
            OutputStream outputStream;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String string = null;
            boolean bl = v2CMoviePanel != null && this.cCmd == 'G' && (string = v2CMoviePanel.createHTMLContents()) != null;
            String string2 = "HTTP/1.1 200 OK\r\n";
            if (!bl) {
                if (this.cCmd == 'G') {
                    string2 = "HTTP/1.1 404 Not Found\r\n";
                    string = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1></body></html>";
                } else {
                    string = "";
                }
            }
            byte[] byArray = string.getBytes("UTF-8");
            StringBuffer stringBuffer = new StringBuffer(string.length() + 1000);
            stringBuffer.append(string2);
            stringBuffer.append("Date: ");
            stringBuffer.append(simpleDateFormat.format(new Date()));
            stringBuffer.append("\r\n");
            stringBuffer.append("Server: V2C_");
            stringBuffer.append(V2CReleaseInfo.getReleaseName());
            stringBuffer.append("\r\n");
            if (bl) {
                stringBuffer.append("Last-Modified: ");
                stringBuffer.append(simpleDateFormat.format(new Date(v2CMoviePanel.lTime)));
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("Content-Length: ");
            stringBuffer.append(byArray.length);
            stringBuffer.append("\r\n");
            stringBuffer.append("Content-Type: text/html; charset=UTF-8\r\n");
            stringBuffer.append("\r\n");
            byte[] byArray2 = stringBuffer.toString().getBytes("ISO-8859-1");
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            this.osResponse = outputStream = this.sSocket.getOutputStream();
            outputStream.write(byArray3);
        }

        void sendResult() throws IOException {
            OutputStream outputStream;
            String string = this.bExtRequest && this.cCmd == 'R' ? String.valueOf(V2CApp.getMainWindowHandle(false)) + "\r\n" : "";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("HTTP/1.1 200 OK\r\n");
            stringBuffer.append("Date: ");
            stringBuffer.append(simpleDateFormat.format(new Date()));
            stringBuffer.append("\r\n");
            stringBuffer.append("Server: V2C_");
            stringBuffer.append(V2CReleaseInfo.getReleaseName());
            stringBuffer.append("\r\n");
            stringBuffer.append("Content-Length: ");
            stringBuffer.append(string.length());
            stringBuffer.append("\r\n");
            stringBuffer.append("\r\n");
            stringBuffer.append(string);
            this.osResponse = outputStream = this.sSocket.getOutputStream();
            outputStream.write(stringBuffer.toString().getBytes("UTF-8"));
            outputStream.close();
        }
    }
}

