/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.monazilla.v2c.V2CAbstractImagePanel;
import org.monazilla.v2c.V2CAnimationController;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CImagePopupParent;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CLauncher;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CNGFileItem;
import org.monazilla.v2c.V2CPopupPanel;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextPopup2;
import org.monazilla.v2c.V2CThreadItem;

public class V2CImagePopup
extends V2CAbstractImagePanel
implements V2CPopupPanel,
ActionListener {
    private static final int RESIZE_NONE = 0;
    private static final int RESIZE_TOPLEFT = 1;
    private static final int RESIZE_BOTTOMLEFT = 2;
    private static final int RESIZE_BOTTOMRIGHT = 3;
    private static final int RESIZE_TOPRIGHT = 4;
    static final HashSet hsOpenPopups = new HashSet();
    static Reference refCurrentImagePopup;
    Rectangle rScreenBounds;
    V2CImagePopupParent vipParent;
    Window jwPopupWindow;
    Point pInitialPoint;
    final JScrollPane jScrollPane;
    JLabel jLabel;
    JProgressBar jProgressBar;
    JLabel jlStopButton;
    Timer tTimer;
    int iResizeWindow;
    boolean bCloseOnMouseMove;

    static V2CImagePopup getCurrentImagePopup() {
        Object var0 = null;
        Reference reference = refCurrentImagePopup;
        return reference != null ? (V2CImagePopup)reference.get() : null;
    }

    static void notifyDownloadCompleted(V2CLink v2CLink) {
        V2CImagePopup v2CImagePopup = V2CImagePopup.getCurrentImagePopup();
        if (v2CImagePopup != null) {
            v2CImagePopup.downloadCompleted(v2CLink);
        }
    }

    static void imageUpdated(V2CImageSet v2CImageSet) {
        V2CImagePopup v2CImagePopup = V2CImagePopup.getCurrentImagePopup();
        if (v2CImagePopup != null && v2CImagePopup.vImageSet == v2CImageSet) {
            v2CImagePopup.repaint();
        }
        Iterator iterator = hsOpenPopups.iterator();
        while (iterator.hasNext()) {
            v2CImagePopup = (V2CImagePopup)iterator.next();
            if (v2CImagePopup.vImageSet != v2CImageSet) continue;
            v2CImagePopup.repaint();
        }
    }

    static void setAllOpenPopupsVisibility(boolean bl) {
        Iterator iterator = hsOpenPopups.iterator();
        while (iterator.hasNext()) {
            V2CImagePopup v2CImagePopup = (V2CImagePopup)iterator.next();
            v2CImagePopup.jwPopupWindow.setVisible(bl);
        }
    }

    static String createErrorText(String string) {
        String string2 = "\u753b\u50cf\u30a8\u30e9\u30fc\uff1a";
        if (string != null) {
            if (string.equals("OutOfMemoryError: Java heap space")) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(" \u5272\u308a\u5f53\u3066\u30e1\u30e2\u30ea\u4e0d\u8db3\n");
                if (V2CLauncher.startedByLauncher()) {
                    stringBuffer.append("\u300c\u8a2d\u5b9a\u300d\u30e1\u30cb\u30e5\u30fc\u306e\u300c\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u8a2d\u5b9a\u300d\u3067\n");
                }
                stringBuffer.append("\u30e1\u30e2\u30ea\u4f7f\u7528\u91cf\u306e\u4e0a\u9650\u3092\u5897\u3084\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
                return stringBuffer.toString();
            }
            return string2 + '\n' + string;
        }
        return string2 + " \uff08\u539f\u56e0\u4e0d\u660e\uff09";
    }

    static V2CPopupPanel popupImage(V2CImagePopupParent v2CImagePopupParent, V2CLink v2CLink, Point point) {
        return V2CImagePopup.popupImage(v2CImagePopupParent, v2CLink, point, 0);
    }

    static V2CPopupPanel popupImage(V2CImagePopupParent v2CImagePopupParent, V2CLink v2CLink, Point point, boolean bl) {
        return V2CImagePopup.popupImage(v2CImagePopupParent, v2CLink, point, V2CImagePopup.getScaleFromShiftState(bl));
    }

    static V2CPopupPanel popupImage(V2CImagePopupParent v2CImagePopupParent, V2CLink v2CLink, Point point, int n) {
        V2CImagePopup.closeVolatilePopup();
        V2CImageSet v2CImageSet = v2CLink.getLocalImage();
        if (v2CImageSet != null && v2CImageSet.isSizeLimitExceeded()) {
            int n2 = V2CLink.nMaxLoadImageSize;
            if (n2 <= 0) {
                n2 = 30000;
            }
            int n3 = V2CLink.nMaxLoadImageArea;
            int n4 = v2CImageSet.getWidth();
            int n5 = v2CImageSet.getHeight();
            if (n4 <= n2 && n5 <= n2 && (n3 <= 0 || n4 * n5 <= n3)) {
                v2CLink.clearThumbnail(true);
                v2CLink.clearImage();
                v2CImageSet = null;
            }
        }
        if (v2CImageSet == null || v2CImageSet.isOK()) {
            return new V2CImagePopup(v2CImagePopupParent, v2CLink, point, n);
        }
        v2CLink.createThumbnailBG(false);
        V2CTextPopup2 v2CTextPopup2 = new V2CTextPopup2(V2CImagePopup.createErrorText(v2CImageSet.getErrorMessage()), point, (Component)((Object)v2CImagePopupParent));
        v2CTextPopup2.showPopup();
        return v2CTextPopup2;
    }

    static void closeVolatilePopup() {
        V2CImagePopup v2CImagePopup = V2CImagePopup.getCurrentImagePopup();
        if (v2CImagePopup != null) {
            v2CImagePopup.closePopupWindow();
        }
    }

    private V2CImagePopup(V2CImagePopupParent v2CImagePopupParent, V2CLink v2CLink, Point point, int n) {
        super(v2CLink, n);
        Window window;
        Serializable serializable;
        V2CInputMap v2CInputMap = V2CInputMap.getInputMap("ImagePopup");
        this.bPopup = true;
        this.vipParent = v2CImagePopupParent;
        this.bFocusRequested = true;
        this.pInitialPoint = point;
        PopupMouseListener popupMouseListener = new PopupMouseListener();
        this.addMouseListener(popupMouseListener);
        this.addMouseMotionListener(popupMouseListener);
        this.jScrollPane = new JScrollPane(this);
        JFrame jFrame = null;
        if (v2CImagePopupParent instanceof Component && (serializable = SwingUtilities.getWindowAncestor((Component)((Object)v2CImagePopupParent))) != null && (window = serializable.getOwner()) instanceof JFrame) {
            jFrame = (JFrame)window;
        }
        if (jFrame == null) {
            jFrame = V2CMain.v2cMain;
        }
        if (V2CMain.getUseJDialogForPopup()) {
            this.jwPopupWindow = serializable = new JDialog((Frame)jFrame, false);
            ((Dialog)serializable).setUndecorated(true);
            ((JDialog)serializable).setContentPane(this.jScrollPane);
            this.requestFocusInWindow();
        } else {
            this.jwPopupWindow = serializable = new JWindow(jFrame);
            serializable.setFocusableWindowState(true);
            serializable.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    V2CImagePopup.this.requestFocus();
                }
            });
            ((JWindow)serializable).setContentPane(this.jScrollPane);
        }
        if (this.vImageSet != null) {
            if (!this.vImageSet.isOK()) {
                return;
            }
            this.bNeedsUpdate = this.vImageSet.needsUpdate();
        }
        this.jwPopupWindow.setLocation(point);
        if (this.vImageSet != null) {
            this.bResized = true;
            this.resizeWindow(false);
            this.jwPopupWindow.setVisible(true);
        } else {
            this.jwPopupWindow.setVisible(true);
            this.setLayout(new GridBagLayout());
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).gridy = 0;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets = new Insets(2, 2, 2, 2);
            this.jLabel = new JLabel("               ");
            this.jLabel.setHorizontalAlignment(0);
            ((GridBagConstraints)serializable).gridwidth = 2;
            this.add((Component)this.jLabel, serializable);
            ((GridBagConstraints)serializable).gridwidth = 1;
            ++((GridBagConstraints)serializable).gridy;
            this.jProgressBar = new JProgressBar(0, 100);
            this.jProgressBar.setStringPainted(true);
            this.add((Component)this.jProgressBar, serializable);
            ++((GridBagConstraints)serializable).gridx;
            ((GridBagConstraints)serializable).insets = new Insets(2, 0, 2, 2);
            this.jlStopButton = new JLabel(icStop);
            this.add((Component)this.jlStopButton, serializable);
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(21);
            this.jwPopupWindow.pack();
            this.vLink.setLoadingStatus(this.jLabel, this.jProgressBar);
            this.tTimer = new Timer(200, this);
            this.tTimer.start();
        }
        refCurrentImagePopup = new SoftReference<V2CImagePopup>(this);
    }

    public boolean needsScrollPane() {
        return false;
    }

    public boolean isCloseOnExit() {
        return this.bCloseOnMouseMove;
    }

    public void closePopupWindow() {
        if (this.bCloseOnMouseMove) {
            this.bCloseOnMouseMove = false;
        }
        if (this.vipParent != null) {
            V2CImagePopupParent v2CImagePopupParent = this.vipParent;
            this.vipParent = null;
            if (v2CImagePopupParent.requestClosePopup(this)) {
                return;
            }
        }
        if (this.tTimer != null && this.tTimer.isRunning()) {
            this.tTimer.stop();
        }
        this.bNeedsUpdate = false;
        this.jwPopupWindow.dispose();
        if (V2CImagePopup.getCurrentImagePopup() == this) {
            refCurrentImagePopup = null;
        }
        hsOpenPopups.remove(this);
        if (this.vImageSet != null) {
            V2CAnimationController.imagePopupClosed(this.vImageSet);
        }
        if (V2CApp.isMacintosh() && V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            this.jScrollPane.setViewportView(null);
            V2CSwingUtil.setContentPane(this.jwPopupWindow, new JPanel());
        }
    }

    void detouchImagePopup() {
        if (this.vipParent != null) {
            this.vipParent.imagePopupDetouched(this);
            this.vipParent = null;
            hsOpenPopups.add(this);
            if (V2CImagePopup.getCurrentImagePopup() == this) {
                refCurrentImagePopup = null;
            }
        }
    }

    Point getWindowLocation() {
        return this.jwPopupWindow.getLocation();
    }

    V2CPopupPanel showErrorText(String string) {
        this.closePopupWindow();
        V2CTextPopup2 v2CTextPopup2 = new V2CTextPopup2(V2CImagePopup.createErrorText(string), this.getWindowLocation(), (Component)this);
        v2CTextPopup2.showPopup();
        return v2CTextPopup2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        V2CImageSet v2CImageSet;
        this.vImageSet = v2CImageSet = this.vLink.getLocalImage();
        if (v2CImageSet == null) {
            long l;
            if (!this.vLink.isChecking() && !this.vLink.hasImageCache()) {
                this.closePopupWindow();
            } else if (this.jLabel != null && (l = System.currentTimeMillis()) > this.ltLastUpdate + 250L) {
                this.ltLastUpdate = l;
                this.vLink.setLoadingStatus(this.jLabel, this.jProgressBar);
                this.repaint();
            }
            return;
        }
        this.tTimer.stop();
        if (!v2CImageSet.isOK()) {
            if (this.vipParent != null) {
                this.vipParent.imageError(v2CImageSet.getErrorMessage());
            }
            return;
        }
        this.remove(this.jProgressBar);
        this.remove(this.jLabel);
        this.remove(this.jlStopButton);
        this.setLayout(null);
        this.bNeedsUpdate = v2CImageSet.needsUpdate();
        this.nDispWidth = this.nWidth = v2CImageSet.getWidth();
        this.nDispHeight = this.nHeight = v2CImageSet.getHeight();
        this.bResized = true;
        SwingUtilities.invokeLater(new V2CAbstractImagePanel.PanelResizer());
    }

    void downloadCompleted(V2CLink v2CLink) {
        if (v2CLink != this.vLink) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (V2CImagePopup.this.jLabel != null) {
                    V2CImagePopup.this.jLabel.setText("done.");
                }
                if (V2CImagePopup.this.jProgressBar != null) {
                    V2CImagePopup.this.jProgressBar.setValue(100);
                }
            }
        });
    }

    void resizePanel(boolean bl) {
        this.resizeWindow(bl);
    }

    void resizeWindow(boolean bl) {
        boolean bl2;
        int n;
        int n2;
        Rectangle rectangle;
        if (this.nWidth <= 1 || this.nHeight <= 1) {
            return;
        }
        this.bResized = true;
        this.bResizing = true;
        Point point = this.jwPopupWindow.getLocation();
        Insets insets = this.jwPopupWindow.getInsets();
        this.rScreenBounds = rectangle = V2CSwingUtil.getScreenBoundsAt(point);
        Insets insets2 = this.jScrollPane.getInsets();
        if (bl) {
            Dimension dimension = this.jwPopupWindow.getSize();
            n2 = dimension.width - insets2.left - insets2.right;
            n = dimension.height - insets2.top - insets2.bottom;
        } else {
            n2 = Math.min(nMaxWidth, rectangle.width - insets.left - insets.right - insets2.left - insets2.right - 2);
            n = Math.min(nMaxHeight, rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom - 2);
        }
        double d = 1.0;
        int n3 = this.nDispWidth;
        int n4 = this.nDispHeight;
        switch (this.nSize) {
            case 0: {
                double d2 = (double)nSmallMaxWidth / (double)n3;
                double d3 = (double)nSmallMaxHeight / (double)n4;
                d = Math.min(Math.min(d2, d3), 1.0);
                break;
            }
            case 1: {
                if (n2 >= n3 && n >= n4) break;
                d = Math.min((double)n2 / (double)n3, (double)n / (double)n4);
                break;
            }
            case 3: {
                if (n2 <= n3 || n <= n4) break;
                d = Math.min((double)n2 / (double)n3, (double)n / (double)n4);
                break;
            }
            case 4: {
                d = Math.min((double)n2 / (double)n3, (double)n / (double)n4);
                break;
            }
            case 10: {
                d = this.dScale;
            }
        }
        if (Math.abs(d - 1.0) < 1.0E-4) {
            d = 1.0;
        }
        n3 = (int)(d * (double)n3);
        n4 = (int)(d * (double)n4);
        this.nViewWidth = n3;
        this.nViewHeight = n4;
        this.dScale = d;
        this.setPreferredSize(new Dimension(this.nViewWidth, this.nViewHeight));
        this.setSize(this.nViewWidth, this.nViewHeight);
        boolean bl3 = V2CApp.isGTK();
        if (bl3) {
            n3 += 2;
            n4 += 2;
        }
        int n5 = UIManager.getInt("ScrollBar.width");
        boolean bl4 = n2 < n3;
        boolean bl5 = bl2 = n < n4;
        if (bl2) {
            n3 += n5;
            if (bl3) {
                n3 += 2;
            }
        }
        if (n2 < n3) {
            n3 = n2;
        }
        if (bl4) {
            n4 += n5;
            if (bl3) {
                n4 += 2;
            }
        }
        if (n < n4) {
            n4 = n;
        }
        Dimension dimension = new Dimension(n3 + insets2.left + insets2.right, n4 + insets2.top + insets2.bottom);
        this.jScrollPane.setPreferredSize(dimension);
        this.jScrollPane.setHorizontalScrollBarPolicy(30);
        this.jScrollPane.setVerticalScrollBarPolicy(20);
        if (bAlwaysCenter || this.nSize == 3) {
            this.centerImagePopup(point, rectangle, dimension);
        } else {
            int n6 = (int)point.getX();
            int n7 = (int)point.getY();
            int n8 = (int)dimension.getWidth();
            int n9 = (int)dimension.getHeight();
            boolean bl6 = false;
            if (this.pInitialPoint != null) {
                bl6 = true;
                n7 = Math.max(this.pInitialPoint.y - n9 + 1, rectangle.y + 1);
                this.pInitialPoint = null;
            }
            if (n6 + n8 + 2 > rectangle.x + rectangle.width) {
                bl6 = true;
                n6 = rectangle.x + rectangle.width - n8 - 1;
            }
            if (n7 + n9 + 2 > rectangle.y + rectangle.height) {
                bl6 = true;
                n7 = rectangle.y + rectangle.height - n9 - 1;
            }
            if (bl6) {
                this.jwPopupWindow.setLocation(n6, n7);
            }
        }
        this.jwPopupWindow.pack();
        this.bResizing = false;
    }

    void centerImagePopup() {
        Point point = this.jwPopupWindow.getLocation();
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
        Dimension dimension = this.jwPopupWindow.getSize();
        this.centerImagePopup(point, rectangle, dimension);
    }

    void centerImagePopup(Point point, Rectangle rectangle, Dimension dimension) {
        int n;
        int n2 = rectangle.x + (rectangle.width - dimension.width) / 2;
        if (n2 < rectangle.x) {
            n2 = rectangle.x;
        }
        if ((n = rectangle.y + (rectangle.height - dimension.height) / 2) < rectangle.y) {
            n = rectangle.y;
        }
        if (n2 != point.x || n != point.y) {
            this.jwPopupWindow.setLocation(n2, n);
        }
    }

    void saveImage(File file, boolean bl) {
        V2CThreadItem v2CThreadItem = null;
        if (this.vipParent != null) {
            v2CThreadItem = this.vipParent.getThreadItem();
        }
        this.saveImage(this.jwPopupWindow, file, v2CThreadItem, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showImageProperty() {
        if (V2CApp.isUNIX()) {
            this.jwPopupWindow.setVisible(false);
        }
        try {
            super.showImageProperty();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (V2CApp.isUNIX()) {
                this.jwPopupWindow.setVisible(true);
            }
            throw throwable;
        }
        if (V2CApp.isUNIX()) {
            this.jwPopupWindow.setVisible(true);
        }
    }

    void showNextImage(boolean bl) {
        if (this.vipParent != null) {
            this.vipParent.popupNextImage(bl);
        }
    }

    void disableLink() {
        if (!this.imageLoaded()) {
            return;
        }
        this.closePopupWindow();
        this.vLink.disable();
    }

    void deleteLinkCache() {
        if (!this.imageLoaded()) {
            return;
        }
        this.closePopupWindow();
        this.vLink.deleteHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToNGFile(boolean bl, ActionEvent actionEvent) {
        String string;
        boolean bl2;
        if (!this.imageLoaded()) {
            return;
        }
        Window window = this.jwPopupWindow;
        boolean bl3 = bl2 = V2CApp.isUNIX() && window instanceof JWindow;
        if (bl2) {
            window.setVisible(false);
        }
        if (bl) {
            string = "";
        } else {
            try {
                string = V2CNGFileItem.getInputComment();
                Object var7_6 = null;
                if (bl2) {
                    window.setVisible(true);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (bl2) {
                    window.setVisible(true);
                }
                throw throwable;
            }
            if (string == null) {
                return;
            }
        }
        this.closePopupWindow();
        this.vLink.addToNGFile(string);
    }

    void setCloseOnMouseMove() {
        this.bCloseOnMouseMove = true;
    }

    private class PopupMouseListener
    extends V2CAbstractImagePanel.ImageMouseListener {
        int nDX;
        int nDY;
        Rectangle rWindowRect;
        boolean bZoomFollowWindowSize;
        boolean bDragWindow;
        boolean bIgnoreClick;

        PopupMouseListener() {
            super("ImagePopup");
        }

        void dragAction(MouseEvent mouseEvent, int n, int n2) {
            if (this.bDragWindow) {
                Rectangle rectangle = V2CImagePopup.this.jwPopupWindow.getBounds();
                int n3 = rectangle.x + n;
                int n4 = rectangle.y + n2;
                if (V2CImagePopup.this.rScreenBounds == null) {
                    return;
                }
                if (n3 < V2CImagePopup.this.rScreenBounds.x + 1) {
                    n3 = V2CImagePopup.this.rScreenBounds.x + 1;
                } else if (n3 + rectangle.width > V2CImagePopup.this.rScreenBounds.x + V2CImagePopup.this.rScreenBounds.width - 1) {
                    n3 = V2CImagePopup.this.rScreenBounds.x + V2CImagePopup.this.rScreenBounds.width - rectangle.width - 1;
                }
                if (n4 < V2CImagePopup.this.rScreenBounds.y + 1) {
                    n4 = V2CImagePopup.this.rScreenBounds.y + 1;
                } else if (n4 + rectangle.height > V2CImagePopup.this.rScreenBounds.y + V2CImagePopup.this.rScreenBounds.height - 1) {
                    n4 = V2CImagePopup.this.rScreenBounds.y + V2CImagePopup.this.rScreenBounds.height - rectangle.height - 1;
                }
                if (n3 == rectangle.x && n4 == rectangle.y) {
                    return;
                }
                V2CImagePopup.this.jwPopupWindow.setLocation(n3, n4);
            } else if (V2CImagePopup.this.iResizeWindow != 0) {
                JScrollPane jScrollPane = V2CImagePopup.this.jScrollPane;
                Point point = mouseEvent.getPoint();
                if (this.bZoomFollowWindowSize) {
                    Insets insets = jScrollPane.getInsets();
                    Point point2 = SwingUtilities.convertPoint(mouseEvent.getComponent(), point.x, point.y, jScrollPane);
                    int n5 = jScrollPane.getWidth() - insets.left - insets.right;
                    int n6 = jScrollPane.getHeight() - insets.top - insets.bottom;
                    if (V2CImagePopup.this.iResizeWindow == 3) {
                        n = point2.x + this.nDX - jScrollPane.getWidth();
                        n2 = point2.y + this.nDY - jScrollPane.getHeight();
                        double d = (double)Math.max(n5 + n, 20) / (double)n5;
                        double d2 = (double)Math.max(n6 + n2, 20) / (double)n6;
                        double d3 = Math.min(d, d2);
                        V2CImagePopup.this.nSize = 10;
                        V2CImagePopup.this.dScale *= d3;
                        V2CImagePopup.this.resizePanel(false);
                        V2CImagePopup.this.repaint();
                    }
                } else {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    Rectangle rectangle = this.rWindowRect;
                    Rectangle rectangle2 = V2CImagePopup.this.jwPopupWindow.getBounds();
                    SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                    Rectangle rectangle3 = V2CImagePopup.this.rScreenBounds;
                    if (rectangle3 == null) {
                        rectangle3 = V2CSwingUtil.getScreenBoundsAt(point);
                    }
                    if (V2CImagePopup.this.iResizeWindow == 1) {
                        n10 = Math.max(point.x - this.nDX, rectangle3.x + 1);
                        n9 = Math.max(point.y - this.nDY, rectangle3.y + 1);
                        n8 = Math.max(rectangle.x + rectangle.width - n10, 20);
                        n7 = Math.max(rectangle.y + rectangle.height - n9, 20);
                    } else if (V2CImagePopup.this.iResizeWindow == 2) {
                        n10 = Math.max(point.x - this.nDX, rectangle3.x + 1);
                        n9 = rectangle.y;
                        n8 = Math.max(rectangle.x + rectangle.width - n10, 20);
                        n7 = Math.max(point.y + this.nDY - n9, 20);
                    } else if (V2CImagePopup.this.iResizeWindow == 3) {
                        n10 = rectangle.x;
                        n9 = rectangle.y;
                        n8 = Math.max(point.x + this.nDX - n10, 20);
                        n7 = Math.max(point.y + this.nDY - n9, 20);
                    } else if (V2CImagePopup.this.iResizeWindow == 4) {
                        n10 = rectangle.x;
                        n9 = Math.max(point.y - this.nDY, rectangle3.y + 1);
                        n8 = Math.max(point.x + this.nDX - n10, 20);
                        n7 = Math.max(rectangle.y + rectangle.height - n9, 20);
                    } else {
                        return;
                    }
                    V2CImagePopup.this.nSize = 10;
                    V2CImagePopup.this.jwPopupWindow.setBounds(n10, n9, n8, n7);
                    V2CImagePopup.this.jwPopupWindow.invalidate();
                    V2CImagePopup.this.jwPopupWindow.validate();
                    Dimension dimension = jScrollPane.getViewport().getSize();
                    double d = (double)dimension.width / (V2CImagePopup.this.dScale * (double)V2CImagePopup.this.nDispWidth);
                    double d4 = (double)dimension.height / (V2CImagePopup.this.dScale * (double)V2CImagePopup.this.nDispHeight);
                    double d5 = Math.max(d, d4);
                    if (d5 > 1.0) {
                        V2CImagePopup.this.dScale *= d5;
                        V2CImagePopup.this.nViewWidth = (int)(V2CImagePopup.this.dScale * (double)V2CImagePopup.this.nDispWidth);
                        V2CImagePopup.this.nViewHeight = (int)(V2CImagePopup.this.dScale * (double)V2CImagePopup.this.nDispHeight);
                        Dimension dimension2 = new Dimension(V2CImagePopup.this.nViewWidth, V2CImagePopup.this.nViewHeight);
                        V2CImagePopup.this.setPreferredSize(dimension2);
                        V2CImagePopup.this.setSize(dimension2);
                        V2CImagePopup.this.repaint();
                    }
                }
            } else {
                super.dragAction(mouseEvent, n, n2);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!V2CImagePopup.this.bCloseOnMouseMove || V2CImagePopup.this.vipParent == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            V2CImagePopup.this.vipParent.mouseMoved(V2CImagePopup.this, point);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl;
            if (this.bIgnoreClick) {
                this.bIgnoreClick = false;
                return;
            }
            if (!V2CSwingUtil.isSimpleClick(mouseEvent)) {
                return;
            }
            boolean bl2 = bl = V2CImagePopup.this.findComponentAt(mouseEvent.getPoint()) == V2CImagePopup.this.jlStopButton;
            if (V2CImagePopup.this.vipParent != null) {
                V2CImagePopup.this.closePopupWindow();
            } else {
                V2CImagePopup.this.jwPopupWindow.toFront();
            }
            if (bl) {
                V2CImagePopup.this.vLink.stopDownloading();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (this.bDragged && this.bIgnoreClick) {
                this.bIgnoreClick = false;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (V2CImagePopup.this.bCloseOnMouseMove) {
                this.bIgnoreClick = true;
                V2CImagePopup.this.bCloseOnMouseMove = false;
            }
            this.bDragWindow = false;
            super.mousePressed(mouseEvent);
            if (!mouseEvent.isConsumed() && V2CSwingUtil.isSimpleClick(mouseEvent)) {
                this.rWindowRect = V2CImagePopup.this.jwPopupWindow.getBounds();
                Rectangle rectangle = V2CImagePopup.this.getVisibleRect();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle2 = V2CImagePopup.this.jScrollPane.getBounds();
                Point point2 = SwingUtilities.convertPoint(mouseEvent.getComponent(), point.x, point.y, V2CImagePopup.this.jScrollPane);
                int n = rectangle.width;
                int n2 = rectangle.height;
                int n3 = Math.min(20, n / 4);
                int n4 = Math.min(20, n2 / 4);
                int n5 = rectangle.x + n3;
                int n6 = rectangle.x + n - n3;
                int n7 = 0;
                if (point.y <= rectangle.y + n4) {
                    if (point.x <= n5) {
                        n7 = 1;
                        this.nDX = point2.x;
                        this.nDY = point2.y;
                    } else if (point.x >= n6) {
                        n7 = 4;
                        this.nDX = rectangle2.width - point2.x;
                        this.nDY = point2.y;
                    }
                } else if (point.y >= rectangle.y + rectangle.height - n4) {
                    if (point.x <= n5) {
                        n7 = 2;
                        this.nDX = point2.x;
                        this.nDY = rectangle2.height - point2.y;
                    } else if (point.x >= n6) {
                        n7 = 3;
                        this.nDX = rectangle2.width - point2.x;
                        this.nDY = rectangle2.height - point2.y;
                    }
                }
                V2CImagePopup.this.iResizeWindow = n7;
                boolean bl = !V2CImagePopup.this.jScrollPane.getVerticalScrollBar().isShowing() && !V2CImagePopup.this.jScrollPane.getHorizontalScrollBar().isShowing();
                boolean bl2 = this.bZoomFollowWindowSize = bl && n7 == 3;
                if (n7 == 0) {
                    this.bDragWindow = bl ? true : point.x < rectangle.x + n3 || point.x > rectangle.x + rectangle.width - n3 || point.y < rectangle.y + n4 || point.y > rectangle.y + rectangle.height - n4;
                }
            }
        }
    }
}

