/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import org.monazilla.v2c.V2CFileClassLoader;
import org.monazilla.v2c.V2CLauncher;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CMacQuaquaSupport {
    static final String sKeyPrefix = "Main.";
    static final String[] slQuaquaJars = new String[]{"quaqua.jar", "quaqua-filechooser-only.jar", "quaqua-colorchooser-only.jar", "quaqua-menu-only.jar", "quaqua-filechooser.jar"};
    static final String sQuaquaJNILib = "libquaqua.jnilib";
    static final String sJavaLibraryPathKey = "java.library.path";
    static final String sUseQuaquaKey = "Main.UseQuaqua";
    static final String sQuaquaTabbedPaneDesignKey = "Main.QuaquaTabbedPaneDesign";
    static final String sPanther = "panther";
    static final String sJaguar = "jaguar";
    static boolean bQuaquaInstalled;
    static String sVersion;
    static boolean bNeedsGeometryTweak;
    static Insets insZero;
    static Insets insVM;
    static V2CFileClassLoader vFileClassLoader;

    static boolean isQuaquaJarExists() {
        int n;
        if (V2CLauncher.startedByLauncher()) {
            for (n = 0; n < slQuaquaJars.length; ++n) {
                if (V2CLauncher.getAbsolutePathInJarDir(slQuaquaJars[n], false) == null) continue;
                return true;
            }
        }
        for (n = 0; n < slQuaquaJars.length; ++n) {
            if (V2CLocalFileHandler.getAbsolutePathInV2CDir(slQuaquaJars[n]) == null) continue;
            return true;
        }
        return false;
    }

    static boolean isClassPathContainsQuaqua() {
        String string = System.getProperty("java.class.path");
        return string != null && string.indexOf("quaqua") >= 0;
    }

    static boolean getShowQuaquaSetting() {
        return V2CMacQuaquaSupport.isClassPathContainsQuaqua() || V2CMacQuaquaSupport.isQuaquaJarExists();
    }

    static void checkJNILib() {
    }

    static boolean getUseQuaqua() {
        return V2CMain.getUserProperty().getBoolean(sUseQuaquaKey, true);
    }

    static String getVersion() {
        return sVersion;
    }

    static void appendQuaquaInfo(StringBuffer stringBuffer) {
        if (!bQuaquaInstalled) {
            return;
        }
        stringBuffer.append(" [Quaqua");
        if (sVersion != null && sVersion.length() > 0) {
            stringBuffer.append('-');
            stringBuffer.append(sVersion);
        }
        stringBuffer.append(']');
    }

    static boolean isTabbedPaneDesignJaguar() {
        return V2CMain.getUserProperty().get(sQuaquaTabbedPaneDesignKey, sPanther).equals(sJaguar);
    }

    static boolean isQuaquaInstalled() {
        return bQuaquaInstalled;
    }

    static boolean needsGeometryTweak() {
        return bNeedsGeometryTweak;
    }

    static void resetVisualMargin(JComponent jComponent) {
        if (insZero == null) {
            insZero = new Insets(0, 0, 0, 0);
        }
        jComponent.putClientProperty("Quaqua.Component.visualMargin", insZero);
    }

    static void setVisualMargin(JComponent jComponent) {
        if (insVM == null) {
            insVM = new Insets(1, 1, 1, 1);
        }
        jComponent.putClientProperty("Quaqua.Component.visualMargin", insVM);
    }

    static void setSquareButtonStyle(AbstractButton abstractButton) {
        abstractButton.putClientProperty("Quaqua.Button.style", "square");
    }

    static void setParameters(boolean bl, boolean bl2) {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (bl) {
            v2CProperty.remove(sUseQuaquaKey);
        } else {
            v2CProperty.putBoolean(sUseQuaquaKey, false);
        }
        if (bl2) {
            v2CProperty.put(sQuaquaTabbedPaneDesignKey, sJaguar);
        } else {
            v2CProperty.remove(sQuaquaTabbedPaneDesignKey);
        }
    }

    static void tryQuaquaLookAndFeel() {
        V2CMacQuaquaSupport.tryQuaquaLookAndFeel1();
        if (!bQuaquaInstalled) {
            return;
        }
        Dimension dimension = UIManager.getDimension("ToolBar.separatorSize");
        boolean bl = bNeedsGeometryTweak = dimension == null || dimension.width > 2;
        if (bNeedsGeometryTweak) {
            UIManager.put("ToolBar.separatorSize", new DimensionUIResource(2, 2));
        }
        UIManager.put("ScrollBar.width", new Integer(15));
    }

    static void tryQuaquaLookAndFeel1() {
        int n;
        String string;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (!v2CProperty.getBoolean(sUseQuaquaKey, true)) {
            return;
        }
        if (V2CMacQuaquaSupport.isClassPathContainsQuaqua()) {
            System.setProperty("Quaqua.TabbedPane.design", v2CProperty.get(sQuaquaTabbedPaneDesignKey, sPanther));
            try {
                string = QuaquaManager.getLookAndFeelClassName();
                if (string != null && string.length() > 0) {
                    UIManager.setLookAndFeel(string);
                    bQuaquaInstalled = true;
                }
            }
            catch (Exception exception) {
                V2CSwingUtil.showErrorMessage("Look&Feel\u306e\u8a2d\u5b9a\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u306e\u3067\nLook&Feel\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
            if (bQuaquaInstalled) {
                return;
            }
        }
        string = null;
        if (V2CLauncher.startedByLauncher()) {
            for (n = 0; n < slQuaquaJars.length && (string = V2CLauncher.getAbsolutePathInJarDir(slQuaquaJars[n], false)) == null; ++n) {
            }
        }
        if (string == null) {
            for (n = 0; n < slQuaquaJars.length && (string = V2CLocalFileHandler.getAbsolutePathInV2CDir(slQuaquaJars[n])) == null; ++n) {
            }
        }
        if (string == null) {
            return;
        }
        System.setProperty("Quaqua.TabbedPane.design", v2CProperty.get(sQuaquaTabbedPaneDesignKey, sPanther));
        String[] stringArray = new String[]{string};
        try {
            vFileClassLoader = new V2CFileClassLoader(stringArray);
            Thread.currentThread().setContextClassLoader(vFileClassLoader);
            Class<?> clazz = vFileClassLoader.loadClass("ch.randelshofer.quaqua.QuaquaManager");
            Method method = clazz.getDeclaredMethod("getLookAndFeelClassName", null);
            Object object = method.invoke(null, (Object[])null);
            if (object instanceof String) {
                UIManager.setLookAndFeel((String)object);
                UIManager.getDefaults().put("ClassLoader", vFileClassLoader);
                bQuaquaInstalled = true;
                V2CMacQuaquaSupport.setVersion(clazz);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    static void setContextClassLoader() {
        if (vFileClassLoader != null) {
            Thread.currentThread().setContextClassLoader(vFileClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void setVersion(Class var0) {
        block13: {
            var1_1 = null;
            var2_2 = null;
            try {
                var2_2 = new BufferedReader(new InputStreamReader(var0.getResourceAsStream("version.txt"), "UTF-8"));
                var1_1 = var2_2.readLine();
                var5_3 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var4_11) {
                var5_5 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var6_8) {
                        // empty catch block
                    }
                }
                throw var4_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var6_6) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (IOException var3_9) {
                    var5_4 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var6_7) {}
                    }
                }
            }
        }
        if (var1_1 == null || var1_1.length() == 0) {
            return;
        }
        var3_10 = var1_1.charAt(0);
        if (var3_10 < '0' || var3_10 > '9') {
            return;
        }
        var4_12 = var1_1.indexOf(32);
        V2CMacQuaquaSupport.sVersion = var4_12 > 0 ? var1_1.substring(0, var4_12) : var1_1;
    }
}

