/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import org.monazilla.v2c.V2CKeywordUtil;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNGExElement;
import org.monazilla.v2c.V2CNGItem;
import org.monazilla.v2c.V2CNGWordMatrix;
import org.monazilla.v2c.V2CPackedPropValue;

public class V2CNGExItem
implements V2CNGItem {
    static final char NGEX_THREADTITLE = 'T';
    static final char NGEX_THREADURL = 'U';
    static final char NGEX_NAME = 'N';
    static final char NGEX_MAIL = 'E';
    static final char NGEX_ID = 'I';
    static final char NGEX_IDEXT = 'X';
    static final char NGEX_BE = 'B';
    static final char NGEX_AUX = 'A';
    static final char NGEX_MESSAGE = 'M';
    boolean bActive;
    String sLabel;
    V2CNGExElement vNGExThreadTitle;
    V2CNGExElement vNGExThreadURL;
    V2CNGExElement vNGExName;
    V2CNGExElement vNGExMail;
    V2CNGExElement vNGExID;
    V2CNGExElement vNGExIDExt;
    V2CNGExElement vNGExBe;
    V2CNGExElement vNGExAux;
    V2CNGExElement vNGExMessage;
    boolean bAddToNGID;
    int iWeight;
    int nMaxRecDepth;
    boolean bTransparent;
    String sReason;
    String sSummary;
    int iTime;
    int iAppliedTime;
    int iExpiration;
    String sExpiration;
    boolean bATChanged;
    boolean bValid;
    private final int NELEMENTS = 9;

    static V2CNGExItem createItem(String string) {
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CPackedPropValue.createPackedValueArray(string);
        if (v2CPackedPropValueArray == null || v2CPackedPropValueArray.length <= 1) {
            return null;
        }
        V2CNGExItem v2CNGExItem = new V2CNGExItem(v2CPackedPropValueArray);
        return v2CNGExItem.bValid ? v2CNGExItem : null;
    }

    public V2CNGExItem(String string) {
        this.bActive = true;
        this.nMaxRecDepth = -1;
        this.sLabel = string;
        this.iTime = this.iAppliedTime = V2CMiscUtil.currentTimeMins();
    }

    private V2CNGExItem(V2CPackedPropValue[] v2CPackedPropValueArray) {
        int n;
        int n2;
        int n3;
        V2CPackedPropValue v2CPackedPropValue = v2CPackedPropValueArray[0];
        this.bActive = v2CPackedPropValue.getBoolean('A');
        this.bAddToNGID = v2CPackedPropValue.getBoolean('I');
        this.sLabel = v2CPackedPropValue.getString('L');
        this.bTransparent = v2CPackedPropValue.getBoolean('T');
        this.iWeight = v2CPackedPropValue.getIntInRange('w', -9, 9);
        this.nMaxRecDepth = n3 = v2CPackedPropValue.getIntInRangeIfExists('D', -1, 0, 100);
        if (n3 > 0) {
            V2CNGWordMatrix.setRecursiveUsed();
        }
        if ((n2 = v2CPackedPropValue.getInt('T')) <= 0) {
            n2 = V2CMiscUtil.currentTimeMins();
        }
        this.iTime = n2;
        int n4 = v2CPackedPropValue.getInt('A');
        int n5 = this.iAppliedTime = n4 > 0 ? n2 + n4 : n2;
        if (v2CPackedPropValue.getBoolean('V')) {
            this.iExpiration = -1;
        } else {
            n = v2CPackedPropValue.getInt('V');
            if (n > 0) {
                this.iExpiration = n * 1440;
            } else if (n < 0) {
                this.iExpiration = -n;
            }
        }
        n = v2CPackedPropValueArray.length;
        boolean bl = false;
        block11: for (int i = 1; i < n; ++i) {
            V2CPackedPropValue v2CPackedPropValue2 = v2CPackedPropValueArray[i];
            String string = v2CPackedPropValue2.getString('K');
            if (string == null || string.length() != 1) {
                bl = false;
                break;
            }
            char c = string != null ? string.charAt(0) : (char)'\u0000';
            V2CNGExElement v2CNGExElement = V2CNGExElement.restore(v2CPackedPropValue2, c == 'X', c == 'B');
            if (v2CNGExElement == null) {
                bl = false;
                break;
            }
            switch (c) {
                case 'A': {
                    bl = true;
                    this.vNGExAux = v2CNGExElement;
                    continue block11;
                }
                case 'E': {
                    bl = true;
                    this.vNGExMail = v2CNGExElement;
                    continue block11;
                }
                case 'B': {
                    bl = true;
                    this.vNGExBe = v2CNGExElement;
                    continue block11;
                }
                case 'I': {
                    bl = true;
                    this.vNGExID = v2CNGExElement;
                    continue block11;
                }
                case 'M': {
                    bl = true;
                    this.vNGExMessage = v2CNGExElement;
                    continue block11;
                }
                case 'N': {
                    bl = true;
                    this.vNGExName = v2CNGExElement;
                    continue block11;
                }
                case 'T': {
                    this.vNGExThreadTitle = v2CNGExElement;
                    continue block11;
                }
                case 'U': {
                    this.vNGExThreadURL = v2CNGExElement;
                    continue block11;
                }
                case 'X': {
                    bl = true;
                    this.vNGExIDExt = v2CNGExElement;
                }
            }
        }
        this.bValid = bl;
    }

    boolean isValid() {
        return this.bValid;
    }

    boolean isActive() {
        return this.bActive;
    }

    boolean isAddToNGID() {
        return this.bAddToNGID;
    }

    String getLabel() {
        return this.sLabel;
    }

    void getSaveValue(ArrayList arrayList) {
        arrayList.clear();
        if (!this.bValid) {
            return;
        }
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setBoolean('A', this.bActive);
        v2CPackedPropValue.setBoolean('I', this.bAddToNGID);
        v2CPackedPropValue.setBoolean('T', this.bTransparent);
        if (this.sLabel != null && this.sLabel.length() > 0) {
            v2CPackedPropValue.setString('L', this.sLabel);
        }
        if (this.iWeight != 0) {
            v2CPackedPropValue.setInt('w', this.iWeight);
        }
        if (this.nMaxRecDepth >= 0) {
            v2CPackedPropValue.setInt('D', this.nMaxRecDepth);
        }
        if (this.iTime > 0) {
            int n;
            v2CPackedPropValue.setInt('T', this.iTime);
            if (this.iAppliedTime > this.iTime) {
                v2CPackedPropValue.setInt('A', this.iAppliedTime - this.iTime);
            }
            if ((n = this.iExpiration) > 0) {
                int n2 = n % 1440;
                v2CPackedPropValue.setInt('V', n2 > 0 ? -n : n / 1440);
            } else if (n < 0) {
                v2CPackedPropValue.setBoolean('V', true);
            }
        }
        arrayList.add(v2CPackedPropValue);
        if (this.vNGExThreadTitle != null) {
            this.vNGExThreadTitle.addSaveValue(arrayList, 'T');
        }
        if (this.vNGExThreadURL != null) {
            this.vNGExThreadURL.addSaveValue(arrayList, 'U');
        }
        if (this.vNGExName != null) {
            this.vNGExName.addSaveValue(arrayList, 'N');
        }
        if (this.vNGExMail != null) {
            this.vNGExMail.addSaveValue(arrayList, 'E');
        }
        if (this.vNGExID != null) {
            this.vNGExID.addSaveValue(arrayList, 'I');
        }
        if (this.vNGExIDExt != null) {
            this.vNGExIDExt.addSaveValue(arrayList, 'X');
        }
        if (this.vNGExBe != null) {
            this.vNGExBe.addSaveValue(arrayList, 'B');
        }
        if (this.vNGExAux != null) {
            this.vNGExAux.addSaveValue(arrayList, 'A');
        }
        if (this.vNGExMessage != null) {
            this.vNGExMessage.addSaveValue(arrayList, 'M');
        }
    }

    boolean setElements(V2CNGExElement[] v2CNGExElementArray, boolean bl) {
        this.bValid = false;
        if (v2CNGExElementArray == null || v2CNGExElementArray.length != 9) {
            return false;
        }
        boolean bl2 = false;
        for (int i = 0; i < 9; ++i) {
            V2CNGExElement v2CNGExElement = v2CNGExElementArray[i];
            if (v2CNGExElement == null) continue;
            if (!v2CNGExElement.isValid()) {
                return false;
            }
            if (i < 2) continue;
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        this.vNGExThreadTitle = v2CNGExElementArray[0];
        this.vNGExThreadURL = v2CNGExElementArray[1];
        this.vNGExName = v2CNGExElementArray[2];
        this.vNGExMail = v2CNGExElementArray[3];
        this.vNGExID = v2CNGExElementArray[4];
        this.vNGExIDExt = v2CNGExElementArray[5];
        this.vNGExBe = v2CNGExElementArray[6];
        this.vNGExAux = v2CNGExElementArray[7];
        this.vNGExMessage = v2CNGExElementArray[8];
        this.bAddToNGID = bl;
        this.bValid = true;
        return true;
    }

    void setActive(boolean bl) {
        if (this.bActive == bl) {
            return;
        }
        this.bActive = bl;
    }

    void setTransparent(boolean bl) {
        if (this.bTransparent == bl) {
            return;
        }
        this.bTransparent = bl;
    }

    void setWeight(String string) {
        int n = V2CKeywordUtil.toWeight(string);
        if (this.iWeight == n) {
            return;
        }
        this.iWeight = n;
    }

    void setLabel(String string) {
        this.sReason = null;
        if (string != null) {
            if (string.indexOf(9) >= 0) {
                string = V2CMiscUtil.replaceTab2SP(string);
            }
            if (string.equals(this.sLabel)) {
                return;
            }
        } else if (this.sLabel == null) {
            return;
        }
        this.sLabel = string;
    }

    void clearSummary() {
        this.sSummary = null;
    }

    static void appendDescription(V2CNGExElement v2CNGExElement, String string, StringBuffer stringBuffer) {
        if (v2CNGExElement == null) {
            return;
        }
        stringBuffer.append(string);
        v2CNGExElement.appendDescription(stringBuffer);
    }

    String getSummary() {
        String string = this.sSummary;
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bAddToNGID) {
            stringBuffer.append("\u81ea\u52d5NGID\u3001");
        }
        V2CNGExItem.appendDescription(this.vNGExThreadTitle, "\uff7d\uff9a\uff80\uff72", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExThreadURL, "URL", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExName, "\u540d\u524d", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExMail, "\uff92\uff70\uff99", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExID, "ID", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExIDExt, "ID\u672b\u5c3e", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExBe, "Be", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExAux, "Aux", stringBuffer);
        V2CNGExItem.appendDescription(this.vNGExMessage, "\u672c\u6587", stringBuffer);
        string = stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : "";
        this.sSummary = string;
        return string;
    }

    long getTime() {
        return (long)this.iTime * 60000L;
    }

    long getAppliedTime() {
        return (long)this.iAppliedTime * 60000L;
    }

    long getExpirationTime(int n) {
        return (long)this.getExpirationMin(n) * 60000L;
    }

    private int getExpirationMin(int n) {
        int n2 = this.iExpiration;
        if (n2 == 0) {
            n2 = n;
        }
        if (n2 <= 0) {
            return 0;
        }
        return (n2 <= 1440 ? this.iTime : this.iAppliedTime) + n2;
    }

    boolean isExpired(int n, int n2) {
        int n3 = this.getExpirationMin(n2);
        return n3 > 0 ? n > n3 : false;
    }

    boolean checkExpiration(int n, int n2) {
        if (!this.bActive || !this.isExpired(n, n2)) {
            return false;
        }
        this.bActive = false;
        return true;
    }

    void setExpiration(String string) {
        if (string == null) {
            return;
        }
        int n = V2CKeywordUtil.parseExpiration(string);
        if (n < -1) {
            return;
        }
        this.sExpiration = null;
        this.iExpiration = n;
    }

    String getExpirationString() {
        String string = this.sExpiration;
        if (string == null) {
            this.sExpiration = string = V2CKeywordUtil.formatExpiration(this.iExpiration);
        }
        return string;
    }

    void setApplied() {
        this.bATChanged = true;
    }

    boolean checkAppliedTimeChange(int n) {
        if (this.bATChanged) {
            this.bATChanged = false;
            if (n > this.iAppliedTime) {
                this.iAppliedTime = n;
                return true;
            }
        }
        return false;
    }

    public String getReasonString() {
        if (this.sReason == null) {
            this.sReason = this.sLabel != null ? "NGEx[" + this.sLabel + ']' : "NGEx";
        }
        return this.sReason;
    }

    public int getWeight() {
        return this.iWeight;
    }

    public int getMaxRecDepth() {
        return this.nMaxRecDepth;
    }

    void setMaxRecDepth(int n) {
        if (this.nMaxRecDepth == n) {
            return;
        }
        this.nMaxRecDepth = n;
        if (n > 0) {
            V2CNGWordMatrix.setRecursiveUsed();
        }
    }

    public boolean isTransparent() {
        return this.bTransparent;
    }
}

