/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextField;

public class V2CNewUserDefinedItemPanel {
    JPanel jPanel;
    final boolean bBoard;
    final boolean bLocal;
    JTextField jtfName;
    JTextField jtfURL;
    String sURLPattern;

    static V2CNewUserDefinedItemPanel createPanelForRSS() {
        return new V2CNewUserDefinedItemPanel(false, false, "https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+", new String[]{"[2NN+] http://www.2nn.jp/rss/index.rdf"});
    }

    static V2CNewUserDefinedItemPanel createPanelForLocalBoard() {
        return new V2CNewUserDefinedItemPanel(true, true, "\\p{Alnum}+", new String[]{"\u30d5\u30a9\u30eb\u30c0\u306b\u4f7f\u7528\u53ef\u80fd\u306a\u6587\u5b57\u306f\u534a\u89d2\u82f1\u6570\u5b57\u306e\u307f\u3002", "\u30d5\u30a9\u30eb\u30c0\u304c example \u306e\u5834\u5408", "\u5f62\u5f0f\u7684\u306aURL\u306f http://localboard/example/ \u306b\u306a\u308a\u307e\u3059\u3002", "\u6ce8\u610f\uff1a\u30d5\u30a9\u30eb\u30c0\u3092\u5f8c\u304b\u3089\u5909\u66f4\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002"});
    }

    private V2CNewUserDefinedItemPanel(boolean bl, boolean bl2, String string, String[] stringArray) {
        JPanel jPanel;
        this.jPanel = jPanel = new JPanel(new GridBagLayout());
        this.bBoard = bl;
        this.bLocal = bl2;
        this.sURLPattern = string;
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        jPanel.add((Component)new JLabel("\u540d\u524d\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jtfName = new V2CTextField(30);
        jPanel.add((Component)this.jtfName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        jPanel.add((Component)new JLabel(bl2 ? "\u30d5\u30a9\u30eb\u30c0\uff1a" : "URL\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jtfURL = new V2CTextField(bl2 ? 30 : 50);
        jPanel.add((Component)this.jtfURL, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        if (!bl2) {
            jPanel.add((Component)new JLabel("\u4f8b\uff1a"), gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            JLabel jLabel = new JLabel(string2);
            if (string2.startsWith("\u6ce8\u610f\uff1a")) {
                jLabel.setForeground(Color.RED);
            }
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
    }

    boolean showDialog() {
        Pattern pattern = Pattern.compile(this.sURLPattern);
        while (true) {
            String[] stringArray = new String[]{"OK", "Cancel"};
            V2CSwingUtil.showDialogWithClose((JFrame)V2CMain.v2cMain, (JComponent)this.jPanel, (JTextComponent)(this.jtfName != null ? this.jtfName : this.jtfURL), (this.bLocal ? "\u30ed\u30fc\u30ab\u30eb" : "\u30e6\u30fc\u30b6\u5b9a\u7fa9") + (this.bBoard ? "\u677f" : "RSS"), stringArray, null);
            if (stringArray[0] == null) {
                return false;
            }
            String string = this.jtfName.getText();
            if (string == null || string.length() == 0) {
                V2CSwingUtil.showErrorMessage("\u540d\u524d\u304c\u7a7a\u3067\u3059\u3002");
                continue;
            }
            String string2 = this.jtfURL.getText().trim();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) {
                V2CSwingUtil.showErrorMessage(this.bLocal ? "\u30d5\u30a9\u30eb\u30c0\u306f\u534a\u89d2\u82f1\u6570\u5b57\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" : V2CJStr.getMalformedURLMessage(string2));
                continue;
            }
            if (this.bLocal) break;
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                V2CSwingUtil.showErrorMessage(V2CJStr.getMalformedURLMessage(string2));
                V2CMiscUtil.printMalformedURLException(malformedURLException);
                continue;
            }
            break;
        }
        return true;
    }

    String getNewName() {
        return this.jtfName.getText();
    }

    String getNewURLString() {
        return this.jtfURL.getText().trim();
    }
}

