/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.monazilla.v2c.V2CClassStateSaver;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CPropertyOwner;
import org.monazilla.v2c.V2CRSSEntry;
import org.monazilla.v2c.V2CRSSEntryList;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class V2CRSSItem
implements V2CPropertyOwner {
    private static final String sHTTPDateKey = "HTTP.Date";
    private static final String sHTTPLastModifiedKey = "HTTP.LastModified";
    private static final String sURL2NumFileName = "url2num.txt";
    private static final SimpleDateFormat dfDate = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final HashMap hmRSSItems = new HashMap();
    private static final ArrayList alNum2URL = new ArrayList(100);
    private static final ClassStateSaver classStateSaver = new ClassStateSaver(600);
    private static final Icon icRSSItem = V2CSwingUtil.getItemIcon("RSSItem");
    String sURL;
    String sName;
    int nNum;
    File fLocalCache;
    long lDate;
    long lLastModified;
    HashSet hsLastLinks = new HashSet();
    boolean bLastLinkLoaded;
    V2CProperty vpProperty;
    static final String[] slChannelElements = new String[]{"title", "link", "description"};
    static final String[] slChannelNameSpaces = new String[]{"dc:", "syn:"};

    static Icon getIcon() {
        return icRSSItem;
    }

    static V2CRSSItem getRSSItem(String string) {
        return (V2CRSSItem)hmRSSItems.get(string);
    }

    static void removeItem(V2CRSSItem v2CRSSItem) {
        if (v2CRSSItem == null) {
            return;
        }
        v2CRSSItem.removeItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void restoreURL2Num() {
        BufferedReader bufferedReader = V2CLocalFileHandler.getRSSReader(sURL2NumFileName);
        if (bufferedReader == null) {
            return;
        }
        try {
            try {
                String string;
                ArrayList arrayList = alNum2URL;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    V2CRSSItem v2CRSSItem;
                    String[] stringArray;
                    if (string.length() == 0 || string.charAt(0) == '#' || (stringArray = string.split(",", 2)).length != 2) continue;
                    int n = -1;
                    try {
                        n = V2CMiscUtil.parseInt(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n < 0 || (v2CRSSItem = (V2CRSSItem)hmRSSItems.get(string2 = stringArray[1])) == null) continue;
                    v2CRSSItem.setNumber(n);
                    if (arrayList.size() <= n) {
                        int n2 = 2 * (n + 1);
                        for (int i = arrayList.size(); i < n2; ++i) {
                            arrayList.add(null);
                        }
                    }
                    if (arrayList.get(n) != null) continue;
                    arrayList.set(n, v2CRSSItem);
                }
                Object var10_11 = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var10_12 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            V2CLocalFileHandler.closeReader(bufferedReader);
            throw throwable;
        }
        V2CLocalFileHandler.closeReader(bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void saveURL2Num() {
        BufferedWriter bufferedWriter = V2CLocalFileHandler.getRSSWriter(sURL2NumFileName);
        if (bufferedWriter == null) {
            return;
        }
        try {
            try {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList = alNum2URL;
                synchronized (arrayList2) {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        V2CRSSItem v2CRSSItem = (V2CRSSItem)arrayList.get(i);
                        if (v2CRSSItem == null) continue;
                        bufferedWriter.write(String.valueOf(i));
                        bufferedWriter.write(44);
                        bufferedWriter.write(v2CRSSItem.sURL);
                        bufferedWriter.newLine();
                    }
                }
            }
            catch (IOException iOException) {
                Object var8_8 = null;
                V2CLocalFileHandler.closeWriter(bufferedWriter);
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            V2CLocalFileHandler.closeWriter(bufferedWriter);
            throw throwable;
        }
        V2CLocalFileHandler.closeWriter(bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V2CRSSItem(String string, String string2) {
        this.sName = string;
        this.sURL = string2;
        this.nNum = -1;
        ArrayList arrayList = alNum2URL;
        synchronized (arrayList) {
            hmRSSItems.put(string2, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumber() {
        ArrayList arrayList;
        int n = this.nNum;
        if (n >= 0) {
            return n;
        }
        ArrayList arrayList2 = arrayList = alNum2URL;
        synchronized (arrayList2) {
            int n2;
            int n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                if (arrayList.get(n2) != null) continue;
                n = n2;
                arrayList.set(n2, this);
                break;
            }
            if (n < 0) {
                n2 = 2 * (n3 + 1);
                for (int i = n3; i < n2; ++i) {
                    arrayList.add(null);
                }
                n = n3;
                arrayList.set(n3, this);
            }
            this.nNum = n;
        }
        classStateSaver.requestSave();
        this.deleteFiles();
        return n;
    }

    private void deleteFiles() {
        int n = this.nNum;
        if (n >= 0) {
            V2CLocalFileHandler.getRSSCacheFile(n).delete();
            V2CLocalFileHandler.getRSSPropertyFile(n).delete();
            V2CLocalFileHandler.getRSSLastLinkFile(n).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItem() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alNum2URL;
        synchronized (arrayList2) {
            hmRSSItems.remove(this.sURL);
            int n = this.nNum;
            if (n >= 0 && n < arrayList.size()) {
                arrayList.set(n, null);
                classStateSaver.requestSave();
                this.deleteFiles();
            }
            this.nNum = -1;
        }
    }

    private void setNumber(int n) {
        this.nNum = n;
    }

    File localCacheFile() {
        if (this.fLocalCache == null) {
            this.fLocalCache = V2CLocalFileHandler.getRSSCacheFile(this.getNumber());
        }
        return this.fLocalCache;
    }

    File getPropertyFile() {
        return V2CLocalFileHandler.getRSSPropertyFile(this.getNumber());
    }

    File getLastLinkFile() {
        return V2CLocalFileHandler.getRSSLastLinkFile(this.getNumber());
    }

    long getDate() {
        if (this.lDate == 0L) {
            V2CProperty v2CProperty = this.getProperty();
            this.lDate = v2CProperty.getLong(sHTTPDateKey);
            this.lLastModified = v2CProperty.getLong(sHTTPLastModifiedKey);
        }
        return this.lLastModified > 0L ? this.lLastModified : this.lDate;
    }

    byte[] getRawSubjectTxt() {
        long l = this.getDate();
        V2CHttpUtil.CAndC cAndC = V2CHttpUtil.getRawHTTPFile(this.sURL, null, l, 2);
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (cAndC == null) {
            return null;
        }
        HttpURLConnection httpURLConnection = cAndC.getConnection();
        if (httpURLConnection == null) {
            return null;
        }
        String string = httpURLConnection.getContentType();
        if (!V2CRSSItem.checkContentType(string)) {
            if (string != null) {
                V2CMain.setMessage(this.sURL + ": Content-Type is " + string);
            }
            return null;
        }
        this.lDate = httpURLConnection.getDate();
        this.lLastModified = httpURLConnection.getLastModified();
        return cAndC.getRawContents();
    }

    private static boolean checkContentType(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.toLowerCase()).startsWith("text/")) {
            return true;
        }
        if (string.equals("application/rdf+xml") || string.equals("application/rss+xml") || string.equals("application/atom+xml")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.startsWith("xml") || string2.startsWith("rdf") || string2.startsWith("rss") || string2.startsWith("atom");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void loadLastLink() {
        block11: {
            String string;
            if (this.bLastLinkLoaded) {
                return;
            }
            this.bLastLinkLoaded = true;
            BufferedReader bufferedReader = V2CLocalFileHandler.getBufferedReader(this.getLastLinkFile());
            if (bufferedReader == null) {
                return;
            }
            while ((string = bufferedReader.readLine()) != null) {
                this.hsLastLinks.add(string);
            }
            Object var4_4 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    Object var4_5 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void saveLastLink(ArrayList arrayList) {
        block11: {
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            BufferedWriter bufferedWriter = V2CLocalFileHandler.getBufferedWriter(this.getLastLinkFile());
            if (bufferedWriter == null) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String string;
                V2CRSSEntry v2CRSSEntry;
                Object[] objectArray = (Object[])arrayList.get(i);
                if (objectArray == null || (v2CRSSEntry = (V2CRSSEntry)objectArray[5]) == null || (string = v2CRSSEntry.getURLString()) == null || string.length() == 0) continue;
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            Object var8_8 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    Object var8_9 = null;
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.bLastLinkLoaded = false;
    }

    ArrayList getAndParse() {
        int n;
        byte[] byArray = this.getRawSubjectTxt();
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (byArray == null || byArray.length == 0) {
            return this.parseLocal();
        }
        if (byArray.length > 3 && (byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
            n = byArray.length - 3;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 3, byArray2, 0, n);
            byArray = byArray2;
        }
        for (n = 0; n < byArray.length; ++n) {
            byte by = byArray[n];
            if (by == 10 || by == 32) continue;
            if (n <= 0) break;
            int n2 = byArray.length - n;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            break;
        }
        if (!V2CLocalFileHandler.saveToFile(this.localCacheFile(), byArray)) {
            return null;
        }
        ArrayList arrayList = this.parseFile(true);
        this.saveLastLink(arrayList);
        return arrayList;
    }

    ArrayList parseLocal() {
        return this.parseFile(false);
    }

    ArrayList parseFile(boolean bl) {
        Document document;
        Object object;
        this.loadLastLink();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(this.localCacheFile());
        }
        catch (SAXException sAXException) {
            try {
                document = documentBuilderFactory.newDocumentBuilder().parse(new Skip8InputStream(this.localCacheFile()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        object = document.getDocumentElement();
        String string = object.getTagName();
        if (string != null) {
            if (string.equals("rdf:RDF")) {
                return this.parseRSS10((Element)object, bl);
            }
            if (string.equals("rss")) {
                return this.parseRSS09((Element)object, bl);
            }
            if (string.equals("feed")) {
                return this.parseAtom((Element)object, bl);
            }
        }
        return null;
    }

    ArrayList parseAtom(Element element, boolean bl) {
        if (bl) {
            this.extractChannelProperty(element);
        }
        NodeList nodeList = element.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = nodeList.getLength();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element2;
            String string;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (string = (element2 = (Element)node).getTagName()) == null || !string.equals("entry")) continue;
            stringBuffer.setLength(0);
            Object object2 = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            V2CRSSEntry v2CRSSEntry = new V2CRSSEntry();
            NodeList nodeList2 = element2.getChildNodes();
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                Object object3;
                Element element3;
                String string5;
                object = nodeList2.item(j);
                if (!(object instanceof Element) || (string5 = (element3 = (Element)object).getTagName()) == null) continue;
                if (string5.equals("link")) {
                    if (object2 != null || (object3 = element3.getAttribute("href")) == null) continue;
                    object2 = object3;
                    continue;
                }
                object3 = element3.getFirstChild();
                if (object3 == null) continue;
                if (string5.equals("title")) {
                    v2CRSSEntry.setTitle(V2CResItem.replaceEscapes(object3.getNodeValue()));
                    continue;
                }
                if (string5.equals("updated")) {
                    string3 = object3.getNodeValue();
                    continue;
                }
                if (string5.equals("published")) {
                    string2 = object3.getNodeValue();
                    continue;
                }
                if (string5.equals("dc:subject")) {
                    v2CRSSEntry.setSubject(object3.getNodeValue());
                    continue;
                }
                if (string5.equals("modified")) {
                    string4 = object3.getNodeValue();
                    continue;
                }
                if (string5.equals("id")) continue;
                stringBuffer.append('[');
                stringBuffer.append(string5);
                stringBuffer.append("] ");
                String string6 = object3.getNodeValue();
                if (string6 != null) {
                    stringBuffer.append(V2CResItem.replaceEscapes(string6));
                }
                stringBuffer.append(' ');
            }
            if (object2 == null) {
                object2 = element2.getAttribute("rdf:about");
            }
            if (object2 != null) {
                v2CRSSEntry.setURL((String)object2);
                if (!this.hsLastLinks.contains(object2)) {
                    v2CRSSEntry.setNew(true);
                }
            }
            if (string3 == null && (string3 = string2) == null) {
                string3 = string4;
            }
            if (string3 != null) {
                v2CRSSEntry.setDate(string3);
            }
            if (stringBuffer.length() > 0) {
                v2CRSSEntry.setOther(stringBuffer.toString());
            }
            Object[] objectArray = new Object[]{String.valueOf(n2 + 1), v2CRSSEntry.getSubject(), v2CRSSEntry.getTitle(), (object = v2CRSSEntry.getDate()) != null ? dfDate.format((Date)object) : null, v2CRSSEntry.getOther(), v2CRSSEntry};
            arrayList.add(objectArray);
            ++n2;
        }
        return arrayList;
    }

    ArrayList parseRSS09(Element element, boolean bl) {
        String string = element.getAttribute("version");
        if (string == null) {
            return null;
        }
        if (string.equals("0.91")) {
            return this.parseRSS091(element, bl);
        }
        if (string.equals("2.0")) {
            return this.parseRSS091(element, bl);
        }
        return null;
    }

    ArrayList parseRSS091(Element element, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        Element element2 = null;
        for (int i = 0; i < n; ++i) {
            Element element3;
            String string;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (string = (element3 = (Element)node).getTagName()) == null || !string.equals("channel")) continue;
            element2 = element3;
            break;
        }
        if (element2 == null) {
            return null;
        }
        if (bl) {
            this.extractChannelProperty(element2);
        }
        return this.parseRSS10(element2, false);
    }

    ArrayList parseRSS10(Element element, boolean bl) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        NodeList nodeList = element.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = nodeList.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element2;
            String string;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (string = (element2 = (Element)node).getTagName()) == null) continue;
            if (string.equals("channel")) {
                if (!bl) continue;
                this.extractChannelProperty(element2);
                continue;
            }
            if (!string.equals("item")) continue;
            stringBuffer.setLength(0);
            String string2 = null;
            V2CRSSEntry v2CRSSEntry = new V2CRSSEntry();
            NodeList nodeList2 = element2.getChildNodes();
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                Node node2;
                Element element3;
                String string3;
                object = nodeList2.item(j);
                if (!(object instanceof Element) || (string3 = (element3 = (Element)object).getTagName()) == null || (node2 = element3.getFirstChild()) == null) continue;
                if (string3.equals("title")) {
                    v2CRSSEntry.setTitle(V2CResItem.replaceEscapes(node2.getNodeValue()));
                    continue;
                }
                if (string3.equals("link")) {
                    string2 = node2.getNodeValue();
                    continue;
                }
                if (string3.equals("dc:subject")) {
                    v2CRSSEntry.setSubject(node2.getNodeValue());
                    continue;
                }
                if (string3.equals("dc:date")) {
                    v2CRSSEntry.setDate(node2.getNodeValue());
                    continue;
                }
                if (string3.equals("pubDate")) {
                    v2CRSSEntry.setDate(node2.getNodeValue());
                    continue;
                }
                stringBuffer.append('[');
                stringBuffer.append(string3);
                stringBuffer.append("] ");
                String string4 = node2.getNodeValue();
                if (string4 != null) {
                    stringBuffer.append(V2CResItem.replaceEscapes(string4));
                }
                stringBuffer.append(' ');
            }
            if (string2 == null) {
                string2 = element2.getAttribute("rdf:about");
            }
            if (string2 != null) {
                v2CRSSEntry.setURL(string2);
                if (!this.hsLastLinks.contains(string2)) {
                    v2CRSSEntry.setNew(true);
                }
            }
            if (stringBuffer.length() > 0) {
                v2CRSSEntry.setOther(stringBuffer.toString());
            }
            Object[] objectArray = new Object[]{String.valueOf(n2 + 1), v2CRSSEntry.getSubject(), v2CRSSEntry.getTitle(), (object = v2CRSSEntry.getDate()) != null ? dfDate.format((Date)object) : null, v2CRSSEntry.getOther(), v2CRSSEntry};
            arrayList.add(objectArray);
            ++n2;
        }
        return arrayList;
    }

    void extractChannelProperty(Element element) {
        V2CProperty v2CProperty = this.getProperty();
        v2CProperty.clear();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            int n2;
            Element element2;
            String string;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element) || (string = (element2 = (Element)node2).getTagName()) == null) continue;
            if (string.equals("item") || string.equals("entry")) break;
            boolean bl = false;
            for (n2 = 0; n2 < slChannelElements.length; ++n2) {
                if (!string.equals(slChannelElements[n2])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (n2 = 0; n2 < slChannelNameSpaces.length; ++n2) {
                    if (!string.startsWith(slChannelNameSpaces[n2])) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl || (node = element2.getFirstChild()) == null) continue;
            v2CProperty.put(string, V2CMiscUtil.escapeNewLine(node.getNodeValue()));
        }
        v2CProperty.putLong(sHTTPDateKey, this.lDate);
        v2CProperty.putLong(sHTTPLastModifiedKey, this.lLastModified);
    }

    public V2CProperty getProperty() {
        if (this.vpProperty == null) {
            this.vpProperty = new V2CProperty(this.getPropertyFile(), this, null);
        }
        return this.vpProperty;
    }

    void open(boolean bl, String string) {
        if (string == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.equals("ON")) {
            bl2 = true;
        } else if (string.equals("BN")) {
            bl2 = true;
            bl3 = true;
        }
        this.open(bl, bl2, bl3, false);
    }

    void open(boolean bl, boolean bl2, boolean bl3) {
        this.open(bl, bl2, false, bl3);
    }

    void open(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl4) {
            V2CMiscUtil.openLinkWithWebBrowser(this.sURL, bl2, bl4, false, false);
        } else if (bl3) {
            V2CRSSEntryList.openRSSBG(this, bl);
        } else {
            V2CRSSEntryList.openRSS(this, bl, bl2);
        }
    }

    void setName(String string) {
        this.sName = string;
    }

    String getName() {
        return this.sName;
    }

    String getURLString() {
        return this.sURL;
    }

    public String getLevelString(boolean bl) {
        return bl ? "RSS [ " + this.sName + " ]" : "RSS";
    }

    public String getPropertyClassString() {
        return "RSS";
    }

    public String toString() {
        return this.sName;
    }

    static class Skip8InputStream
    extends FileInputStream {
        Skip8InputStream(File file) throws FileNotFoundException, IOException {
            super(file);
        }

        public int read() throws IOException {
            int n = super.read();
            return n != 8 ? n : 32;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    if (byArray[n + i] != 8) continue;
                    byArray[n + i] = 32;
                }
            }
            return n3;
        }

        public boolean markSupported() {
            return false;
        }
    }

    static class ClassStateSaver
    extends V2CClassStateSaver {
        ClassStateSaver(int n) {
            super(n);
        }

        public void doSaveState() {
            V2CRSSItem.saveURL2Num();
        }
    }
}

