/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CSSColor {
    private static final boolean bDbg = false;
    static final int FG = 1;
    static final int BG = 2;
    static final int BOOKMARK = 3;
    static final int NEWMARK = 4;
    static final int PREVIEWMARK = 5;
    static final int SEPARATOR = 6;
    int iColorIndex;
    Color cColor;
    boolean bImportant;
    private static Pattern pSharpColor = Pattern.compile("[\\dA-Fa-f]+");
    private static Pattern pRGBAColor = Pattern.compile("rgba?\\(\\s*(\\d+%?)\\s*,\\s*(\\d+%?)\\s*,\\s*(\\d+%?)\\s*(?:,\\s*([\\d.]+%?)\\s*)?\\)");
    private static Pattern pUserDefinedColor = Pattern.compile("usc\\(\\s*(\\w+)\\s*\\)");
    private static Pattern pNamedColor = Pattern.compile("\\p{Alpha}\\p{Alnum}+");

    static V2CSSColor parseColor(String string) {
        V2CSSColor[] v2CSSColorArray = V2CSSColor.parseColorArray(string, 1);
        return v2CSSColorArray != null ? v2CSSColorArray[0] : null;
    }

    static V2CSSColor[] parseColorArray(String string, int n) {
        Matcher matcher = pSharpColor.matcher(string);
        V2CSSColor[] v2CSSColorArray = new V2CSSColor[n];
        int n2 = string.length();
        int n3 = 0;
        int n4 = -1;
        block2: for (int i = 0; i < n2; ++i) {
            int n5;
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            V2CSSColor v2CSSColor = null;
            if (c == '!') {
                boolean bl = false;
                if (n2 >= i + 10 && string.regionMatches(i + 1, "important", 0, 9)) {
                    if (n2 > i + 10) {
                        if (Character.isWhitespace(string.charAt(i + 10))) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                if (!bl) break;
                n4 = n3;
                i += 9;
            } else if (c == '#') {
                int n6 = i + 1;
                if (!matcher.find(n6) || matcher.start() != n6) break;
                n5 = matcher.end();
                int n7 = n5 - n6;
                Color color = V2CSwingUtil.parseHexColorString(string, n6, n5, true);
                if (color != null) {
                    v2CSSColor = new V2CSSColor(color);
                }
                i = n5 - 1;
            } else {
                Matcher matcher2;
                if (c == 'r') {
                    Matcher matcher3 = pRGBAColor.matcher(string);
                    if (matcher3.find(i) && matcher3.start() == i) {
                        n5 = matcher3.groupCount();
                        if (n5 != 4) break;
                        boolean bl = true;
                        int n8 = 0;
                        for (int j = 0; j < 4; ++j) {
                            int n9;
                            boolean bl2;
                            String string2 = matcher3.group(j + 1);
                            if (string2 == null) {
                                if (j < 3) break block2;
                                bl = false;
                                break;
                            }
                            int n10 = string2.length();
                            if (n10 == 0) break block2;
                            boolean bl3 = bl2 = string2.charAt(n10 - 1) == '%';
                            if (j < 3) {
                                n9 = V2CMiscUtil.parseInt(string2, 0, bl2 ? n10 - 1 : n10, -1);
                            } else if (string2.indexOf(46) < 0) {
                                n9 = V2CMiscUtil.parseInt(string2, 0, bl2 ? n10 - 1 : n10, -1);
                                if (n9 == 1) {
                                    n9 = 255;
                                }
                            } else {
                                float f;
                                try {
                                    f = Float.parseFloat(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    break block2;
                                }
                                n9 = (int)(f * 255.0f);
                            }
                            if (n9 < 0) break block2;
                            if (bl2) {
                                n9 = (int)((float)n9 * 2.55f);
                            }
                            if (n9 > 255) {
                                n9 = 255;
                            }
                            n8 = n8 << 8 | n9;
                        }
                        if (string.charAt(i + 3) != (bl ? (char)'a' : '(')) break;
                        if (bl) {
                            n8 = n8 << 24 | n8 >>> 8;
                        }
                        v2CSSColor = new V2CSSColor(new Color(n8, bl));
                        i = matcher3.end() - 1;
                    }
                } else if (c == 'u' && (matcher2 = pUserDefinedColor.matcher(string)).find(i) && matcher2.start() == i) {
                    String string3 = string.substring(matcher2.start(1), matcher2.end(1));
                    int n11 = -1;
                    if (string3.equals("FG")) {
                        n11 = 1;
                    } else if (string3.equals("BG")) {
                        n11 = 2;
                    } else if (string3.equals("BookMark")) {
                        n11 = 3;
                    } else if (string3.equals("NewMark")) {
                        n11 = 4;
                    } else if (string3.equals("PreviewMark")) {
                        n11 = 5;
                    } else if (string3.equals("Separator")) {
                        n11 = 6;
                    }
                    if (n11 >= 0) {
                        v2CSSColor = new V2CSSColor(n11);
                    }
                    i = matcher2.end() - 1;
                }
                if (v2CSSColor == null) {
                    Matcher matcher4 = pNamedColor.matcher(string);
                    if (!matcher4.find(i) || matcher4.start() != i) break;
                    int n12 = matcher4.end();
                    Color color = V2CSwingUtil.parseColorName(string.substring(i, n12), false);
                    if (color != null) {
                        v2CSSColor = new V2CSSColor(color);
                    }
                    i = n12 - 1;
                }
            }
            if (v2CSSColor == null || n3 >= n) break;
            v2CSSColorArray[n3++] = v2CSSColor;
        }
        if (n == 1 && n3 == 1 && n4 == 1) {
            v2CSSColorArray[0].setImportant();
        }
        return v2CSSColorArray;
    }

    public V2CSSColor(Color color) {
        this.cColor = color;
    }

    public V2CSSColor(int n) {
        this.iColorIndex = n;
    }

    void setImportant() {
        this.bImportant = true;
    }

    boolean isImportant() {
        return this.bImportant;
    }

    Color getColor() {
        if (this.cColor != null) {
            return this.cColor;
        }
        switch (this.iColorIndex) {
            case 1: {
                return V2CThreadStyle.getDefaultForeground();
            }
            case 2: {
                return V2CThreadStyle.getThreadBackground();
            }
            case 3: {
                return V2CAbstractThreadPanel.cBookMarkBG;
            }
            case 4: {
                return V2CAbstractThreadPanel.cNewMarkBG;
            }
            case 5: {
                return V2CAbstractThreadPanel.cWritePreviewMarkBG;
            }
            case 6: {
                return new Color(16747520);
            }
        }
        return null;
    }
}

