/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import org.monazilla.v2c.V2CMiscUtil;

public class V2CSSDistance {
    static final int MASK_NOABSUNIT = 1;
    static final int MASK_FONTSIZE = 4;
    static final int MASK_NAME = 8;
    static final int MASK_AUTO = 16;
    static final int MASK_PERCENT = 32;
    static final int MASK_NEGATIVE = 64;
    static final int MASK_NOUNIT = 128;
    static final int UNIT_EM = 0;
    static final int UNIT_EX = 1;
    static final int UNIT_PX = 2;
    static final int UNIT_CM = 3;
    static final int UNIT_MM = 4;
    static final int UNIT_IN = 5;
    static final int UNIT_PT = 6;
    static final int UNIT_PC = 7;
    static final int UNIT_ICONWIDTH = 8;
    static final int UNIT_ICONHEIGHT = 9;
    private static final int MAX_ABSUNIT = 9;
    static final int UNIT_PERCENT = 10;
    static final int UNIT_FONTSIZE = 11;
    static final int UNIT_AUTO = 12;
    static final int UNIT_NONE = 13;
    static final int FS_XXSMALL = 0;
    static final int FS_XSMALL = 1;
    static final int FS_SMALL = 2;
    static final int FS_MEDIUM = 3;
    static final int FS_LARGE = 4;
    static final int FS_XLARGE = 5;
    static final int FS_XXLARGE = 6;
    static final int FS_SMALLER = 7;
    static final int FS_LARGER = 8;
    static final int DIR_ANY = 0;
    static final int DIR_H = 1;
    static final int DIR_V = 2;
    float fValue;
    int nUnit;
    int nDirection;

    static V2CSSDistance parse(String string) {
        return V2CSSDistance.parse(string, 64);
    }

    static V2CSSDistance parse(String string, int n) {
        boolean bl;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = (n & 8) != 0;
        boolean bl5 = (n & 0x10) != 0;
        boolean bl6 = (n & 0x20) != 0;
        boolean bl7 = (n & 0x40) != 0;
        boolean bl8 = bl = (n & 0x80) != 0;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (bl7) {
            if (c == '-') {
                string = string.substring(1);
                if (--n2 == 0) {
                    return null;
                }
                c = string.charAt(0);
            } else {
                bl7 = false;
            }
        }
        if (n2 == 1) {
            if (bl) {
                return c >= '0' && c <= '9' ? new V2CSSDistance(c - 48, 13) : null;
            }
            return c == '0' ? new V2CSSDistance(0.0f, 0) : null;
        }
        if (c >= '0' && c <= '9' || c == '.') {
            float f;
            char c2 = string.charAt(n2 - 2);
            char c3 = string.charAt(n2 - 1);
            int n3 = -1;
            if (c3 >= '0' && c3 <= '9' || c3 == '.') {
                if (!bl) {
                    return null;
                }
                n3 = 13;
            } else if (c3 == '%') {
                if (!bl6) {
                    return null;
                }
                n3 = 10;
            } else if (c2 == 'p') {
                if (c3 == 'x') {
                    n3 = 2;
                } else if (c3 == 't') {
                    n3 = 6;
                } else if (c3 == 'c') {
                    n3 = 7;
                }
            } else if (c2 == 'e') {
                if (c3 == 'm') {
                    n3 = 0;
                } else if (c3 == 'x') {
                    n3 = 1;
                }
            } else if (c2 == 'c' && c3 == 'm') {
                n3 = 3;
            } else if (c2 == 'm' && c3 == 'm') {
                n3 = 4;
            } else if (c2 == 'i' && c3 == 'n') {
                n3 = 5;
            } else if (c2 == 'Z') {
                if (c3 == 'H') {
                    n3 = 9;
                } else if (c3 == 'W') {
                    n3 = 8;
                }
            }
            if (n3 < 0 || bl2 && n3 <= 9) {
                return null;
            }
            int n4 = n3 == 13 ? n2 : (n3 == 10 ? n2 - 1 : n2 - 2);
            if (string.indexOf(46) < 0) {
                int n5 = V2CMiscUtil.parseInt(string, 0, n4, Integer.MIN_VALUE);
                if (n5 == Integer.MIN_VALUE) {
                    return null;
                }
                f = n5;
            } else {
                try {
                    f = Float.parseFloat(string.substring(0, n4));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return new V2CSSDistance(bl7 ? -f : f, n3);
        }
        if (bl7) {
            return null;
        }
        if (bl3) {
            int n6 = -1;
            if (string.equals("xx-small")) {
                n6 = 0;
            } else if (string.equals("x-small")) {
                n6 = 1;
            } else if (string.equals("small")) {
                n6 = 2;
            } else if (string.equals("medium")) {
                n6 = 3;
            } else if (string.equals("large")) {
                n6 = 4;
            } else if (string.equals("x-large")) {
                n6 = 5;
            } else if (string.equals("xx-large")) {
                n6 = 6;
            } else if (string.equals("smaller")) {
                n6 = 7;
            } else if (string.equals("larger")) {
                n6 = 8;
            }
            if (n6 >= 0) {
                return new V2CSSDistance(0.0f, 11, n6);
            }
        }
        if (bl4) {
            if (string.equals("left")) {
                return new V2CSSDistance(0.0f, 10, 1);
            }
            if (string.equals("top")) {
                return new V2CSSDistance(0.0f, 10, 2);
            }
            if (string.equals("right")) {
                return new V2CSSDistance(100.0f, 10, 1);
            }
            if (string.equals("bottom")) {
                return new V2CSSDistance(100.0f, 10, 2);
            }
            if (string.equals("center")) {
                return new V2CSSDistance(50.0f);
            }
        }
        if (bl5 && string.equals("auto")) {
            return new V2CSSDistance(0.0f, 12);
        }
        return null;
    }

    public V2CSSDistance(float f) {
        this(f, 10, 0);
    }

    public V2CSSDistance(float f, int n) {
        this(f, n, 0);
    }

    public V2CSSDistance(float f, int n, int n2) {
        if (n == 10) {
            f /= 100.0f;
        }
        this.fValue = f;
        this.nUnit = n;
        this.nDirection = n2;
    }

    float getValue() {
        return this.fValue;
    }

    boolean isNegative() {
        return this.fValue < 0.0f;
    }

    int getUnit() {
        return this.nUnit;
    }

    boolean isPercent() {
        return this.nUnit == 10;
    }

    boolean isFontKeyword() {
        return this.nUnit == 11;
    }

    int getFontSize() {
        return this.nDirection;
    }

    int getDirection() {
        return this.nDirection;
    }
}

