/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CScrollablePopupMenu
extends JPopupMenu
implements ActionListener,
MouseListener,
MouseMotionListener {
    private static MWListener vMWListener;
    private Timer tScrollTimer;
    private boolean bOnTop;
    private Window wPopupWindow;

    static MWListener getMouseWheelListnerInstance() {
        MWListener mWListener = vMWListener;
        if (vMWListener == null) {
            vMWListener = mWListener = new MWListener();
        }
        return mWListener;
    }

    static void addMWListener(JMenu jMenu) {
        if (jMenu != null) {
            V2CScrollablePopupMenu.addMWListener(jMenu.getPopupMenu());
        }
    }

    static void addMWListener(JPopupMenu jPopupMenu) {
        if (jPopupMenu != null) {
            jPopupMenu.addMouseWheelListener(V2CScrollablePopupMenu.getMouseWheelListnerInstance());
        }
    }

    public V2CScrollablePopupMenu() {
        this.setLightWeightPopupEnabled(false);
        this.addMouseWheelListener(V2CScrollablePopupMenu.getMouseWheelListnerInstance());
    }

    boolean isScrolling() {
        return this.tScrollTimer != null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            Timer timer = (Timer)object;
            if (timer != this.tScrollTimer) {
                this.tScrollTimer = null;
                return;
            }
            Window window = this.wPopupWindow;
            if (window == null) {
                this.tScrollTimer = null;
                return;
            }
            Point point = V2CSwingUtil.getMouseLocationOnScreen(null);
            Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
            Rectangle rectangle2 = window.getBounds();
            int n = point.x;
            int n2 = point.y;
            if (n <= rectangle2.x || n >= rectangle2.x + rectangle2.width || (this.bOnTop ? n2 >= rectangle.y + 5 : n2 <= rectangle.y + rectangle.height - 5)) {
                this.tScrollTimer = null;
                return;
            }
            if (this.bOnTop) {
                if (rectangle2.y >= rectangle.y) {
                    this.tScrollTimer = null;
                    return;
                }
                rectangle2.y = Math.min(rectangle.y, rectangle2.y + 20);
            } else {
                if (rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
                    this.tScrollTimer = null;
                    return;
                }
                rectangle2.y = Math.max(rectangle.y + rectangle.height - rectangle2.height, rectangle2.y - 20);
            }
            window.setBounds(rectangle2);
            timer.start();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMovedAction(mouseEvent);
    }

    boolean mouseMovedAction(MouseEvent mouseEvent) {
        Timer timer;
        boolean bl;
        if (V2CApp.javaVersionLessThan(1, 5) && !V2CApp.isMacintosh() || this.tScrollTimer != null) {
            return false;
        }
        Component component = mouseEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null || window instanceof JFrame) {
            return false;
        }
        this.wPopupWindow = window;
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(mouseEvent.getPoint());
        Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseEvent);
        int n = point.y;
        if (n < rectangle.y + 5) {
            bl = true;
        } else if (n > rectangle.y + rectangle.height - 5) {
            bl = false;
        } else {
            return false;
        }
        this.bOnTop = bl;
        Rectangle rectangle2 = window.getBounds();
        if (bl ? rectangle2.y >= rectangle.y : rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return false;
        }
        this.tScrollTimer = timer = new Timer(50, this);
        timer.setRepeats(false);
        timer.start();
        return true;
    }

    static class MWListener
    implements MouseWheelListener {
        MWListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Component component = mouseWheelEvent.getComponent();
            Container container = component.getParent();
            int n = 0;
            while (container != null) {
                if (!((container = container.getParent()) instanceof JRootPane) || ++n <= 1) continue;
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window == null || window instanceof JFrame) {
                return;
            }
            mouseWheelEvent.consume();
            int n2 = mouseWheelEvent.getUnitsToScroll();
            if (V2CApp.isMacintosh()) {
                if (n2 > 0) {
                    n2 = Math.max(n2 / 3, 1);
                } else if (n2 < 0) {
                    n2 = Math.min(n2 / 3, -1);
                }
            }
            Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseWheelEvent);
            Rectangle rectangle = window.getBounds();
            int n3 = point.y;
            if (n2 > 0) {
                int n4 = rectangle.y + rectangle.height - 10;
                if (n4 <= n3) {
                    return;
                }
                rectangle.y += Math.max(-10 * n2, n3 - n4);
            } else {
                int n5 = rectangle.y + 10;
                if (n5 >= n3) {
                    return;
                }
                rectangle.y += Math.min(-10 * n2, n3 - n5);
            }
            window.setBounds(rectangle);
        }
    }
}

