/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadNGWordSet;
import org.monazilla.v2c.V2CThreadTitleKeywordSet;

public class V2CSimilarThreadFilter {
    static final int MODE_NORMAL = 0;
    static final int MODE_AUTO = 1;
    static final int MODE_OLD = 2;
    final V2CThreadItem tiOriginal;
    final HashMap hmNGThreads;
    final V2CThreadNGWordSet vThreadNGWordSet;
    final V2CThreadTitleKeywordSet vThreadTitleKeywordSet;
    final String sTitle;
    final String sTitle2;
    int[] ilIndex;

    static V2CSimilarThreadFilter createInstance(V2CThreadItem v2CThreadItem) {
        if (v2CThreadItem == null) {
            return null;
        }
        V2CSimilarThreadFilter v2CSimilarThreadFilter = new V2CSimilarThreadFilter(v2CThreadItem);
        return v2CSimilarThreadFilter.canFilter() ? v2CSimilarThreadFilter : null;
    }

    private V2CSimilarThreadFilter(V2CThreadItem v2CThreadItem) {
        this.tiOriginal = v2CThreadItem;
        V2CBoardItem v2CBoardItem = v2CThreadItem.getBoardItem();
        this.hmNGThreads = v2CBoardItem.getNGThreads();
        this.vThreadNGWordSet = v2CBoardItem.getThreadNGWordSet();
        this.vThreadTitleKeywordSet = v2CBoardItem.getThreadTitleKeywordSet();
        this.sTitle = V2CSimilarThreadFilter.normalizeTitle(v2CThreadItem.getTitle());
        this.sTitle2 = V2CThreadItem.guessNextThreadTitle(this.sTitle);
    }

    boolean canFilter() {
        return this.sTitle != null && this.sTitle.length() > 0;
    }

    static String normalizeTitle(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = string;
        StringBuffer stringBuffer = null;
        int n3 = 0;
        int n4 = 0;
        while ((n3 = string.indexOf(12304, n3)) >= 0 && (n2 = string.indexOf(12305, n3)) >= 0) {
            n = string.indexOf(12304, n3 + 1);
            if (n > n3 && n < n2) {
                n3 = n;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.delete(n3 - n4, n2 + 1 - n4);
            n4 += n2 + 1 - n3;
            n3 = n2 + 1;
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        n2 = 0;
        for (n = string.length() - 1; n >= 0; --n) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\u3000') continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.deleteCharAt(n);
            n2 = 1;
        }
        if (n2 != 0) {
            string = stringBuffer.toString();
        }
        if (string.length() <= 1) {
            string = string2;
        }
        return V2CMiscUtil.normalizeCase(string);
    }

    V2CThreadItem[] filterPastThread(V2CThreadItem[] v2CThreadItemArray) {
        return this.filter(v2CThreadItemArray, 2);
    }

    V2CThreadItem[] filter(V2CThreadItem[] v2CThreadItemArray, int n) {
        int n2;
        V2CThreadItem v2CThreadItem;
        V2CThreadItem v2CThreadItem2 = this.tiOriginal;
        if (v2CThreadItem2 == null || v2CThreadItemArray == null || v2CThreadItemArray.length == 0) {
            return new V2CThreadItem[0];
        }
        boolean bl = n == 2;
        int n3 = v2CThreadItem2.getNRes();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < v2CThreadItemArray.length; ++i) {
            String string;
            V2CThreadItem v2CThreadItem3 = v2CThreadItemArray[i];
            if (v2CThreadItem3 == null || !bl && v2CThreadItem3 == v2CThreadItem2 || !bl && !v2CThreadItem3.isActive() || v2CThreadItem3.isThread924() || !v2CThreadItem3.getThreadVisibility(this.hmNGThreads, this.vThreadNGWordSet, this.vThreadTitleKeywordSet) || (string = v2CThreadItem3.getTitle()) == null) continue;
            if (string.length() > n4) {
                n4 = string.length();
            }
            v2CThreadItemArray[n5++] = v2CThreadItem3;
        }
        if (n5 == 0) {
            return new V2CThreadItem[0];
        }
        this.ilIndex = new int[n4];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = v2CThreadItem2.getBirthday();
        for (int i = 0; i < n5; ++i) {
            v2CThreadItem = v2CThreadItemArray[i];
            if (bl && v2CThreadItem.getNResGet() <= 0) continue;
            n2 = this.calcScore(v2CThreadItem);
            if (!bl) {
                if (v2CThreadItem.getNRes() >= n3) {
                    int n6 = n2 = n == 0 ? 2 * n2 / 3 : 0;
                }
                if (v2CThreadItem.getBirthday() < l - 86400000L) {
                    n2 = 2 * n2 / 3;
                }
            }
            if (n2 <= 0) continue;
            arrayList.add(new ThreadScore(v2CThreadItem, n2));
        }
        if (arrayList.size() == 0) {
            return new V2CThreadItem[0];
        }
        Object[] objectArray = arrayList.toArray(new ThreadScore[0]);
        Arrays.sort(objectArray);
        arrayList.clear();
        v2CThreadItem = null;
        n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (i == 0) {
                n2 = Math.max(bl ? 2 * ((ThreadScore)object).nScore / 3 : ((ThreadScore)object).nScore / 3, 1);
            } else if (((ThreadScore)object).nScore < n2) break;
            arrayList.add(((ThreadScore)object).viThread);
        }
        return arrayList.toArray(new V2CThreadItem[0]);
    }

    private int calcScore(V2CThreadItem v2CThreadItem) {
        String string = V2CSimilarThreadFilter.normalizeTitle(v2CThreadItem.getTitle());
        return Math.max(this.calcScore(string, this.sTitle), this.calcScore(string, this.sTitle2));
    }

    private int calcScore(String string, String string2) {
        if (string2 == null) {
            return Integer.MIN_VALUE;
        }
        int[] nArray = this.ilIndex;
        Arrays.fill(nArray, -1);
        int n = -1;
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = 0;
        int n5 = 1;
        block0: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (n < n3 - 1) {
                if (string.charAt(n + 1) == c) {
                    nArray[n + 1] = i;
                    ++n;
                    n4 += n5;
                    if (n5 >= 3) continue;
                    ++n5;
                    continue;
                }
                n5 = 1;
            }
            for (int j = 0; j < n3; ++j) {
                if (nArray[j] >= 0 || string.charAt(j) != c) continue;
                nArray[j] = i;
                n = j;
                continue block0;
            }
            n = -1;
        }
        return n4;
    }

    private static class ThreadScore
    implements Comparable {
        final V2CThreadItem viThread;
        final int nScore;

        ThreadScore(V2CThreadItem v2CThreadItem, int n) {
            this.viThread = v2CThreadItem;
            this.nScore = n;
        }

        public int compareTo(Object object) {
            ThreadScore threadScore = (ThreadScore)object;
            int n = threadScore.nScore - this.nScore;
            if (n != 0) {
                return n;
            }
            return threadScore.viThread.getNRes() - this.viThread.getNRes();
        }
    }
}

