/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.monazilla.v2c.V2CAAListMenu;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBaseFont;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CJSE6Util;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNoBeepDeletePrevAction;
import org.monazilla.v2c.V2CNoBeepTextField;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CShortPhraseMenu;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CWinComboBox;
import org.monazilla.v2c.V2CWinWOFileChooser;
import org.monazilla.v2c.mac.V2CMacApplicationHandler;

public class V2CSwingUtil {
    static final boolean bAAText;
    private static LookAndFeel lafLastLaf;
    private static boolean bSynth;
    static boolean bVistaTableHeader;
    static Color cTransparent;
    static Color cMacTextShadow;
    private static final HashMap hmIcons;
    static final boolean bListenToComboBoxButton;
    static Timer tDragScrollTimer;
    static ActionListener vDragScrollTimerOwner;
    static final HashMap hmColorNames;
    static boolean bCreateFileChooserTried;
    static boolean bUseWinWOFileChooser;
    static Reference refGraphicsConfigs;
    static Rectangle rTotalBounds;
    static final String sUIManagerTableFontKey = "Table.font";
    private static final int nDefAdditionalRowHeight = 4;
    static int nAdditionalRowHeight;
    private static final String sWinXPSThemeActive = "win.xpstyle.themeActive";
    static BufferedImage biUnselectedCheckBox;
    static BufferedImage biSelectedCheckBox;
    private static boolean bShouldUseCoveredComboBox;
    private static boolean bShouldUseCoveredComboBoxChecked;

    static String getClipboardText() {
        Transferable transferable;
        String string = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null && (transferable = clipboard.getContents(null)) != null) {
            try {
                Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                if (object instanceof String) {
                    string = (String)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static void setRenderingHint(Graphics2D graphics2D) {
        if (bAAText) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            V2CMain.addFontDesktopHints(graphics2D);
        }
    }

    static void restoreTreeStates(JTree jTree, String string) {
        String string2 = V2CMain.getUserProperty().get(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || string3.length() == 0) continue;
            if (string3.indexOf(43) >= 0) {
                V2CSwingUtil.restoreViewPosition((V2CPanel)((Object)jTree), string3);
                continue;
            }
            V2CSwingUtil.restoreExpandedFolder(jTree, string3);
        }
    }

    static void restoreViewPosition(V2CPanel v2CPanel, String string) {
        int n = string.indexOf(43);
        if (n <= 0) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = Integer.parseInt(string.substring(0, n));
            n3 = Integer.parseInt(string.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 < 0 || n3 < 0) {
            return;
        }
        Point point = v2CPanel.getViewPosition();
        if (point != null) {
            point.y = n3;
        }
    }

    static void restoreExpandedFolder(JTree jTree, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            return;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode);
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(58, n)) <= 0) {
                if (n < string.length()) {
                    n2 = string.length();
                } else {
                    if (string.length() < n) break;
                    return;
                }
            }
            try {
                int n3 = Integer.parseInt(string.substring(n, n2));
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
            treePath = treePath.pathByAddingChild(defaultMutableTreeNode);
            n = n2 + 1;
        }
        jTree.expandPath(treePath);
    }

    static void saveTreeStates(JTree jTree, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        V2CSwingUtil.getTreeStateString(jTree, stringBuffer);
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        V2CMain.getUserProperty().put(string, stringBuffer.toString());
    }

    static void getTreeStateString(JTree jTree, StringBuffer stringBuffer) {
        V2CSwingUtil.getTreeStateString(jTree, stringBuffer, null);
    }

    static void getTreeStateString(JTree jTree, StringBuffer stringBuffer, String string) {
        Cloneable cloneable;
        TreeNode[] treeNodeArray;
        if (!(jTree instanceof V2CPanel)) {
            return;
        }
        Object object = jTree.getModel().getRoot();
        if (object == null) {
            return;
        }
        Enumeration<TreePath> enumeration = jTree.getExpandedDescendants(new TreePath(object));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                treeNodeArray = defaultMutableTreeNode.getPath();
                if (treeNodeArray == null || treeNodeArray.length <= 1) continue;
                if (string != null) {
                    stringBuffer.append(string);
                }
                cloneable = (DefaultMutableTreeNode)treeNodeArray[0];
                for (int i = 1; i < treeNodeArray.length; ++i) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treeNodeArray[i];
                    stringBuffer.append(((DefaultMutableTreeNode)cloneable).getIndex(defaultMutableTreeNode));
                    stringBuffer.append(':');
                    cloneable = defaultMutableTreeNode;
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == ':') {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                stringBuffer.append(',');
            }
        }
        int n = 0;
        int n2 = 0;
        treeNodeArray = SwingUtilities.getAncestorOfClass(JScrollPane.class, jTree);
        if (treeNodeArray != null) {
            cloneable = ((JScrollPane)treeNodeArray).getViewport().getViewPosition();
            n = ((Point)cloneable).x;
            n2 = ((Point)cloneable).y;
        } else {
            cloneable = ((V2CPanel)((Object)jTree)).getViewPosition();
            n = ((Point)cloneable).x;
            n2 = ((Point)cloneable).y;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(n);
        stringBuffer.append('+');
        stringBuffer.append(n2);
        stringBuffer.append(',');
    }

    static Timer startDragAutoScrollTimer(ActionListener actionListener) {
        V2CSwingUtil.stopDragAutoScrollTimer(actionListener, false);
        Timer timer = tDragScrollTimer;
        if (timer == null) {
            tDragScrollTimer = timer = new Timer(10, actionListener);
        } else {
            if (timer.isRunning()) {
                timer.stop();
            }
            if (vDragScrollTimerOwner != null) {
                timer.removeActionListener(vDragScrollTimerOwner);
            }
            timer.addActionListener(actionListener);
        }
        vDragScrollTimerOwner = actionListener;
        timer.start();
        return timer;
    }

    static void stopDragAutoScrollTimer(ActionListener actionListener, boolean bl) {
        Timer timer = tDragScrollTimer;
        if (timer != null) {
            if (timer.isRunning()) {
                timer.stop();
            }
            if (bl && vDragScrollTimerOwner != null) {
                timer.removeActionListener(vDragScrollTimerOwner);
                vDragScrollTimerOwner = null;
            }
        }
    }

    static void printParentClasses(Component component) {
        if (component == null) {
            return;
        }
        System.out.println("0: " + component.getClass());
        int n = 1;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            System.out.println(" " + n++ + ": " + container.getClass());
        }
    }

    static JScrollPane getParentScrollPane(Component component) {
        Container container = component.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane) {
            return (JScrollPane)container;
        }
        return null;
    }

    static boolean isEqual(Color color, Color color2) {
        return color != null ? color.equals(color2) : color2 == null;
    }

    static Color parseColorString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '#') {
            return V2CSwingUtil.parseColorName(string);
        }
        int n = string.length();
        if (n < 7) {
            return null;
        }
        if (string.charAt(1) == '#') {
            string = "#0" + string.substring(2, n - 1);
        }
        return V2CSwingUtil.parseHexColorString(string, 1, false);
    }

    static Color parseHexColorString(String string) {
        return V2CSwingUtil.parseHexColorString(string, 0, string.length(), false);
    }

    static Color parseHexColorString(String string, int n, boolean bl) {
        return V2CSwingUtil.parseHexColorString(string, n, string.length(), bl);
    }

    static Color parseHexColorString(String string, int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3;
        int n3 = n2 - n;
        if (n3 == 3) {
            bl3 = false;
            bl2 = false;
        } else if (n3 == 6) {
            bl3 = true;
            bl2 = false;
        } else if (n3 == 4) {
            bl3 = false;
            bl2 = true;
        } else if (n3 == 8) {
            bl3 = true;
            bl2 = true;
        } else {
            return null;
        }
        int n4 = V2CMiscUtil.parseHexInt(string, n, n2, 0);
        if (!bl3) {
            int n5 = n4 & 0xF000;
            int n6 = n4 & 0xF00;
            int n7 = n4 & 0xF0;
            int n8 = n4 & 0xF;
            n4 = n5 << 16 | n5 << 12 | n6 << 12 | n6 << 8 | n7 << 8 | n7 << 4 | n8 << 4 | n8;
        }
        if (bl2 && bl) {
            n4 = n4 << 24 | n4 >>> 8;
        }
        return new Color(n4, bl2);
    }

    static Color parseColorName(String string) {
        return V2CSwingUtil.parseColorName(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Color parseColorName(String string, boolean bl) {
        Serializable serializable = hmColorNames;
        synchronized (serializable) {
            if (hmColorNames.size() == 0) {
                V2CSwingUtil.fillColorNameHashMap();
            }
        }
        serializable = (Color)hmColorNames.get(string.toLowerCase());
        if (!bl || serializable != null) {
            return serializable;
        }
        return V2CSwingUtil.parseHexColorString(string, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void fillColorNameHashMap() {
        block19: {
            DataInputStream dataInputStream;
            BufferedInputStream bufferedInputStream;
            block18: {
                int n;
                HashMap hashMap = hmColorNames;
                hashMap.put("transparent", new Color(0, true));
                bufferedInputStream = V2CLocalFileHandler.getJarFileInputStream("org/monazilla/v2c/conf/color.dat");
                if (bufferedInputStream == null) {
                    return;
                }
                dataInputStream = null;
                dataInputStream = new DataInputStream(bufferedInputStream);
                while ((n = dataInputStream.readInt()) >= 0) {
                    String string = dataInputStream.readUTF();
                    hashMap.put(string, new Color(n));
                }
                Object var6_6 = null;
                if (dataInputStream == null) break block18;
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                break block19;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var6_7 = null;
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException iOException2) {}
                    } else {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException3) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    static String colorToString(Color color) {
        int n = ((color.getRed() << 8) + color.getGreen() << 8) + color.getBlue();
        int n2 = color.getAlpha();
        int n3 = 7;
        if (n2 != 255) {
            n |= n2 << 24;
            n3 = 9;
        }
        String string = Integer.toHexString(n);
        return "#00000000".substring(0, n3 - string.length()) + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImageIcon getItemIcon(String string, char c) {
        ImageIcon imageIcon;
        String string2 = string + '_' + c;
        Serializable serializable = hmIcons;
        synchronized (serializable) {
            imageIcon = V2CSwingUtil.getItemIcon(string2);
            if (imageIcon != null) {
                return imageIcon;
            }
        }
        serializable = V2CSwingUtil.getItemIcon(string);
        imageIcon = V2CSwingUtil.getItemIcon("Overlay_" + c);
        final ImageIcon imageIcon2 = new ImageIcon();
        if (SwingUtilities.isEventDispatchThread()) {
            V2CSwingUtil.overlayIcon(imageIcon2, (ImageIcon)serializable, imageIcon);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable((ImageIcon)serializable, imageIcon){
                    private final /* synthetic */ ImageIcon val$iib;
                    private final /* synthetic */ ImageIcon val$iim;
                    {
                        this.val$iib = imageIcon22;
                        this.val$iim = imageIcon3;
                    }

                    public void run() {
                        V2CSwingUtil.overlayIcon(imageIcon2, this.val$iib, this.val$iim);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        HashMap hashMap = hmIcons;
        synchronized (hashMap) {
            ImageIcon imageIcon3 = V2CSwingUtil.getItemIcon(string2);
            if (imageIcon3 != null) {
                return imageIcon3;
            }
            hmIcons.put(string2, imageIcon2);
        }
        return imageIcon2;
    }

    static ImageIcon createFavoriteIcon(ImageIcon imageIcon) {
        return V2CSwingUtil.createOverlayIcon(imageIcon, "Overlay_F");
    }

    static ImageIcon createUpdatingIcon(ImageIcon imageIcon) {
        return V2CSwingUtil.createOverlayIcon(imageIcon, "Overlay_U");
    }

    private static ImageIcon createOverlayIcon(final ImageIcon imageIcon, String string) {
        final ImageIcon imageIcon2 = V2CSwingUtil.getItemIcon(string);
        if (imageIcon2 == null) {
            return imageIcon;
        }
        final ImageIcon imageIcon3 = new ImageIcon();
        if (SwingUtilities.isEventDispatchThread()) {
            V2CSwingUtil.overlayIcon(imageIcon3, imageIcon, imageIcon2);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        V2CSwingUtil.overlayIcon(imageIcon3, imageIcon, imageIcon2);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return imageIcon3;
    }

    private static void overlayIcon(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        Image image;
        Object object;
        Image image2 = imageIcon2.getImage();
        if (image2 instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image2;
            object = bufferedImage.copyData(null);
            image = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.copyData(null), true, null);
        } else {
            image = V2CMain.v2cMain.createImage(imageIcon2.getIconWidth(), imageIcon2.getIconHeight());
        }
        boolean bl = false;
        if (image != null && (object = image.getGraphics()) != null) {
            bl = true;
            ((Graphics)object).drawImage(imageIcon2.getImage(), 0, 0, null);
            try {
                int n = Math.min(imageIcon2.getIconWidth(), imageIcon3.getIconWidth());
                int n2 = Math.min(imageIcon2.getIconHeight(), imageIcon3.getIconHeight());
                if (n > 0 && n2 > 0) {
                    ((Graphics)object).drawImage(imageIcon3.getImage(), 0, 0, n, n2, 0, 0, n, n2, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((Graphics)object).dispose();
        }
        if (bl) {
            imageIcon.setImage(image);
        }
    }

    public static ImageIcon getSystemIcon(String string) {
        return V2CSwingUtil.getSystemIcon(string, false);
    }

    public static ImageIcon getItemIcon(String string) {
        return V2CSwingUtil.getSystemIcon(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageIcon getSystemIcon(String string, boolean bl) {
        ImageIcon imageIcon;
        if (string == null || string.length() == 0) {
            return null;
        }
        HashMap hashMap = hmIcons;
        synchronized (hashMap) {
            imageIcon = (ImageIcon)hmIcons.get(string);
            if (imageIcon != null) {
                return imageIcon;
            }
            imageIcon = V2CLocalFileHandler.getSystemIcon(string, bl);
            if (imageIcon == null) {
                return null;
            }
            hmIcons.put(string, imageIcon);
        }
        return imageIcon;
    }

    static ImageIcon getSystemImage(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return V2CLocalFileHandler.getSystemImage(string);
    }

    static boolean needsConversion(BufferedImage bufferedImage) {
        return bufferedImage != null && V2CApp.javaVersionEqualOrGreaterThan(1, 5);
    }

    static BufferedImage convertToCompatibeImage(BufferedImage bufferedImage) {
        return V2CSwingUtil.convertToCompatibeImage(bufferedImage, null);
    }

    static BufferedImage convertToCompatibeImage(BufferedImage bufferedImage, final Color color) {
        if (!V2CSwingUtil.needsConversion(bufferedImage)) {
            return bufferedImage;
        }
        if (EventQueue.isDispatchThread()) {
            return V2CSwingUtil.doConvertToCompatibeImage(bufferedImage, color);
        }
        final BufferedImage[] bufferedImageArray = new BufferedImage[]{bufferedImage};
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    bufferedImageArray[0] = V2CSwingUtil.doConvertToCompatibeImage(bufferedImageArray[0], color);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedImageArray[0];
    }

    private static BufferedImage doConvertToCompatibeImage(BufferedImage bufferedImage, Color color) {
        GraphicsConfiguration graphicsConfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        bufferedImage = bufferedImage2;
        return bufferedImage;
    }

    static BufferedImage clipImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 <= 0 || n6 <= 0) {
            return null;
        }
        BufferedImage bufferedImage2 = V2CMain.v2cMain.getGraphicsConfiguration().createCompatibleImage(n5, n6, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n5, n6, n, n2, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    static char restrictMnemonic(char c) {
        if (c == ' ') {
            return c;
        }
        if (c == '\u0000' || c < '0' || c > 'z') {
            return '\u0000';
        }
        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 32);
        }
        return '\u0000';
    }

    static void addPopupToTextFields(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JTextField) {
                V2CPopupListener v2CPopupListener = new V2CPopupListener("TextComponent");
                v2CPopupListener.setRequestFocus(true);
                ((JTextField)component).addMouseListener(v2CPopupListener);
                continue;
            }
            if (!(component instanceof Container)) continue;
            V2CSwingUtil.addPopupToTextFields((Container)component);
        }
    }

    static void replaceDeletePrevAction(ActionMap actionMap) {
        if (actionMap == null) {
            return;
        }
        Object[] objectArray = actionMap.keys();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!"delete-previous".equals(objectArray[i])) continue;
                Action action = actionMap.get("delete-previous");
                if (action != null && !(action instanceof V2CNoBeepDeletePrevAction)) {
                    actionMap.put("delete-previous", new V2CNoBeepDeletePrevAction(action));
                }
                return;
            }
        }
        V2CSwingUtil.replaceDeletePrevAction(actionMap.getParent());
    }

    static void disableQuaquaTextComponentPopup(JTextComponent jTextComponent) {
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.isQuaquaInstalled()) {
            jTextComponent.putClientProperty("Quaqua.TextComponent.showPopup", Boolean.FALSE);
        }
    }

    static JFileChooser createFileChooser() {
        return V2CSwingUtil.createFileChooser(null);
    }

    static JFileChooser createFileChooser(File file) {
        if (!V2CApp.isWinType()) {
            return new JFileChooser(file);
        }
        if (bCreateFileChooserTried) {
            if (bUseWinWOFileChooser) {
                return new V2CWinWOFileChooser(file);
            }
            return new JFileChooser(file);
        }
        bCreateFileChooserTried = true;
        JFileChooser jFileChooser = null;
        try {
            jFileChooser = new JFileChooser(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (jFileChooser == null) {
            bUseWinWOFileChooser = true;
            jFileChooser = new V2CWinWOFileChooser(file);
        }
        return jFileChooser;
    }

    static JTextField createTextField() {
        return V2CSwingUtil.createTextField(0);
    }

    static JTextField createTextField(int n) {
        V2CNoBeepTextField v2CNoBeepTextField = new V2CNoBeepTextField();
        if (n > 0) {
            v2CNoBeepTextField.setColumns(n);
        }
        return v2CNoBeepTextField;
    }

    static float getFloat(JFormattedTextField jFormattedTextField) {
        return V2CSwingUtil.getFloat(jFormattedTextField, 0.0f);
    }

    static float getFloat(JFormattedTextField jFormattedTextField, float f) {
        if (jFormattedTextField == null) {
            return f;
        }
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.isQuaquaInstalled()) {
            try {
                jFormattedTextField.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return ((Number)jFormattedTextField.getValue()).floatValue();
    }

    static int getInt(JFormattedTextField jFormattedTextField) {
        return V2CSwingUtil.getInt(jFormattedTextField, -1);
    }

    static int getInt(JFormattedTextField jFormattedTextField, int n) {
        if (jFormattedTextField == null) {
            return n;
        }
        try {
            jFormattedTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ((Number)jFormattedTextField.getValue()).intValue();
    }

    static int getInt(JSpinner jSpinner) {
        try {
            jSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ((Number)jSpinner.getValue()).intValue();
    }

    static void armRequestFocus(JComponent jComponent) {
        V2CSwingUtil.armRequestFocus(jComponent, false);
    }

    static void armRequestFocus(final JComponent jComponent, final boolean bl) {
        if (jComponent.isShowing()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (bl) {
                        Window window;
                        if (V2CApp.isMacintosh() && (window = SwingUtilities.getWindowAncestor(jComponent)) != null) {
                            window.toFront();
                        }
                        jComponent.requestFocus();
                    } else {
                        jComponent.requestFocusInWindow();
                    }
                }
            });
        }
    }

    static void openThreadLater(final V2CThreadItem v2CThreadItem, final boolean bl, final boolean bl2, final V2CThreadOpenRequest v2CThreadOpenRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                v2CThreadItem.open(bl, bl2, v2CThreadOpenRequest);
            }
        });
    }

    static void clearGraphicsConfiguration() {
        refGraphicsConfigs = null;
    }

    private static GraphicsConfiguration[] createGraphicsConfigArray() {
        GraphicsConfiguration[] graphicsConfigurationArray;
        Reference reference = refGraphicsConfigs;
        if (reference != null && (graphicsConfigurationArray = (GraphicsConfiguration[])reference.get()) != null) {
            return graphicsConfigurationArray;
        }
        graphicsConfigurationArray = new ArrayList();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            graphicsConfigurationArray.add(graphicsDeviceArray[i].getDefaultConfiguration());
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (graphicsConfigurationArray.size() > 0) {
            if (graphicsConfigurationArray.get(0) != graphicsConfiguration && graphicsConfigurationArray.contains(graphicsConfiguration)) {
                graphicsConfigurationArray.remove(graphicsConfiguration);
                graphicsConfigurationArray.add(0, graphicsConfiguration);
            }
        } else {
            graphicsConfigurationArray.add(graphicsConfiguration);
        }
        GraphicsConfiguration[] graphicsConfigurationArray2 = new GraphicsConfiguration[graphicsConfigurationArray.size()];
        for (int i = 0; i < graphicsConfigurationArray.size(); ++i) {
            graphicsConfigurationArray2[i] = (GraphicsConfiguration)graphicsConfigurationArray.get(i);
        }
        refGraphicsConfigs = new SoftReference<GraphicsConfiguration[]>(graphicsConfigurationArray2);
        return graphicsConfigurationArray2;
    }

    static GraphicsConfiguration getGraphicsConfigurationAt(Point point) {
        GraphicsConfiguration[] graphicsConfigurationArray = V2CSwingUtil.createGraphicsConfigArray();
        if (graphicsConfigurationArray.length > 1) {
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[i];
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.contains(point)) continue;
                return graphicsConfiguration;
            }
        }
        return graphicsConfigurationArray[0];
    }

    static Rectangle getScreenBoundsAt(int n, int n2) {
        return V2CSwingUtil.getScreenBoundsAt(new Point(n, n2));
    }

    static Rectangle getScreenBoundsAt(Point point) {
        GraphicsConfiguration[] graphicsConfigurationArray = V2CSwingUtil.createGraphicsConfigArray();
        GraphicsConfiguration graphicsConfiguration = V2CSwingUtil.getGraphicsConfigurationAt(point);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        if (graphicsConfiguration == graphicsConfigurationArray[0]) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            rectangle = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }
        return rectangle;
    }

    static boolean checkWindowPosition(Point point) {
        if (point == null) {
            return true;
        }
        Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
        boolean bl = V2CSwingUtil.checkWindowPosition(rectangle);
        if (!bl) {
            point.x = rectangle.x;
            point.y = rectangle.y;
        }
        return bl;
    }

    static boolean checkWindowPosition(Rectangle rectangle) {
        int n;
        if (rectangle == null) {
            return true;
        }
        if (rTotalBounds == null) {
            Rectangle rectangle2 = null;
            GraphicsConfiguration[] graphicsConfigurationArray = V2CSwingUtil.createGraphicsConfigArray();
            for (n = 0; n < graphicsConfigurationArray.length; ++n) {
                GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[n];
                Rectangle rectangle3 = graphicsConfiguration.getBounds();
                if (rectangle2 == null) {
                    rectangle2 = rectangle3;
                    continue;
                }
                SwingUtilities.computeUnion(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle2);
            }
            rTotalBounds = rectangle2;
        }
        int n2 = V2CSwingUtil.rTotalBounds.x;
        int n3 = V2CSwingUtil.rTotalBounds.y;
        n = n2 + V2CSwingUtil.rTotalBounds.width;
        int n4 = n3 + V2CSwingUtil.rTotalBounds.height;
        boolean bl = true;
        if (rectangle.x + 100 < n2) {
            bl = false;
            rectangle.x = n2;
        }
        if (rectangle.y + 5 < n3) {
            bl = false;
            rectangle.y = n3;
        }
        if (rectangle.x + 100 > n) {
            bl = false;
            rectangle.x = n - 100;
        }
        if (rectangle.y + 100 > n4) {
            bl = false;
            rectangle.y = n4 - 100;
        }
        return bl;
    }

    static boolean isAlwaysOnTopSupported() {
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            return V2CJSE6Util.isAlwaysOnTopSupported();
        }
        return V2CApp.javaVersionEqualOrGreaterThan(1, 5);
    }

    static void toFront(JFrame jFrame) {
        int n = jFrame.getExtendedState();
        if ((n & 1) != 0) {
            jFrame.setExtendedState(n & 0xFFFFFFFE);
        }
        jFrame.toFront();
    }

    static JRootPane getRootPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        if (window instanceof JWindow) {
            return ((JWindow)window).getRootPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane();
        }
        return null;
    }

    static Container getContentPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getContentPane();
        }
        if (window instanceof JWindow) {
            return ((JWindow)window).getContentPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getContentPane();
        }
        return null;
    }

    static void setContentPane(Window window, Container container) {
        if (window instanceof JFrame) {
            ((JFrame)window).setContentPane(container);
        } else if (window instanceof JWindow) {
            ((JWindow)window).setContentPane(container);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setContentPane(container);
        }
    }

    static Component getGlassPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getGlassPane();
        }
        if (window instanceof JWindow) {
            return ((JWindow)window).getGlassPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getGlassPane();
        }
        return null;
    }

    static void setGlassPane(Window window, Component component) {
        if (window instanceof JFrame) {
            ((JFrame)window).setGlassPane(component);
        } else if (window instanceof JWindow) {
            ((JWindow)window).setGlassPane(component);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setGlassPane(component);
        }
    }

    static void expandMenuOfName(JPopupMenu jPopupMenu, String string) {
        for (int i = jPopupMenu.getComponentCount() - 1; i >= 0; --i) {
            JMenu jMenu;
            Component component = jPopupMenu.getComponent(i);
            if (!(component instanceof JMenu) || !(jMenu = (JMenu)component).getText().equals(string)) continue;
            jPopupMenu.remove(i);
            for (int j = jMenu.getItemCount() - 1; j >= 0; --j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem != null) {
                    jMenu.remove(j);
                    jPopupMenu.insert(jMenuItem, i);
                    continue;
                }
                jPopupMenu.insert(new JPopupMenu.Separator(), i);
            }
            break;
        }
    }

    static String addMnemonic(String string, char c) {
        int n;
        if (string == null) {
            string = "";
        }
        boolean bl = (n = string.length()) > 0 && string.charAt(n - 1) == '\u2026';
        StringBuffer stringBuffer = new StringBuffer(n + 3);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.setLength(n - 1);
        }
        stringBuffer.append('(');
        stringBuffer.append(c);
        stringBuffer.append(')');
        if (bl) {
            stringBuffer.append('\u2026');
        }
        return stringBuffer.toString();
    }

    static Point tweakMouseLocationOnScreen(Point point, Component component) {
        if (V2CApp.isUNIX() && point != null) {
            Window window;
            Point point2 = new Point(point.x, point.y);
            SwingUtilities.convertPointToScreen(point2, component);
            if (point2.x == point.x && point2.y == point.y && (window = SwingUtilities.getWindowAncestor(component)) != null) {
                Point point3 = window.getLocation();
                point.x += point3.x;
                point.y += point3.y;
            }
        }
        return point;
    }

    static Point getMouseLocationOnScreen(MouseEvent mouseEvent) {
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
            return V2CJ2SE5Util.getMouseLocation();
        }
        if (V2CApp.isMacintosh()) {
            return V2CMacApplicationHandler.getMouseLocationOnScreen();
        }
        if (mouseEvent != null) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            return point;
        }
        return new Point(0, 0);
    }

    static Point getMouseLocation(Component component) {
        Point point;
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
            point = V2CJ2SE5Util.getMouseLocation();
        } else if (V2CApp.isMacintosh()) {
            point = V2CMacApplicationHandler.getMouseLocationOnScreen();
        } else {
            return null;
        }
        SwingUtilities.convertPointFromScreen(point, component);
        return point;
    }

    static boolean isSimpleMouseOver(MouseEvent mouseEvent) {
        return !mouseEvent.isShiftDown() && !mouseEvent.isAltDown() && !mouseEvent.isAltGraphDown() && !mouseEvent.isControlDown() && !mouseEvent.isMetaDown();
    }

    static boolean isSimpleClick(MouseEvent mouseEvent) {
        return V2CSwingUtil.isSimpleClick(mouseEvent, 1);
    }

    static boolean isSimpleClick(MouseEvent mouseEvent, int n) {
        if (mouseEvent.getButton() != n) {
            return false;
        }
        int n2 = 0;
        int n3 = 8384;
        switch (n) {
            case 1: {
                n3 |= 0x1B00;
                break;
            }
            case 2: {
                n3 |= 0x1500;
                break;
            }
            case 3: {
                n3 |= 0xE00;
            }
        }
        return (mouseEvent.getModifiersEx() & (n2 | n3)) == n2;
    }

    static boolean isControlMetaDown(MouseEvent mouseEvent) {
        return V2CApp.isMacintosh() ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    static void setTableRowHeight(JTable jTable) {
        jTable.setRowHeight(V2CSwingUtil.calcTableRowHeight(jTable.getFont()));
    }

    static int calcTableRowHeight(Font font) {
        int n = font != null ? font.getSize() : UIManager.getFont(sUIManagerTableFontKey).getSize();
        int n2 = nAdditionalRowHeight + 4;
        if (n >= 12) {
            return n + n2;
        }
        return (int)((double)n * (1.0 + (double)n2 / 12.0));
    }

    static JScrollPane createScrollPaneForTable(JTable jTable, int n) {
        return V2CSwingUtil.createScrollPaneForTable(jTable, n, -1);
    }

    static JScrollPane createScrollPaneForTable(JTable jTable, int n, int n2) {
        V2CSwingUtil.setTableRowHeight(jTable);
        int n3 = n2 >= 0 ? V2CSwingUtil.setTableColumnWidths(jTable, n2) : V2CSwingUtil.ensureTableColumnWidths(jTable);
        if (n3 <= 0) {
            n3 = 400;
        }
        jTable.setPreferredScrollableViewportSize(new Dimension(n3, n));
        return new JScrollPane(jTable);
    }

    static int setTableColumnWidths(JTable jTable, int n) {
        int n2 = jTable.getRowCount();
        if (n2 == 0) {
            return 0;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n3 = 0;
        for (int i = tableColumnModel.getColumnCount() - 1; i >= 0; --i) {
            Dimension dimension;
            Component component;
            Object object;
            TableCellRenderer tableCellRenderer;
            int n4 = 0;
            for (int j = Math.min(n2, 10) - 1; j >= 0; --j) {
                tableCellRenderer = jTable.getCellRenderer(j, i);
                object = jTable.getValueAt(j, i);
                component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                dimension = component.getPreferredSize();
                if (dimension.width <= n4) continue;
                n4 = dimension.width;
            }
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
            }
            object = tableColumn.getHeaderValue();
            component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, i);
            dimension = component.getPreferredSize();
            if (dimension.width > n4) {
                n4 = dimension.width;
            }
            tableColumn.setPreferredWidth(n4 += n);
            n3 += n4;
        }
        return n3;
    }

    static int ensureTableColumnWidths(JTable jTable) {
        int n = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = tableColumnModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, i);
            int n2 = tableColumn.getPreferredWidth();
            Dimension dimension = component.getPreferredSize();
            int n3 = dimension.width + 2;
            if (n2 < n3) {
                tableColumn.setPreferredWidth(n3);
                n2 = n3;
            }
            n += n2;
        }
        return n;
    }

    static void checkEditing(JTable jTable) {
        TableCellEditor tableCellEditor;
        if (jTable.isEditing() && (tableCellEditor = jTable.getCellEditor()) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    static boolean isSynthLaF() {
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
            return false;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null && lookAndFeel != lafLastLaf) {
            lafLastLaf = lookAndFeel;
            bSynth = V2CJ2SE5Util.isSynthLaF(lookAndFeel);
        }
        return bSynth;
    }

    static void updateVistaTableHeaderFlag() {
        Object object;
        String string;
        LookAndFeel lookAndFeel;
        boolean bl = false;
        if (V2CApp.isWindowsVista() && V2CApp.javaVersionEqualOrGreaterThan(1, 6) && (lookAndFeel = UIManager.getLookAndFeel()) != null && (string = lookAndFeel.getID()) != null && string.equals("Windows") && (object = Toolkit.getDefaultToolkit().getDesktopProperty(sWinXPSThemeActive)) instanceof Boolean && ((Boolean)object).booleanValue()) {
            bl = true;
        }
        bVistaTableHeader = bl;
    }

    static boolean needsVistaTableHeader() {
        return bVistaTableHeader;
    }

    static GridBagConstraints createGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        return gridBagConstraints;
    }

    static BufferedImage getCheckBoxImage(boolean bl) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = bl ? biSelectedCheckBox : biUnselectedCheckBox;
        if (bufferedImage != null) {
            return bufferedImage;
        }
        JCheckBox jCheckBox = new JCheckBox(){

            public boolean isShowing() {
                return true;
            }
        };
        jCheckBox.setVisible(true);
        Dimension dimension = jCheckBox.getPreferredSize();
        GraphicsConfiguration graphicsConfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
        BufferedImage bufferedImage3 = graphicsConfiguration.createCompatibleImage(dimension.width, dimension.height, 3);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        jCheckBox.paintAll(graphics2D);
        graphics2D.dispose();
        biUnselectedCheckBox = bufferedImage3;
        jCheckBox.setSelected(true);
        bufferedImage3 = graphicsConfiguration.createCompatibleImage(dimension.width, dimension.height, 3);
        graphics2D = bufferedImage3.createGraphics();
        graphics2D.setColor(Color.RED);
        graphics2D.fillRect(0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight());
        jCheckBox.paintAll(graphics2D);
        graphics2D.dispose();
        biSelectedCheckBox = bufferedImage3;
        return bl ? biSelectedCheckBox : biUnselectedCheckBox;
    }

    static JButton addButton(String string, ActionListener actionListener, JPanel jPanel, GridBagConstraints gridBagConstraints, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setFocusable(false);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        jPanel.add((Component)jButton, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridy;
        } else {
            ++gridBagConstraints.gridx;
        }
        return jButton;
    }

    static JCheckBox addCheckBox(String string, boolean bl, JPanel jPanel, GridBagConstraints gridBagConstraints, boolean bl2) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setFocusable(false);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        if (bl2) {
            ++gridBagConstraints.gridy;
        } else {
            ++gridBagConstraints.gridx;
        }
        return jCheckBox;
    }

    static JComboBox createComboBox(ComboBoxModel comboBoxModel) {
        if (V2CApp.isWinType()) {
            return new V2CWinComboBox(comboBoxModel);
        }
        return new JComboBox(comboBoxModel);
    }

    static JComboBox createComboBox(Object[] objectArray) {
        if (V2CApp.isWinType()) {
            return new V2CWinComboBox(objectArray);
        }
        return new JComboBox<Object>(objectArray);
    }

    static JComboBox createComboBox() {
        if (V2CApp.isWinType()) {
            return new V2CWinComboBox();
        }
        return new JComboBox();
    }

    static JSpinner createIntSpinner(int n, int n2, int n3) {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n, n2, n3, 1));
        Dimension dimension = jSpinner.getPreferredSize();
        dimension.width = (int)((double)dimension.width * 1.2);
        jSpinner.setPreferredSize(dimension);
        return jSpinner;
    }

    static void stiffen(JComponent jComponent) {
        if (V2CApp.isWinType()) {
            Dimension dimension = jComponent.getPreferredSize();
            dimension.width = (int)((double)dimension.width * 0.7);
            jComponent.setMinimumSize(dimension);
        }
    }

    static boolean shouldUseCoveredComboBox() {
        if (!bShouldUseCoveredComboBoxChecked) {
            String string;
            bShouldUseCoveredComboBoxChecked = true;
            boolean bl = V2CApp.isMacintosh() ? false : (V2CApp.javaVersionEqualOrGreaterThan(1, 6) && V2CApp.isWinType() ? true : (string = UIManager.getLookAndFeel().getID()).equals("Motif") || string.equals("SkinLF"));
            bShouldUseCoveredComboBox = bl;
        }
        return bShouldUseCoveredComboBox;
    }

    static void listenToComboBoxButton(JComboBox jComboBox, MouseListener mouseListener) {
        if (V2CSwingUtil.shouldUseCoveredComboBox() || mouseListener == null) {
            return;
        }
        int n = jComboBox.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jComboBox.getComponent(i);
            if (!(component instanceof JButton)) continue;
            component.addMouseListener(mouseListener);
        }
    }

    static JScrollPane createBoundedScrollPane(JComponent jComponent, double d, double d2) {
        Rectangle rectangle = V2CMain.v2cMain.getBounds();
        Rectangle rectangle2 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int n = (int)((double)rectangle2.width * d);
        int n2 = (int)((double)rectangle2.height * d2);
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        Insets insets = jScrollPane.getInsets();
        jScrollPane.getViewport().setSize(n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        Dimension dimension = jComponent.getPreferredSize();
        int n3 = dimension.width + insets.left + insets.right;
        int n4 = dimension.height + insets.top + insets.bottom;
        int n5 = Math.min(n3, n);
        int n6 = Math.min(n4, n2);
        if (n6 < n4 && n5 == n3) {
            n5 += UIManager.getInt("ScrollBar.width");
        }
        Dimension dimension2 = new Dimension(n5, n6);
        jScrollPane.setPreferredSize(dimension2);
        jScrollPane.setMaximumSize(dimension2);
        return jScrollPane;
    }

    static void addToShortPhrase(String string) {
        if (string == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int n = string.indexOf(10);
        if (n == string.length() - 1) {
            string = string.substring(0, string.length() - 1);
        }
        if (!V2CAAListMenu.addAA(string)) {
            V2CShortPhraseMenu.addPhrase(string);
        }
    }

    static Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    static void registerESCToDialog(final JDialog jDialog) {
        JRootPane jRootPane = jDialog.getRootPane();
        ActionMap actionMap = jRootPane.getActionMap();
        if (actionMap.get("close") == null) {
            actionMap.put("close", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
        }
        InputMap inputMap = jRootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    static boolean showDialogWithFocusRequest(JComponent jComponent, String string, JComponent jComponent2) {
        String[] stringArray = new String[]{"OK", "Cancel"};
        int n = V2CSwingUtil.showDialogWithFocusRequest(jComponent, string, jComponent2, stringArray, 0);
        return n == 0;
    }

    static int showDialogWithFocusRequest(JComponent jComponent, String string, JComponent jComponent2, String[] stringArray, int n) {
        Object[] objectArray = V2CSwingUtil.createJButtonForOptionPane(stringArray);
        Object object = objectArray[n];
        FocusOptionPane focusOptionPane = new FocusOptionPane(jComponent, -1, -1, null, objectArray, object, jComponent2);
        JDialog jDialog = focusOptionPane.createDialog(V2CMain.v2cMain, string);
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object2 = focusOptionPane.getValue();
        for (int i = 0; i < objectArray.length; ++i) {
            if (object2 != objectArray[i]) continue;
            return i;
        }
        return -1;
    }

    static Object showComboBoxDialog(List list, Object object, String string, String string2) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return V2CSwingUtil.showComboBoxDialog(list.toArray(), object, string, string2);
    }

    static Object showComboBoxDialog(Object[] objectArray, Object object, String string, String string2) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        ++gridBagConstraints.gridy;
        JComboBox jComboBox = V2CSwingUtil.createComboBox(objectArray);
        if (object != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                jComboBox.setSelectedIndex(i);
                break;
            }
        }
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jComboBox, gridBagConstraints);
        if (!V2CSwingUtil.showDialogWithFocusRequest(jPanel, string2, jComboBox)) {
            return null;
        }
        return jComboBox.getSelectedItem();
    }

    static void hideDialogWithSelection(Component component, int n) {
        JOptionPane jOptionPane;
        Object[] objectArray;
        Container container = SwingUtilities.getAncestorOfClass(JOptionPane.class, component);
        if (container != null && (objectArray = (jOptionPane = (JOptionPane)container).getOptions()) != null && objectArray.length > n) {
            jOptionPane.setValue(objectArray[n]);
        }
        if ((container = SwingUtilities.getAncestorOfClass(JDialog.class, component)) != null) {
            ((JDialog)container).setVisible(false);
        }
    }

    static Point showDialogWithClose(JComponent jComponent, JTextComponent jTextComponent, String string) {
        return V2CSwingUtil.showDialogWithClose((JFrame)V2CMain.v2cMain, jComponent, jTextComponent, string, (String)null, null);
    }

    static Point showDialogWithClose(JComponent jComponent, JTextComponent jTextComponent, String string, Point point) {
        return V2CSwingUtil.showDialogWithClose((JFrame)V2CMain.v2cMain, jComponent, jTextComponent, string, (String)null, point);
    }

    static Point showDialogWithClose(JFrame jFrame, JComponent jComponent, JTextComponent jTextComponent, String string) {
        return V2CSwingUtil.showDialogWithClose(jFrame, jComponent, jTextComponent, string, (String)null, null);
    }

    static Point showDialogWithClose(JComponent jComponent, JTextComponent jTextComponent, String string, String string2) {
        return V2CSwingUtil.showDialogWithClose((JFrame)V2CMain.v2cMain, jComponent, jTextComponent, string, string2, null);
    }

    static Point showDialogWithClose(JFrame jFrame, JComponent jComponent, JTextComponent jTextComponent, String string, String string2) {
        return V2CSwingUtil.showDialogWithClose(jFrame, jComponent, jTextComponent, string, string2, null);
    }

    static Point showDialogWithClose(JFrame jFrame, JComponent jComponent, JTextComponent jTextComponent, String string, String string2, Point point) {
        String[] stringArray = string2 != null ? new String[]{string2} : null;
        return V2CSwingUtil.showDialogWithClose(jFrame, jComponent, jTextComponent, string, stringArray, point);
    }

    static Point showDialogWithClose(JFrame jFrame, JComponent jComponent, JTextComponent jTextComponent, String string, String[] stringArray, Point point) {
        Object[] objectArray;
        boolean bl = false;
        Object object = null;
        if (stringArray != null && stringArray.length > 1) {
            objectArray = V2CSwingUtil.createJButtonForOptionPane(stringArray, true);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("OK")) continue;
                object = objectArray[i];
                break;
            }
        } else {
            String string2;
            if (stringArray != null) {
                string2 = stringArray[0];
                if (V2CMiscUtil.isEqual(string2, "MODELESS")) {
                    bl = true;
                    string2 = "\u9589\u3058\u308b";
                }
            } else {
                string2 = "\u9589\u3058\u308b";
            }
            objectArray = new Object[]{new CloseButton(string2)};
        }
        FocusOptionPane focusOptionPane = new FocusOptionPane(jComponent, -1, -1, null, objectArray, object, jTextComponent);
        JDialog jDialog = focusOptionPane.createDialog(jFrame, string);
        jDialog.setResizable(true);
        if (point != null) {
            V2CSwingUtil.checkWindowPosition(point);
            jDialog.setLocation(point);
        }
        jDialog.pack();
        V2CSwingUtil.addWheelScroller(jComponent);
        if (bl) {
            jDialog.setModal(false);
        }
        jDialog.setVisible(true);
        if (!bl) {
            jDialog.dispose();
            if (stringArray != null && stringArray.length > 1) {
                Object object2 = focusOptionPane.getValue();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (object2 == objectArray[i]) continue;
                    stringArray[i] = null;
                }
            }
        }
        return jDialog.getLocation();
    }

    private static void addWheelScroller(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window window = SwingUtilities.getWindowAncestor(component);
                if (window instanceof JDialog) {
                    final JDialog jDialog = (JDialog)window;
                    jDialog.addMouseWheelListener(new MouseWheelListener(){

                        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                            int n;
                            Point point = mouseWheelEvent.getPoint();
                            for (Component component = SwingUtilities.getDeepestComponentAt(mouseWheelEvent.getComponent(), point.x, point.y); component != null; component = component.getParent()) {
                                if (!(component instanceof JScrollPane)) continue;
                                return;
                            }
                            Point point2 = jDialog.getLocation();
                            if (point2 == null) {
                                return;
                            }
                            int n2 = n = mouseWheelEvent.getWheelRotation() > 0 ? -15 : 15;
                            if (mouseWheelEvent.isShiftDown()) {
                                point2.x += n;
                            } else {
                                point2.y += n;
                            }
                            jDialog.setLocation(point2);
                        }
                    });
                }
            }
        });
    }

    static boolean showOKCancelDialog(String string, String string2) {
        return V2CSwingUtil.showOKCancelDialog(string, string2, -1);
    }

    static boolean showOKCancelWarningDialog(String string) {
        return V2CSwingUtil.showOKCancelDialog(string, "\u8b66\u544a", 2);
    }

    static boolean showOKCancelWarningDialog(String string, String string2) {
        return V2CSwingUtil.showOKCancelDialog(string, string2, 2);
    }

    static boolean showOKCancelQuestionDialog(String string, String string2) {
        return V2CSwingUtil.showOKCancelDialog(string, string2, 3);
    }

    static boolean showOKCancelDialog(String string, String string2, int n) {
        int n2 = JOptionPane.showConfirmDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString(string), string2, 2, n);
        return n2 == 0;
    }

    static boolean showOKCancelDialog(Component component, String string) {
        Object object;
        Object[] objectArray;
        if (V2CApp.isWinType() && V2CBaseFont.getUIFontScale() != 0) {
            objectArray = V2CSwingUtil.createJButtonForOptionPane(new String[]{"OK", "Cancel"}, true);
            object = objectArray[0];
        } else {
            objectArray = null;
            object = null;
        }
        V2CSwingUtil.addWheelScroller(component);
        int n = JOptionPane.showOptionDialog(V2CMain.v2cMain, component, string, 2, -1, null, objectArray, object);
        return n == 0;
    }

    static String showInputDialog(String string) {
        return JOptionPane.showInputDialog(V2CSwingUtil.wrapString(string));
    }

    static String showInputDialog(String string, String string2) {
        return JOptionPane.showInputDialog(V2CSwingUtil.wrapString(string), (Object)string2);
    }

    static String showInputDialog(Component component, String string, String string2) {
        return JOptionPane.showInputDialog(component, V2CSwingUtil.wrapString(string), string2);
    }

    static String showInputDialog(String string, String string2, int n) {
        return JOptionPane.showInputDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString(string), string2, n);
    }

    static String showInputDialog(String string, String string2, String string3, int n) {
        Object object = JOptionPane.showInputDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString(string), string2, n, null, null, string3);
        return object instanceof String ? (String)object : null;
    }

    static void showPlainMessage(String string, String string2) {
        V2CSwingUtil.showMessage(string, string2, -1);
    }

    static void showInformationMessage(String string) {
        V2CSwingUtil.showInformationMessage(string, "\u60c5\u5831");
    }

    static void showInformationMessage(String string, String string2) {
        V2CSwingUtil.showMessage(string, string2, 1);
    }

    static void showWarningMessage(String string) {
        V2CSwingUtil.showWarningMessage(string, "\u8b66\u544a");
    }

    static void showWarningMessage(String string, String string2) {
        V2CSwingUtil.showMessage(string, string2, 2);
    }

    static void showErrorMessage(String string) {
        V2CSwingUtil.showErrorMessage(string, "\u30a8\u30e9\u30fc");
    }

    static void showErrorMessage(String string, String string2) {
        V2CSwingUtil.showMessage(string, string2, 0);
    }

    static void showMessage(String string, String string2, int n) {
        if (V2CApp.isInShutdownThread()) {
            return;
        }
        if (n == 0) {
            V2CApp.setErrorMessage(string, string2);
        }
        JOptionPane.showMessageDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString(string), string2, n);
    }

    public static void showMessageLater(final String string, final String string2, final int n) {
        if (V2CApp.isInShutdownThread()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                V2CSwingUtil.showMessage(string, string2, n);
            }
        });
    }

    static void showMessageDialogLater(final Object object, final String string, final int n) {
        if (V2CApp.isInShutdownThread()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString(object), string, n);
            }
        });
    }

    static void showScrollableMessage(String string, String string2, int n) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = V2CSwingUtil.createBoundedScrollPane(jTextArea, 0.5, 0.5);
        JOptionPane.showMessageDialog(V2CMain.v2cMain, jScrollPane, string2, n);
    }

    static boolean needsWrapString() {
        String string;
        if (!V2CApp.isWinType()) {
            return false;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel != null && (string = lookAndFeel.getName()) != null && string.equals("Substance");
    }

    static JComponent wrapStringIntoComponent(String string) {
        if (string.indexOf(10) >= 0) {
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setEditable(false);
            jTextArea.setOpaque(false);
            jTextArea.setBorder(null);
            return jTextArea;
        }
        return new JLabel(string);
    }

    static Object wrapString(Object object) {
        if (V2CSwingUtil.needsWrapString() && object instanceof String) {
            return V2CSwingUtil.wrapStringIntoComponent((String)object);
        }
        return object;
    }

    static Object[] createJButtonForOptionPane(String[] stringArray) {
        return V2CSwingUtil.createJButtonForOptionPane(stringArray, false);
    }

    static Object[] createJButtonForOptionPane(String[] stringArray, boolean bl) {
        if (!bl && !V2CSwingUtil.needsWrapString()) {
            return stringArray;
        }
        Object[] objectArray = new CloseButton[stringArray.length];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            CloseButton closeButton;
            objectArray[i] = closeButton = new CloseButton(stringArray[i]);
            Dimension dimension = closeButton.getPreferredSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < objectArray.length; ++i) {
            ((JComponent)objectArray[i]).setPreferredSize(dimension);
        }
        return objectArray;
    }

    static {
        String string;
        cTransparent = new Color(0, 0, 0, 0);
        cMacTextShadow = new Color(0x5FFFFFFF, true);
        hmIcons = new HashMap();
        boolean bl = bListenToComboBoxButton = !V2CApp.javaVersionEqualOrGreaterThan(1, 5);
        bAAText = V2CApp.javaVersionEqualTo(1, 5) ? (string = System.getProperty("swing.aatext")) != null && string.equals("true") : false;
        hmColorNames = new HashMap(200);
    }

    private static class CloseButton
    extends JButton
    implements ActionListener {
        CloseButton(String string) {
            super(string);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JOptionPane == null ? (class$javax$swing$JOptionPane = V2CSwingUtil.class$("javax.swing.JOptionPane")) : class$javax$swing$JOptionPane, this);
            if (container != null) {
                ((JOptionPane)container).setValue(this);
            }
            if ((container = SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = V2CSwingUtil.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, this)) != null) {
                ((JDialog)container).dispose();
            }
        }
    }

    static class FocusOptionPane
    extends JOptionPane {
        JComponent jcFocus;

        public FocusOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2, JComponent jComponent) {
            super(object, n, n2, icon, objectArray, object2);
            this.jcFocus = jComponent;
        }

        public void selectInitialValue() {
            super.selectInitialValue();
            if (this.jcFocus != null) {
                this.jcFocus.requestFocus();
                this.jcFocus = null;
            }
        }
    }

    static class ImageFilter
    extends FileFilter {
        ImageFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string == null || string.length() < 5) {
                return false;
            }
            return string.endsWith(".gif") || string.endsWith(".GIF") || string.endsWith(".jpg") || string.endsWith(".JPG") || string.endsWith(".png") || string.endsWith(".PNG");
        }

        public String getDescription() {
            return "Image Files (*.gif; *.jpg; *.png)";
        }
    }
}

