/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CCountHighlight;
import org.monazilla.v2c.V2CGalleryEntry;
import org.monazilla.v2c.V2CHeaderTextSegment;
import org.monazilla.v2c.V2CHighlightStyle;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CResLabel;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CThreadGallery {
    private static final int nThumbnailSpacing = 10;
    V2CThreadPanel vThreadPanel;
    V2CGalleryEntry[] lGalleryEntry;
    V2CGalleryEntry gePopupWindow;
    ResNumRect rnrPopupWindow;
    ArrayList alResNumRects;
    int iResNumToGo = -1;

    public V2CThreadGallery(V2CThreadPanel v2CThreadPanel) {
        this.vThreadPanel = v2CThreadPanel;
    }

    void setLinks(V2CGalleryEntry[] v2CGalleryEntryArray) {
        this.lGalleryEntry = v2CGalleryEntryArray;
    }

    V2CLink[] getLinks() {
        V2CGalleryEntry[] v2CGalleryEntryArray = this.lGalleryEntry;
        int n = v2CGalleryEntryArray.length;
        V2CLink[] v2CLinkArray = new V2CLink[n];
        for (int i = 0; i < n; ++i) {
            v2CLinkArray[i] = v2CGalleryEntryArray[i].getLink();
        }
        return v2CLinkArray;
    }

    boolean contains(V2CLink v2CLink) {
        V2CGalleryEntry[] v2CGalleryEntryArray = this.lGalleryEntry;
        if (v2CGalleryEntryArray == null) {
            return false;
        }
        int n = v2CGalleryEntryArray.length;
        for (int i = 0; i < n; ++i) {
            if (v2CGalleryEntryArray[i].getLink() != v2CLink) continue;
            return true;
        }
        return false;
    }

    Shape getPopupShape() {
        V2CGalleryEntry v2CGalleryEntry = this.gePopupWindow;
        if (v2CGalleryEntry != null) {
            return v2CGalleryEntry.getRect();
        }
        ResNumRect resNumRect = this.rnrPopupWindow;
        if (resNumRect != null) {
            return resNumRect.rRect;
        }
        return null;
    }

    boolean entryExistsAt(Point point, boolean bl) {
        ResNumRect resNumRect;
        V2CGalleryEntry v2CGalleryEntry = this.getEntryAt(point);
        if (v2CGalleryEntry != null) {
            this.gePopupWindow = v2CGalleryEntry;
            return true;
        }
        if (!bl && (resNumRect = this.getResNumRectAt(point)) != null) {
            this.rnrPopupWindow = resNumRect;
            return true;
        }
        return false;
    }

    void clearPopupRect() {
        this.gePopupWindow = null;
        this.rnrPopupWindow = null;
    }

    void tryPopup(MouseEvent mouseEvent) {
        V2CGalleryEntry v2CGalleryEntry = this.gePopupWindow;
        if (v2CGalleryEntry != null) {
            this.vThreadPanel.thumbnailPopup(null, mouseEvent, v2CGalleryEntry.getLinkTextSegment(), v2CGalleryEntry.getLink(), v2CGalleryEntry.getRect());
            return;
        }
        ResNumRect resNumRect = this.rnrPopupWindow;
        if (resNumRect != null) {
            this.vThreadPanel.popupResNumPopup(resNumRect.geEntry.getResItem().getResIndex(), mouseEvent, resNumRect.rRect);
        }
    }

    boolean mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        V2CGalleryEntry v2CGalleryEntry = this.getEntryAt(point);
        if (v2CGalleryEntry != null) {
            this.vThreadPanel.thumbnailClicked(v2CGalleryEntry.createDummyActiveShape(), mouseEvent, v2CGalleryEntry.getLinkTextSegment(), v2CGalleryEntry.getLink(), v2CGalleryEntry.getRect());
            return true;
        }
        ResNumRect resNumRect = this.getResNumRectAt(point);
        if (resNumRect != null) {
            this.iResNumToGo = resNumRect.geEntry.getResItem().getResIndex();
            this.vThreadPanel.toNormalMode();
            this.iResNumToGo = -1;
            return true;
        }
        return false;
    }

    void setResNumToGo(int n) {
        this.iResNumToGo = n;
    }

    int getResNumToGo() {
        return this.iResNumToGo;
    }

    ResNumRect getResNumRectAt(Point point) {
        ArrayList arrayList = this.alResNumRects;
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ResNumRect resNumRect = (ResNumRect)arrayList.get(i);
            if (!resNumRect.rRect.contains(point)) continue;
            return resNumRect;
        }
        return null;
    }

    V2CGalleryEntry getEntryAt(Point point) {
        int n = point.x;
        int n2 = point.y;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.lGalleryEntry;
        int n3 = v2CGalleryEntryArray.length;
        for (int i = 0; i < n3; ++i) {
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[i];
            if (!v2CGalleryEntry.contains(n, n2)) continue;
            return v2CGalleryEntry;
        }
        return null;
    }

    boolean imageThumbnailUpdated(V2CImageSet v2CImageSet) {
        Rectangle rectangle = this.vThreadPanel.getRealDrawingRect();
        Graphics graphics = null;
        boolean bl = false;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.lGalleryEntry;
        int n = v2CGalleryEntryArray.length;
        for (int i = 0; i < n; ++i) {
            V2CImageSet v2CImageSet2;
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[i];
            if (!v2CGalleryEntry.isRectSet() || (v2CImageSet2 = v2CGalleryEntry.getValidThumbnail()) != v2CImageSet) continue;
            if (graphics == null) {
                graphics = (Graphics2D)this.vThreadPanel.getGraphics();
            }
            if (graphics == null) {
                return false;
            }
            Rectangle rectangle2 = v2CGalleryEntry.getRect();
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            if (rectangle3.width <= 0 || rectangle3.height <= 0) continue;
            graphics.setClip(rectangle3);
            V2CAbstractThreadPanel.drawThumbnail((Graphics2D)graphics, rectangle3.x, rectangle3.y + 1, v2CImageSet2, v2CGalleryEntry.getLink(), 0);
            bl = true;
        }
        if (graphics != null) {
            graphics.dispose();
        }
        return bl;
    }

    int calcHeight(Rectangle rectangle) {
        return this.calcAndDraw(null, rectangle, 0);
    }

    void draw(Graphics2D graphics2D, Rectangle rectangle, int n) {
        this.calcAndDraw(graphics2D, rectangle, n);
    }

    int calcAndDraw(Graphics2D graphics2D, Rectangle rectangle, int n) {
        Color color;
        V2CHeaderTextSegment v2CHeaderTextSegment;
        FontRenderContext fontRenderContext;
        Font font;
        ArrayList<ResNumRect> arrayList;
        boolean bl = graphics2D != null;
        V2CThreadPanel v2CThreadPanel = this.vThreadPanel;
        V2CSSFont v2CSSFont = V2CSSFont.getDefaultFont();
        V2CSSFont[] v2CSSFontArray = new V2CSSFont[]{v2CSSFont};
        if (bl) {
            arrayList = new ArrayList<ResNumRect>();
            V2CThreadStyle.setTextAAHint(graphics2D);
            graphics2D.setColor(V2CThreadStyle.getThreadBackground());
            graphics2D.fill(rectangle);
            font = v2CSSFont.getAwtFont();
            graphics2D.setFont(font);
            fontRenderContext = graphics2D.getFontRenderContext();
            v2CHeaderTextSegment = new V2CHeaderTextSegment(32);
            color = V2CThreadStyle.getDefaultColor(1);
        } else {
            arrayList = null;
            font = null;
            fontRenderContext = null;
            v2CHeaderTextSegment = null;
            color = null;
        }
        this.alResNumRects = arrayList;
        int n2 = v2CSSFont.getAscent() + 2;
        int n3 = v2CSSFont.getDescent() + 2;
        int n4 = n2 + n3;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.x + 10;
        int n7 = rectangle.y;
        int n8 = n7 + rectangle.height;
        int n9 = n7 + n4 - n;
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = false;
        V2CResItem v2CResItem = null;
        int n12 = this.lGalleryEntry.length;
        for (int i = 0; i < n12; ++i) {
            V2CGalleryEntry v2CGalleryEntry = this.lGalleryEntry[i];
            if (bl2) {
                v2CGalleryEntry.clearRect();
                continue;
            }
            V2CLink v2CLink = v2CGalleryEntry.getLink();
            V2CImageSet v2CImageSet = v2CLink.getValidThumbnail();
            if (v2CImageSet == null) {
                v2CGalleryEntry.clearRect();
                continue;
            }
            int n13 = v2CImageSet.getWidth();
            int n14 = v2CImageSet.getHeight();
            if (n10 > 0 && n6 + n13 + 10 > n5) {
                n6 = rectangle.x + 10;
                if (bl && (n9 += n11 + n4) >= n8) {
                    bl2 = true;
                    v2CGalleryEntry.clearRect();
                    continue;
                }
                n11 = n14;
                n10 = 0;
            } else {
                if (n11 < n14) {
                    n11 = n14;
                }
                ++n10;
            }
            if (n9 + n14 >= n7) {
                Object object;
                if (bl && (object = v2CGalleryEntry.getResItem()) != v2CResItem) {
                    v2CResItem = object;
                    String string = ((Object)v2CHeaderTextSegment.getTextToDraw((V2CResItem)object, this.vThreadPanel.vtiThreadItem)).toString();
                    Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
                    rectangle2D.setRect(rectangle2D.getX() + (double)n6, rectangle2D.getY() + (double)n9 - (double)n3, rectangle2D.getWidth(), rectangle2D.getHeight());
                    arrayList.add(new ResNumRect(rectangle2D, v2CGalleryEntry));
                    V2CHighlightStyle v2CHighlightStyle = V2CCountHighlight.getRefHilightStyle(((V2CResItem)object).getRefCount());
                    V2CResLabel v2CResLabel = ((V2CResItem)object).getResLabel();
                    v2CThreadPanel.resetFontOverride();
                    v2CThreadPanel.getHeaderFont(v2CHeaderTextSegment, (V2CResItem)object, false);
                    graphics2D.setColor(color);
                    if (v2CHighlightStyle != null || v2CResLabel != null) {
                        v2CThreadPanel.simpleHighlight(graphics2D, v2CSSFontArray, fontRenderContext, (V2CResItem)object, v2CHeaderTextSegment, false, v2CResLabel, true, v2CHighlightStyle, rectangle2D, 0, string.length(), n6, n9 - n3, null);
                    } else {
                        v2CThreadPanel.drawTextSegmentLine(graphics2D, v2CSSFontArray, (V2CResItem)object, 32, string, (int)rectangle2D.getWidth(), rectangle2D, 0, string.length(), n6, n9 - n3, null);
                    }
                }
                object = V2CAbstractThreadPanel.drawThumbnail(graphics2D, n6, n9, v2CLink, 0);
                v2CGalleryEntry.setRect((Rectangle)object);
            } else {
                v2CGalleryEntry.clearRect();
            }
            n6 += n13 + 10;
        }
        return n9 + n11 + 10;
    }

    private static class ResNumRect {
        Rectangle2D rRect;
        V2CGalleryEntry geEntry;

        ResNumRect(Rectangle2D rectangle2D, V2CGalleryEntry v2CGalleryEntry) {
            this.rRect = rectangle2D;
            this.geEntry = v2CGalleryEntry;
        }
    }
}

