/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CBoardCategoryItem;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CProgressPanel;
import org.monazilla.v2c.V2CSaveFile;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CTreeModel
extends DefaultTreeModel {
    static final String sBBSMenuCondKey = "BBS.MenuCond:";
    private static final String sSaveFile = "bbstree.txt";
    transient V2CBBS vBBS;
    JTree jTree;
    DefaultMutableTreeNode tnRoot;
    boolean bExpandRoot;

    public V2CTreeModel(V2CBBS v2CBBS) {
        super(new DefaultMutableTreeNode());
        this.vBBS = v2CBBS;
        this.restoreBBSTree();
    }

    synchronized boolean has(V2CBoardItem v2CBoardItem) {
        if (this.tnRoot == null) {
            return false;
        }
        int n = this.tnRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tnRoot.getChildAt(i);
            V2CBoardCategoryItem v2CBoardCategoryItem = (V2CBoardCategoryItem)defaultMutableTreeNode.getUserObject();
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                V2CBoardItem v2CBoardItem2 = (V2CBoardItem)defaultMutableTreeNode2.getUserObject();
                if (v2CBoardItem2 != v2CBoardItem) continue;
                return true;
            }
        }
        return false;
    }

    void rootLabelChanged() {
        if (this.tnRoot == null) {
            return;
        }
        this.tnRoot.setUserObject(this.vBBS.getLabel());
        this.nodeChanged(this.tnRoot);
    }

    void updateModel(V2CProgressPanel v2CProgressPanel, StringBuffer stringBuffer) {
        if (!this.vBBS.isUpdateModelSupported()) {
            return;
        }
        boolean bl = v2CProgressPanel == null;
        ArrayList arrayList = this.getAndParseBBSMenu(bl);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (arrayList == null) {
            return;
        }
        if (!bl) {
            v2CProgressPanel.setMessage("HTML\u3092\u89e3\u6790\u4e2d...");
        }
        Hashtable hashtable = this.createBoardTmpHashtable(arrayList);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Hashtable hashtable2 = this.checkHREFExact(hashtable, arrayList);
        if (!this.checkByBoardDir(hashtable, hashtable2, arrayList, v2CProgressPanel, stringBuffer)) {
            System.out.println("Following board is orphaned:");
            Enumeration enumeration = hashtable2.elements();
            while (enumeration.hasMoreElements()) {
                V2CBoardItem v2CBoardItem = (V2CBoardItem)enumeration.nextElement();
                stringBuffer.append("\u5ec3\u6b62\uff1a ");
                stringBuffer.append(v2CBoardItem.getName());
                stringBuffer.append(" [ ");
                stringBuffer.append(v2CBoardItem.getURLString());
                stringBuffer.append(" ]\n");
                System.out.println("  " + v2CBoardItem.getURLString());
            }
        }
        this.changeModel(arrayList, hashtable, v2CProgressPanel, stringBuffer);
        this.saveBBSTree();
        if (bl) {
            V2CMain.setMessage("\u677f\u4e00\u89a7\u66f4\u65b0\u5b8c\u4e86");
        }
    }

    ArrayList getAndParseBBSMenu(boolean bl) {
        return null;
    }

    Hashtable createBoardTmpHashtable(ArrayList arrayList) {
        int n = arrayList.size();
        Hashtable<String, BoardTmp> hashtable = new Hashtable<String, BoardTmp>((int)((double)n / 0.75));
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof BoardTmp)) continue;
            BoardTmp boardTmp = (BoardTmp)e;
            String string = boardTmp.sHREF;
            hashtable.put(string, boardTmp);
            arrayList.set(i, string);
        }
        return hashtable;
    }

    Hashtable checkHREFExact(Hashtable hashtable, ArrayList arrayList) {
        Hashtable<String, V2CBoardItem> hashtable2 = new Hashtable<String, V2CBoardItem>();
        if (this.tnRoot == null) {
            return hashtable2;
        }
        int n = this.tnRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tnRoot.getChildAt(i);
            int n2 = defaultMutableTreeNode.getChildCount();
            for (int j = 0; j < n2; ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                V2CBoardItem v2CBoardItem = (V2CBoardItem)defaultMutableTreeNode2.getUserObject();
                String string = v2CBoardItem.getURLString();
                Object v = hashtable.get(string);
                if (v != null) {
                    if (!(v instanceof BoardTmp)) continue;
                    v2CBoardItem.setName(((BoardTmp)v).sBoardName);
                    hashtable.put(string, v2CBoardItem);
                    continue;
                }
                String string2 = V2CBoardItem.getBoardDir(string);
                if (string2 == null) {
                    V2CApp.errorExit("\u677f\u306eURL\u30a8\u30e9\u30fc\uff1a\n" + string);
                }
                hashtable2.put('/' + string2 + '/', v2CBoardItem);
            }
        }
        this.replaceTmpToItem(arrayList, hashtable);
        return hashtable2;
    }

    void replaceTmpToItem(ArrayList arrayList, Hashtable hashtable) {
        int n;
        int n2 = arrayList.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            String string;
            Object object = arrayList.get(n);
            if (!(object instanceof String) || !((object = hashtable.get(string = (String)object)) instanceof V2CBoardItem)) continue;
            V2CBoardItem v2CBoardItem = (V2CBoardItem)object;
            stringArray[n3++] = string;
            arrayList.set(n, v2CBoardItem);
        }
        for (n = 0; n < n3; ++n) {
            hashtable.remove(stringArray[n]);
        }
    }

    boolean checkByBoardDir(Hashtable hashtable, Hashtable hashtable2, ArrayList arrayList, V2CProgressPanel v2CProgressPanel, StringBuffer stringBuffer) {
        Object object;
        int n;
        Object[] objectArray = hashtable2.keySet().toArray();
        Object[] objectArray2 = hashtable.keySet().toArray();
        block0: for (n = 0; n < objectArray.length; ++n) {
            object = (String)objectArray[n];
            for (int i = 0; i < objectArray2.length; ++i) {
                V2CBoardItem v2CBoardItem;
                String string;
                Object object2 = objectArray2[i];
                if (!(object2 instanceof String) || !(string = (String)object2).endsWith((String)object) || !(v2CBoardItem = (V2CBoardItem)hashtable2.get(object)).isSeverMoveSupported()) continue;
                BoardTmp boardTmp = (BoardTmp)hashtable.get(string);
                String string2 = v2CBoardItem.getURLString();
                String string3 = boardTmp.sHREF;
                System.out.println("server moved: " + string2 + " -> " + string3);
                boolean bl = v2CBoardItem.moveServerInBBS(string3);
                if (bl) {
                    v2CBoardItem.setName(boardTmp.sBoardName);
                    stringBuffer.append("\u79fb\u8ee2\uff1a ");
                    stringBuffer.append(v2CBoardItem.getName());
                    stringBuffer.append("\n  \u65e7URL\uff1a ");
                    stringBuffer.append(string2);
                    stringBuffer.append("\n  \u65b0URL\uff1a ");
                    stringBuffer.append(string3);
                    stringBuffer.append("\n");
                } else {
                    System.out.println("  not really ??");
                }
                String string4 = "\u79fb\u8ee2\uff1a " + v2CBoardItem.getName();
                if (v2CProgressPanel != null) {
                    v2CProgressPanel.setMessage(string4);
                } else {
                    V2CMain.setMessage("2ch\u677f\u4e00\u89a7\u66f4\u65b0\u4e2d\u2026 " + string4);
                }
                hashtable.put(string, v2CBoardItem);
                objectArray2[i] = null;
                continue block0;
            }
            objectArray[n] = null;
        }
        this.replaceTmpToItem(arrayList, hashtable);
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (object == null) continue;
            hashtable2.remove(object);
        }
        return hashtable2.size() == 0;
    }

    boolean replaceBoardByHREF(ArrayList arrayList, V2CBoardItem v2CBoardItem) {
        String string = v2CBoardItem.getURLString();
        boolean bl = false;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            BoardCategoryTmp boardCategoryTmp = (BoardCategoryTmp)arrayList.get(i);
            for (int j = 0; j < boardCategoryTmp.getSize(); ++j) {
                Object object = boardCategoryTmp.get(j);
                if (!(object instanceof BoardTmp)) continue;
                BoardTmp boardTmp = (BoardTmp)object;
                if (!string.equals(boardTmp.sHREF)) continue;
                boardCategoryTmp.setElementAt(v2CBoardItem, j);
                bl = true;
            }
        }
        return bl;
    }

    void changeModel(ArrayList arrayList, Hashtable hashtable, V2CProgressPanel v2CProgressPanel, StringBuffer stringBuffer) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.replceBoardCategory(arrayList);
        this.tnRoot = defaultMutableTreeNode = new DefaultMutableTreeNode(this.vBBS.getLabel());
        this.bExpandRoot = true;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object e = arrayList.get(i);
            if (e instanceof V2CBoardCategoryItem) {
                object = (V2CBoardCategoryItem)e;
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            object = null;
            if (e instanceof V2CBoardItem) {
                object = (V2CBoardItem)e;
            } else if (e instanceof String) {
                BoardTmp boardTmp = (BoardTmp)hashtable.get(e);
                String string = boardTmp.sBoardName;
                object = this.createNewBoard(string, boardTmp.sHREF);
                ((V2CBoardItem)object).setName(string);
                ((V2CBoardItem)object).checkNewDefinedBoardActivity();
                String string2 = "\u65b0\u677f\uff1a " + string + "\n  URL\uff1a " + boardTmp.sHREF + '\n';
                int n2 = string2.length();
                if (stringBuffer.length() >= n2 && stringBuffer.charAt(n2 - 1) == '\n' && string2.equals(stringBuffer.substring(0, n2))) {
                    string2 = null;
                }
                if (string2 != null) {
                    stringBuffer.insert(0, string2);
                    String string3 = "\u65b0\u677f\uff1a " + string;
                    if (v2CProgressPanel != null) {
                        v2CProgressPanel.setMessage(string3);
                    } else {
                        V2CMain.setMessage("2ch\u677f\u4e00\u89a7\u66f4\u65b0\u4e2d\u2026 " + string3);
                    }
                }
            } else {
                System.out.println("unknown: " + i);
            }
            if (object == null) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(object, false));
        }
        this.setRoot(defaultMutableTreeNode);
    }

    V2CBoardItem createNewBoard(String string, String string2) {
        V2CBoardItem v2CBoardItem = V2CBoardItem.getBoardItem(string, string2, this.vBBS, 2);
        v2CBoardItem.setState(2);
        return v2CBoardItem;
    }

    V2CBoardItem restoreBoardItem(String string, String string2) {
        return V2CBoardItem.getBoardItem(string, string2, this.vBBS, 2);
    }

    void replceBoardCategory(ArrayList arrayList) {
        Object object;
        Object object2;
        int n;
        int n2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.tnRoot != null) {
            n2 = this.tnRoot.getChildCount();
            for (n = 0; n < n2; ++n) {
                object2 = (DefaultMutableTreeNode)this.tnRoot.getChildAt(n);
                object = ((DefaultMutableTreeNode)object2).getUserObject();
                if (!(object instanceof V2CBoardCategoryItem)) continue;
                hashtable.put(((V2CBoardCategoryItem)object).getName(), object);
            }
        }
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object2 = arrayList.get(n);
            if (!(object2 instanceof BoardCategoryTmp)) continue;
            object = (BoardCategoryTmp)object2;
            String string = ((BoardCategoryTmp)object).sBoardCategoryName;
            V2CBoardCategoryItem v2CBoardCategoryItem = (V2CBoardCategoryItem)hashtable.get(string);
            if (v2CBoardCategoryItem == null) {
                v2CBoardCategoryItem = new V2CBoardCategoryItem(string, false, this.vBBS);
            }
            arrayList.set(n, v2CBoardCategoryItem);
        }
    }

    void setTree(JTree jTree) {
        this.jTree = jTree;
        if (this.bExpandRoot) {
            jTree.expandRow(0);
        }
    }

    V2CBoardCategoryItem getBoardCategoryItem(String string) {
        if (string == null || string.length() == 0 || this.tnRoot == null) {
            return null;
        }
        int n = this.tnRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tnRoot.getChildAt(i);
            V2CBoardCategoryItem v2CBoardCategoryItem = (V2CBoardCategoryItem)defaultMutableTreeNode.getUserObject();
            if (!string.equals(v2CBoardCategoryItem.getName())) continue;
            return v2CBoardCategoryItem;
        }
        return null;
    }

    private DefaultMutableTreeNode getTreeNode(V2CBoardCategoryItem v2CBoardCategoryItem) {
        if (this.tnRoot == null) {
            return null;
        }
        int n = this.tnRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tnRoot.getChildAt(i);
            V2CBoardCategoryItem v2CBoardCategoryItem2 = (V2CBoardCategoryItem)defaultMutableTreeNode.getUserObject();
            if (v2CBoardCategoryItem2 != v2CBoardCategoryItem) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    ArrayList getBoardList(V2CBoardCategoryItem v2CBoardCategoryItem) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(v2CBoardCategoryItem);
        if (defaultMutableTreeNode == null) {
            return null;
        }
        ArrayList<V2CBoardItem> arrayList = new ArrayList<V2CBoardItem>();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            V2CBoardItem v2CBoardItem = (V2CBoardItem)defaultMutableTreeNode2.getUserObject();
            arrayList.add(v2CBoardItem);
        }
        return arrayList;
    }

    V2CBoardItem[] createBoardList() {
        int n;
        if (this.tnRoot == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        int n2 = this.tnRoot.getChildCount();
        for (n = 0; n < n2; ++n) {
            this.addToBoardList((DefaultMutableTreeNode)this.tnRoot.getChildAt(n), arrayList);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        V2CBoardItem[] v2CBoardItemArray = new V2CBoardItem[n];
        for (int i = 0; i < n; ++i) {
            v2CBoardItemArray[i] = (V2CBoardItem)arrayList.get(i);
        }
        return v2CBoardItemArray;
    }

    V2CBoardItem[] createBoardList(V2CBoardCategoryItem v2CBoardCategoryItem) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(v2CBoardCategoryItem);
        if (defaultMutableTreeNode == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.addToBoardList(defaultMutableTreeNode, arrayList);
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        V2CBoardItem[] v2CBoardItemArray = new V2CBoardItem[n];
        for (int i = 0; i < n; ++i) {
            v2CBoardItemArray[i] = (V2CBoardItem)arrayList.get(i);
        }
        return v2CBoardItemArray;
    }

    private void addToBoardList(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList arrayList) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            arrayList.add(defaultMutableTreeNode2.getUserObject());
        }
    }

    boolean restoreBBSTree() {
        BufferedReader bufferedReader = V2CLocalFileHandler.getSaveFileReader(V2CLocalFileHandler.getFileInBBSDir(this.vBBS, sSaveFile));
        if (bufferedReader == null) {
            if (V2CTreeModel.checkUNIXMountOption()) {
                V2CApp.immediateExit(0);
            }
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        V2CBoardCategoryItem v2CBoardCategoryItem = null;
        try {
            String string;
            boolean bl = true;
            block7: while ((string = bufferedReader.readLine()) != null) {
                int n = string.length();
                if (bl) {
                    bl = false;
                    if (n > 0 && string.charAt(0) == '\ufeff') {
                        if (n == 1) continue;
                        string = string.substring(1);
                        --n;
                    }
                }
                if (n < 2 && string.charAt(1) != ',') {
                    return false;
                }
                int n2 = string.charAt(0) - 48;
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                int n3 = string.indexOf(44, 3);
                if (n3 < 0) {
                    return false;
                }
                String string2 = string.substring(2, n3);
                String string3 = string.substring(n3 + 1);
                switch (n2) {
                    case 0: {
                        this.tnRoot = defaultMutableTreeNode = new DefaultMutableTreeNode(this.vBBS.getLabel());
                        this.bExpandRoot = string2.equals("E");
                        this.setRoot(defaultMutableTreeNode);
                        continue block7;
                    }
                    case 1: {
                        v2CBoardCategoryItem = new V2CBoardCategoryItem(string3, string2, this.vBBS);
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(v2CBoardCategoryItem);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        continue block7;
                    }
                    case 2: {
                        boolean bl2;
                        String string4 = string2;
                        boolean bl3 = bl2 = string4.charAt(0) != ' ';
                        if (!bl2) {
                            string4 = string4.substring(1);
                        }
                        V2CBoardItem v2CBoardItem = this.restoreBoardItem(string3, string4);
                        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(v2CBoardItem, false));
                        continue block7;
                    }
                }
                return false;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static boolean checkUNIXMountOption() {
        boolean bl;
        boolean bl2 = bl = V2CApp.isUNIX() && V2CLocalFileHandler.checkLCBBSDir();
        if (bl) {
            V2CSwingUtil.showErrorMessage("\u677f\u4e00\u89a7\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002\n\u3082\u3057Linux\u3067FAT32\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306b\u306fmount\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\n\"shortname=mixed\" \u3092\u6307\u5b9a\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean saveBBSTree() {
        Object object;
        int n;
        if (this.tnRoot == null) {
            return false;
        }
        V2CSaveFile v2CSaveFile = new V2CSaveFile(V2CLocalFileHandler.getFileInBBSDir(this.vBBS, sSaveFile));
        BufferedWriter bufferedWriter = v2CSaveFile.getWriter();
        if (bufferedWriter == null) {
            V2CSwingUtil.showErrorMessage("\u677f\u4e00\u89a7\u306e\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u677f\u4e00\u89a7\u306e\u66f4\u65b0");
            return false;
        }
        for (n = 0; n < this.jTree.getRowCount(); ++n) {
            object = (DefaultMutableTreeNode)this.jTree.getPathForRow(n).getLastPathComponent();
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (!(object2 instanceof V2CBoardCategoryItem)) continue;
            ((V2CBoardCategoryItem)object2).setExpanded(this.jTree.isExpanded(n));
        }
        try {
            try {
                bufferedWriter.write("0,E,");
                bufferedWriter.write(this.vBBS.getName());
                bufferedWriter.newLine();
                n = this.tnRoot.getChildCount();
                object = "1," + (n > 1 ? "C" : "E") + ",";
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tnRoot.getChildAt(i);
                    V2CBoardCategoryItem v2CBoardCategoryItem = (V2CBoardCategoryItem)defaultMutableTreeNode.getUserObject();
                    bufferedWriter.write((String)object);
                    bufferedWriter.write(v2CBoardCategoryItem.getName());
                    bufferedWriter.newLine();
                    for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                        V2CBoardItem v2CBoardItem = (V2CBoardItem)defaultMutableTreeNode2.getUserObject();
                        String string = v2CBoardItem.getURLStringForSave();
                        bufferedWriter.write("2,");
                        bufferedWriter.write(string);
                        bufferedWriter.write(44);
                        bufferedWriter.write(v2CBoardItem.getName());
                        bufferedWriter.newLine();
                    }
                }
                v2CSaveFile.setOK();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                V2CSwingUtil.showErrorMessage(iOException.getMessage(), "\u677f\u4e00\u89a7\u306e\u66f4\u65b0");
                boolean bl = false;
                Object var13_16 = null;
                V2CLocalFileHandler.closeWriter(bufferedWriter);
                return bl;
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            V2CLocalFileHandler.closeWriter(bufferedWriter);
            throw throwable;
        }
        V2CLocalFileHandler.closeWriter(bufferedWriter);
        v2CSaveFile.replaceTmpFile();
        return true;
    }

    static class BoardTmp {
        String sBoardName;
        String sHREF;
        BoardCategoryTmp bcTemp;

        public BoardTmp(String string, String string2, BoardCategoryTmp boardCategoryTmp) {
            this.sBoardName = string;
            this.sHREF = string2;
            this.bcTemp = boardCategoryTmp;
        }
    }

    static class BoardCategoryTmp {
        String sBoardCategoryName;
        ArrayList vBoard = new ArrayList();
        String sContent;

        public BoardCategoryTmp(String string) {
            this.sBoardCategoryName = string;
        }

        void add(BoardTmp boardTmp) {
            this.vBoard.add(boardTmp);
        }

        Object get(int n) {
            return this.vBoard.get(n);
        }

        void setElementAt(Object object, int n) {
            this.vBoard.set(n, object);
        }

        int getSize() {
            return this.vBoard.size();
        }
    }
}

