/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.migemo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;

class Dictionary {
    final File fFile;
    char[] clDict;
    int[] ilKeyIndex;
    short[] shlKeyLength;
    int nEntry;

    static Dictionary create(File fd, String se) {
        if (fd == null || !fd.isFile() || !fd.canRead()) {
            return null;
        }
        Dictionary dict = new Dictionary(fd);
        return dict.load(se) ? dict : null;
    }

    static void sortBranch(int[] ils, int is, int ie, char[] cld, int[] il, short[] shl) {
        int i1;
        int i0 = is;
        while ((i1 = 2 * i0 + 1) <= ie) {
            if (i1 < ie && Dictionary.compareForSort(ils[i1], ils[i1 + 1], cld, il, shl) < 0) {
                ++i1;
            }
            if (Dictionary.compareForSort(ils[i0], ils[i1], cld, il, shl) >= 0) {
                return;
            }
            int it = ils[i0];
            ils[i0] = ils[i1];
            ils[i1] = it;
            i0 = i1;
        }
    }

    static int compareForSort(int i0, int i1, char[] cld, int[] il, short[] shl) {
        short nc0 = shl[i0];
        short nc1 = shl[i1];
        i0 = il[i0];
        i1 = il[i1];
        int n0 = i0 + (nc0 < nc1 ? nc0 : nc1);
        while (i0 < n0) {
            int d = cld[i0] - cld[i1];
            if (d != 0) {
                return d;
            }
            ++i0;
            ++i1;
        }
        return nc0 - nc1;
    }

    Dictionary(File fd) {
        this.fFile = fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean load(String se) {
        block24: {
            nl = (int)this.fFile.length();
            if (nl == 0) {
                return true;
            }
            cld = new char[nl];
            isr = null;
            nc = 0;
            try {
                try {
                    isr = new InputStreamReader((InputStream)new FileInputStream(this.fFile), se != null ? se : "JISAutoDetect");
                    while ((nr = isr.read(cld, nc, nl - nc)) >= 0 && (nr <= 0 || (nc += nr) < nl)) {
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    var7_18 = false;
                    var9_11 = null;
                    if (isr == null) return var7_18;
                    try {
                        isr.close();
                        return var7_18;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return var7_18;
                }
                var9_10 = null;
                if (isr == null) break block24;
            }
            catch (Throwable var8_20) {
                var9_12 = null;
                if (isr == null) throw var8_20;
                ** try [egrp 2[TRYBLOCK] [4 : 131->139)] { 
lbl33:
                // 1 sources

                isr.close();
                throw var8_20;
lbl35:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var8_20;
            }
            try {}
            catch (IOException e) {}
            isr.close();
        }
        if (nc == 0) {
            return true;
        }
        if (nc < nl) {
            cln = new char[nc];
            System.arraycopy(cld, 0, cln, 0, nc);
            cld = cln;
        }
        il = new int[nc];
        shl = new short[nc];
        ne = 0;
        ic = 0;
        if (cld[0] == '\ufeff') {
            ++ic;
        }
        i0 = ic;
        while (ic < nc) {
            c = cld[ic];
            if (c == '\n' || c == '\r') {
                i0 = ic + 1;
            } else if (c == '\t' && (nkl = ic - i0) > 0 && nkl <= 32767 && cld[i0] != ';') {
                il[ne] = i0;
                shl[ne] = (short)nkl;
                ++ne;
            }
            ++ic;
        }
        if (ne == 0) {
            return true;
        }
        if (ne > 1) {
            ils = new int[ne];
            for (i = 0; i < ne; ++i) {
                ils[i] = i;
            }
            for (i = (ne - 1) / 2; i >= 0; --i) {
                Dictionary.sortBranch(ils, i, ne - 1, cld, il, shl);
            }
            for (i = ne - 1; i > 0; --i) {
                it = ils[i];
                ils[i] = ils[0];
                ils[0] = it;
                Dictionary.sortBranch(ils, 0, i - 1, cld, il, shl);
            }
            iln = new int[ne];
            shln = new short[ne];
            for (i = 0; i < ne; ++i) {
                is = ils[i];
                iln[i] = il[is];
                shln[i] = shl[is];
            }
        } else {
            iln = new int[]{il[0]};
            shln = new short[]{shl[0]};
        }
        this.ilKeyIndex = iln;
        this.shlKeyLength = shln;
        this.clDict = cld;
        this.nEntry = ne;
        return true;
    }

    int compare(int i, char[] cl1, int nc1) {
        int nc0 = this.shlKeyLength[i];
        int i0 = this.ilKeyIndex[i];
        int nc = nc0 < nc1 ? nc0 : nc1;
        char[] cl0 = this.clDict;
        int i1 = 0;
        while (i1 < nc) {
            int d = cl0[i0] - cl1[i1];
            if (d != 0) {
                return d;
            }
            ++i1;
            ++i0;
        }
        return nc0 - nc1;
    }

    boolean startsWith(int i, char[] cl1, int nc1) {
        short nc0 = this.shlKeyLength[i];
        if (nc0 < nc1) {
            return false;
        }
        int i0 = this.ilKeyIndex[i];
        char[] cl0 = this.clDict;
        int i1 = 0;
        while (i1 < nc1) {
            int d = cl0[i0] - cl1[i1];
            if (d != 0) {
                return false;
            }
            ++i1;
            ++i0;
        }
        return true;
    }

    boolean equals(int i, char[] cl1, int nc1) {
        short nc0 = this.shlKeyLength[i];
        if (nc0 != nc1) {
            return false;
        }
        int i0 = this.ilKeyIndex[i];
        char[] cl0 = this.clDict;
        int i1 = 0;
        while (i1 < nc1) {
            int d = cl0[i0] - cl1[i1];
            if (d != 0) {
                return false;
            }
            ++i1;
            ++i0;
        }
        return true;
    }

    int findStart(char[] cl1, int nc1) {
        if (this.compare(0, cl1, nc1) >= 0) {
            return 0;
        }
        int ip1 = this.nEntry - 1;
        if (ip1 == 0) {
            return 1;
        }
        int d = this.compare(ip1, cl1, nc1);
        if (d <= 0) {
            return d == 0 ? ip1 : ip1 + 1;
        }
        if (ip1 == 1) {
            return 1;
        }
        int ip0 = 0;
        do {
            int ipm;
            if ((d = this.compare(ipm = (ip0 + ip1) / 2, cl1, nc1)) == 0) {
                return ipm;
            }
            if (d > 0) {
                ip1 = ipm;
                continue;
            }
            ip0 = ipm + 1;
        } while (ip0 + 1 < ip1);
        return ip1;
    }

    void addWords(int ie, Set set) {
        int ip0;
        char[] cld = this.clDict;
        int nc = cld.length;
        for (int i = ip0 = this.ilKeyIndex[ie] + this.shlKeyLength[ie] + 1; i < nc; ++i) {
            char ci = cld[i];
            if (ci != '\t' && ci != '\n' && ci != '\r') continue;
            if (ip0 < i) {
                set.add(new String(cld, ip0, i - ip0));
            }
            if (ci != '\t') break;
            ip0 = i + 1;
        }
    }

    void lookup(String sk0, boolean be, Set set) {
        int i;
        int ne = this.nEntry;
        if (ne == 0) {
            return;
        }
        int nck = sk0.length();
        if (nck == 0) {
            return;
        }
        char[] clk = new char[nck];
        sk0.getChars(0, nck, clk, 0);
        int is = this.findStart(clk, nck);
        for (i = is - 1; i >= 0; --i) {
            if (be) {
                if (!this.startsWith(i, clk, nck)) break;
            } else if (!this.equals(i, clk, nck)) break;
            this.addWords(i, set);
        }
        for (i = is; i < ne; ++i) {
            if (be) {
                if (!this.startsWith(i, clk, nck)) break;
            } else if (!this.equals(i, clk, nck)) break;
            this.addWords(i, set);
        }
    }
}

