/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CAutoReloader;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CAutoReloadController
extends JPanel
implements ActionListener {
    private static final Color cNormal = new Color(8900331);
    private static final Color cWarning = Color.YELLOW;
    private static final Color cPaused = new Color(10025880);
    private static final Color cStopping = Color.RED;
    private static final int nReloadTimeUnit = 1800;
    private static final int nWarningLimit = 360;
    private static final int nStoppingLimit = 180;
    V2CThreadPanel vThreadPanel;
    JButton jbStart;
    JButton jbPause;
    JButton jbStop;
    JToggleButton jtbNextThread;
    JToggleButton jtbPage;
    JToggleButton jtbOneLineMode;
    JLabel jlTimeIndicator;
    JButton jbSet;
    JButton jbClose;
    boolean bRunning;
    private Timer tUpdateTimer;

    public V2CAutoReloadController(V2CThreadPanel v2CThreadPanel) {
        super(new GridBagLayout());
        JLabel jLabel;
        if (V2CApp.isMacintosh()) {
            this.setOpaque(true);
        }
        this.vThreadPanel = v2CThreadPanel;
        V2CAutoReloader v2CAutoReloader = v2CThreadPanel.vAutoReloader;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        Insets insets = new Insets(2, 7, 2, 7);
        this.jbStart = this.createButton("arstart", insets, gridBagConstraints);
        this.jbPause = this.createButton("arpause", insets, gridBagConstraints);
        this.jbStop = this.createButton("arstop", insets, gridBagConstraints);
        Insets insets2 = new Insets(2, 2, 2, 2);
        this.jtbNextThread = this.createToggleButton("arnextth", true, insets2, gridBagConstraints);
        this.jtbPage = this.createToggleButton("arpagesc", v2CAutoReloader != null ? v2CAutoReloader.bPageScroll : V2CAutoReloader.bPageScroll0, insets2, gridBagConstraints);
        boolean bl = v2CThreadPanel.isOneLineMode();
        this.jtbOneLineMode = this.createToggleButton("ar1lmode", bl, insets2, gridBagConstraints);
        this.jlTimeIndicator = jLabel = new JLabel("00:00:00");
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 12.0f));
        jLabel.setOpaque(true);
        this.resetCount();
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbSet = this.createButton("arset", insets2, gridBagConstraints);
        this.jbClose = this.createButton("arclose", insets2, gridBagConstraints);
        if (!bl && (v2CAutoReloader != null ? v2CAutoReloader.bOneLineMode : V2CAutoReloader.bOneLineMode0)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    V2CAutoReloadController.this.jtbOneLineMode.setSelected(true);
                    V2CAutoReloadController.this.vThreadPanel.setOneLineMode(true);
                }
            });
        }
    }

    public boolean isValidateRoot() {
        return true;
    }

    private JButton createButton(String string, Insets insets, GridBagConstraints gridBagConstraints) {
        JButton jButton = new JButton(V2CSwingUtil.getSystemIcon(string));
        jButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(jButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(jButton);
        }
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        this.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jButton;
    }

    private JToggleButton createToggleButton(String string, boolean bl, Insets insets, GridBagConstraints gridBagConstraints) {
        JToggleButton jToggleButton = new JToggleButton(V2CSwingUtil.getSystemIcon(string));
        jToggleButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(jToggleButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(jToggleButton);
        }
        if (bl) {
            jToggleButton.setSelected(bl);
        }
        jToggleButton.setMargin(insets);
        jToggleButton.addActionListener(this);
        this.add((Component)jToggleButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jToggleButton;
    }

    boolean isPageMode() {
        return this.jtbPage.isSelected();
    }

    void togglePageMode() {
        this.jtbPage.setSelected(!this.jtbPage.isSelected());
    }

    boolean isOneLineMode() {
        return this.jtbOneLineMode.isSelected();
    }

    void setOneLineMode(boolean bl) {
        this.jtbOneLineMode.setSelected(bl);
    }

    void started() {
        this.bRunning = true;
        this.updateCount();
        this.startUpdateTimer();
    }

    void stopped() {
        this.bRunning = false;
        this.stopUpdateTimer();
        this.resetCount();
    }

    void setMode(V2CAutoReloadController v2CAutoReloadController) {
        if (v2CAutoReloadController != null) {
            this.setNextThread(v2CAutoReloadController.getNextThread());
            this.jtbPage.setSelected(v2CAutoReloadController.jtbPage.isSelected());
            this.jtbOneLineMode.setSelected(v2CAutoReloadController.jtbOneLineMode.isSelected());
        }
    }

    void toggleNextThread() {
        this.setNextThread(!this.getNextThread());
    }

    void setNextThread(boolean bl) {
        this.jtbNextThread.setSelected(bl);
    }

    boolean getNextThread() {
        return this.jtbNextThread.isSelected();
    }

    void resetCount() {
        this.setCount(0, false);
    }

    void updateCount() {
        V2CAutoReloader v2CAutoReloader = this.vThreadPanel.vAutoReloader;
        this.setCount(v2CAutoReloader != null ? v2CAutoReloader.getRemainingTime() : 0, true);
    }

    void setCount(int n, boolean bl) {
        V2CAutoReloader v2CAutoReloader;
        if (bl && !this.bRunning) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n / 3600;
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        int n3 = n / 60 % 60;
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        stringBuffer.append(':');
        int n4 = n % 60;
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        this.jlTimeIndicator.setText(stringBuffer.toString());
        Color color = bl ? ((v2CAutoReloader = this.vThreadPanel.vAutoReloader) != null && v2CAutoReloader.isPaused() ? cPaused : (n <= 180 ? cStopping : (n <= 360 ? cWarning : cNormal))) : null;
        this.jlTimeIndicator.setBackground(color);
    }

    void startUpdateTimer() {
        if (this.tUpdateTimer == null) {
            this.tUpdateTimer = new Timer(1000, this);
        } else if (this.tUpdateTimer.isRunning()) {
            this.tUpdateTimer.stop();
        }
        this.tUpdateTimer.start();
    }

    void stopUpdateTimer() {
        if (this.tUpdateTimer != null && this.tUpdateTimer.isRunning()) {
            this.tUpdateTimer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbStart) {
            this.vThreadPanel.startAutoReload(true);
        } else if (object == this.jbPause) {
            this.vThreadPanel.togglePauseAutoReload();
        } else if (object == this.jbStop) {
            this.vThreadPanel.stopAutoReload();
        } else if (object == this.jtbPage) {
            this.vThreadPanel.setScrollMode(this.jtbPage.isSelected());
        } else if (object == this.jtbOneLineMode) {
            this.vThreadPanel.setOneLineMode(this.jtbOneLineMode.isSelected());
        } else if (object == this.jbSet) {
            V2CAutoReloader.setAutoReload();
        } else if (object == this.jbClose) {
            this.vThreadPanel.hideAutoReloadController(true);
        } else if (object == this.tUpdateTimer) {
            this.updateCount();
        }
    }
}

