/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CBoardCategoryItem;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CClearLogPanel;
import org.monazilla.v2c.V2CConsistencyChecker;
import org.monazilla.v2c.V2CFavoritePanel;
import org.monazilla.v2c.V2CGestureActionEvent;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CLogSearchPanel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProgressPanel;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSendToMenu;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTree;
import org.monazilla.v2c.V2CTreeModel;

public class V2CBoardTree
extends V2CTree {
    private static final String sKeyPrefix = "BoardTree.";
    private static final String sShowIconKey = "BoardTree.ShowIcon";
    private static final String sConfKey = "BoardTree.Conf";
    static final String sTreeStateKeyPrefix = "BBS.TreeState_";
    static boolean bAutoUpdate2chBoardTree;
    static boolean bAutoAdd;
    static boolean bShowIcon;
    static Icon icFolder;
    V2CBBS vBBS;
    Icon icBBS;
    boolean bUserDefined;
    static Icon icBoard;
    static Icon iCategoryIcon;
    static Icon iCategoryOpenIcon;

    static void setConf(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (V2CApp.setBooleanUserProperty(sShowIconKey, bShowIcon, bl, true)) {
            bShowIcon = bl;
            Object[] objectArray = V2CMain.getTrees();
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof V2CBoardTree)) continue;
                ((V2CBoardTree)object).updateUI();
            }
        }
        boolean bl4 = false;
        if (bl2 != bAutoUpdate2chBoardTree) {
            bl4 = true;
            bAutoUpdate2chBoardTree = bl2;
        }
        if (bl3 != bAutoAdd) {
            bAutoAdd = bl3;
            bl4 = true;
        }
        if (bl4) {
            V2CProperty v2CProperty = V2CApp.getUserProperty();
            if (bl2 || bl3) {
                object = new V2CPackedPropValue();
                ((V2CPackedPropValue)object).setBoolean('u', bl2);
                ((V2CPackedPropValue)object).setBoolean('a', bl3);
                v2CProperty.putPackedValue(sConfKey, (V2CPackedPropValue)object);
            } else {
                v2CProperty.remove(sConfKey);
            }
        }
    }

    static Icon getFolderIcon() {
        return icFolder;
    }

    public V2CBoardTree(V2CBBS v2CBBS) {
        this(v2CBBS, false);
    }

    public V2CBoardTree(V2CBBS v2CBBS, boolean bl) {
        super(v2CBBS.getTreeModel(), bl, false);
        TreeSelectionModel treeSelectionModel;
        this.vBBS = v2CBBS;
        this.icBBS = v2CBBS.getIcon();
        if (this.dTreeModel != null) {
            ((V2CTreeModel)this.dTreeModel).setTree(this);
        }
        if ((treeSelectionModel = this.getSelectionModel()) == null) {
            treeSelectionModel = new DefaultTreeSelectionModel();
            this.setSelectionModel(treeSelectionModel);
        }
        treeSelectionModel.setSelectionMode(1);
        MyRenderer myRenderer = new MyRenderer();
        if (fTreeFont != null) {
            myRenderer.setFont(fTreeFont);
        }
        this.setCellRenderer(myRenderer);
        this.setTextColors();
        this.vGestureMap = V2CGestureMap.getGestureMap("BoardTree");
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.addMouseMotionListener(popupListener);
        V2CSwingUtil.restoreTreeStates(this, sTreeStateKeyPrefix + v2CBBS.getID());
        V2CInputMap.setKeyBind(this, 0, "BoardTree");
    }

    public Icon getIcon() {
        return this.icBBS;
    }

    public Icon getDefaultIcon() {
        return this.icBBS;
    }

    public String getTitleString() {
        return this.vBBS.getLabel();
    }

    public V2CProgressState getProgressState() {
        return null;
    }

    void saveTreeStates() {
        V2CSwingUtil.saveTreeStates(this, sTreeStateKeyPrefix + this.vBBS.getID());
    }

    void manualServerMove() {
        V2CBoardItem v2CBoardItem = this.getSelectedBoardItem();
        if (v2CBoardItem != null && v2CBoardItem.manualServerMove()) {
            ((V2CTreeModel)this.dTreeModel).saveBBSTree();
        }
    }

    void updateTreeModel(boolean bl) {
        if (bl && !bAutoUpdate2chBoardTree) {
            return;
        }
        if (!this.vBBS.isUpdateModelSupported()) {
            V2CSwingUtil.showErrorMessage("\u73fe\u5728V2C\u306f " + this.vBBS.getName() + " \u306e\u677f\u4e00\u89a7\u306e\n\u81ea\u52d5\u66f4\u65b0\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002", "\u677f\u4e00\u89a7\u30a8\u30e9\u30fc");
            return;
        }
        if (!V2CMain.isOnlineMode()) {
            return;
        }
        if (!this.setUpdating(true)) {
            System.out.println("already updating !");
            return;
        }
        V2CProgressPanel v2CProgressPanel = bl ? null : new V2CProgressPanel("\u677f\u4e00\u89a7\u3092\u53d6\u5f97\u4e2d...", "\u677f\u4e00\u89a7\u66f4\u65b0");
        UpdateModelThread updateModelThread = new UpdateModelThread(v2CProgressPanel);
        if (bl) {
            updateModelThread.start();
        } else if (!v2CProgressPanel.showPanel(updateModelThread)) {
            updateModelThread.interrupt();
            return;
        }
    }

    HashSet createOpenCategorySet() {
        HashSet<String> hashSet = new HashSet<String>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.dTreeModel.getRoot();
        if (defaultMutableTreeNode == null) {
            return hashSet;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof V2CBoardCategoryItem) || !this.isExpanded(new TreePath(defaultMutableTreeNode2.getPath()))) continue;
            hashSet.add(((V2CBoardCategoryItem)object).getName());
        }
        return hashSet;
    }

    void restoreOpenCategorySet(HashSet hashSet) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.dTreeModel.getRoot();
        if (defaultMutableTreeNode == null) {
            return;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof V2CBoardCategoryItem) || !hashSet.contains(((V2CBoardCategoryItem)object).getName())) continue;
            this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    void openSelectedBoard(boolean bl) {
        this.openSelectedItem(bl, false, true);
    }

    void openSelectedItem(String string) {
        if (string == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("ON")) {
            bl = true;
        } else if (string.equals("BN")) {
            bl = true;
            bl2 = true;
        }
        this.openSelectedItem(bl, bl2, false);
    }

    void openSelectedItem(boolean bl, boolean bl2, boolean bl3) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof V2CBoardItem) {
            V2CMain.hideTreePaneFrame(false);
            ((V2CBoardItem)object).open(true, bl, bl2);
        } else {
            if (bl3) {
                return;
            }
            if (object instanceof V2CBoardCategoryItem) {
                TreeNode treeNode = (TreeNode)this.dTreeModel.getRoot();
                if (defaultMutableTreeNode == treeNode) {
                    return;
                }
                TreePath treePath = this.getSelectionPath();
                if (treePath != null) {
                    this.expandTreeFolder(treePath, defaultMutableTreeNode);
                }
            }
        }
    }

    V2CBoardItem findBoardByDirName(String string) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.dTreeModel.getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            V2CBoardItem v2CBoardItem;
            String string2;
            Object object = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            if (!(object instanceof V2CBoardItem) || !(string2 = (v2CBoardItem = (V2CBoardItem)object).getURLString()).endsWith(string)) continue;
            return v2CBoardItem;
        }
        return null;
    }

    void logSearchInSelectedItem(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            if (!(actionEvent instanceof V2CGestureActionEvent)) {
                return;
            }
            object3 = (V2CGestureActionEvent)actionEvent;
            if (((V2CGestureActionEvent)object3).getComponent() != this) {
                return;
            }
            object2 = ((V2CGestureActionEvent)object3).getStartPoint();
            object = this.getPathForLocation(((Point)object2).x, ((Point)object2).y);
            if (object == null) {
                return;
            }
            this.setSelectionPath((TreePath)object);
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
        }
        object3 = defaultMutableTreeNode.getUserObject();
        object2 = null;
        object = null;
        if (object3 instanceof String) {
            object = this.vBBS.createBoardList();
            object2 = this.vBBS.getName();
        } else if (object3 instanceof V2CBoardCategoryItem) {
            V2CBoardCategoryItem v2CBoardCategoryItem = (V2CBoardCategoryItem)object3;
            object = v2CBoardCategoryItem.createBoardList();
            object2 = v2CBoardCategoryItem.getName();
        } else if (object3 instanceof V2CBoardItem) {
            V2CBoardItem v2CBoardItem = (V2CBoardItem)object3;
            object = new V2CBoardItem[]{v2CBoardItem};
            object2 = v2CBoardItem.getName();
        }
        if (object == null) {
            return;
        }
        V2CLogSearchPanel.showPanel(object, (String)object2, false);
    }

    void checkConsistencyInSelectedItem() {
        Object object = ((DefaultMutableTreeNode)this.getLastSelectedPathComponent()).getUserObject();
        if (object instanceof V2CBoardItem) {
            V2CConsistencyChecker.check((V2CBoardItem)object);
        }
    }

    void showClearLogPanel() {
        Object object = ((DefaultMutableTreeNode)this.getLastSelectedPathComponent()).getUserObject();
        String string = null;
        if (object instanceof String) {
            string = this.vBBS.getName();
        } else if (object instanceof V2CBoardCategoryItem) {
            string = ((V2CBoardCategoryItem)object).getName();
        } else if (object instanceof V2CBoardItem) {
            string = ((V2CBoardItem)object).getName();
        } else {
            return;
        }
        V2CClearLogPanel v2CClearLogPanel = new V2CClearLogPanel(string);
        if (!v2CClearLogPanel.showDialog()) {
            return;
        }
        V2CBoardItem[] v2CBoardItemArray = null;
        if (object instanceof String) {
            v2CBoardItemArray = this.vBBS.createBoardList();
        } else if (object instanceof V2CBoardCategoryItem) {
            v2CBoardItemArray = ((V2CBoardCategoryItem)object).createBoardList();
        } else if (object instanceof V2CBoardItem) {
            v2CBoardItemArray = new V2CBoardItem[]{(V2CBoardItem)object};
        }
        if (v2CBoardItemArray == null || v2CBoardItemArray.length == 0) {
            return;
        }
        V2CBoardItem.clearLogs(v2CBoardItemArray, v2CClearLogPanel.getDeleteActive());
    }

    void copySelectedBoardCategory() {
        Object object = ((DefaultMutableTreeNode)this.getLastSelectedPathComponent()).getUserObject();
        if (!(object instanceof V2CBoardCategoryItem)) {
            return;
        }
        V2CFavoritePanel.copyBoardCategoryItem((V2CBoardCategoryItem)object);
    }

    void copySelectedBoard() {
        V2CBoardItem v2CBoardItem = this.getSelectedBoardItem();
        if (v2CBoardItem == null) {
            return;
        }
        V2CFavoritePanel.copyBoardItem(v2CBoardItem);
    }

    void openSelectedBoardOutside() {
        V2CBoardItem v2CBoardItem = this.getSelectedBoardItem();
        if (v2CBoardItem == null) {
            return;
        }
        V2CMiscUtil.openLinkOutside(v2CBoardItem.getURLString());
    }

    V2CBoardItem getSelectedBoardItem() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof V2CBoardItem) {
            return (V2CBoardItem)object;
        }
        return null;
    }

    V2CBBS getBBS() {
        return this.vBBS;
    }

    void createNewThread() {
        V2CBoardItem v2CBoardItem = this.getSelectedBoardItem();
        if (v2CBoardItem == null) {
            return;
        }
        V2CMain.hideTreePaneFrame(false);
        v2CBoardItem.createNewThread();
    }

    void showPopup(MouseEvent mouseEvent, Point point) {
        JPopupMenu jPopupMenu;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        boolean bl = false;
        String string = null;
        if (object instanceof V2CBoardItem) {
            string = "Board";
            bl = true;
        } else if (object instanceof V2CBoardCategoryItem) {
            string = "BoardCategory";
            bl = true;
        } else if (object instanceof String) {
            string = "BBS";
        } else {
            return;
        }
        if (this.bUserDefined) {
            string = string + "UD";
        }
        if ((jPopupMenu = V2CMain.getPopupMenu(string)) == null) {
            return;
        }
        if (bl) {
            V2CSendToMenu.setItemAndPoint(object, point);
        }
        V2CPopupListener.showPopup(jPopupMenu, mouseEvent, this, point.x, point.y);
    }

    static {
        icFolder = icNativeFolder != null ? icNativeFolder : V2CSwingUtil.getItemIcon("Category");
        bShowIcon = V2CMain.getUserProperty().getBoolean(sShowIconKey, true);
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sConfKey);
        if (v2CPackedPropValue != null) {
            bAutoUpdate2chBoardTree = v2CPackedPropValue.getBoolean('u');
            bAutoAdd = v2CPackedPropValue.getBoolean('a');
        }
        icBoard = V2CBoardItem.getIcon();
        iCategoryIcon = icFolder;
        iCategoryOpenIcon = icNativeDocument != null ? icNativeDocument : V2CSwingUtil.getItemIcon("CategoryOpen");
    }

    class PopupListener
    extends V2CTree.LabelPopupListener {
        PopupListener() {
            super(V2CBoardTree.this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (V2CBoardTree.this.vGestureMap.mouseDragged(mouseEvent)) {
                mouseEvent.consume();
                return;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!V2CPopupListener.isDefined(mouseEvent)) {
                return;
            }
            this.nModifiersEx = mouseEvent.getModifiersEx();
            if (V2CBoardTree.this.vGestureMap.mousePressed(mouseEvent, true)) {
                V2CBoardTree.this.showPopup(mouseEvent);
            }
            if (V2CGestureMap.isInGesture()) {
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!V2CPopupListener.isDefined(mouseEvent)) {
                return;
            }
            boolean bl = V2CGestureMap.isInGesture();
            if (V2CBoardTree.this.vGestureMap.mouseReleased(mouseEvent)) {
                V2CBoardTree.this.showPopup(mouseEvent);
                return;
            }
            if (V2CApp.isMacintosh() ? bl && V2CGestureMap.hasPointerMoved() : bl) {
                return;
            }
            if (mouseEvent.getClickCount() == 1) {
                TreePath treePath = V2CBoardTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                V2CBoardTree.this.setSelectionPath(treePath);
            }
            V2CBoardTree.this.openSelectedItem(V2CMouseClickManager.checkClickAction("G", mouseEvent));
        }
    }

    private class MyRenderer
    extends V2CTree.ItemRenderer {
        MyRenderer() {
            this.setClosedIcon(iCategoryIcon);
            this.setOpenIcon(iCategoryOpenIcon);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (bShowIcon) {
                if (object2 instanceof V2CBoardItem) {
                    this.setIcon(icBoard);
                } else if (object2 instanceof String) {
                    this.setIcon(V2CBoardTree.this.icBBS);
                }
            } else {
                this.setIcon(null);
            }
            Color color = null;
            if (object2 instanceof V2CBoardItem) {
                color = ((V2CBoardItem)object2).getColor(false);
            }
            this.cLabelColor = color;
            this.bSelected = bl;
            return this;
        }
    }

    private class UpdateModelThread
    extends Thread {
        final V2CProgressPanel vProgressPanel;

        UpdateModelThread(V2CProgressPanel v2CProgressPanel) {
            this.vProgressPanel = v2CProgressPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                final HashSet hashSet = V2CBoardTree.this.createOpenCategorySet();
                final StringBuffer stringBuffer = new StringBuffer();
                ((V2CTreeModel)V2CBoardTree.this.dTreeModel).updateModel(this.vProgressPanel, stringBuffer);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        V2CBoardTree.this.restoreOpenCategorySet(hashSet);
                        if (stringBuffer.length() > 0) {
                            JTextArea jTextArea = new JTextArea(stringBuffer.toString());
                            jTextArea.setEditable(false);
                            jTextArea.setMargin(new Insets(5, 10, 5, 10));
                            JScrollPane jScrollPane = V2CSwingUtil.createBoundedScrollPane(jTextArea, 0.8, 0.8);
                            V2CSwingUtil.showDialogWithClose(jScrollPane, null, "\u677f\u4e00\u89a7\u66f4\u65b0\u60c5\u5831");
                        }
                    }
                });
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                V2CBoardTree.this.setUpdating(false);
                if (this.vProgressPanel != null) {
                    this.vProgressPanel.hidePanel();
                }
                throw throwable;
            }
            V2CBoardTree.this.setUpdating(false);
            if (this.vProgressPanel != null) {
                this.vProgressPanel.hidePanel();
            }
        }
    }
}

