/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCustomTabbedPaneUI;
import org.monazilla.v2c.V2CJSE6Util;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CSingleTabbedPane;
import org.monazilla.v2c.V2CTabbedPane;

public class V2CCustomTabbedPane
extends JTabbedPane {
    private static final String UNKNOWN_TITLE = "\u540d\u79f0\u672a\u8a2d\u5b9a";
    private final V2CSingleTabbedPane vParentTabbedPane;
    int nTabPosition;
    boolean bFlatTab;
    int nFixedTabHeight;
    boolean bLimitTitleChars;
    boolean bTruncateTitle;
    int nMaxFullLengthTab;
    int nMaxTitleLength;
    boolean bFixTabWidth;
    int nFixedTabWidth;
    int nMaxFixedTabWidth;
    boolean bUseTabComponent;
    int iDragTargetIndex = -1;

    public V2CCustomTabbedPane(V2CSingleTabbedPane v2CSingleTabbedPane, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl2;
        this.vParentTabbedPane = v2CSingleTabbedPane;
        this.setTabPosition(n);
        boolean bl3 = n3 == 1;
        boolean bl4 = n3 == 2;
        boolean bl5 = bl2 = !bl && bl4;
        if (bl2 && !V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            bl2 = false;
            bl = true;
        }
        this.bFlatTab = bl;
        this.nFixedTabHeight = n2;
        this.bLimitTitleChars = bl3;
        this.nMaxFullLengthTab = n4;
        this.nMaxTitleLength = n5;
        this.bFixTabWidth = bl4;
        this.nFixedTabWidth = n6;
        this.nMaxFixedTabWidth = n7;
        this.bUseTabComponent = bl2;
        if (bl) {
            this.updateUI();
        }
    }

    private void setTabPosition(int n) {
        int n2;
        if (n == this.nTabPosition) {
            return;
        }
        this.nTabPosition = n;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        this.setTabPlacement(n2);
    }

    void reconfigure(int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = n3 == 1;
        boolean bl6 = n3 == 2;
        boolean bl7 = bl2 = !bl && bl6;
        if (bl2 && !V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            bl2 = false;
            bl = true;
        }
        this.setTabPosition(n);
        if (bl2 != this.bUseTabComponent) {
            this.bUseTabComponent = bl2;
            bl4 = true;
            int n8 = this.getTabCount();
            if (bl2) {
                for (int i = 0; i < n8; ++i) {
                    V2CJSE6Util.setTabComponentAt(this, i, this.createTabComponent(null, this.getIconAt(i)));
                }
            } else {
                for (int i = 0; i < n8; ++i) {
                    V2CJSE6Util.setTabComponentAt(this, i, null);
                }
            }
        }
        if (bl != this.bFlatTab) {
            this.bFlatTab = bl;
            bl3 = true;
        }
        if (n2 != this.nFixedTabHeight) {
            this.nFixedTabHeight = n2;
            bl3 = true;
        }
        this.nMaxFullLengthTab = n4;
        this.nMaxTitleLength = n5;
        if (bl5 || this.bLimitTitleChars) {
            this.bLimitTitleChars = bl5;
            this.bTruncateTitle = bl5 ? this.getTabCount() > n4 : false;
            bl4 = true;
        }
        if (bl6 != this.bFixTabWidth) {
            this.bFixTabWidth = bl6;
            bl3 = true;
        }
        if (bl6 && (n6 != this.nFixedTabWidth || n7 != this.nMaxFixedTabWidth)) {
            this.nFixedTabWidth = n6;
            this.nMaxFixedTabWidth = n7;
            bl3 = true;
        }
        if (bl4) {
            this.resetTabTitles();
            this.resetTooltips();
        }
        if (bl3) {
            this.updateUI();
        }
    }

    void sendChangeEventToOthers() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            final ChangeListener changeListener = changeListenerArray[i];
            if (changeListener instanceof V2CTabbedPane) continue;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    changeListener.stateChanged(new ChangeEvent(V2CCustomTabbedPane.this));
                }
            });
        }
    }

    String checkPanelTitle(String string) {
        if (this.bTruncateTitle && string.length() > this.nMaxTitleLength) {
            string = string.substring(0, this.nMaxTitleLength - 1) + '\u2026';
        }
        return string;
    }

    void manageTooltip(int n, boolean bl) {
        if (!(bl || this.bLimitTitleChars && this.bTruncateTitle || this.bFixTabWidth)) {
            return;
        }
        String string = null;
        V2CPanel v2CPanel = this.getPanelAt(n);
        if (v2CPanel != null) {
            string = v2CPanel.getTitleString();
        }
        if (string == null) {
            string = UNKNOWN_TITLE;
        }
        if (!(this.bTruncateTitle && string.length() > this.nMaxTitleLength || this.bFixTabWidth)) {
            string = null;
        }
        this.setToolTipTextAt(n, string);
    }

    int getFixedTabHeight() {
        return this.nFixedTabHeight;
    }

    V2CPanel getPanelAt(int n) {
        Component component = this.getComponentAt(n);
        if (!(component instanceof V2CPanel)) {
            if (component instanceof JScrollPane) {
                if (!((component = ((JScrollPane)component).getViewport().getView()) instanceof V2CPanel)) {
                    component = null;
                }
            } else {
                component = null;
            }
        }
        return (V2CPanel)((Object)component);
    }

    void checkTabCount(int n) {
        if (!this.bLimitTitleChars) {
            return;
        }
        int n2 = this.getTabCount() + n;
        boolean bl = false;
        if (this.bTruncateTitle) {
            if (n2 <= this.nMaxFullLengthTab) {
                this.bTruncateTitle = false;
                bl = true;
            }
        } else if (n2 > this.nMaxFullLengthTab) {
            this.bTruncateTitle = true;
            bl = true;
        }
        if (bl) {
            this.resetTabTitles();
        }
    }

    void resetTabTitles() {
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            V2CPanel v2CPanel = this.getPanelAt(i);
            if (v2CPanel == null) continue;
            this.setTitleAt(i, V2CSingleTabbedPane.getPanelTitle(v2CPanel));
        }
    }

    void resetTooltips() {
        int n = this.getTabCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.manageTooltip(i, true);
            }
        }
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        this.checkTabCount(1);
        string = this.checkPanelTitle(string);
        if (this.bUseTabComponent) {
            super.insertTab(null, icon, component, string2, n);
            V2CJSE6Util.setTabComponentAt(this, n, this.createTabComponent(string, icon));
        } else {
            super.insertTab(string, icon, component, string2, n);
        }
        this.manageTooltip(n, false);
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof V2CCustomTabbedPaneUI) {
            ((V2CCustomTabbedPaneUI)tabbedPaneUI).resetTabVisibilityChecked();
        }
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.checkTabCount(1);
        string = this.checkPanelTitle(string);
        if (this.bUseTabComponent) {
            super.addTab(null, icon, component, string2);
            V2CJSE6Util.setTabComponentAt(this, this.getTabCount() - 1, this.createTabComponent(string, icon));
        } else {
            super.addTab(string, icon, component, string2);
        }
        this.manageTooltip(this.getTabCount() - 1, false);
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof V2CCustomTabbedPaneUI) {
            ((V2CCustomTabbedPaneUI)tabbedPaneUI).resetTabVisibilityChecked();
        }
    }

    public void addTab(String string, Icon icon, Component component) {
        this.addTab(string, icon, component, null);
    }

    public void addTab(String string, Component component) {
        this.addTab(string, null, component, null);
    }

    public void remove(Component component) {
        int n = this.getTabCount();
        super.remove(component);
        int n2 = this.getTabCount();
        if (n2 < n) {
            this.checkTabCount(0);
        }
    }

    public void remove(int n) {
        int n2 = this.getTabCount();
        super.remove(n);
        int n3 = this.getTabCount();
        if (n3 < n2) {
            this.checkTabCount(0);
        }
    }

    public void setIconAt(int n, Icon icon) {
        Component component;
        super.setIconAt(n, icon);
        if (this.bUseTabComponent && (component = V2CJSE6Util.getTabComponentAt(this, n)) instanceof JLabel) {
            ((JLabel)component).setIcon(icon);
        }
    }

    String getRealTitleAt(int n) {
        V2CPanel v2CPanel = this.getPanelAt(n);
        return v2CPanel != null ? v2CPanel.getTitleString() : null;
    }

    public void setTitleAt(int n, String string) {
        string = this.checkPanelTitle(string);
        if (this.bUseTabComponent) {
            Component component = V2CJSE6Util.getTabComponentAt(this, n);
            if (component instanceof JLabel) {
                ((JLabel)component).setText(string);
            }
        } else {
            super.setTitleAt(n, string);
        }
        this.manageTooltip(n, true);
    }

    Component createTabComponent(String string, Icon icon) {
        return new FixedWidthLabel(string, icon, 4);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.bUseTabComponent) {
            int n = this.getTabCount();
            for (int i = 0; i < n; ++i) {
                Component component = V2CJSE6Util.getTabComponentAt(this, i);
                if (!(component instanceof FixedWidthLabel)) continue;
                ((FixedWidthLabel)component).setFont(font);
            }
        }
    }

    public void setForegroundAt(int n, Color color) {
        Component component;
        super.setForegroundAt(n, color);
        if (this.bUseTabComponent && n >= 0 && n < this.getTabCount() && (component = V2CJSE6Util.getTabComponentAt(this, n)) instanceof FixedWidthLabel) {
            ((FixedWidthLabel)component).setForeground(color);
        }
    }

    public void setTabLayoutPolicy(int n) {
        super.setTabLayoutPolicy(n);
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof V2CCustomTabbedPaneUI) {
            ((V2CCustomTabbedPaneUI)tabbedPaneUI).tabLayoutPolicyChanged(n);
        }
    }

    public void doLayout() {
        boolean bl;
        TabbedPaneUI tabbedPaneUI = this.getUI();
        V2CCustomTabbedPaneUI v2CCustomTabbedPaneUI = null;
        if (tabbedPaneUI instanceof V2CCustomTabbedPaneUI) {
            v2CCustomTabbedPaneUI = (V2CCustomTabbedPaneUI)tabbedPaneUI;
        }
        boolean bl2 = bl = this.getTabLayoutPolicy() == 0;
        if (v2CCustomTabbedPaneUI != null) {
            v2CCustomTabbedPaneUI.calculateTabWidth(this.getTabPlacement(), this.getTabCount(), bl);
        }
        super.doLayout();
        if (!bl && v2CCustomTabbedPaneUI != null) {
            v2CCustomTabbedPaneUI.adjustScrollTabButtonSize(this.getTabPlacement());
        }
    }

    public void updateUI() {
        if (this.bFlatTab) {
            this.setUI(new V2CCustomTabbedPaneUI(this.bFixTabWidth, this.nFixedTabWidth, this.nMaxFixedTabWidth));
        } else {
            super.updateUI();
        }
    }

    void setDragTargetIndex(int n) {
        Rectangle rectangle;
        int n2 = this.getTabCount();
        if (n == n2) {
            --n;
        }
        if (n == this.iDragTargetIndex) {
            return;
        }
        int n3 = this.iDragTargetIndex;
        this.iDragTargetIndex = n;
        if (n2 == 0) {
            return;
        }
        if (n3 >= 0 && (rectangle = this.getBoundsAt(n3)) != null) {
            this.repaint(rectangle);
        }
        if (n >= 0 && (rectangle = this.getBoundsAt(n)) != null) {
            this.repaint(rectangle);
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        super.paint(graphics);
        this.vParentTabbedPane.paintAttributes(graphics);
        if (this.iDragTargetIndex >= 0 && (rectangle = this.getBoundsAt(this.iDragTargetIndex)) != null) {
            graphics.setColor(new Color(V2CApp.isMacintosh() ? 0x404040FF : 1090478919, true));
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        }
    }

    private class FixedWidthLabel
    extends JLabel {
        FixedWidthLabel(String string, Icon icon, int n) {
            super(string, icon, n);
            this.setFont(V2CCustomTabbedPane.this.getFont());
            this.setHorizontalAlignment(2);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (V2CCustomTabbedPane.this.bUseTabComponent) {
                dimension.width = V2CCustomTabbedPane.this.nFixedTabWidth;
            }
            return dimension;
        }
    }
}

