/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCharSequence;
import org.monazilla.v2c.V2CFontTextSegment;
import org.monazilla.v2c.V2CHighlightItem;
import org.monazilla.v2c.V2CHighlightRegion;
import org.monazilla.v2c.V2CKeywordHighlightItem;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNameKeywordHighlightItem;
import org.monazilla.v2c.V2CTextMarkerItem;
import org.monazilla.v2c.V2CTextSegment;

public class V2CHTMLString
implements CharSequence {
    static final int TAG_COMMENT = 1;
    static final int TAG_HR = 2;
    static final int TAG_BOLD = 3;
    static final int TAG_BOLD_END = 4;
    static final int TAG_ITALIC = 5;
    static final int TAG_ITALIC_END = 6;
    static final int TAG_FONT = 7;
    static final int TAG_FONT_END = 8;
    static final int TAG_UNORDEREDLIST = 9;
    static final int TAG_UNORDEREDLIST_END = 10;
    static final int TAG_P = 11;
    static final int TAG_BQ = 12;
    static final int TAG_P_END = 13;
    static final int TAG_BQ_END = 14;
    private static final boolean bHideUnprocessedTags = false;
    static final HashMap hmEntity = new HashMap();
    static final String[] slEntity = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml", "fnof", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega", "alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv", "bull", "hellip", "prime", "Prime", "oline", "frasl", "weierp", "image", "real", "trade", "alefsym", "larr", "uarr", "rarr", "darr", "harr", "crarr", "lArr", "uArr", "rArr", "dArr", "hArr", "forall", "part", "exist", "empty", "nabla", "isin", "notin", "ni", "prod", "sum", "minus", "lowast", "radic", "prop", "infin", "ang", "and", "or", "cap", "cup", "int", "there4", "sim", "cong", "asymp", "ne", "equiv", "le", "ge", "sub", "sup", "nsub", "sube", "supe", "oplus", "otimes", "perp", "sdot", "lceil", "rceil", "lfloor", "rfloor", "lang", "rang", "loz", "spades", "clubs", "hearts", "diams", "quot", "amp", "lt", "gt", "OElig", "oelig", "Scaron", "scaron", "Yuml", "circ", "tilde", "ensp", "emsp", "thinsp", "zwnj", "zwj", "lrm", "rlm", "ndash", "mdash", "lsquo", "rsquo", "sbquo", "ldquo", "rdquo", "bdquo", "dagger", "Dagger", "permil", "lsaquo", "rsaquo", "euro"};
    static final char[] clEntity;
    final boolean bName;
    V2CTextSegment[] vlTextSegment = new V2CTextSegment[10];
    int nTextSegment;
    int[] ilDrawOrder;
    final Object oTSLockObject = new byte[0];
    char[] clMsg;
    int nMsgLength;
    boolean bCommentTag;
    boolean bVirtualTagInserted;
    ArrayList alKeywords;
    boolean bHighlightChecked;

    public V2CHTMLString(boolean bl) {
        this.bName = bl;
    }

    void breakMessageLines(String string, boolean bl) {
        char[] cArray = new char[string.length() + 1];
        string.getChars(0, string.length(), cArray, 0);
        this.breakMessageLines(cArray, cArray.length - 1, bl);
    }

    void breakMessageLines(char[] cArray, int n, boolean bl) {
        int n2;
        --n;
        while (n >= 0 && (n2 = cArray[n]) == 32) {
            --n;
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = ++n - 3;
        for (int i = 0; i < n5; ++i) {
            char c;
            int n6;
            int n7;
            if (cArray[i] != '<' || cArray[i + 1] != 'b' || cArray[i + 2] != 'r') continue;
            char c2 = cArray[i + 3];
            if (c2 == '>') {
                n7 = 4;
            } else {
                if (i + 5 >= n || c2 != ' ' || cArray[i + 4] != '/' || cArray[i + 5] != '>') continue;
                n7 = 6;
            }
            for (n6 = i - 1; n6 >= n3 && (c = cArray[n6]) == ' '; --n6) {
            }
            if (n6 >= n3) {
                if (n3 != n4) {
                    System.arraycopy(cArray, n3, cArray, n4, n6 - n3 + 1);
                }
                n4 += n6 - n3 + 1;
            }
            cArray[n4++] = 10;
            ++n2;
            if (i + n7 < n && cArray[i + n7] == ' ') {
                ++i;
            }
            n3 = i + n7;
            i += n7 - 1;
        }
        if (n3 < n) {
            if (n3 != n4) {
                System.arraycopy(cArray, n3, cArray, n4, n - n3);
            }
            n4 += n - n3;
        }
        if (bl) {
            cArray[n4++] = 10;
        }
        if (cArray.length < n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = cArray2;
        }
        this.clMsg = cArray;
        this.nMsgLength = n4;
    }

    void replaceEscapes() {
        int n;
        char[] cArray = this.clMsg;
        int n2 = 0;
        while ((n2 = this.indexInMsg("&", n2)) >= 0 && (n = this.nMsgLength) > n2 + 2) {
            block14: {
                int n3;
                int n4;
                int n5;
                block13: {
                    block16: {
                        String string;
                        block17: {
                            block10: {
                                block15: {
                                    int n6;
                                    block11: {
                                        block12: {
                                            int n7;
                                            if (cArray[n2 + 1] != '#') break block10;
                                            if (cArray[n2 + 2] != 'X' && cArray[n2 + 2] != 'x') break block11;
                                            if (n <= n2 + 3) break;
                                            int n8 = 0;
                                            for (n7 = n2 + 3; n7 < n; ++n7) {
                                                n5 = cArray[n7];
                                                if (n5 >= 48 && n5 <= 57) {
                                                    if ((n8 = n8 * 16 + (n5 - 48)) <= 0x10FFFF) continue;
                                                    n8 = -1;
                                                    break;
                                                }
                                                if (n5 >= 65 && n5 <= 70) {
                                                    if ((n8 = n8 * 16 + (n5 - 65 + 10)) <= 0x10FFFF) continue;
                                                    n8 = -1;
                                                    break;
                                                }
                                                if (n5 >= 97 && n5 <= 102) {
                                                    if ((n8 = n8 * 16 + (n5 - 97 + 10)) <= 0x10FFFF) continue;
                                                    n8 = -1;
                                                    break;
                                                }
                                                if (n5 != 59) break;
                                                ++n7;
                                                break;
                                            }
                                            if (n8 <= 0) break block12;
                                            n4 = n8;
                                            n3 = n7;
                                            break block13;
                                        }
                                        n2 += 3;
                                        break block14;
                                    }
                                    int n9 = 0;
                                    for (n6 = n2 + 2; n6 < n; ++n6) {
                                        n5 = cArray[n6];
                                        if (n5 >= 48 && n5 <= 57) {
                                            if ((n9 = n9 * 10 + (n5 - 48)) <= 0x10FFFF) continue;
                                            n9 = -1;
                                            break;
                                        }
                                        if (n5 != 59) break;
                                        ++n6;
                                        break;
                                    }
                                    if (n9 <= 0) break block15;
                                    n4 = n9;
                                    n3 = n6;
                                    break block13;
                                }
                                n2 += 2;
                                break block14;
                            }
                            string = this.lookingAtEntity(n2 + 1);
                            if (string == null) break block16;
                            Character c = (Character)hmEntity.get(string);
                            if (c == null) break block17;
                            n3 = n2 + 1 + string.length() + 1;
                            n4 = c.charValue();
                            break block13;
                        }
                        n2 += string.length() + 1;
                        break block14;
                    }
                    ++n2;
                    break block14;
                }
                boolean bl = n4 < 65536;
                int n10 = bl ? 1 : 2;
                n5 = n - n3;
                if (n5 > 0) {
                    System.arraycopy(cArray, n3, cArray, n2 + n10, n5);
                }
                if (bl) {
                    cArray[n2++] = (char)n4;
                } else {
                    cArray[n2++] = (char)(((n4 -= 65536) >> 10 & 0x3FF) + 55296);
                    cArray[n2++] = (char)((n4 & 0x3FF) + 56320);
                }
                this.nMsgLength -= n3 - n2;
            }
            if (n2 < this.nMsgLength) continue;
        }
    }

    private String lookingAtEntity(int n) {
        char[] cArray = this.clMsg;
        int n2 = Math.min(n + 9, cArray.length);
        boolean bl = false;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            boolean bl2;
            char c = cArray[i];
            boolean bl3 = c >= 'a' && c <= 'z';
            boolean bl4 = c >= 'A' && c <= 'Z';
            boolean bl5 = bl2 = c >= '0' && c <= '9';
            if (!(bl3 || bl4 || bl2)) {
                bl = c == ';';
                break;
            }
            ++n3;
        }
        if (!bl || n3 < 2 || n3 > 8) {
            return null;
        }
        return new String(cArray, n, n3);
    }

    void processHTMLTags() {
        int n = 0;
        block18: while ((n = this.indexInMsg("<", n)) >= 0 && n < this.nMsgLength - 2) {
            switch (V2CHTMLString.toLowerCase(this.clMsg[n + 1])) {
                case '!': {
                    n = this.startComment(n);
                    continue block18;
                }
                case 'a': {
                    n = this.removeResLink(n);
                    continue block18;
                }
                case 'b': {
                    n = this.startByB(n);
                    continue block18;
                }
                case 'f': {
                    n = this.startFont(n);
                    continue block18;
                }
                case 'h': {
                    n = this.processHR(n);
                    continue block18;
                }
                case 'i': {
                    n = this.startItalic(n);
                    continue block18;
                }
                case 'p': {
                    n = this.startPara(n);
                    continue block18;
                }
                case 'u': {
                    n = this.startUnorderedList(n);
                    continue block18;
                }
                case '/': {
                    switch (V2CHTMLString.toLowerCase(this.clMsg[n + 2])) {
                        case 'b': {
                            n = this.endByB(n);
                            continue block18;
                        }
                        case 'f': {
                            n = this.endFont(n);
                            continue block18;
                        }
                        case 'i': {
                            n = this.endItalic(n);
                            continue block18;
                        }
                        case 'p': {
                            n = this.endPara(n);
                            continue block18;
                        }
                        case 'u': {
                            n = this.endUnorderedList(n);
                            continue block18;
                        }
                    }
                    n = this.skipTag(n);
                    continue block18;
                }
            }
            n = this.skipTag(n);
        }
    }

    void processHTMLTags2() {
        char[] cArray = this.clMsg;
        int n = this.nMsgLength;
        block14: for (int i = 0; i < n; ++i) {
            if (cArray[i] != '\u0000') continue;
            char c = cArray[i + 1];
            switch (c) {
                case '\u0001': {
                    V2CTextSegment v2CTextSegment;
                    n = this.skipMsgChars(i, cArray[i + 2]);
                    if (!this.bName) {
                        this.bCommentTag = true;
                        v2CTextSegment = new V2CTextSegment(i, 0x800000);
                        v2CTextSegment.setSubType((short)1);
                        this.addTextSegment(v2CTextSegment);
                    }
                    --i;
                    continue block14;
                }
                case '\u0002': {
                    cArray[i] = 10;
                    cArray[i + 1] = 10;
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(i + 1, 0x800000);
                    v2CTextSegment.setSubType((short)8);
                    v2CTextSegment.setNewLineNext(true);
                    this.addTextSegment(v2CTextSegment);
                    continue block14;
                }
                case '\u0003': {
                    n = this.skipMsgChars(i, 3);
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(i, 0x800000);
                    v2CTextSegment.setSubType((short)2);
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\u0004': {
                    n = this.skipMsgChars(i, 4);
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(i, 0x800000);
                    v2CTextSegment.setSubType((short)-2);
                    if (n > i && cArray[i] == '\n') {
                        v2CTextSegment.setNewLineNext(true);
                    }
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\u0005': {
                    n = this.skipMsgChars(i, 3);
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(i, 0x800000);
                    v2CTextSegment.setSubType((short)3);
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\u0006': {
                    n = this.skipMsgChars(i, 4);
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(i, 0x800000);
                    v2CTextSegment.setSubType((short)-3);
                    if (n > i && cArray[i] == '\n') {
                        v2CTextSegment.setNewLineNext(true);
                    }
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\u0007': {
                    char c2 = cArray[i + 2];
                    V2CTextSegment v2CTextSegment = new V2CFontTextSegment(i, 6, new String(cArray, i + 6, c2 - 7));
                    n = this.skipMsgChars(i, c2);
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\b': {
                    n = this.skipMsgChars(i, 7);
                    V2CTextSegment v2CTextSegment = new V2CFontTextSegment(i, 6);
                    if (this.nMsgLength > i && cArray[i] == '\n') {
                        v2CTextSegment.setNewLineNext(true);
                    }
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\t': {
                    i = this.startUnorderedList2(i);
                    n = this.nMsgLength;
                    continue block14;
                }
                case '\n': {
                    i = this.endUnorderedList2(i);
                    n = this.nMsgLength;
                    continue block14;
                }
                case '\u000b': 
                case '\f': {
                    int n2;
                    boolean bl;
                    boolean bl2 = bl = c == '\u000b';
                    if (i > 0) {
                        if (cArray[i + 2] == '\u0002') {
                            cArray[i] = 10;
                            n2 = 1;
                        } else if (cArray[i - 1] == '\n') {
                            if (i <= 1 || cArray[i - 2] == '\n') {
                                n2 = 0;
                            } else {
                                cArray[i] = 10;
                                n2 = 1;
                            }
                        } else {
                            cArray[i] = 10;
                            cArray[i + 1] = 10;
                            n2 = 2;
                        }
                    } else {
                        n2 = 0;
                    }
                    n = this.skipMsgChars(i += n2, (bl ? 3 : 12) - n2);
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(i, 0x800000);
                    v2CTextSegment.setSubType(bl ? (short)9 : 10);
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                case '\r': 
                case '\u000e': {
                    int n2;
                    boolean bl;
                    boolean bl3 = bl = c == '\r';
                    if (i > 0 && i + 5 < n) {
                        if (cArray[i - 1] == '\n') {
                            if (i <= 1 || cArray[i - 2] == '\n') {
                                n2 = 0;
                            } else {
                                cArray[i] = 10;
                                n2 = 1;
                            }
                        } else {
                            cArray[i] = 10;
                            cArray[i + 1] = 10;
                            n2 = 2;
                        }
                    } else {
                        n2 = 0;
                    }
                    n = this.skipMsgChars(i += n2, (bl ? 4 : 13) - n2);
                    V2CTextSegment v2CTextSegment = new V2CTextSegment(Math.max(i - 2, 0), 0x800000);
                    v2CTextSegment.setSubType((short)(-(bl ? 9 : 10)));
                    this.addTextSegment(v2CTextSegment);
                    --i;
                    continue block14;
                }
                default: {
                    cArray[i] = 32;
                    cArray[i + 1] = 32;
                }
            }
        }
    }

    int startComment(int n) {
        int n2 = this.nMsgLength;
        if (n2 < n + 8) {
            return n + 2;
        }
        char[] cArray = this.clMsg;
        if (cArray[n + 2] != '-' || cArray[n + 3] != '-' || cArray[n + 4] == '-') {
            return n + 2;
        }
        int n3 = this.indexInMsg("--", n + 5);
        if (n3 < 0 || n2 < n3 + 3) {
            return n + 2;
        }
        int n4 = -1;
        for (int i = n3 + 2; i < n2; ++i) {
            char c = cArray[i];
            if (c == '>') {
                n4 = i + 1;
                break;
            }
            if (c != ' ') break;
        }
        if (n4 < 0) {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = '\u0001';
        cArray[n + 2] = (char)(n4 - n);
        return n4;
    }

    int removeResLink(int n) {
        int n2 = this.indexInMsg(">", n + 8);
        if (n2 < 0) {
            return n + 2;
        }
        int n3 = this.indexInMsg("</a>", n2 + 1);
        if (n3 < 0) {
            return n + 2;
        }
        int n4 = n3 - n2 - 1;
        char[] cArray = this.clMsg;
        int n5 = this.nMsgLength;
        if (n2 + 1 > n && n4 > 0) {
            System.arraycopy(cArray, n2 + 1, cArray, n, n4);
        }
        if (n3 + 4 > n + n4 && n5 > n3 + 4) {
            System.arraycopy(cArray, n3 + 4, cArray, n + n4, n5 - n3 - 4);
        }
        this.nMsgLength = n5 - (n2 - n + 5);
        return n + n4;
    }

    private int skipTag(int n) {
        return n + 2;
    }

    private int startByB(int n) {
        switch (V2CHTMLString.toLowerCase(this.clMsg[n + 2])) {
            case '>': {
                return this.startBold(n);
            }
            case 'l': {
                return this.startBQ(n);
            }
            case 'r': {
                return this.processBR(n);
            }
        }
        return n + 2;
    }

    private int endByB(int n) {
        switch (V2CHTMLString.toLowerCase(this.clMsg[n + 3])) {
            case '>': {
                return this.endBold(n);
            }
            case 'l': {
                return this.endBQ(n);
            }
        }
        return n + 3;
    }

    private int startBold(int n) {
        char[] cArray = this.clMsg;
        cArray[n] = '\u0000';
        cArray[n + 1] = 3;
        return n + 3;
    }

    private int endBold(int n) {
        char[] cArray = this.clMsg;
        cArray[n] = '\u0000';
        cArray[n + 1] = 4;
        return n + 4;
    }

    private int processBR(int n) {
        if (this.nMsgLength < n + 4) {
            return n + 2;
        }
        char c = this.clMsg[n + 3];
        if (c == '>') {
            this.skipMsgChars(n, 3);
            this.clMsg[n] = 10;
            return n + 1;
        }
        if (c == ' ') {
            String string = "clear=all";
            int n2 = n + 13;
            if (this.nMsgLength > n2 && this.clMsg[n2] == '>' && string.equals(new String(this.clMsg, n + 4, string.length()))) {
                this.skipMsgChars(n, 13);
                this.clMsg[n] = 10;
                return n + 1;
            }
        }
        return n + 2;
    }

    private int startFont(int n) {
        char[] cArray = this.clMsg;
        char c = cArray[n + 2];
        if (c != 'o' && c != 'O') {
            return n + 2;
        }
        c = cArray[n + 3];
        if (c != 'n' && c != 'N') {
            return n + 2;
        }
        c = cArray[n + 4];
        if (c != 't' && c != 'T') {
            return n + 2;
        }
        int n2 = 0;
        int n3 = this.nMsgLength;
        for (int i = n + 6; i < n3; ++i) {
            if (cArray[i] != '>') continue;
            n2 = i + 1 - n;
            break;
        }
        if (n2 == 0) {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 7;
        cArray[n + 2] = (char)n2;
        return n + n2;
    }

    private int endFont(int n) {
        char[] cArray = this.clMsg;
        char c = cArray[n + 3];
        if (c != 'o' && c != 'O') {
            return n + 2;
        }
        c = cArray[n + 4];
        if (c != 'n' && c != 'N') {
            return n + 2;
        }
        c = cArray[n + 5];
        if (c != 't' && c != 'T') {
            return n + 2;
        }
        if (cArray[n + 6] != '>') {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 8;
        return n + 7;
    }

    private int processHR(int n) {
        int n2;
        char[] cArray = this.clMsg;
        int n3 = this.nMsgLength;
        if (n3 < n + 4 || cArray[n + 2] != 'r' && cArray[n + 2] != 'R' || cArray[n + 3] != '>') {
            return n + 2;
        }
        for (n2 = n - 1; n2 >= 0 && cArray[n2] == ' '; --n2) {
        }
        cArray[++n2] = '\u0000';
        cArray[n2 + 1] = 2;
        System.arraycopy(cArray, n + 4, cArray, n2 + 2, n3 - n - 4);
        this.nMsgLength = n3 - (n - n2 + 2);
        return n2 + 1;
    }

    private int startPara(int n) {
        char[] cArray = this.clMsg;
        if (cArray[n + 2] != '>') {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 11;
        if (n >= 2 && cArray[n - 2] == '\u0000' && cArray[n - 1] == '\u0002') {
            cArray[n + 2] = 2;
        }
        return n + 3;
    }

    private int endPara(int n) {
        char[] cArray = this.clMsg;
        if (cArray[n + 3] != '>') {
            return n + 2;
        }
        n = this.skipPrevSP(n);
        cArray[n] = '\u0000';
        cArray[n + 1] = 13;
        return n + 4;
    }

    private int startBQ(int n) {
        char[] cArray = this.clMsg;
        if (n + 12 > this.nMsgLength || !new String(cArray, n + 3, 9).regionMatches(true, 0, "OCKQUOTE>", 0, 9)) {
            return n + 3;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 12;
        if (n >= 4 && cArray[n - 4] == '\u0000' && cArray[n - 3] == '\u0002') {
            cArray[n + 2] = 2;
        }
        return n + 12;
    }

    private int skipPrevSP(int n) {
        char[] cArray = this.clMsg;
        for (int i = n - 1; i >= 0; --i) {
            char c = cArray[i];
            if (c == ' ') continue;
            int n2 = n - i - 1;
            if (n2 <= 0) {
                return n;
            }
            this.skipMsgChars(n -= n2, n2);
            return n;
        }
        return n;
    }

    private int endBQ(int n) {
        char[] cArray = this.clMsg;
        if (n + 13 > this.nMsgLength || !new String(cArray, n + 4, 9).regionMatches(true, 0, "OCKQUOTE>", 0, 9)) {
            return n + 4;
        }
        n = this.skipPrevSP(n);
        cArray[n] = '\u0000';
        cArray[n + 1] = 14;
        return n + 13;
    }

    private int startItalic(int n) {
        char[] cArray = this.clMsg;
        if (cArray[n + 2] != '>') {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 5;
        return n + 3;
    }

    private int endItalic(int n) {
        char[] cArray = this.clMsg;
        if (cArray[n + 3] != '>') {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 6;
        return n + 4;
    }

    private int startUnorderedList(int n) {
        char[] cArray = this.clMsg;
        char c = cArray[n + 2];
        if (c != 'l' && c != 'L' || cArray[n + 3] != '>') {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 9;
        return n + 4;
    }

    private int endUnorderedList(int n) {
        char[] cArray = this.clMsg;
        char c = cArray[n + 3];
        if (c != 'l' && c != 'L' || cArray[n + 4] != '>') {
            return n + 2;
        }
        cArray[n] = '\u0000';
        cArray[n + 1] = 10;
        return n + 5;
    }

    private int startUnorderedList2(int n) {
        char c;
        int n2 = 3;
        int n3 = 0;
        for (int i = n - 1; i >= 0 && ((c = this.clMsg[i]) == ' ' || c == '\u3000'); --i) {
            ++n3;
        }
        if (n + 4 < this.nMsgLength && this.clMsg[n + 4] == ' ') {
            ++n2;
        }
        this.skipMsgChars(n -= n3, n2 += n3);
        this.clMsg[n] = 10;
        V2CTextSegment v2CTextSegment = new V2CTextSegment(n, 0x800000);
        v2CTextSegment.setSubType((short)7);
        v2CTextSegment.setNewLineNext(true);
        this.addTextSegment(v2CTextSegment);
        return n;
    }

    private int endUnorderedList2(int n) {
        char c;
        int n2;
        int n3 = 5;
        int n4 = 0;
        for (n2 = n - 1; n2 >= 0 && ((c = this.clMsg[n2]) == ' ' || c == '\u3000'); --n2) {
            ++n4;
        }
        if (n + 5 < this.nMsgLength && this.clMsg[n + 5] == ' ') {
            ++n3;
        }
        n2 = (n -= n4) > 0 && this.clMsg[n - 1] == '\n' ? 1 : 0;
        char c2 = c = n2 == 0 && n + (n3 += n4) < this.nMsgLength - 1 ? (char)'\u0001' : '\u0000';
        if (c != '\u0000') {
            --n3;
        }
        this.skipMsgChars(n, n3);
        if (c != '\u0000') {
            this.clMsg[n] = 10;
        }
        V2CTextSegment v2CTextSegment = new V2CTextSegment(n2 != 0 ? n - 1 : n, 0x800000);
        v2CTextSegment.setSubType((short)-7);
        if (c != '\u0000') {
            v2CTextSegment.setNewLineNext(true);
        }
        this.addTextSegment(v2CTextSegment);
        return n - 1;
    }

    int indexInMsg(String string) {
        return this.indexInMsg(string, 0);
    }

    int indexInMsg(String string, int n) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n2 = -1;
        int n3 = string.length();
        int n4 = this.nMsgLength - n3;
        char c = string.charAt(0);
        char[] cArray = this.clMsg;
        block0: for (int i = n; i < n4; ++i) {
            int n5;
            if (cArray[i] != c) continue;
            for (n5 = 1; n5 < n3; ++n5) {
                if (cArray[i + n5] != string.charAt(n5)) continue block0;
            }
            if (n5 != n3) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    static char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    boolean startsWithInMsg(String string, int n) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = string.length();
        if (this.nMsgLength < n + n2) {
            return false;
        }
        char[] cArray = this.clMsg;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == cArray[n + i]) continue;
            return false;
        }
        return true;
    }

    int skipMsgChars(int n, int n2) {
        int n3 = this.nMsgLength;
        int n4 = n3 - (n + n2);
        if (n4 > 0) {
            System.arraycopy(this.clMsg, n + n2, this.clMsg, n, n4);
        }
        this.nMsgLength = n3 -= n2;
        return n3;
    }

    void createNormalTextSegments(boolean bl) {
        this.sortTextSegments();
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        int n = this.nTextSegment;
        V2CTextSegment[] v2CTextSegmentArray2 = new V2CTextSegment[10];
        this.vlTextSegment = v2CTextSegmentArray2;
        this.nTextSegment = 0;
        char[] cArray = this.clMsg;
        boolean bl2 = true;
        boolean bl3 = false;
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            int n3;
            V2CTextSegment v2CTextSegment;
            if (i < n) {
                v2CTextSegment = v2CTextSegmentArray[i];
                n3 = v2CTextSegment.getSegmentStartIndex();
            } else {
                v2CTextSegment = null;
                n3 = this.nMsgLength;
            }
            int n4 = n2;
            int n5 = -1;
            for (int j = n2; j < n3; ++j) {
                char c = cArray[j];
                if (c == ' ') {
                    if (n5 >= 0) continue;
                    n5 = j;
                    continue;
                }
                if (c == '\n') {
                    V2CTextSegment v2CTextSegment2 = new V2CTextSegment(cArray, n4, j, 1);
                    this.addTextSegment(v2CTextSegment2);
                    v2CTextSegment2.setNewLineNext(true);
                    bl2 = true;
                    bl3 = false;
                    n4 = j + 1;
                    continue;
                }
                if (n5 < 0) continue;
                if (n5 == n4 && (bl2 || bl3)) {
                    this.addTextSegment(new V2CTextSegment(cArray, n4, j, 524288));
                    bl2 = false;
                    bl3 = false;
                    n4 = j;
                } else if (j > n5 + 1) {
                    this.addTextSegment(new V2CTextSegment(cArray, n4, n5 + 1, 1));
                    this.addTextSegment(new V2CTextSegment(cArray, n5 + 1, j, 524288));
                    bl2 = false;
                    bl3 = false;
                    n4 = j;
                }
                n5 = -1;
            }
            if (n4 < n3) {
                if (n5 >= 0 && n5 == n4) {
                    if (bl2 || bl3) {
                        this.addTextSegment(new V2CTextSegment(cArray, n4, n3, 524288));
                    } else {
                        this.addTextSegment(new V2CTextSegment(cArray, n4, n4 + 1, 1));
                        if (n3 > n4 + 1) {
                            this.addTextSegment(new V2CTextSegment(cArray, n4 + 1, n3, 524288));
                        }
                    }
                } else {
                    this.addTextSegment(new V2CTextSegment(cArray, n4, n3, 1));
                }
                bl2 = false;
                bl3 = false;
            }
            if (v2CTextSegment == null) continue;
            this.addTextSegment(v2CTextSegment);
            n2 = v2CTextSegment.getSegmentEndIndex();
            bl2 = false;
            boolean bl4 = bl3 = n2 > n3 && cArray[n2 - 1] == ' ';
            if (n2 >= this.nMsgLength || cArray[n2] != '\n') continue;
            v2CTextSegment.setNewLineNext(true);
            bl2 = true;
            ++n2;
        }
        if (bl && this.nTextSegment > 0) {
            this.vlTextSegment[this.nTextSegment - 1].setNewLineNext(true);
        }
    }

    private void sortTextSegments() {
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        int n = this.nTextSegment;
        if (n < 2) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            V2CTextSegment v2CTextSegment;
            int n2;
            V2CTextSegment v2CTextSegment2 = v2CTextSegmentArray[i];
            int n3 = v2CTextSegment2.getSegmentStartIndex();
            for (int j = i - 1; j >= 0 && n3 < (n2 = (v2CTextSegment = v2CTextSegmentArray[j]).getSegmentStartIndex()); --j) {
                V2CTextSegment v2CTextSegment3 = v2CTextSegmentArray[j];
                v2CTextSegmentArray[j] = v2CTextSegmentArray[j + 1];
                v2CTextSegmentArray[j + 1] = v2CTextSegment3;
            }
        }
    }

    void addTextSegment(V2CTextSegment v2CTextSegment) {
        int n = this.nTextSegment;
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        if (n >= v2CTextSegmentArray.length) {
            v2CTextSegmentArray = this.enlargeTextSegmentArray();
        }
        v2CTextSegmentArray[n] = v2CTextSegment;
        this.nTextSegment = n + 1;
    }

    V2CTextSegment[] enlargeTextSegmentArray() {
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        V2CTextSegment[] v2CTextSegmentArray2 = new V2CTextSegment[v2CTextSegmentArray.length * 2];
        System.arraycopy(v2CTextSegmentArray, 0, v2CTextSegmentArray2, 0, v2CTextSegmentArray.length);
        this.vlTextSegment = v2CTextSegmentArray2;
        return v2CTextSegmentArray2;
    }

    void checkRedundantNewLineNext() {
        int n = this.nTextSegment;
        if (n == 0) {
            return;
        }
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        V2CTextSegment v2CTextSegment = v2CTextSegmentArray[0];
        boolean bl = v2CTextSegment.newLineNext();
        for (int i = 1; i < n; ++i) {
            V2CTextSegment v2CTextSegment2 = v2CTextSegmentArray[i];
            boolean bl2 = v2CTextSegment2.newLineNext();
            if (bl2 && bl && v2CTextSegment.getSegmentEndIndex() == v2CTextSegment2.getSegmentStartIndex()) {
                v2CTextSegment.setNewLineNext(false);
            }
            v2CTextSegment = v2CTextSegment2;
            bl = bl2;
        }
    }

    V2CTextSegment[] getTextSegments() {
        return this.vlTextSegment;
    }

    int getSegmentCount() {
        return this.nTextSegment;
    }

    ArrayList getKeywordRange() {
        return this.alKeywords;
    }

    int[] getDrawOrder() {
        int n;
        int[] nArray = this.ilDrawOrder;
        if (nArray == null) {
            return null;
        }
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        int n2 = this.nTextSegment;
        if (nArray.length != n2) {
            nArray = new int[n2];
        }
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        n = -1;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            V2CTextSegment v2CTextSegment = v2CTextSegmentArray[i];
            int n4 = v2CTextSegment.getType();
            if (v2CTextSegment.length() == 0 && !v2CTextSegment.newLineNext() || (n4 & 0x80001) == 0) continue;
            if (n < 0) {
                if (!v2CTextSegment.isRTL()) continue;
                n = n3 = i;
                continue;
            }
            if (v2CTextSegment.isRTL()) {
                n3 = i;
                continue;
            }
            if (!v2CTextSegment.newLineNext() && (n4 == 1 && v2CTextSegment.length() == 1 && v2CTextSegment.charAt(0) == ' ' || n4 == 524288)) continue;
            int n5 = n3 - n;
            if (n5 > 1) {
                for (int j = 0; j <= n5; ++j) {
                    nArray[n + j] = n3 - j;
                }
            }
            n3 = -1;
            n = -1;
        }
        return nArray;
    }

    boolean createKeywordLinkTextSegment(int n, int n2, String string) {
        return false;
    }

    boolean insertInlineMsgImg(int n, String string) {
        return false;
    }

    void removeAllInlineMsgImgs() {
    }

    boolean hasKeywords() {
        ArrayList arrayList = this.alKeywords;
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            V2CHighlightItem v2CHighlightItem;
            V2CHighlightRegion v2CHighlightRegion = (V2CHighlightRegion)arrayList.get(i);
            if (v2CHighlightRegion == null || (v2CHighlightItem = v2CHighlightRegion.vHighlightItem) == null || v2CHighlightItem instanceof V2CTextMarkerItem) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContainKeyword() {
        ArrayList arrayList = this.alKeywords;
        V2CHighlightRegion v2CHighlightRegion = (V2CHighlightRegion)arrayList.get(0);
        int n = 1;
        int n2 = arrayList.size();
        Object object = this.oTSLockObject;
        synchronized (object) {
            V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
            int n3 = this.nTextSegment;
            block3: for (int i = 0; i < n3; ++i) {
                V2CTextSegment v2CTextSegment = v2CTextSegmentArray[i];
                if (v2CTextSegment.length() == 0) continue;
                int n4 = v2CTextSegment.getSegmentStartIndex();
                int n5 = v2CTextSegment.getSegmentEndIndex();
                while (n5 > v2CHighlightRegion.iBegin) {
                    if (n4 < v2CHighlightRegion.iEnd) {
                        v2CTextSegment.setContainKeyword(true);
                        continue block3;
                    }
                    if (n >= n2) break block3;
                    v2CHighlightRegion = (V2CHighlightRegion)arrayList.get(n++);
                }
            }
        }
    }

    final int checkKeywordHighlightWeight(V2CKeywordHighlightItem[] v2CKeywordHighlightItemArray, int n) {
        return this.checkKeywordHighlight(v2CKeywordHighlightItemArray, n, true, false, null, null);
    }

    final int checkKeywordHighlight(V2CKeywordHighlightItem[] v2CKeywordHighlightItemArray, String[] stringArray, V2CKeywordHighlightItem[] v2CKeywordHighlightItemArray2) {
        return this.checkKeywordHighlight(v2CKeywordHighlightItemArray, 0, true, true, stringArray, v2CKeywordHighlightItemArray2);
    }

    final int applyKeywordHighlight(V2CKeywordHighlightItem[] v2CKeywordHighlightItemArray) {
        return this.checkKeywordHighlight(v2CKeywordHighlightItemArray, 0, false, this.bName, null, null);
    }

    private final int checkKeywordHighlight(V2CKeywordHighlightItem[] v2CKeywordHighlightItemArray, int n, boolean bl, boolean bl2, String[] stringArray, V2CKeywordHighlightItem[] v2CKeywordHighlightItemArray2) {
        if (v2CKeywordHighlightItemArray == null || v2CKeywordHighlightItemArray.length == 0) {
            return 0;
        }
        boolean bl3 = this.bName;
        if (!bl && !bl3) {
            this.removeAllInlineMsgImgs();
        }
        int n2 = -1;
        Object object = null;
        String string = null;
        String string2 = null;
        block4: for (int i = 0; i < v2CKeywordHighlightItemArray.length; ++i) {
            String string3;
            Object object2;
            int n3;
            boolean bl4;
            boolean bl5;
            V2CKeywordHighlightItem v2CKeywordHighlightItem = v2CKeywordHighlightItemArray[i];
            if (v2CKeywordHighlightItem == null || !v2CKeywordHighlightItem.isActive()) continue;
            if (bl) {
                boolean bl6 = bl3 ? ((V2CNameKeywordHighlightItem)v2CKeywordHighlightItem).hasSoundOrAvatarName(bl2) : bl2 && v2CKeywordHighlightItem.hasSoundName();
                bl5 = v2CKeywordHighlightItem.getWeight() > (bl6 ? n2 : n);
                boolean bl7 = bl4 = v2CKeywordHighlightItemArray2 != null && v2CKeywordHighlightItem.isTabImageSet() && v2CKeywordHighlightItemArray2[i] == null;
                if (!bl5 && !bl4) {
                    continue;
                }
            } else {
                if (!v2CKeywordHighlightItem.isDefined()) continue;
                bl4 = false;
                bl5 = false;
            }
            if (v2CKeywordHighlightItem.isRegEx()) {
                Pattern pattern = v2CKeywordHighlightItem.getPattern();
                if (pattern == null) continue;
                Matcher matcher = pattern.matcher(this);
                int n4 = 0;
                while (matcher.find(n4)) {
                    n3 = matcher.start();
                    int n5 = matcher.end();
                    if (n5 == n3) {
                        n4 = n5 + 1;
                        if (n4 >= this.length() - 1) continue block4;
                        continue;
                    }
                    if (bl) {
                        if (bl5) {
                            int n6 = v2CKeywordHighlightItem.getWeight();
                            if (bl3) {
                                object2 = (V2CNameKeywordHighlightItem)v2CKeywordHighlightItem;
                                String string4 = ((V2CNameKeywordHighlightItem)object2).getSoundOrAvatarName(bl2);
                                if (string4 != null) {
                                    object = string4;
                                    n2 = n6;
                                }
                                if (n6 > n) {
                                    n = n6;
                                }
                            } else if (bl2) {
                                object2 = v2CKeywordHighlightItem.getSoundName();
                                if (object2 != null) {
                                    object = object2;
                                    n2 = n6;
                                }
                                if (n6 > n) {
                                    n = n6;
                                }
                            } else {
                                n = n6;
                            }
                        }
                        if (!bl4) continue block4;
                        v2CKeywordHighlightItemArray2[i] = v2CKeywordHighlightItem;
                        continue block4;
                    }
                    try {
                        String string5 = v2CKeywordHighlightItem.getHREF();
                        if (string5 != null && (object2 = V2CMiscUtil.replaceRegEx(matcher, string5)) != null) {
                            this.createKeywordLinkTextSegment(n3, n5, (String)object2);
                        }
                        if ((object2 = v2CKeywordHighlightItem.getInlineMessageImage()) != null && ((String)object2).length() > 0) {
                            object2 = V2CMiscUtil.replaceRegEx(matcher, (String)object2);
                            this.insertInlineMsgImg(v2CKeywordHighlightItem.getIMIRight() ? n5 : n3, (String)object2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (v2CKeywordHighlightItem.isHighlightDefined()) {
                        this.addHighlightRegion(v2CKeywordHighlightItem, n3, n5);
                    }
                    v2CKeywordHighlightItem.setApplied();
                    n4 = n5;
                }
                continue;
            }
            String string6 = v2CKeywordHighlightItem.getWord();
            if (string6 == null || string6.length() == 0) continue;
            int n7 = string6.length();
            if (string == null) {
                string = this.toString();
            }
            if (v2CKeywordHighlightItem.isCaseSensitive()) {
                string3 = string;
            } else {
                if (string2 == null) {
                    string2 = V2CMiscUtil.normalizeCase(string);
                }
                string3 = string2;
            }
            n3 = 0;
            while ((n3 = string3.indexOf(string6, n3)) >= 0) {
                if (bl) {
                    if (bl5) {
                        int n8 = v2CKeywordHighlightItem.getWeight();
                        if (bl3) {
                            V2CNameKeywordHighlightItem v2CNameKeywordHighlightItem = (V2CNameKeywordHighlightItem)v2CKeywordHighlightItem;
                            object2 = v2CNameKeywordHighlightItem.getSoundOrAvatarName(bl2);
                            if (object2 != null) {
                                object = object2;
                                n2 = n8;
                            }
                            if (n8 > n) {
                                n = n8;
                            }
                        } else if (bl2) {
                            String string7 = v2CKeywordHighlightItem.getSoundName();
                            if (string7 != null) {
                                object = string7;
                                n2 = n8;
                            }
                            if (n8 > n) {
                                n = n8;
                            }
                        } else {
                            n = n8;
                        }
                    }
                    if (!bl4) continue block4;
                    v2CKeywordHighlightItemArray2[i] = v2CKeywordHighlightItem;
                    continue block4;
                }
                try {
                    String string8;
                    String string9 = v2CKeywordHighlightItem.getHREF();
                    if (string9 != null) {
                        this.createKeywordLinkTextSegment(n3, n3 + n7, string9);
                    }
                    if ((string8 = v2CKeywordHighlightItem.getInlineMessageImage()) != null && string8.length() > 0) {
                        this.insertInlineMsgImg(v2CKeywordHighlightItem.getIMIRight() ? n3 + n7 : n3, string8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (v2CKeywordHighlightItem.isHighlightDefined()) {
                    this.addHighlightRegion(v2CKeywordHighlightItem, n3, n3 + n7);
                }
                v2CKeywordHighlightItem.setApplied();
                n3 += n7;
            }
        }
        if (bl) {
            if (bl3) {
                this.postCheckKeywordHighlight((String)object, bl2);
            } else if (stringArray != null) {
                stringArray[0] = object;
            }
        }
        return n;
    }

    void postCheckKeywordHighlight(String string, boolean bl) {
    }

    void addHighlightRegion(V2CHighlightItem v2CHighlightItem, int n, int n2) {
        ArrayList<V2CHighlightRegion> arrayList = this.alKeywords;
        if (arrayList == null) {
            this.alKeywords = arrayList = new ArrayList<V2CHighlightRegion>();
        }
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            V2CHighlightRegion v2CHighlightRegion = (V2CHighlightRegion)arrayList.get(i);
            int n4 = v2CHighlightRegion.iBegin;
            if (n3 <= n && n2 <= n4) {
                arrayList.add(i, new V2CHighlightRegion(v2CHighlightItem, n, n2));
                return;
            }
            n3 = v2CHighlightRegion.iEnd;
            if (n3 <= n) continue;
            if (n < n4) {
                arrayList.add(i++, new V2CHighlightRegion(v2CHighlightItem, n, n4));
            }
            if (n2 <= n3) {
                return;
            }
            n = n3;
        }
        if (n < n2) {
            arrayList.add(new V2CHighlightRegion(v2CHighlightItem, n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetHighlight0() {
        this.bHighlightChecked = false;
        if (this.alKeywords != null) {
            this.alKeywords.clear();
        }
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        Object object = this.oTSLockObject;
        synchronized (object) {
            this.removeVirtualTags();
            for (int i = this.nTextSegment - 1; i >= 0; --i) {
                v2CTextSegmentArray[i].setContainKeyword(false);
            }
        }
    }

    private void removeVirtualTags() {
        if (!this.bVirtualTagInserted) {
            return;
        }
        int n = this.nTextSegment;
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        int n2 = 0;
        V2CTextSegment v2CTextSegment = null;
        for (int i = 0; i < n; ++i) {
            V2CTextSegment v2CTextSegment2 = v2CTextSegmentArray[i];
            int n3 = v2CTextSegment2.getSubType();
            if (v2CTextSegment2.getType() != 0x800000 || n3 < 1024 && n3 > -1024) {
                v2CTextSegment = v2CTextSegment2;
                if (n2 < i) {
                    v2CTextSegmentArray[n2] = v2CTextSegment2;
                }
                ++n2;
                continue;
            }
            if (!v2CTextSegment2.newLineNext()) continue;
            if (v2CTextSegment != null) {
                v2CTextSegment.setNewLineNext(true);
                continue;
            }
            System.out.println("tsp==null: " + i);
        }
        if (n2 < n) {
            V2CTextSegment[] v2CTextSegmentArray2 = new V2CTextSegment[n2];
            System.arraycopy(v2CTextSegmentArray, 0, v2CTextSegmentArray2, 0, n2);
            this.vlTextSegment = v2CTextSegmentArray2;
            this.nTextSegment = n2;
        }
        this.bVirtualTagInserted = false;
    }

    void replaceSegmentString(int n, V2CTextSegment v2CTextSegment, String string) {
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        if (this.nTextSegment <= n || v2CTextSegmentArray[n] != v2CTextSegment) {
            return;
        }
        char[] cArray = this.clMsg;
        int n2 = this.nMsgLength;
        boolean bl = false;
        int n3 = v2CTextSegment.getSegmentStartIndex();
        int n4 = v2CTextSegment.length();
        int n5 = string.length();
        int n6 = n5 - n4;
        if (n6 != 0) {
            if (n2 + n6 > cArray.length) {
                bl = true;
                char[] cArray2 = new char[n2 + n6];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
                this.clMsg = cArray2;
            }
            System.arraycopy(cArray, n3 + n4, cArray, n3 + n5, n2 - n3 - n4);
            this.nMsgLength += n6;
        }
        string.getChars(0, n5, cArray, n3);
        if (n6 == 0) {
            return;
        }
        for (int i = this.nTextSegment - 1; i >= 0; --i) {
            V2CTextSegment v2CTextSegment2 = v2CTextSegmentArray[i];
            if (bl) {
                v2CTextSegment2.setCharArray(cArray);
            }
            if (i <= n) continue;
            v2CTextSegment2.setSegmentStartIndex(v2CTextSegment2.getSegmentStartIndex() + n6);
        }
        v2CTextSegment.forceSetLength(n5);
    }

    public int length() {
        return this.nMsgLength;
    }

    public char charAt(int n) {
        return this.clMsg[n];
    }

    public CharSequence subSequence(int n, int n2) {
        return new V2CCharSequence(this.clMsg, n, n2);
    }

    public String toString() {
        return new String(this.clMsg, 0, this.nMsgLength);
    }

    static {
        int n = slEntity.length;
        clEntity = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff', '\u0192', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u03d1', '\u03d2', '\u03d6', '\u2022', '\u2026', '\u2032', '\u2033', '\u203e', '\u2044', '\u2118', '\u2111', '\u211c', '\u2122', '\u2135', '\u2190', '\u2191', '\u2192', '\u2193', '\u2194', '\u21b5', '\u21d0', '\u21d1', '\u21d2', '\u21d3', '\u21d4', '\u2200', '\u2202', '\u2203', '\u2205', '\u2207', '\u2208', '\u2209', '\u220b', '\u220f', '\u2211', '\u2212', '\u2217', '\u221a', '\u221d', '\u221e', '\u2220', '\u2227', '\u2228', '\u2229', '\u222a', '\u222b', '\u2234', '\u223c', '\u2245', '\u2248', '\u2260', '\u2261', '\u2264', '\u2265', '\u2282', '\u2283', '\u2284', '\u2286', '\u2287', '\u2295', '\u2297', '\u22a5', '\u22c5', '\u2308', '\u2309', '\u230a', '\u230b', '\u2329', '\u232a', '\u25ca', '\u2660', '\u2663', '\u2665', '\u2666', '\"', '&', '<', '>', '\u0152', '\u0153', '\u0160', '\u0161', '\u0178', '\u02c6', '\u02dc', '\u2002', '\u2003', '\u2009', '\u200c', '\u200d', '\u200e', '\u200f', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2030', '\u2039', '\u203a', '\u20ac'};
        if (n != clEntity.length) {
            System.out.println("Error in Entity Array !");
            V2CApp.immediateExit(1);
        }
        for (int i = 0; i < n; ++i) {
            hmEntity.put(slEntity[i], new Character(clEntity[i]));
        }
    }
}

