/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CHTMLString;
import org.monazilla.v2c.V2CLogSearchPanel;
import org.monazilla.v2c.V2CLogSearchResultList;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CResLabel;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextMarker;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadRes;

public class V2CLogSearcher {
    static Icon icDefault;
    private static final int[] ilAllRes;
    final boolean bForSave;
    final boolean bSearchInBoard;
    final V2CBoardItem[] vlBoardItem;
    final V2CThreadItem[] vlThreadItem;
    final SearchCond scURL;
    final SearchCond scThreadTitle;
    final SearchCond scName;
    final SearchCond scMail;
    final SearchCond scID;
    final SearchCond scBe;
    final SearchCond scAux;
    final SearchCond scMessage;
    final boolean bResLabel;
    final V2CResLabel vResLabel;
    final boolean bTextMarker;
    int[] ilBeID;
    final boolean bActiveThreadOnly;
    final long ltStartDate;
    final long ltEndDate;
    final boolean bUseTime;
    final int nStartTime;
    final int nEndTime;
    final boolean bUseDayOfWeek;
    final boolean[] blDayOfWeek;
    String sTitle;
    String sError;

    static Icon getIcon() {
        return icDefault;
    }

    private SearchCond createSearchCond(V2CLogSearchPanel.SimpleEntry simpleEntry, boolean bl) {
        if (!(bl || simpleEntry.jcbLabel.isSelected() && simpleEntry.jtfWords.getText().length() != 0)) {
            return null;
        }
        return new SearchCond(simpleEntry);
    }

    public V2CLogSearcher(V2CLogSearchPanel v2CLogSearchPanel, boolean bl) {
        boolean bl2;
        int n;
        JComponent[] jComponentArray;
        boolean bl3;
        this.bForSave = bl;
        this.bSearchInBoard = v2CLogSearchPanel.bSearchInBoard;
        this.vlBoardItem = v2CLogSearchPanel.vlBoardItem;
        this.vlThreadItem = v2CLogSearchPanel.vlThreadItem;
        this.bActiveThreadOnly = v2CLogSearchPanel.jcbActiveThreadOnly.isSelected();
        this.scURL = this.createSearchCond(v2CLogSearchPanel.seURL, bl);
        this.scThreadTitle = this.createSearchCond(v2CLogSearchPanel.seThreadTitle, bl);
        this.scName = this.createSearchCond(v2CLogSearchPanel.seName, bl);
        this.scMail = this.createSearchCond(v2CLogSearchPanel.seMail, bl);
        this.scID = this.createSearchCond(v2CLogSearchPanel.seID, bl);
        this.scBe = this.createSearchCond(v2CLogSearchPanel.seBe, bl);
        this.scAux = this.createSearchCond(v2CLogSearchPanel.seAux, bl);
        this.scMessage = this.createSearchCond(v2CLogSearchPanel.seMessage, bl);
        this.bResLabel = v2CLogSearchPanel.jcbResLabel.isSelected();
        Object object = v2CLogSearchPanel.jcbResLabelSelection.getSelectedItem();
        this.vResLabel = object instanceof V2CResLabel ? (V2CResLabel)object : null;
        this.bTextMarker = v2CLogSearchPanel.jcbTextMarker.isSelected();
        if (bl) {
            this.scBe.parseBe();
        }
        this.ltStartDate = v2CLogSearchPanel.deStart.getDate();
        this.ltEndDate = v2CLogSearchPanel.deEnd.getDate();
        this.bUseDayOfWeek = bl3 = v2CLogSearchPanel.jcbUseDayOfWeek.isSelected();
        boolean[] blArray = null;
        if (bl || bl3) {
            boolean[] blArray2 = new boolean[7];
            boolean bl4 = true;
            jComponentArray = v2CLogSearchPanel.jcblDayOfWeek;
            for (n = 0; n < 7; ++n) {
                if (jComponentArray[n].isSelected()) {
                    blArray2[n] = true;
                    continue;
                }
                bl4 = false;
            }
            if (bl || !bl4) {
                blArray = blArray2;
            }
        }
        this.blDayOfWeek = blArray;
        this.bUseTime = bl2 = v2CLogSearchPanel.jcbUseTime.isSelected();
        if (bl || bl2) {
            this.nStartTime = v2CLogSearchPanel.tpStart.getTime() * 1000;
            this.nEndTime = v2CLogSearchPanel.tpEnd.getTime() * 1000;
        } else {
            this.nStartTime = 0;
            this.nEndTime = 0;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            jComponentArray = new V2CLogSearchPanel.SimpleEntry[]{v2CLogSearchPanel.seURL, v2CLogSearchPanel.seThreadTitle, v2CLogSearchPanel.seName, v2CLogSearchPanel.seMail, v2CLogSearchPanel.seID, v2CLogSearchPanel.seBe, v2CLogSearchPanel.seAux, v2CLogSearchPanel.seMessage};
            for (n = 0; n < jComponentArray.length; ++n) {
                JComponent jComponent = jComponentArray[n];
                if (!((V2CLogSearchPanel.SimpleEntry)jComponent).jcbLabel.isSelected()) continue;
                stringBuffer.append(((V2CLogSearchPanel.SimpleEntry)jComponent).jtfWords.getText());
                stringBuffer.append(' ');
            }
            if (stringBuffer.length() < 10) {
                if (this.bResLabel) {
                    stringBuffer.append(this.vResLabel != null ? this.vResLabel.toString() : "\u5168\u30e9\u30d9\u30eb");
                    stringBuffer.append(' ');
                }
                if (this.bTextMarker) {
                    stringBuffer.append("\u30de\u30fc\u30ab\u30fc ");
                }
                if (this.ltStartDate > 0L) {
                    stringBuffer.append("\u958b\u59cb\u65e5 ");
                }
                if (this.ltEndDate > 0L) {
                    stringBuffer.append("\u7d42\u4e86\u65e5 ");
                }
                if (this.blDayOfWeek != null) {
                    stringBuffer.append("\u66dc\u65e5 ");
                }
                if (this.bUseTime) {
                    stringBuffer.append("\u6642\u523b ");
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
                if (stringBuffer.length() > 10) {
                    stringBuffer.setLength(9);
                    stringBuffer.append('\u2026');
                }
            }
            this.sTitle = "\u30ed\u30b0\u691c\u7d22 [" + stringBuffer + ']';
        }
    }

    boolean check(boolean bl) {
        if (this.bForSave) {
            return false;
        }
        boolean bl2 = false;
        SearchCond searchCond = this.scURL;
        SearchCond searchCond2 = this.scThreadTitle;
        SearchCond searchCond3 = this.scName;
        SearchCond searchCond4 = this.scMail;
        SearchCond searchCond5 = this.scID;
        SearchCond searchCond6 = this.scBe;
        SearchCond searchCond7 = this.scAux;
        SearchCond searchCond8 = this.scMessage;
        if (!bl && (searchCond != null && searchCond.isSearchWordDefined() || searchCond2 != null && searchCond2.isSearchWordDefined()) || searchCond3 != null && searchCond3.isSearchWordDefined() || searchCond4 != null && searchCond4.isSearchWordDefined() || searchCond5 != null && searchCond5.isSearchWordDefined() || searchCond6 != null && searchCond6.isSearchWordDefined() || searchCond7 != null && searchCond7.isSearchWordDefined() || searchCond8 != null && searchCond8.isSearchWordDefined()) {
            bl2 = true;
        }
        if (searchCond != null && !searchCond.check() || searchCond2 != null && !searchCond2.check() || searchCond3 != null && !searchCond3.check() || searchCond4 != null && !searchCond4.check() || searchCond5 != null && !searchCond5.check() || searchCond7 != null && !searchCond7.check() || searchCond8 != null && !searchCond8.check()) {
            return false;
        }
        if (searchCond6 != null) {
            if (!searchCond6.parseBe()) {
                return false;
            }
            this.ilBeID = searchCond6.ilBe;
        }
        if (this.bTextMarker || this.bResLabel) {
            bl2 = true;
        }
        long l = this.ltStartDate;
        long l2 = this.ltEndDate;
        if (l > 0L || l2 > 0L) {
            bl2 = true;
        }
        if (l > 0L && l2 > 0L && l > l2) {
            this.sError = "\u958b\u59cb\u65e5\u304c\u7d42\u4e86\u65e5\u3088\u308a\u5f8c\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002";
            return false;
        }
        if (this.bUseDayOfWeek) {
            bl2 = true;
            boolean[] blArray = this.blDayOfWeek;
            if (blArray != null) {
                boolean bl3 = false;
                for (int i = 0; i < 7; ++i) {
                    if (!blArray[i]) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    this.sError = "\u66dc\u65e5\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                    return false;
                }
            }
        }
        if (this.bUseTime) {
            bl2 = true;
            if (this.nStartTime == this.nEndTime) {
                this.sError = "\u958b\u59cb\u6642\u9593\u3068\u7d42\u4e86\u6642\u9593\u304c\u540c\u3058\u3067\u3059\u3002";
                return false;
            }
        }
        if (!bl2) {
            this.sError = "\u691c\u7d22\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            return false;
        }
        return true;
    }

    static void restoreSearchCond(SearchCond searchCond, V2CLogSearchPanel.SimpleEntry simpleEntry) {
        if (searchCond != null) {
            searchCond.restoreCond(simpleEntry);
        } else {
            simpleEntry.jcbCaseSens.setSelected(true);
        }
    }

    void restore(V2CLogSearchPanel v2CLogSearchPanel) {
        JCheckBox[] jCheckBoxArray;
        Object object;
        if (!this.bForSave) {
            return;
        }
        v2CLogSearchPanel.jcbActiveThreadOnly.setSelected(this.bActiveThreadOnly);
        this.scURL.restoreCond(v2CLogSearchPanel.seURL);
        this.scThreadTitle.restoreCond(v2CLogSearchPanel.seThreadTitle);
        this.scName.restoreCond(v2CLogSearchPanel.seName);
        this.scMail.restoreCond(v2CLogSearchPanel.seMail);
        this.scID.restoreCond(v2CLogSearchPanel.seID);
        this.scBe.restoreCond(v2CLogSearchPanel.seBe);
        this.scAux.restoreCond(v2CLogSearchPanel.seAux);
        this.scMessage.restoreCond(v2CLogSearchPanel.seMessage);
        v2CLogSearchPanel.jcbResLabel.setSelected(this.bResLabel);
        if (this.vResLabel != null && (object = V2CResLabel.get((String)(jCheckBoxArray = this.vResLabel.getName()))) != null) {
            v2CLogSearchPanel.jcbResLabelSelection.setSelectedItem(object);
        }
        v2CLogSearchPanel.jcbTextMarker.setSelected(this.bTextMarker);
        v2CLogSearchPanel.deStart.setDate(this.ltStartDate);
        v2CLogSearchPanel.deEnd.setDate(this.ltEndDate);
        v2CLogSearchPanel.jcbUseDayOfWeek.setSelected(this.bUseDayOfWeek);
        jCheckBoxArray = v2CLogSearchPanel.jcblDayOfWeek;
        object = this.blDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            jCheckBoxArray[i].setSelected((boolean)object[i]);
        }
        v2CLogSearchPanel.jcbUseTime.setSelected(this.bUseTime);
        v2CLogSearchPanel.tpStart.setTime(this.nStartTime / 1000);
        v2CLogSearchPanel.tpEnd.setTime(this.nEndTime / 1000);
    }

    int[] filter(V2CThreadPanel v2CThreadPanel) {
        return this.search(v2CThreadPanel.getThreadItem(), v2CThreadPanel, true);
    }

    int[] search(V2CThreadItem v2CThreadItem, boolean bl) {
        return this.search(v2CThreadItem, null, bl);
    }

    private int[] search(V2CThreadItem v2CThreadItem, V2CThreadPanel v2CThreadPanel, boolean bl) {
        Object object;
        int n;
        boolean[] blArray;
        boolean bl2;
        V2CTextMarker v2CTextMarker;
        boolean bl3;
        V2CResLabel[] v2CResLabelArray;
        boolean bl4;
        boolean bl5 = bl4 = v2CThreadPanel != null;
        if (v2CThreadItem == null || v2CThreadItem.getNResGet() <= 0 || !bl4 && this.bActiveThreadOnly && !v2CThreadItem.isActive()) {
            return null;
        }
        long l = this.ltStartDate;
        long l2 = this.ltEndDate;
        if (l2 > 0L) {
            l2 += 86400000L;
        }
        long l3 = v2CThreadItem.getBirthday();
        if (l2 > 0L && l2 < l3) {
            return null;
        }
        long l4 = v2CThreadItem.getTLast();
        if (l4 > 0L && l4 < l) {
            return null;
        }
        if (!bl4) {
            SearchCond searchCond = this.scURL;
            if (searchCond != null && !V2CLogSearcher.checkString(v2CThreadItem.getFormalURLString(), searchCond)) {
                return null;
            }
            v2CResLabelArray = this.scThreadTitle;
            if (v2CResLabelArray != null && !V2CLogSearcher.checkString(v2CThreadItem.getTitle(), (SearchCond)v2CResLabelArray)) {
                return null;
            }
        }
        if (bl3 = this.bResLabel) {
            v2CResLabelArray = bl4 ? v2CThreadPanel.getThreadRes().getResLabels() : V2CResLabel.restoreLabels(v2CThreadItem);
            if (v2CResLabelArray == null || v2CResLabelArray.length == 0) {
                return null;
            }
        } else {
            v2CResLabelArray = null;
        }
        if (this.bTextMarker) {
            v2CTextMarker = bl4 ? v2CThreadPanel.getTextMarker() : new V2CTextMarker(v2CThreadItem);
            if (v2CTextMarker == null || v2CTextMarker.getMarkerCount() == 0) {
                return null;
            }
        } else {
            v2CTextMarker = null;
        }
        boolean[] blArray2 = this.blDayOfWeek;
        boolean bl6 = l > 0L || l2 > 0L;
        boolean bl7 = this.bUseTime;
        int n2 = this.nStartTime;
        int n3 = this.nEndTime;
        boolean bl8 = n3 < n2;
        SearchCond searchCond = this.scName;
        SearchCond searchCond2 = this.scMail;
        SearchCond searchCond3 = this.scID;
        SearchCond searchCond4 = this.scAux;
        SearchCond searchCond5 = this.scMessage;
        int[] nArray = this.ilBeID;
        int n4 = nArray != null ? nArray.length : -1;
        boolean bl9 = bl2 = n4 == 0;
        if (!(searchCond != null || searchCond2 != null || searchCond3 != null || searchCond4 != null || searchCond5 != null || nArray != null || bl3 || this.bTextMarker || bl6 || this.bUseDayOfWeek || bl7)) {
            return ilAllRes;
        }
        ArrayList<Integer> arrayList = null;
        V2CThreadRes v2CThreadRes = bl4 ? v2CThreadPanel.getThreadRes() : v2CThreadItem.getBBS().createNewThreadRes(v2CThreadItem);
        v2CThreadRes.parseLocalDat(false);
        int n5 = v2CThreadRes.getNRes();
        boolean[] blArray3 = blArray = v2CTextMarker != null ? v2CTextMarker.createMatchArray(n5) : null;
        if (this.bTextMarker && blArray == null) {
            return null;
        }
        V2CResLabel v2CResLabel = this.vResLabel;
        for (n = 0; n < n5; ++n) {
            int n6;
            if (bl3) {
                Object object2 = object = n < v2CResLabelArray.length ? v2CResLabelArray[n] : null;
                if (object == null || v2CResLabel != null && v2CResLabel != object) continue;
            }
            if (blArray != null && !blArray[n] || (object = v2CThreadRes.getResItem(n)) == null) continue;
            long l5 = ((V2CResItem)object).getTime();
            if (l5 > 0L) {
                if (blArray2 != null && !blArray2[n6 = V2CResItem.getDayOfWeek(l5)] || bl6 && (l > 0L && l5 < l || l2 > 0L && l5 > l2)) continue;
                if (bl7) {
                    n6 = (int)((l5 + 32400000L) % 86400000L);
                    if (bl8 ? n6 < n2 && n6 > n3 : n6 < n2 || n6 > n3) {
                        continue;
                    }
                }
            } else if (blArray2 != null || bl6 || bl7) continue;
            if (nArray != null) {
                n6 = ((V2CResItem)object).getBeID0();
                if (n6 <= 0) continue;
                if (!bl2) {
                    boolean bl10 = false;
                    for (int i = 0; i < n4; ++i) {
                        if (n6 != nArray[i]) continue;
                        bl10 = true;
                        break;
                    }
                    if (!bl10) continue;
                }
            }
            if (searchCond != null && !V2CLogSearcher.checkString(((V2CResItem)object).getNameString(), searchCond) || searchCond2 != null && !V2CLogSearcher.checkString(((V2CResItem)object).getMail(), searchCond2) || searchCond3 != null && !V2CLogSearcher.checkString(((V2CResItem)object).getID(), searchCond3) || searchCond4 != null && !V2CLogSearcher.checkString(((V2CResItem)object).getAuxString(), searchCond4) || searchCond5 != null && !V2CLogSearcher.checkString(((V2CHTMLString)object).toString(), searchCond5)) continue;
            if (!bl) {
                return ilAllRes;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            arrayList.add(new Integer(((V2CResItem)object).getResIndex()));
        }
        if (arrayList == null) {
            return null;
        }
        n = arrayList.size();
        object = new int[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    static boolean checkString(String string, SearchCond searchCond) {
        return searchCond.bNot ^ V2CLogSearcher.checkString0(string, searchCond);
    }

    static boolean checkString0(String string, SearchCond searchCond) {
        if (string == null) {
            return false;
        }
        boolean bl = searchCond.bRegExp;
        boolean bl2 = searchCond.bCaseSens;
        String[] stringArray = searchCond.slSearchWord;
        Matcher[] matcherArray = searchCond.mlMatcher;
        int n = stringArray.length;
        boolean bl3 = searchCond.bAnd;
        boolean bl4 = searchCond.bOr;
        boolean bl5 = false;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                matcherArray[i].reset(string);
                bl5 = matcherArray[i].find();
            } else {
                if (!bl2) {
                    string = V2CMiscUtil.normalizeCase(string);
                }
                boolean bl6 = bl5 = string.indexOf(stringArray[i]) >= 0;
            }
            if (bl3) {
                if (bl5) continue;
                return false;
            }
            if (!bl4 || !bl5) continue;
            return true;
        }
        return bl5;
    }

    void addWord(String string, boolean bl) {
        if (bl) {
            int[] nArray;
            int n = V2CMiscUtil.parseInt(string);
            if (n <= 0) {
                return;
            }
            SearchCond searchCond = this.scBe;
            int[] nArray2 = searchCond.ilBe;
            if (nArray2 != null) {
                int n2 = nArray2.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray2[i] != n) continue;
                    return;
                }
                nArray = new int[n2 + 1];
                if (n2 > 0) {
                    System.arraycopy(nArray2, 0, nArray, 0, n2);
                }
            } else {
                nArray = new int[1];
            }
            nArray[nArray.length - 1] = n;
            searchCond.ilBe = nArray;
            searchCond.bUsed = true;
        } else {
            String[] stringArray;
            SearchCond searchCond = this.scID;
            String[] stringArray2 = searchCond.slSearchWord;
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals(string)) continue;
                    return;
                }
                stringArray = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            } else {
                stringArray = new String[1];
            }
            stringArray[stringArray.length - 1] = string;
            searchCond.slSearchWord = stringArray;
            searchCond.bUsed = true;
        }
    }

    void open(boolean bl) {
        V2CLogSearchResultList.openResultList(this, bl);
    }

    boolean getSearchInBoard() {
        return this.bSearchInBoard;
    }

    V2CBoardItem[] getBoardList() {
        return this.vlBoardItem;
    }

    V2CThreadItem[] getThreadList() {
        return this.vlThreadItem;
    }

    String getTitleString() {
        return this.sTitle;
    }

    static {
        ilAllRes = new int[0];
        icDefault = V2CSwingUtil.getItemIcon("Find");
    }

    class SearchCond {
        boolean bBe;
        boolean bUsed;
        String[] slSearchWord;
        Matcher[] mlMatcher;
        boolean bRegExp;
        boolean bCaseSens;
        boolean bNot;
        boolean bAnd;
        boolean bOr;
        int[] ilBe;

        SearchCond(V2CLogSearchPanel.SimpleEntry simpleEntry) {
            this.bBe = simpleEntry.bBe;
            this.bUsed = simpleEntry.jcbLabel.isSelected();
            this.bRegExp = simpleEntry.jcbRegExp.isSelected();
            this.bCaseSens = simpleEntry.jcbCaseSens.isSelected();
            this.bNot = simpleEntry.jcbNot.isSelected();
            this.bAnd = simpleEntry.jcbAnd.isSelected();
            this.bOr = !this.bAnd && simpleEntry.jcbOr.isSelected();
            String string = simpleEntry.jtfWords.getText();
            String[] stringArray = V2CMiscUtil.turnStringToArray(string, this.bAnd || this.bOr);
            this.slSearchWord = stringArray != null && stringArray.length > 0 ? stringArray : null;
        }

        boolean check() {
            String[] stringArray = this.slSearchWord;
            if (stringArray == null) {
                return true;
            }
            int n = stringArray.length;
            Matcher[] matcherArray = new Matcher[n];
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (this.bRegExp) {
                    try {
                        if (this.bCaseSens) {
                            matcherArray[i] = Pattern.compile(string).matcher("");
                            continue;
                        }
                        matcherArray[i] = Pattern.compile(string, 2).matcher("");
                        continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        V2CLogSearcher.this.sError = "\u6b63\u898f\u8868\u73fe\u6587\u6cd5\u30a8\u30e9\u30fc";
                        return false;
                    }
                }
                if (this.bCaseSens) continue;
                stringArray[i] = V2CMiscUtil.normalizeCase(string);
            }
            this.mlMatcher = matcherArray;
            return true;
        }

        boolean parseBe() {
            int[] nArray;
            if (!this.bBe) {
                return false;
            }
            String[] stringArray = this.slSearchWord;
            if (stringArray == null) {
                return true;
            }
            int n = stringArray.length;
            if (n == 1 && stringArray[0].equals("*")) {
                nArray = new int[]{};
            } else {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = V2CMiscUtil.parseInt(stringArray[i]);
                    if (n2 <= 0) {
                        V2CLogSearcher.this.sError = '\'' + stringArray[i] + "'\u3092BeID\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                        return false;
                    }
                    nArray[i] = n2;
                }
            }
            this.ilBe = nArray;
            return true;
        }

        boolean isSearchWordDefined() {
            return this.slSearchWord != null;
        }

        void restoreCond(V2CLogSearchPanel.SimpleEntry simpleEntry) {
            simpleEntry.jcbLabel.setSelected(this.bUsed);
            if (this.bBe) {
                String string;
                int[] nArray = this.ilBe;
                if (nArray == null) {
                    return;
                }
                if (nArray.length == 0) {
                    string = "*";
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuffer.append(nArray[i]);
                        stringBuffer.append(' ');
                    }
                    string = stringBuffer.substring(0, stringBuffer.length() - 1);
                }
                simpleEntry.jtfWords.setText(string);
                return;
            }
            simpleEntry.jcbRegExp.setSelected(this.bRegExp);
            simpleEntry.jcbCaseSens.setSelected(this.bCaseSens);
            simpleEntry.jcbNot.setSelected(this.bNot);
            simpleEntry.jcbAnd.setSelected(this.bAnd);
            simpleEntry.jcbOr.setSelected(this.bOr);
            String[] stringArray = this.slSearchWord;
            if (stringArray != null) {
                String string;
                if (stringArray.length > 1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(' ');
                    }
                    string = stringBuffer.substring(0, stringBuffer.length() - 1);
                } else {
                    string = stringArray[0];
                }
                simpleEntry.jtfWords.setText(string);
            }
        }
    }
}

