/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.monazilla.v2c.V2CLogEvent;
import org.monazilla.v2c.V2CLogger;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CLogViewer
extends JTextPane {
    Style[] stylTime;
    Style styURL;
    Style styMessage;
    Style styExpand;
    V2CLogEvent[] vlLogEvent;

    public V2CLogViewer() {
        this.setMargin(new Insets(5, 5, 5, 10));
        this.setFont(V2CSSFont.getDefaultFont().getAwtFont());
        StyledDocument styledDocument = this.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setBold(style, true);
        Style style2 = styledDocument.addStyle("time", style);
        this.stylTime = new Style[3];
        this.stylTime[0] = styledDocument.addStyle("time_info", style2);
        StyleConstants.setBackground(this.stylTime[0], new Color(10025880));
        this.stylTime[1] = styledDocument.addStyle("time_warn", style2);
        StyleConstants.setBackground(this.stylTime[1], Color.YELLOW);
        this.stylTime[2] = styledDocument.addStyle("time_error", style2);
        StyleConstants.setBackground(this.stylTime[2], Color.RED);
        this.styURL = styledDocument.addStyle("url", style);
        this.styMessage = styledDocument.addStyle("message", style);
        StyleConstants.setBold(this.styMessage, false);
        this.styExpand = styledDocument.addStyle("message", this.styMessage);
        StyleConstants.setBackground(this.styExpand, new Color(8900331));
        this.vlLogEvent = V2CLogger.getEventArray();
        for (int i = 0; i < this.vlLogEvent.length; ++i) {
            V2CLogEvent v2CLogEvent = this.vlLogEvent[i];
            this.addEvent(styledDocument, v2CLogEvent);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                V2CLogViewer.this.checkMouseClick(mouseEvent);
            }
        });
    }

    private void addEvent(StyledDocument styledDocument, V2CLogEvent v2CLogEvent) {
        v2CLogEvent.reset();
        Style style = this.stylTime[Math.min(v2CLogEvent.getLevel(), this.stylTime.length - 1)];
        int n = styledDocument.getLength();
        try {
            styledDocument.insertString(n, v2CLogEvent.getTimeString(), style);
            styledDocument.insertString(styledDocument.getLength(), "   " + v2CLogEvent.getURLString() + "\n", this.styURL);
            styledDocument.insertString(styledDocument.getLength(), "    ", this.styMessage);
            n = styledDocument.getLength();
            if (v2CLogEvent.hasSubMessage()) {
                styledDocument.insertString(n, "+", this.styExpand);
            }
            String string = v2CLogEvent.getMessage();
            styledDocument.insertString(styledDocument.getLength(), string, this.styMessage);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        v2CLogEvent.setMessageBound(n, styledDocument.getLength());
    }

    void showDialog() {
        JScrollPane jScrollPane = new JScrollPane(this);
        Rectangle rectangle = V2CMain.v2cMain.getBounds();
        Rectangle rectangle2 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Dimension dimension = new Dimension(2 * rectangle2.width / 3, 2 * rectangle2.height / 3);
        jScrollPane.setPreferredSize(dimension);
        String[] stringArray = new String[]{"\u9589\u3058\u308b", "\u30af\u30ea\u30a2"};
        Object[] objectArray = V2CSwingUtil.createJButtonForOptionPane(stringArray);
        int n = JOptionPane.showOptionDialog(V2CMain.v2cMain, jScrollPane, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30ed\u30b0", -1, -1, null, objectArray, objectArray[0]);
        if (n == 1) {
            V2CLogger.clear();
        }
    }

    void checkMouseClick(MouseEvent mouseEvent) {
        if (!V2CSwingUtil.isSimpleClick(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n = this.viewToModel(point);
        Rectangle rectangle = null;
        try {
            rectangle = this.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (rectangle == null) {
            return;
        }
        int n2 = point.x;
        int n3 = point.y;
        if (n2 < rectangle.x - rectangle.height || n2 > rectangle.x + rectangle.height || n3 < rectangle.y || n3 > rectangle.y + rectangle.height) {
            return;
        }
        boolean bl = false;
        int n4 = 0;
        for (int i = 0; i < this.vlLogEvent.length; ++i) {
            V2CLogEvent v2CLogEvent = this.vlLogEvent[i];
            if (!bl) {
                if (!v2CLogEvent.containdInMessage(n)) continue;
                bl = true;
                String string = v2CLogEvent.getSubMessage();
                if (string == null || string.length() == 0) {
                    return;
                }
                n4 = string.length() - 1;
                StyledDocument styledDocument = this.getStyledDocument();
                try {
                    styledDocument.insertString(v2CLogEvent.getMessageEnd(), string, this.styMessage);
                    styledDocument.remove(v2CLogEvent.getMessageStart(), 1);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
            v2CLogEvent.shiftMessagePos(n4);
        }
    }
}

